/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.util.Date;
import java.util.Optional;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.QualityReview;
import org.egov.pgr.entity.contract.QualityReviewSearchRequest;
import org.egov.pgr.repository.QualityReviewRepository;
import org.egov.pgr.repository.specs.QualityReviewSearchSpec;
import org.egov.pgr.service.ComplaintService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class QualityReviewService {
    @Autowired
    private ComplaintService complaintService;
    @Autowired
    private QualityReviewRepository qualityReviewRepository;

    @Transactional
    public void createQualityReview(QualityReview qualityReview) {
        qualityReview.setFeedbackDate(new Date());
        this.qualityReviewRepository.save((Object)qualityReview);
    }

    @Transactional
    public void updateQualityReview(QualityReview qualityReview) {
        qualityReview.setFeedbackDate(new Date());
        this.qualityReviewRepository.save((Object)qualityReview);
    }

    public Optional<QualityReview> getExistingQualityReviewByCRN(String crn) {
        return Optional.ofNullable(this.qualityReviewRepository.findByComplaint(this.complaintService.getComplaintByCRN(crn)));
    }

    public Page<Complaint> getGrievancesForReview(QualityReviewSearchRequest searchRequest) {
        return this.complaintService.getComplaints(QualityReviewSearchSpec.search(searchRequest), searchRequest);
    }
}

