/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import org.egov.pgr.entity.Configuration;
import org.egov.pgr.entity.Priority;
import org.egov.pgr.repository.ConfigurationRepository;
import org.egov.pgr.service.PriorityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ConfigurationService {
    private static final String DEFAULT_RESOLUTION_TIME_KEY = "DEFAULT_RESOLUTION_SLA_IN_HOURS";
    private static final String DEFAULT_COMPLAINT_PRIORITY = "DEFAULT_COMPLAINT_PRIORITY";
    private static final String USE_AUTO_COMPLETE_FOR_COMPLAINT_TYPE = "USE_AUTO_COMPLETE_FOR_COMPLAINT_TYPE";
    private static final String ASSIGN_REOPENED_COMPLAINT_BASEDON_ROUTER_POSITION = "ASSIGN_REOPENED_COMPLAINT_BASEDON_ROUTER_POSITION";
    @Autowired
    private ConfigurationRepository configurationRepository;
    @Autowired
    private PriorityService priorityService;

    public Integer getDefaultComplaintResolutionTime() {
        return Integer.valueOf(this.getValueByKey(DEFAULT_RESOLUTION_TIME_KEY));
    }

    public Priority getDefaultComplaintPriority() {
        return this.priorityService.getPriorityByCode(this.getValueByKey(DEFAULT_COMPLAINT_PRIORITY));
    }

    public boolean useAutoCompleteForComplaintType() {
        return Boolean.valueOf(this.getValueByKey(USE_AUTO_COMPLETE_FOR_COMPLAINT_TYPE));
    }

    public boolean assignReopenedComplaintBasedOnRouterPosition() {
        return Boolean.valueOf(this.getValueByKey(ASSIGN_REOPENED_COMPLAINT_BASEDON_ROUTER_POSITION));
    }

    public String getValueByKey(String key) {
        return this.getConfigurationByKey(key).getValue();
    }

    public Configuration getConfigurationByKey(String key) {
        return this.configurationRepository.findByKey(key);
    }
}

