/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.web.support.search.DataTableSearchRequest;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.repository.ComplaintTypeRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ComplaintTypeService {
    private static final String COMPLAINT_COMPLAINT_TYPE = "complaint.complaintType";
    private final ComplaintTypeRepository complaintTypeRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public ComplaintTypeService(ComplaintTypeRepository complaintTypeRepository) {
        this.complaintTypeRepository = complaintTypeRepository;
    }

    public ComplaintType findBy(Long complaintTypeId) {
        return (ComplaintType)((Object)this.complaintTypeRepository.findOne(complaintTypeId));
    }

    @Transactional
    public ComplaintType createComplaintType(ComplaintType complaintType) {
        return (ComplaintType)((Object)this.complaintTypeRepository.save((Object)complaintType));
    }

    @Transactional
    public ComplaintType updateComplaintType(ComplaintType complaintType) {
        return (ComplaintType)((Object)this.complaintTypeRepository.save((Object)complaintType));
    }

    public List<ComplaintType> findAll() {
        return this.complaintTypeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public List<ComplaintType> findAllActiveByNameLike(String name) {
        return this.complaintTypeRepository.findByIsActiveTrueAndNameContainingIgnoreCase(name);
    }

    public List<ComplaintType> findActiveComplaintTypesByCategory(Long categoryId) {
        return this.complaintTypeRepository.findByIsActiveTrueAndCategoryIdOrderByNameAsc(categoryId);
    }

    public ComplaintType findByName(String name) {
        return this.complaintTypeRepository.findByName(name);
    }

    public ComplaintType load(Long id) {
        return (ComplaintType)((Object)this.complaintTypeRepository.getOne(id));
    }

    @ReadOnly
    public Page<ComplaintType> getComplaintType(DataTableSearchRequest request) {
        return this.complaintTypeRepository.findAll((Pageable)new PageRequest(request.pageNumber(), request.pageSize()));
    }

    @ReadOnly
    public List<ComplaintType> getFrequentlyFiledComplaints() {
        DateTime previousDate = new DateTime();
        DateTime currentDate = new DateTime();
        previousDate = previousDate.minusMonths(1);
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(Complaint.class, "complaint");
        criteria.createAlias(COMPLAINT_COMPLAINT_TYPE, "compType");
        criteria.setProjection((Projection)Projections.projectionList().add((Projection)Projections.property((String)COMPLAINT_COMPLAINT_TYPE)).add(Projections.count((String)COMPLAINT_COMPLAINT_TYPE).as("count")).add((Projection)Projections.groupProperty((String)COMPLAINT_COMPLAINT_TYPE)));
        criteria.add(Restrictions.between((String)"complaint.createdDate", (Object)previousDate.toDate(), (Object)currentDate.toDate()));
        criteria.add((Criterion)Restrictions.eq((String)"compType.isActive", (Object)Boolean.TRUE));
        criteria.setMaxResults(5).addOrder(Order.desc((String)"count"));
        List resultList = criteria.list();
        ArrayList<ComplaintType> complaintTypeList = new ArrayList<ComplaintType>();
        for (Object row : resultList) {
            Object[] columns = (Object[])row;
            complaintTypeList.add((ComplaintType)((Object)columns[0]));
        }
        return complaintTypeList;
    }

    public ComplaintType findByCode(String code) {
        return this.complaintTypeRepository.findByCode(code);
    }

    public List<ComplaintType> findActiveComplaintTypes() {
        return this.complaintTypeRepository.findByIsActiveTrueOrderByNameAsc();
    }

    public List<String> getActiveComplaintTypeCode() {
        return this.findActiveComplaintTypes().stream().map(ComplaintType::getCode).collect(Collectors.toList());
    }

    public List<ComplaintType> getComplaintTypeByDepartmentId(Long departmentId) {
        return departmentId == null ? this.findAll() : this.complaintTypeRepository.findByDepartmentId(departmentId);
    }
}

