/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.web.support.search.DataTableSearchRequest;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.pgr.elasticsearch.service.ComplaintIndexService;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.event.ComplaintEventPublisher;
import org.egov.pgr.repository.ComplaintRepository;
import org.egov.pgr.service.CitizenComplaintDataPublisher;
import org.egov.pgr.service.ComplaintNotificationService;
import org.egov.pgr.service.ComplaintProcessFlowService;
import org.egov.pgr.service.ComplaintStatusService;
import org.egov.pgr.service.ConfigurationService;
import org.egov.pgr.utils.constants.PGRConstants;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ComplaintService {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ComplaintRepository complaintRepository;
    @Autowired
    private ComplaintStatusService complaintStatusService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private ComplaintIndexService complaintIndexService;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private ComplaintNotificationService complaintNotificationService;
    @Autowired
    private ComplaintProcessFlowService complaintProcessFlowService;
    @Autowired
    private CitizenComplaintDataPublisher citizenComplaintDataPublisher;
    @Autowired
    private ComplaintEventPublisher complaintEventPublisher;

    @Transactional
    public Complaint createComplaint(Complaint complaint) {
        Boundary location;
        if (StringUtils.isBlank((String)complaint.getCrn())) {
            complaint.setCrn(this.applicationNumberGenerator.generate());
        }
        complaint.setStatus(this.complaintStatusService.getByName("REGISTERED"));
        User user = this.securityUtils.getCurrentUser();
        complaint.getComplainant().setUserDetail(user);
        if (this.securityUtils.currentUserIsCitizen()) {
            complaint.getComplainant().setEmail(user.getEmailId());
            complaint.getComplainant().setName(user.getName());
            complaint.getComplainant().setMobile(user.getMobileNumber());
        }
        if (complaint.getLocation() == null && complaint.hasGeoCoordinates() && (location = this.boundaryService.getBoundaryByGisCoordinates(Double.valueOf(complaint.getLat()), Double.valueOf(complaint.getLng()))) != null) {
            complaint.setLocation(location);
        }
        this.complaintProcessFlowService.onRegistration(complaint);
        if (complaint.getComplaintType().getDepartment() != null) {
            complaint.setDepartment(complaint.getComplaintType().getDepartment());
        } else {
            complaint.setDepartment(complaint.getAssignee().getDeptDesig().getDepartment());
        }
        if (complaint.getPriority() == null) {
            complaint.setPriority(this.configurationService.getDefaultComplaintPriority());
        }
        this.complaintRepository.saveAndFlush((Object)complaint);
        if (this.securityUtils.currentUserIsCitizen()) {
            this.citizenComplaintDataPublisher.onRegistration(complaint);
        }
        this.complaintNotificationService.sendRegistrationMessage(complaint);
        this.complaintIndexService.createComplaintIndex(complaint);
        return complaint;
    }

    @Transactional
    public Complaint updateComplaint(Complaint complaint) {
        this.complaintProcessFlowService.onUpdation(complaint);
        if (complaint.getComplaintType().getDepartment() != null) {
            complaint.setDepartment(complaint.getComplaintType().getDepartment());
        } else {
            complaint.setDepartment(complaint.getAssignee().getDeptDesig().getDepartment());
        }
        this.complaintRepository.saveAndFlush((Object)complaint);
        this.complaintEventPublisher.publishEvent(complaint);
        this.citizenComplaintDataPublisher.onUpdation(complaint);
        this.complaintNotificationService.sendUpdateMessage(complaint);
        this.complaintIndexService.updateComplaintIndex(complaint);
        return complaint;
    }

    public Complaint getComplaintById(Long complaintID) {
        return (Complaint)((Object)this.complaintRepository.findOne(complaintID));
    }

    public Complaint getComplaintByCRN(String crn) {
        return this.complaintRepository.findByCrn(crn);
    }

    @ReadOnly
    public Page<Complaint> getLatest(int page, int pageSize) {
        return this.complaintRepository.findByCreatedByIdNotOrderByCreatedDateDesc(ApplicationThreadLocals.getUserId(), (Pageable)new PageRequest(page - 1, pageSize));
    }

    @ReadOnly
    public Page<Complaint> getMyComplaint(int page, int pageSize) {
        return this.complaintRepository.findByCreatedByIdOrderByCreatedDateDesc(ApplicationThreadLocals.getUserId(), (Pageable)new PageRequest(page - 1, pageSize));
    }

    @ReadOnly
    public List<Complaint> getNearByComplaint(int page, int pageSize, float lat, float lng, long distance) {
        return this.complaintRepository.findByNearestComplaint(ApplicationThreadLocals.getUserId(), Float.valueOf(lat), Float.valueOf(lng), distance, (long)pageSize + 1L, ((long)page - 1L) * (long)pageSize);
    }

    @ReadOnly
    public List<Complaint> getPendingGrievances() {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(Complaint.class, "complaint").createAlias("complaint.status", "status");
        criteria.add(Restrictions.in((String)"status.name", (Object[])PGRConstants.PENDING_STATUS));
        criteria.add(Restrictions.in((String)"complaint.assignee", (Collection)this.positionMasterService.getPositionsForEmployee(ApplicationThreadLocals.getUserId(), new Date())));
        return criteria.list();
    }

    @ReadOnly
    public Page<Complaint> getMyPendingGrievances(int page, int pageSize) {
        return this.complaintRepository.findByCreatedByIdAndStatusNameInOrderByCreatedDateDesc(ApplicationThreadLocals.getUserId(), PGRConstants.PENDING_STATUS, (Pageable)new PageRequest(page - 1, pageSize));
    }

    @ReadOnly
    public Page<Complaint> getMyCompletedGrievances(int page, int pageSize) {
        return this.complaintRepository.findByCreatedByIdAndStatusNameInOrderByCreatedDateDesc(ApplicationThreadLocals.getUserId(), PGRConstants.COMPLETED_STATUS, (Pageable)new PageRequest(page - 1, pageSize));
    }

    @ReadOnly
    public Page<Complaint> getMyRejectedGrievances(int page, int pageSize) {
        return this.complaintRepository.findByCreatedByIdAndStatusNameInOrderByCreatedDateDesc(ApplicationThreadLocals.getUserId(), PGRConstants.REJECTED_STATUS, (Pageable)new PageRequest(page - 1, pageSize));
    }

    @ReadOnly
    public Map<String, Long> getMyComplaintsCount() {
        HashMap<String, Long> complaintsCount = new HashMap<String, Long>();
        complaintsCount.put("ALL", this.complaintRepository.countByCreatedById(ApplicationThreadLocals.getUserId()));
        complaintsCount.put("PENDING", this.complaintRepository.countByCreatedByIdAndStatusNameIn(ApplicationThreadLocals.getUserId(), PGRConstants.PENDING_STATUS));
        complaintsCount.put("COMPLETED", this.complaintRepository.countByCreatedByIdAndStatusNameIn(ApplicationThreadLocals.getUserId(), PGRConstants.COMPLETED_STATUS));
        complaintsCount.put("REJECTED", this.complaintRepository.countByCreatedByIdAndStatusNameIn(ApplicationThreadLocals.getUserId(), PGRConstants.REJECTED_STATUS));
        return complaintsCount;
    }

    @ReadOnly
    public Map<String, Long> getComplaintsTotalCount() {
        HashMap<String, Long> complaintsCount = new HashMap<String, Long>();
        complaintsCount.put("FILED", this.complaintRepository.count());
        complaintsCount.put("RESOLVED", this.complaintRepository.countByStatusNameIn(PGRConstants.RESOLVED_STATUS));
        complaintsCount.put("UNRESOLVED", this.complaintRepository.countByStatusNameIn(PGRConstants.PENDING_STATUS));
        return complaintsCount;
    }

    @ReadOnly
    public List<Complaint> getOpenComplaints() {
        return this.complaintRepository.findByStatusNameIn(Arrays.asList(PGRConstants.PENDING_STATUS));
    }

    @ReadOnly
    public List<Complaint> getActedUponComplaints(int page, int pageSize) {
        User user = this.securityUtils.getCurrentUser();
        List positions = this.positionMasterService.getPositionsForEmployee(user.getId());
        ArrayList<Long> positionIds = new ArrayList<Long>();
        positions.stream().forEach(position -> positionIds.add(position.getId()));
        return this.complaintRepository.findRoutedComplaints(positionIds, Arrays.asList(PGRConstants.PENDING_STATUS), (long)pageSize + 1L, ((long)page - 1L) * (long)pageSize);
    }

    @ReadOnly
    public List<Complaint> getActedUponComplaintCount() {
        User user = this.securityUtils.getCurrentUser();
        ArrayList<Complaint> complaintList = new ArrayList<Complaint>();
        List<Complaint> openComplaints = this.complaintRepository.findByStatusNameIn(Arrays.asList(PGRConstants.PENDING_STATUS));
        List positions = this.positionMasterService.getPositionsForEmployee(user.getId());
        openComplaints.forEach(openComplaint -> {
            if (!openComplaint.getStateHistory().isEmpty()) {
                openComplaint.getStateHistory().stream().sorted(Comparator.comparing(StateHistory::getLastModifiedDate)).findFirst().ifPresent(stateHistory -> {
                    if (positions.contains(stateHistory.getOwnerPosition())) {
                        complaintList.add((Complaint)((Object)openComplaint));
                    }
                });
            }
        });
        return complaintList;
    }

    @ReadOnly
    public Page<Complaint> getComplaints(Specification<Complaint> spec, DataTableSearchRequest searchRequest) {
        return this.complaintRepository.findAll(spec, (Pageable)new PageRequest(searchRequest.pageNumber(), searchRequest.pageSize()));
    }
}

