/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.ComplaintRouter;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.contract.BulkRouterGenerator;
import org.egov.pgr.entity.contract.ComplaintRouterSearchRequest;
import org.egov.pgr.repository.ComplaintRouterRepository;
import org.egov.pgr.repository.specs.ComplaintRouterSpec;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ComplaintRouterService {
    private final ComplaintRouterRepository complaintRouterRepository;
    private final BoundaryService boundaryService;
    @Autowired
    private ReportService reportService;

    @Autowired
    public ComplaintRouterService(ComplaintRouterRepository complaintRouterRepository, BoundaryService boundaryService) {
        this.complaintRouterRepository = complaintRouterRepository;
        this.boundaryService = boundaryService;
    }

    public Position getAssignee(Complaint complaint) {
        Position position = null;
        ComplaintRouter complaintRouter = null;
        ArrayList<Boundary> boundaries = new ArrayList<Boundary>();
        if (null != complaint.getLocation()) {
            this.getParentBoundaries(complaint.getLocation().getId(), boundaries);
            if (null != complaint.getComplaintType()) {
                for (Boundary bndry : boundaries) {
                    complaintRouter = this.complaintRouterRepository.findByComplaintTypeAndBoundary(complaint.getComplaintType(), bndry);
                    if (null == complaintRouter) continue;
                    break;
                }
                if (null == complaintRouter) {
                    complaintRouter = this.complaintRouterRepository.findByOnlyComplaintType(complaint.getComplaintType());
                }
                if (null == complaintRouter) {
                    Boundary bndry;
                    Iterator iterator = boundaries.iterator();
                    while (iterator.hasNext() && null == (complaintRouter = this.complaintRouterRepository.findByOnlyBoundary(bndry = (Boundary)iterator.next()))) {
                    }
                }
            }
        } else {
            complaintRouter = this.complaintRouterRepository.findByOnlyComplaintType(complaint.getComplaintType());
            if (null == complaintRouter) {
                complaintRouter = this.complaintRouterRepository.findCityAdminGrievanceOfficer("ADMINISTRATION");
            }
        }
        if (complaintRouter == null) {
            throw new ApplicationRuntimeException("PGR.001");
        }
        position = complaintRouter.getPosition();
        return position;
    }

    @Transactional
    public ComplaintRouter createComplaintRouter(ComplaintRouter complaintRouter) {
        return (ComplaintRouter)((Object)this.complaintRouterRepository.save((Object)complaintRouter));
    }

    @Transactional
    public ComplaintRouter updateComplaintRouter(ComplaintRouter complaintRouter) {
        return (ComplaintRouter)((Object)this.complaintRouterRepository.save((Object)complaintRouter));
    }

    @Transactional
    public void deleteComplaintRouter(ComplaintRouter complaintRouter) {
        this.complaintRouterRepository.delete((Object)complaintRouter);
    }

    public Boolean validateRouter(ComplaintRouter complaintRouter) {
        Boolean exist = false;
        ComplaintRouter queryResult = null;
        if (null != complaintRouter.getComplaintType() && null != complaintRouter.getBoundary()) {
            queryResult = this.complaintRouterRepository.findByComplaintTypeAndBoundary(complaintRouter.getComplaintType(), complaintRouter.getBoundary());
        }
        if (null != complaintRouter.getBoundary() && null == complaintRouter.getComplaintType()) {
            queryResult = this.complaintRouterRepository.findByOnlyBoundary(complaintRouter.getBoundary());
        }
        if (null != complaintRouter.getComplaintType() && null == complaintRouter.getBoundary()) {
            queryResult = this.complaintRouterRepository.findByOnlyComplaintType(complaintRouter.getComplaintType());
        }
        if (queryResult != null) {
            exist = true;
        }
        return exist;
    }

    public ComplaintRouter getExistingRouter(ComplaintRouter complaintRouter) {
        ComplaintRouter router = null;
        if (null != complaintRouter.getComplaintType() && null != complaintRouter.getBoundary()) {
            router = this.complaintRouterRepository.findByComplaintTypeAndBoundary(complaintRouter.getComplaintType(), complaintRouter.getBoundary());
        }
        if (null != complaintRouter.getBoundary() && null == complaintRouter.getComplaintType()) {
            router = this.complaintRouterRepository.findByOnlyBoundary(complaintRouter.getBoundary());
        }
        if (null != complaintRouter.getComplaintType() && null == complaintRouter.getBoundary()) {
            router = this.complaintRouterRepository.findByOnlyComplaintType(complaintRouter.getComplaintType());
        }
        return router != null ? router : null;
    }

    public ComplaintRouter getRouterById(Long id) {
        return (ComplaintRouter)((Object)this.complaintRouterRepository.findOne(id));
    }

    @ReadOnly
    public Page<ComplaintRouter> getComplaintRouter(ComplaintRouterSearchRequest routerSearchRequest) {
        PageRequest pageable = new PageRequest(routerSearchRequest.pageNumber(), routerSearchRequest.pageSize(), routerSearchRequest.orderDir(), new String[]{routerSearchRequest.orderBy()});
        return this.complaintRouterRepository.findAll(ComplaintRouterSpec.search(routerSearchRequest), (Pageable)pageable);
    }

    @ReadOnly
    public ReportOutput generateRouterReport(ComplaintRouterSearchRequest reportCriteria) {
        ReportRequest reportRequest = new ReportRequest("pgr_routerView", (Object)this.complaintRouterRepository.findAll(ComplaintRouterSpec.search(reportCriteria)));
        reportRequest.setReportFormat(reportCriteria.getPrintFormat());
        return this.reportService.createReport(reportRequest);
    }

    public List<ComplaintRouter> getRoutersByComplaintTypeBoundary(List<ComplaintType> complaintTypes, List<Boundary> boundaries) {
        return this.complaintRouterRepository.findRoutersByComplaintTypesBoundaries(complaintTypes, boundaries);
    }

    private void getParentBoundaries(Long boundaryId, List<Boundary> boundaryList) {
        Boundary boundary = this.boundaryService.getBoundaryById(boundaryId);
        if (boundary != null) {
            boundaryList.add(boundary);
            if (boundary.getParent() != null) {
                this.getParentBoundaries(boundary.getParent().getId(), boundaryList);
            }
        }
    }

    public void createBulkRouter(BulkRouterGenerator bulkRouterGenerator) {
        for (ComplaintType complaintType : bulkRouterGenerator.getComplaintTypes()) {
            for (Boundary boundary : bulkRouterGenerator.getBoundaries()) {
                ComplaintRouter router = new ComplaintRouter();
                router.setComplaintType(complaintType);
                router.setBoundary(boundary);
                router.setPosition(bulkRouterGenerator.getPosition());
                ComplaintRouter existingRouter = this.getExistingRouter(router);
                if (existingRouter != null) {
                    existingRouter.setPosition(bulkRouterGenerator.getPosition());
                    this.updateComplaintRouter(existingRouter);
                    continue;
                }
                this.createComplaintRouter(router);
            }
        }
    }
}

