/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.notification.service.NotificationService;
import org.egov.infra.utils.DateUtils;
import org.egov.pgr.entity.Complaint;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ComplaintNotificationService {
    private static final String COMPLAINT_REGISTERED_SMS_MSG_KEY = "msg.complaint.registered.sms";
    private static final String COMPLAINT_REGISTERED_EMAIL_BODY_MSG_KEY = "msg.complaint.registered.email.body";
    private static final String COMPLAINT_REGISTERED_EMAIL_SUBJECT_MEG_KEY = "msg.complaint.registered.email.subject";
    private static final String COMPLAINT_OFFICIAL_REGISTERED_SMS_MSG_KEY = "msg.complaint.official.registered.sms";
    private static final String COMPLAINT_COMPLETED_SMS_MSG_KEY = "msg.complaint.completed.sms";
    private static final String COMPLAINT_COMPLETED_EMAIL_BODY_MSG_KEY = "msg.complaint.completed.email.body";
    private static final String COMPLAINT_COMPLETED_EMAIL_SUBJECT_MSG_KEY = "msg.complaint.completed.email.subject";
    private static final String COMPLAINT_REJECTED_SMS_MSG_KEY = "msg.complaint.rejected.sms";
    private static final String COMPLAINT_REJECTED_EMAIL_BODY_MSG_KEY = "msg.complaint.rejected.email.body";
    private static final String COMPLAINT_REJECTED_EMAIL_SUBJECT_MSG_KEY = "msg.complaint.rejected.email.subject";
    private static final String COMPLAINT_REOPENED_SMS_MSG_KEY = "msg.complaint.reopened.sms";
    private static final String COMPLAINT_REOPENED_EMAIL_BODY_MSG_KEY = "msg.complaint.reopened.email.body";
    private static final String COMPLAINT_REOPENED_EMAIL_SUBJECT_MSG_KEY = "msg.complaint.reopened.email.subject";
    private static final String COMPLAINT_WITHDRAWN_SMS_MSG_KEY = "msg.complaint.withdrawn.sms";
    private static final String COMPLAINT_WITHDRAWN_EMAIL_BODY_MSG_KEY = "msg.complaint.withdrawn.email.body";
    private static final String COMPLAINT_WITHDRAWN_EMAIL_SUBJECT_MSG_KEY = "msg.complaint.withdrawn.email.subject";
    private static final String COMPLAINT_ESCALATION_EMAIL_SUBJECT_MSG_KEY = "msg.complaint.escalation.email.subject";
    private static final String COMPLAINT_ESCALATION_SMS_NEXTOWNER_MSG_KEY = "msg.complaint.escalation.sms.nextowner";
    private static final String COMPLAINT_ESCALATION_SMS_PREVIOUSOWNER_MSG_KEY = "msg.complaint.escalation.sms.previousowner";
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource complaintMessageSource;
    @Autowired
    private NotificationService notificationService;
    @Autowired
    private AssignmentService assignmentService;

    public void sendRegistrationMessage(Complaint complaint) {
        if ("REGISTERED".equals(complaint.getStatus().getName())) {
            this.notificationService.sendEmail(complaint.getComplainant().getEmail(), this.getMessage(COMPLAINT_REGISTERED_EMAIL_SUBJECT_MEG_KEY, new String[0]), this.getMessageForRegistration(COMPLAINT_REGISTERED_EMAIL_BODY_MSG_KEY, complaint));
            this.notificationService.sendSMS(complaint.getComplainant().getMobile(), this.getMessageForRegistration(COMPLAINT_REGISTERED_SMS_MSG_KEY, complaint));
        }
        this.officialSmsOnRegistration(complaint);
    }

    public void officialSmsOnRegistration(Complaint complaint) {
        Employee user;
        List assignments;
        Position owner = (Position)complaint.getState().getOwnerPosition();
        if (owner != null && !(assignments = this.assignmentService.getAssignmentsForPosition(owner.getId(), new Date())).isEmpty() && (user = ((Assignment)assignments.get(0)).getEmployee()) != null) {
            String smsMsg = this.getMessage(COMPLAINT_OFFICIAL_REGISTERED_SMS_MSG_KEY, complaint.getComplaintType().getName(), complaint.getLocation().getName(), complaint.getComplainant().getName(), complaint.getComplainant().getMobile());
            this.notificationService.sendSMS(user.getMobileNumber(), smsMsg);
        }
    }

    public void sendUpdateMessage(Complaint complaint) {
        switch (complaint.getStatus().getName()) {
            case "COMPLETED": {
                this.notificationService.sendEmail(complaint.getComplainant().getEmail(), this.getMessage(COMPLAINT_COMPLETED_EMAIL_SUBJECT_MSG_KEY, new String[0]), this.getMessageForProcessing(COMPLAINT_COMPLETED_EMAIL_BODY_MSG_KEY, complaint));
                this.notificationService.sendSMS(complaint.getComplainant().getMobile(), this.getMessageForProcessing(COMPLAINT_COMPLETED_SMS_MSG_KEY, complaint));
                break;
            }
            case "REJECTED": {
                this.notificationService.sendEmail(complaint.getComplainant().getEmail(), this.getMessage(COMPLAINT_REJECTED_EMAIL_SUBJECT_MSG_KEY, new String[0]), this.getMessageForProcessing(COMPLAINT_REJECTED_EMAIL_BODY_MSG_KEY, complaint));
                this.notificationService.sendSMS(complaint.getComplainant().getMobile(), this.getMessageForProcessing(COMPLAINT_REJECTED_SMS_MSG_KEY, complaint));
                break;
            }
            case "REOPENED": {
                this.notificationService.sendEmail(complaint.getComplainant().getEmail(), this.getMessage(COMPLAINT_REOPENED_EMAIL_SUBJECT_MSG_KEY, new String[0]), this.getMessageForReopening(COMPLAINT_REOPENED_EMAIL_BODY_MSG_KEY, complaint));
                this.notificationService.sendSMS(complaint.getComplainant().getMobile(), this.getMessageForReopening(COMPLAINT_REOPENED_SMS_MSG_KEY, complaint));
                break;
            }
            case "WITHDRAWN": {
                this.notificationService.sendEmail(complaint.getComplainant().getEmail(), this.getMessage(COMPLAINT_WITHDRAWN_EMAIL_SUBJECT_MSG_KEY, new String[0]), this.getMessageForWithdrawn(COMPLAINT_WITHDRAWN_EMAIL_BODY_MSG_KEY, complaint));
                this.notificationService.sendSMS(complaint.getComplainant().getMobile(), this.getMessageForWithdrawn(COMPLAINT_WITHDRAWN_SMS_MSG_KEY, complaint));
                break;
            }
        }
    }

    public void sendEscalationMessage(Complaint complaint, User nextOwner, Position previousAssignee) {
        List prevUserAssignments = this.assignmentService.getAssignmentsForPosition(previousAssignee.getId(), new Date());
        Employee previousOwner = prevUserAssignments.isEmpty() ? null : ((Assignment)prevUserAssignments.get(0)).getEmployee();
        String previousOwnerName = previousOwner != null ? previousOwner.getName() : previousAssignee.getName();
        String emailSubject = this.getMessage(COMPLAINT_ESCALATION_EMAIL_SUBJECT_MSG_KEY, complaint.getComplaintType().getSlaHours().toString());
        String smsMsgnextOwner = this.getMessage(COMPLAINT_ESCALATION_SMS_NEXTOWNER_MSG_KEY, complaint.getCrn(), complaint.getComplaintType().getName(), nextOwner.getName(), complaint.getAssignee().getName());
        String smsMsgPreviousOwner = this.getMessage(COMPLAINT_ESCALATION_SMS_PREVIOUSOWNER_MSG_KEY, complaint.getCrn(), previousOwnerName, previousAssignee.getDeptDesig().getDesignation().getName(), complaint.getComplaintType().getName());
        if (previousOwner != null) {
            this.notificationService.sendEmail(previousOwner.getEmailId(), emailSubject, smsMsgPreviousOwner);
            this.notificationService.sendSMS(previousOwner.getMobileNumber(), smsMsgPreviousOwner);
        }
        this.notificationService.sendEmail(nextOwner.getEmailId(), emailSubject, smsMsgnextOwner);
        this.notificationService.sendSMS(nextOwner.getMobileNumber(), smsMsgnextOwner);
    }

    @Transactional(readOnly=true)
    public String getEmailBody(Complaint complaint) {
        StringBuilder emailBody = new StringBuilder().append(" %0D%0A Grievance Details -  %0D%0A %0D%0A CRN - ").append(complaint.getCrn()).append(" %0D%0A Grievance Type -").append(complaint.getComplaintType().getName()).append("  %0D%0A Grievance department  - ").append(complaint.getDepartment().getName()).append("  %0D%0A Complainant name - ").append(complaint.getComplainant().getName()).append("  %0D%0A Complainant mobile number - ").append(complaint.getComplainant().getMobile()).append("  %0D%0A Location details - ").append(complaint.getLocation().getName()).append(" %0D%0A Grievance details - ").append(complaint.getDetails()).append(" %0D%0A Grievance status -").append(complaint.getStatus().getName()).append(" %0D%0A Grievance Registration Date - ").append(DateUtils.toDefaultDateTimeFormat((Date)complaint.getCreatedDate()));
        return emailBody.toString();
    }

    private String getMessageForRegistration(String msgKey, Complaint complaint) {
        return this.getMessage(msgKey, complaint.getComplainant().getName(), complaint.getComplaintType().getName(), complaint.getComplaintType().getSlaHours().toString(), ApplicationThreadLocals.getDomainURL(), complaint.getCrn(), ApplicationThreadLocals.getMunicipalityName());
    }

    private String getMessageForProcessing(String msgKey, Complaint complaint) {
        return this.getMessage(msgKey, complaint.getComplainant().getName(), complaint.getComplaintType().getName(), ApplicationThreadLocals.getDomainURL(), complaint.getCrn(), ApplicationThreadLocals.getMunicipalityName());
    }

    private String getMessageForReopening(String msgKey, Complaint complaint) {
        return this.getMessage(msgKey, complaint.getComplainant().getName(), complaint.getComplaintType().getName(), complaint.getComplaintType().getSlaHours().toString(), ApplicationThreadLocals.getDomainURL(), complaint.getCrn(), ApplicationThreadLocals.getMunicipalityName());
    }

    private String getMessageForWithdrawn(String msgKey, Complaint complaint) {
        return this.getMessage(msgKey, complaint.getComplainant().getName(), complaint.getComplaintType().getName(), ApplicationThreadLocals.getMunicipalityName());
    }

    private String getMessage(String key, String ... args) {
        return this.complaintMessageSource.getMessage(key, (Object[])args, Locale.getDefault());
    }
}

