/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.pgr.entity.Complaint;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ComplaintHistoryService {
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private AssignmentService assignmentService;

    @ReadOnly
    public List<HashMap<String, Object>> getHistory(Complaint complaint) {
        ArrayList<HashMap<String, Object>> historyTable = new ArrayList<HashMap<String, Object>>();
        State state = complaint.getState();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("date", state.getDateInfo());
        map.put("comments", StringUtils.defaultString((String)state.getComments()));
        map.put("status", state.getValue());
        if ("Complaint is escalated".equals(state.getComments())) {
            map.put("updatedBy", "SYSTEM");
            map.put("status", "ESCALATED");
        } else if (!state.getLastModifiedBy().getType().equals((Object)UserType.EMPLOYEE)) {
            map.put("updatedBy", complaint.getComplainant().getName());
        } else {
            map.put("updatedBy", StringUtils.defaultIfBlank((CharSequence)state.getSenderName(), (CharSequence)(state.getLastModifiedBy().getUsername() + "::" + state.getLastModifiedBy().getName())));
        }
        map.put("updatedUserType", state.getLastModifiedBy().getType());
        Position ownerPosition = (Position)state.getOwnerPosition();
        User user = state.getOwnerUser();
        if (user != null) {
            map.put("user", user.getUsername() + "::" + user.getName());
            map.put("usertype", user.getType());
            Department department = this.eisCommonService.getDepartmentForUser(user.getId());
            map.put("department", StringUtils.defaultString((String)department.getName()));
        } else if (ownerPosition != null && ownerPosition.getDeptDesig() != null) {
            List assignmentList = this.assignmentService.getAssignmentsForPosition(ownerPosition.getId(), new Date());
            Optional employee = !assignmentList.isEmpty() ? Optional.ofNullable(((Assignment)assignmentList.get(0)).getEmployee()) : Optional.empty();
            map.put("user", employee.isPresent() ? ((Employee)employee.get()).getUsername() + "::" + ((Employee)employee.get()).getName() + "::" + ownerPosition.getDeptDesig().getDesignation().getName() : "NO ASSIGNMENT" + "::" + ownerPosition.getName());
            map.put("usertype", employee.isPresent() ? ((Employee)employee.get()).getType() : "");
            map.put("department", ownerPosition.getDeptDesig().getDepartment().getName());
        }
        historyTable.add(map);
        complaint.getStateHistory().stream().sorted(Comparator.comparing(StateHistory::getLastModifiedDate).reversed()).forEach(stateHistory -> historyTable.add(this.constructComplaintHistory(complaint, (StateHistory<Position>)stateHistory)));
        return historyTable;
    }

    private HashMap<String, Object> constructComplaintHistory(Complaint complaint, StateHistory<Position> stateHistory) {
        HashMap<String, Object> complaintHistory = new HashMap<String, Object>();
        complaintHistory.put("date", stateHistory.getDateInfo());
        complaintHistory.put("comments", StringUtils.defaultString((String)stateHistory.getComments()));
        complaintHistory.put("status", stateHistory.getValue());
        if ("Complaint is escalated".equals(stateHistory.getComments())) {
            complaintHistory.put("updatedBy", "SYSTEM");
            complaintHistory.put("status", "ESCALATED");
        } else {
            complaintHistory.put("updatedBy", stateHistory.getLastModifiedBy().getType().equals((Object)UserType.EMPLOYEE) ? stateHistory.getSenderName() : complaint.getComplainant().getName());
        }
        complaintHistory.put("updatedUserType", stateHistory.getLastModifiedBy().getType());
        Position owner = (Position)stateHistory.getOwnerPosition();
        User userobj = stateHistory.getOwnerUser();
        if (userobj != null) {
            complaintHistory.put("user", userobj.getUsername() + "::" + userobj.getName());
            complaintHistory.put("usertype", userobj.getType());
            Department department = this.eisCommonService.getDepartmentForUser(userobj.getId());
            complaintHistory.put("department", department != null ? department.getName() : "");
        } else if (owner != null && owner.getDeptDesig() != null) {
            List assignments = this.assignmentService.getAssignmentsForPosition(owner.getId(), new Date());
            complaintHistory.put("user", !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee().getUsername() + "::" + ((Assignment)assignments.get(0)).getEmployee().getName() + "::" + owner.getDeptDesig().getDesignation().getName() : "NO ASSIGNMENT::" + owner.getName());
            complaintHistory.put("usertype", !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee().getType() : "");
            complaintHistory.put("department", owner.getDeptDesig().getDepartment() != null ? owner.getDeptDesig().getDepartment().getName() : "");
        }
        return complaintHistory;
    }
}

