/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.time.DateUtils;
import org.egov.commons.ObjectType;
import org.egov.commons.service.ObjectTypeService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.PositionHierarchy;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionHierarchyService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.OwnerGroup;
import org.egov.pgr.elasticsearch.service.ComplaintIndexService;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.Escalation;
import org.egov.pgr.entity.contract.BulkEscalationGenerator;
import org.egov.pgr.entity.contract.EscalationForm;
import org.egov.pgr.entity.contract.EscalationHelper;
import org.egov.pgr.entity.contract.EscalationTimeSearchRequest;
import org.egov.pgr.entity.enums.ComplaintStatus;
import org.egov.pgr.repository.ComplaintRepository;
import org.egov.pgr.repository.EscalationRepository;
import org.egov.pgr.repository.specs.EscalationTimeSpec;
import org.egov.pgr.service.ComplaintNotificationService;
import org.egov.pgr.service.ComplaintTypeService;
import org.egov.pgr.service.ConfigurationService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ComplaintEscalationService {
    private static final Logger LOG = LoggerFactory.getLogger(ComplaintEscalationService.class);
    private static final String COMPLAINT_STATUS_NAME = "complaintStatus.name";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private EscalationRepository escalationRepository;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private ObjectTypeService objectTypeService;
    @Autowired
    private ComplaintRepository complaintRepository;
    @Autowired
    private ConfigurationService configurationService;
    @Autowired
    private PositionHierarchyService positionHierarchyService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private UserService userService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ComplaintIndexService complaintIndexService;
    @Autowired
    private ComplaintNotificationService complaintNotificationService;
    @Autowired
    private ComplaintTypeService complaintTypeService;
    @Autowired
    private DesignationService designationService;

    @Transactional
    public void create(Escalation escalation) {
        this.escalationRepository.save((Object)escalation);
    }

    @Transactional
    public void update(Escalation escalation) {
        this.escalationRepository.save((Object)escalation);
    }

    @Transactional
    public void delete(Escalation escalation) {
        this.escalationRepository.delete((Object)escalation);
    }

    public List<Escalation> findAllBycomplaintTypeId(Long complaintTypeId) {
        return this.escalationRepository.findEscalationByComplaintTypeId(complaintTypeId);
    }

    @Transactional
    public void escalateComplaint() {
        try {
            ObjectType objectType = this.objectTypeService.getObjectTypeByName("Complaint");
            if (objectType == null) {
                LOG.warn("Escalation can't be done, Object Type {} not found", (Object)"Complaint");
                return;
            }
            boolean sendMessage = "YES".equalsIgnoreCase(((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("PGR", "SENDEMAILFORESCALATION").get(0)).getValue());
            this.getComplaintsEligibleForEscalation().forEach(complaint -> this.findNextOwnerAndEscalate((Complaint)((Object)complaint), objectType, sendMessage));
        }
        catch (RuntimeException e) {
            LOG.error("An error occurred, escalation can't be completed ", (Throwable)e);
        }
    }

    private void findNextOwnerAndEscalate(Complaint complaint, ObjectType objectType, boolean sendMessage) {
        PositionHierarchy positionHierarchy = this.positionHierarchyService.getPosHirByPosAndObjectTypeAndObjectSubType(complaint.getAssignee().getId(), objectType.getId(), complaint.getComplaintType().getCode());
        Position nextAssignee = null;
        User nextOwner = null;
        if (positionHierarchy != null) {
            nextAssignee = positionHierarchy.getToPosition();
            List superiorAssignments = this.assignmentService.getAssignmentsForPosition(nextAssignee.getId(), new Date());
            nextOwner = !superiorAssignments.isEmpty() ? ((Assignment)superiorAssignments.get(0)).getEmployee() : null;
        } else {
            Set users = this.userService.getUsersByRoleName("Grievance Routing Officer");
            if (!users.isEmpty()) {
                nextOwner = (User)users.iterator().next();
            }
            if (nextOwner != null) {
                List positionList = this.positionMasterService.getPositionsForEmployee(nextOwner.getId(), new Date());
                if (!positionList.isEmpty()) {
                    nextAssignee = (Position)positionList.iterator().next();
                } else {
                    LOG.warn("Could not escalate, no position defined for Grievance Officer role");
                }
            } else {
                LOG.warn("Could not escalate, no user defined for Grievance Officer role");
            }
        }
        this.updateComplaintEscalation(complaint, nextAssignee, nextOwner, sendMessage);
    }

    private void updateComplaintEscalation(Complaint complaint, Position nextAssignee, User nextOwner, boolean sendMessage) {
        if (nextAssignee != null && nextOwner != null && !nextAssignee.equals((Object)complaint.getAssignee())) {
            Position previousAssignee = complaint.getAssignee();
            complaint.setEscalationDate(this.getExpiryDate(complaint));
            complaint.setAssignee(nextAssignee);
            complaint.setCurrentOwner(nextOwner);
            complaint.transition().progress().withOwner((OwnerGroup)nextAssignee).withComments("Complaint is escalated").withDateInfo(new Date()).withStateValue(complaint.getStatus().getName()).withSenderName(this.securityUtils.getCurrentUser().getName());
            this.complaintRepository.saveAndFlush((Object)complaint);
            this.complaintIndexService.updateComplaintEscalationIndexValues(complaint);
            if (sendMessage) {
                this.complaintNotificationService.sendEscalationMessage(complaint, nextOwner, previousAssignee);
            }
        }
    }

    public Date getExpiryDate(Complaint complaint) {
        Designation designation = complaint.getAssignee().getDeptDesig().getDesignation();
        Integer noOfhrs = this.getHrsToResolve(designation.getId(), complaint.getComplaintType().getId());
        return DateUtils.addHours((Date)new Date(), (int)noOfhrs);
    }

    public Integer getHrsToResolve(Long designationId, Long complaintTypeId) {
        Escalation escalation = this.escalationRepository.findByDesignationAndComplaintType(designationId, complaintTypeId);
        return escalation != null ? escalation.getNoOfHrs() : this.configurationService.getDefaultComplaintResolutionTime();
    }

    @Transactional
    public void deleteAllInBatch(List<Escalation> entities) {
        this.escalationRepository.deleteInBatch(entities);
    }

    public Page<Escalation> getEscalationsTime(EscalationTimeSearchRequest escalationTimeSearchRequest) {
        PageRequest pageable = new PageRequest(escalationTimeSearchRequest.pageNumber(), escalationTimeSearchRequest.pageSize(), escalationTimeSearchRequest.orderDir(), new String[]{escalationTimeSearchRequest.orderBy()});
        return this.escalationRepository.findAll(EscalationTimeSpec.search(escalationTimeSearchRequest), (Pageable)pageable);
    }

    public List<PositionHierarchy> getEscalationObjByComplaintTypeFromPosition(List<ComplaintType> complaintTypes, Position fromPosition) {
        List compTypeCodes = complaintTypes.parallelStream().map(ComplaintType::getCode).collect(Collectors.toList());
        ObjectType objectType = this.objectTypeService.getObjectTypeByName("Complaint");
        return this.positionHierarchyService.getListOfPositionHeirarchyByPositionObjectTypeSubType(objectType.getId(), compTypeCodes, fromPosition);
    }

    public PositionHierarchy getExistingEscalation(PositionHierarchy positionHierarchy) {
        PositionHierarchy existingPosHierarchy = null;
        if (null != positionHierarchy.getObjectSubType() && null != positionHierarchy.getFromPosition() && null != positionHierarchy.getToPosition()) {
            existingPosHierarchy = this.positionHierarchyService.getPosHirByPosAndObjectTypeAndObjectSubType(positionHierarchy.getFromPosition().getId(), positionHierarchy.getObjectType().getId(), positionHierarchy.getObjectSubType());
        }
        return existingPosHierarchy != null ? existingPosHierarchy : null;
    }

    public Escalation getEscalationBycomplaintTypeAndDesignation(Long complaintTypeId, Long designationId) {
        return this.escalationRepository.findByDesignationAndComplaintType(designationId, complaintTypeId);
    }

    public List<Complaint> getComplaintsEligibleForEscalation() {
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(Complaint.class, "complaint").createAlias("complaint.status", "complaintStatus");
        criteria.add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.eq((String)COMPLAINT_STATUS_NAME, (Object)ComplaintStatus.REOPENED.name())).add((Criterion)Restrictions.eq((String)COMPLAINT_STATUS_NAME, (Object)ComplaintStatus.FORWARDED.name())).add((Criterion)Restrictions.eq((String)COMPLAINT_STATUS_NAME, (Object)ComplaintStatus.PROCESSING.name())).add((Criterion)Restrictions.eq((String)COMPLAINT_STATUS_NAME, (Object)ComplaintStatus.REGISTERED.name()))).add((Criterion)Restrictions.lt((String)"complaint.escalationDate", (Object)new DateTime().toDate())).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    @Transactional
    public void updateEscalationTime(EscalationForm escalationForm) {
        ComplaintType compType = null;
        if (escalationForm.getComplaintType() != null && escalationForm.getComplaintType().getId() != null) {
            compType = this.complaintTypeService.findBy(escalationForm.getComplaintType().getId());
            List<Escalation> escalationList = this.findAllBycomplaintTypeId(escalationForm.getComplaintType().getId());
            if (!escalationList.isEmpty()) {
                this.deleteAllInBatch(escalationList);
            }
        }
        if (compType != null && escalationForm.getEscalationList() != null && !escalationForm.getEscalationList().isEmpty()) {
            for (Escalation escalation : escalationForm.getEscalationList()) {
                if (escalation.getDesignation() == null) continue;
                Designation desig = this.designationService.getDesignationById(escalation.getDesignation().getId());
                escalation.setComplaintType(compType);
                escalation.setDesignation(desig);
                escalation.setNoOfHrs(escalation.getNoOfHrs());
                this.create(escalation);
            }
        }
    }

    public List<EscalationHelper> viewEscalation(Optional<Long> positionId, Optional<Long> complaintId) {
        ComplaintType complaintType = this.complaintTypeService.findBy(complaintId.get());
        ObjectType objectType = this.objectTypeService.getObjectTypeByName("Complaint");
        ArrayList<EscalationHelper> escalationHelpers = new ArrayList<EscalationHelper>();
        if (objectType != null) {
            List<String> activeComplaintTypeCodes = this.complaintTypeService.getActiveComplaintTypeCode();
            List<PositionHierarchy> positionHierarchies = this.positionHierarchyService.getListOfPositionHeirarchyByFromPositionAndObjectTypeAndSubType(positionId.get(), objectType.getId(), complaintType != null ? complaintType.getCode() : null).stream().filter(posHir -> activeComplaintTypeCodes.contains(posHir.getObjectSubType())).collect(Collectors.toList());
            return this.getEscalationDetailByPositionHierarchy(positionHierarchies);
        }
        return escalationHelpers;
    }

    public List<EscalationHelper> getEscalationDetailByPositionHierarchy(List<PositionHierarchy> positionHierarchies) {
        ArrayList<EscalationHelper> escalationHelpers = new ArrayList<EscalationHelper>();
        for (PositionHierarchy posHir : positionHierarchies) {
            EscalationHelper escalationHelper = new EscalationHelper();
            if (posHir.getObjectSubType() != null) {
                escalationHelper.setComplaintType(this.complaintTypeService.findByCode(posHir.getObjectSubType()));
            }
            escalationHelper.setFromPosition(posHir.getFromPosition());
            escalationHelper.setToPosition(posHir.getToPosition());
            escalationHelpers.add(escalationHelper);
        }
        return escalationHelpers;
    }

    @Transactional
    public void updateBulkEscalation(BulkEscalationGenerator bulkEscalationGenerator) {
        for (ComplaintType complaintType : bulkEscalationGenerator.getComplaintTypes()) {
            ObjectType objectType = this.objectTypeService.getObjectTypeByName("Complaint");
            PositionHierarchy positionHierarchy = new PositionHierarchy();
            positionHierarchy.setObjectType(objectType);
            positionHierarchy.setObjectSubType(complaintType.getCode());
            positionHierarchy.setFromPosition(bulkEscalationGenerator.getFromPosition());
            positionHierarchy.setToPosition(bulkEscalationGenerator.getToPosition());
            PositionHierarchy existingPosHierarchy = this.getExistingEscalation(positionHierarchy);
            if (existingPosHierarchy != null) {
                existingPosHierarchy.setToPosition(bulkEscalationGenerator.getToPosition());
                this.positionHierarchyService.updatePositionHierarchy(existingPosHierarchy);
                continue;
            }
            this.positionHierarchyService.createPositionHierarchy(positionHierarchy);
        }
    }

    @Transactional
    public void updateEscalation(Long id, EscalationForm escalationForm) {
        ObjectType objectType = this.objectTypeService.getObjectTypeByName("Complaint");
        List existingPosHierarchy = this.positionHierarchyService.getPositionHeirarchyByFromPositionAndObjectType(id, objectType.getId());
        if (!existingPosHierarchy.isEmpty()) {
            this.positionHierarchyService.deleteAllInBatch(existingPosHierarchy);
        }
        for (PositionHierarchy posHierarchy : escalationForm.getPositionHierarchyList()) {
            if (posHierarchy.getFromPosition() == null || posHierarchy.getToPosition() == null) continue;
            posHierarchy.setFromPosition(this.positionMasterService.getPositionById(posHierarchy.getFromPosition().getId()));
            posHierarchy.setToPosition(this.positionMasterService.getPositionById(posHierarchy.getToPosition().getId()));
            posHierarchy.setObjectType(objectType);
            posHierarchy.setObjectSubType(posHierarchy.getObjectSubType());
            this.positionHierarchyService.createPositionHierarchy(posHierarchy);
        }
    }
}

