/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.repository.specs;

import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang.StringUtils;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.contract.QualityReviewSearchRequest;
import org.springframework.data.jpa.domain.Specification;

public final class QualityReviewSearchSpec {
    private QualityReviewSearchSpec() {
    }

    public static Specification<Complaint> search(QualityReviewSearchRequest qualityReviewSearchRequest) {
        return (root, query, builder) -> {
            Predicate predicate = builder.conjunction();
            if (qualityReviewSearchRequest.getComplaintId() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("complaintType").get("id"), (Object)qualityReviewSearchRequest.getComplaintId()));
            }
            if (StringUtils.isNotBlank((String)qualityReviewSearchRequest.getCrn())) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("crn"), (Object)qualityReviewSearchRequest.getCrn()));
            }
            if (qualityReviewSearchRequest.getToDate() != null) {
                predicate.getExpressions().add(builder.lessThanOrEqualTo((Expression)root.get("createdDate"), (Comparable)qualityReviewSearchRequest.getToDate()));
            }
            if (qualityReviewSearchRequest.getFromDate() != null) {
                predicate.getExpressions().add(builder.greaterThanOrEqualTo((Expression)root.get("createdDate"), (Comparable)qualityReviewSearchRequest.getFromDate()));
            }
            if (qualityReviewSearchRequest.getLocationId() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("location").get("id"), (Object)qualityReviewSearchRequest.getLocationId()));
            }
            if (qualityReviewSearchRequest.getChildLocationId() != null) {
                predicate.getExpressions().add(builder.equal((Expression)root.get("childLocation").get("id"), (Object)qualityReviewSearchRequest.getChildLocationId()));
            }
            predicate.getExpressions().add(builder.or((Expression)root.get("citizenFeedback").in(new Object[]{0, 1, 2}), (Expression)root.get("citizenFeedback").isNull()));
            return predicate;
        };
    }
}

