/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.report.service;

import java.util.HashMap;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.persistence.utils.Page;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.pgr.report.entity.contract.DrilldownReportRequest;
import org.egov.pgr.report.entity.view.DrilldownReportView;
import org.egov.pgr.report.repository.GrievanceTypewiseReportRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class GrievanceTypewiseReportService {
    @Autowired
    private GrievanceTypewiseReportRepository grievanceTypewiseReportRepository;
    @Autowired
    private ReportService reportService;

    @ReadOnly
    public Page<DrilldownReportView> pagedGrievanceTypewiseRecords(DrilldownReportRequest reportRequest) {
        return this.grievanceTypewiseReportRepository.findGrievanceTypewiseRecord(reportRequest);
    }

    @ReadOnly
    public Page<DrilldownReportView> pagedGrievanceTypewiseRecordsByCompalintId(DrilldownReportRequest reportRequest) {
        return this.grievanceTypewiseReportRepository.findGrievanceTypewiseRecordsByComplaintId(reportRequest);
    }

    @ReadOnly
    public Object[] grievanceTypewiseReportGrandTotal(DrilldownReportRequest reportRequest) {
        return this.grievanceTypewiseReportRepository.findGrandTotal(reportRequest);
    }

    @ReadOnly
    public ReportOutput generateGrievanceTypewiseReport(DrilldownReportRequest reportCriteria) {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("type", "complaintwise");
        ReportRequest reportRequest = new ReportRequest("pgr_functionarywise_report", this.grievanceTypewiseReportRepository.findGrievanceTypewiseRecordList(reportCriteria), reportParams);
        reportRequest.setReportFormat(reportCriteria.getPrintFormat());
        return this.reportService.createReport(reportRequest);
    }

    @ReadOnly
    public ReportOutput generateGrievanceTypewiseReportByComplaintId(DrilldownReportRequest reportCriteria) {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("type", "complaintwise");
        ReportRequest reportRequest = new ReportRequest("pgr_functionarywise_report_comp", this.grievanceTypewiseReportRepository.findGrievanceTypewiseRecordlistByComplaintId(reportCriteria), reportParams);
        reportRequest.setReportFormat(reportCriteria.getPrintFormat());
        return this.reportService.createReport(reportRequest);
    }
}

