/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.report.service;

import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.persistence.utils.Page;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.pgr.report.entity.contract.DrilldownReportRequest;
import org.egov.pgr.report.entity.view.DrilldownReportView;
import org.egov.pgr.report.repository.FunctionarywiseReportRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class FunctionarywiseReportService {
    @Autowired
    private FunctionarywiseReportRepository functionarywiseReportRepository;
    @Autowired
    private ReportService reportService;

    @ReadOnly
    public Page<DrilldownReportView> pagedFunctionarwiseRecords(DrilldownReportRequest request) {
        return this.functionarywiseReportRepository.findByFunctionarywiseRequest(request);
    }

    @ReadOnly
    public Page<DrilldownReportView> pagedFunctionarwiseReportByCompalints(DrilldownReportRequest request) {
        return this.functionarywiseReportRepository.findComplaintsByEmployeeId(request);
    }

    @ReadOnly
    public Object[] functionarywiseReportGrandTotal(DrilldownReportRequest request) {
        return this.functionarywiseReportRepository.findGrandTotalByRequest(request);
    }

    @ReadOnly
    public ReportOutput generateFunctionarywiseReport(DrilldownReportRequest reportCriteria) {
        ReportRequest reportRequest = new ReportRequest("pgr_functionarywise_report", this.functionarywiseReportRepository.findFunctionarywiseReportByRequest(reportCriteria));
        reportRequest.setReportFormat(reportCriteria.getPrintFormat());
        return this.reportService.createReport(reportRequest);
    }

    @ReadOnly
    public ReportOutput generateFunctionaryEmployeewiseReport(DrilldownReportRequest reportCriteria) {
        ReportRequest reportRequest = new ReportRequest("pgr_functionarywise_report_comp", this.functionarywiseReportRepository.findFunctionarywiseReportByEmployeeId(reportCriteria));
        reportRequest.setReportFormat(reportCriteria.getPrintFormat());
        return this.reportService.createReport(reportRequest);
    }
}

