/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.report.service;

import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.pgr.entity.contract.EscalationRouterRequest;
import org.egov.pgr.entity.contract.EscalationRouterView;
import org.egov.pgr.report.repository.EscalationRouterReportRepository;
import org.egov.pgr.repository.specs.EscalationRouterSpec;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EscalationRouterReportService {
    @Autowired
    private EscalationRouterReportRepository escalationRouterReportRepository;
    @Autowired
    private ReportService reportService;

    @ReadOnly
    public Page<EscalationRouterView> pagedEscalationRouterReport(EscalationRouterRequest escalationRouterRequest) {
        PageRequest pageable = new PageRequest(escalationRouterRequest.pageNumber(), escalationRouterRequest.pageSize(), escalationRouterRequest.orderDir(), new String[]{escalationRouterRequest.orderBy()});
        return this.escalationRouterReportRepository.findAll(new EscalationRouterSpec(escalationRouterRequest), (Pageable)pageable);
    }

    @ReadOnly
    public ReportOutput generateEscalationRouterReport(EscalationRouterRequest reportCriteria) {
        ReportRequest reportRequest = new ReportRequest("pgr_routerescalation_report", (Object)this.escalationRouterReportRepository.findAll(new EscalationRouterSpec(reportCriteria)));
        reportRequest.setReportFormat(reportCriteria.getPrintFormat());
        return this.reportService.createReport(reportRequest);
    }
}

