/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.report.service;

import java.util.HashMap;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.persistence.utils.Page;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.pgr.report.entity.contract.DrilldownReportRequest;
import org.egov.pgr.report.entity.view.DrilldownReportView;
import org.egov.pgr.report.repository.DrilldownReportRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DrillDownReportService {
    @Autowired
    private DrilldownReportRepository drilldownReportRepository;
    @Autowired
    private ReportService reportService;

    @ReadOnly
    public Page<DrilldownReportView> pagedDrilldownRecords(DrilldownReportRequest reportRequest) {
        return this.drilldownReportRepository.findDrilldownRecords(reportRequest);
    }

    @ReadOnly
    public Page<DrilldownReportView> pagedDrilldownRecordsByCompalintId(DrilldownReportRequest reportRequest) {
        return this.drilldownReportRepository.findDrilldownRecordsByComplaintTypeId(reportRequest);
    }

    @ReadOnly
    public Object[] drilldownRecordsGrandTotal(DrilldownReportRequest reportRequest) {
        return this.drilldownReportRepository.findDrilldownGrandTotal(reportRequest);
    }

    @ReadOnly
    public ReportOutput generateDrilldownReport(DrilldownReportRequest reportCriteria) {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("groupBy", reportCriteria.getGroupBy());
        reportParams.put("reportTitle", reportCriteria.getReportTitle());
        ReportRequest reportRequest = new ReportRequest("pgr_functionarywise_report", this.drilldownReportRepository.findDrilldownRecordList(reportCriteria), reportParams);
        reportRequest.setReportFormat(reportCriteria.getPrintFormat());
        return this.reportService.createReport(reportRequest);
    }

    @ReadOnly
    public ReportOutput generateComplaintwiseDrilldownReport(DrilldownReportRequest reportCriteria) {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("groupBy", reportCriteria.getGroupBy());
        reportParams.put("reportTitle", reportCriteria.getReportTitle());
        ReportRequest reportRequest = new ReportRequest("pgr_functionarywise_report_comp", this.drilldownReportRepository.findDrilldownRecordsByRequest(reportCriteria), reportParams);
        reportRequest.setReportFormat(reportCriteria.getPrintFormat());
        return this.reportService.createReport(reportRequest);
    }
}

