/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.report.service;

import java.util.HashMap;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.persistence.utils.Page;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.pgr.report.entity.contract.AgeingReportRequest;
import org.egov.pgr.report.entity.view.AgeingReportView;
import org.egov.pgr.report.repository.AgeingReportRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AgeingReportService {
    @Autowired
    private AgeingReportRepository ageingReportRepository;
    @Autowired
    private ReportService reportService;

    @ReadOnly
    public Page<AgeingReportView> pagedAgeingRecords(AgeingReportRequest request) {
        return this.ageingReportRepository.findByAgeingReportResult(request);
    }

    @ReadOnly
    public Object[] ageingReportGrandTotal(AgeingReportRequest request) {
        return this.ageingReportRepository.getGrandTotal(request);
    }

    @ReadOnly
    public ReportOutput generateAgeingReport(AgeingReportRequest reportCriteria) {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("status", reportCriteria.getStatus());
        ReportRequest reportRequest = new ReportRequest("pgr_ageing_report", this.ageingReportRepository.getAgeingReportRecords(reportCriteria), reportParams);
        reportRequest.setReportFormat(reportCriteria.getPrintFormat());
        return this.reportService.createReport(reportRequest);
    }
}

