/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.report.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.egov.infra.persistence.utils.Page;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.StringUtils;
import org.egov.pgr.report.entity.contract.DrilldownReportRequest;
import org.egov.pgr.report.entity.view.DrilldownReportView;
import org.egov.pgr.report.repository.FunctionarywiseReportRepositoryCustom;
import org.springframework.data.domain.Sort;

public class FunctionarywiseReportRepositoryImpl
implements FunctionarywiseReportRepositoryCustom {
    private static final String CREATED_DATE = "createdDate";
    private static final String EMPLOYEE_ID = "employeeId";
    private static final String EMPLOYEE_NAME = "employeeName";
    private static final String STATUS = "status";
    private static final String REGISTERED = "registered";
    private static final String INPROCESS = "inprocess";
    private static final String COMPLETED = "completed";
    private static final String REOPENED = "reopened";
    private static final String REJECTED = "rejected";
    private static final String WITHINSLA = "withinSLA";
    private static final String BEYONDSLA = "beyondSLA";
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<DrilldownReportView> findByFunctionarywiseRequest(DrilldownReportRequest reportRequest) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DrilldownReportView.class);
        Root root = criteriaQuery.from(DrilldownReportView.class);
        CriteriaQuery recordCountQuery = criteriaBuilder.createQuery(DrilldownReportView.class);
        Root countRoot = recordCountQuery.from(DrilldownReportView.class);
        recordCountQuery.multiselect(new Selection[]{criteriaBuilder.count((Expression)countRoot)}).where(this.criteria(reportRequest, criteriaBuilder, (Root<DrilldownReportView>)countRoot).toArray(new Predicate[0])).groupBy(new Expression[]{countRoot.get(EMPLOYEE_ID), countRoot.get(EMPLOYEE_NAME)});
        CriteriaQuery<DrilldownReportView> reportQuery = this.generateReportByRequest((CriteriaQuery<DrilldownReportView>)criteriaQuery, reportRequest, criteriaBuilder, (Root<DrilldownReportView>)root);
        if (reportRequest.orderBy().equals(EMPLOYEE_NAME)) {
            reportQuery.orderBy(new Order[]{reportRequest.orderDir().equals((Object)Sort.Direction.ASC) ? criteriaBuilder.asc((Expression)root.get(reportRequest.orderBy())) : criteriaBuilder.desc((Expression)root.get(reportRequest.orderBy()))});
        } else {
            reportQuery.orderBy(new Order[]{reportRequest.orderDir().equals((Object)Sort.Direction.ASC) ? criteriaBuilder.asc(criteriaBuilder.sum((Expression)root.get(reportRequest.orderBy()))) : criteriaBuilder.desc(criteriaBuilder.sum((Expression)root.get(reportRequest.orderBy())))});
        }
        return new Page(this.entityManager.createQuery(reportQuery), reportRequest.pageNumber() + 1, reportRequest.pageSize(), this.entityManager.createQuery(recordCountQuery).getResultList().size());
    }

    @Override
    public Page<DrilldownReportView> findComplaintsByEmployeeId(DrilldownReportRequest reportRequest) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DrilldownReportView.class);
        Root root = criteriaQuery.from(DrilldownReportView.class);
        CriteriaQuery countCriteriaQuery = criteriaBuilder.createQuery(DrilldownReportView.class);
        Root countRoot = countCriteriaQuery.from(DrilldownReportView.class);
        countCriteriaQuery.multiselect(new Selection[]{criteriaBuilder.count((Expression)countRoot.get("crn"))}).where(this.criteria(reportRequest, criteriaBuilder, (Root<DrilldownReportView>)countRoot).toArray(new Predicate[0])).groupBy(new Expression[]{countRoot.get("crn")});
        TypedQuery query = this.entityManager.createQuery(this.generateReportByEmployeeId((CriteriaQuery<DrilldownReportView>)criteriaQuery, reportRequest, criteriaBuilder, (Root<DrilldownReportView>)root).orderBy(new Order[]{reportRequest.orderDir().equals((Object)Sort.Direction.ASC) ? criteriaBuilder.asc((Expression)root.get(reportRequest.orderBy())) : criteriaBuilder.desc((Expression)root.get(reportRequest.orderBy()))}));
        TypedQuery countquery = this.entityManager.createQuery(countCriteriaQuery);
        return new Page(query, reportRequest.pageNumber() + 1, reportRequest.pageSize(), countquery.getResultList().size());
    }

    @Override
    public Object[] findGrandTotalByRequest(DrilldownReportRequest reportRequest) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Object[].class);
        Root root = criteriaQuery.from(DrilldownReportView.class);
        criteriaQuery.multiselect(new Selection[]{criteriaBuilder.sum((Expression)root.get(REGISTERED)), criteriaBuilder.sum((Expression)root.get(INPROCESS)), criteriaBuilder.sum((Expression)root.get(COMPLETED)), criteriaBuilder.sum((Expression)root.get(REJECTED)), criteriaBuilder.sum((Expression)root.get(REOPENED)), criteriaBuilder.sum((Expression)root.get(WITHINSLA)), criteriaBuilder.sum((Expression)root.get(BEYONDSLA))}).where(this.criteria(reportRequest, criteriaBuilder, (Root<DrilldownReportView>)root).toArray(new Predicate[0]));
        return (Object[])this.entityManager.createQuery(criteriaQuery).getSingleResult();
    }

    @Override
    public List<DrilldownReportView> findFunctionarywiseReportByEmployeeId(DrilldownReportRequest reportRequest) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DrilldownReportView.class);
        Root root = criteriaQuery.from(DrilldownReportView.class);
        return this.entityManager.createQuery(this.generateReportByEmployeeId((CriteriaQuery<DrilldownReportView>)criteriaQuery, reportRequest, criteriaBuilder, (Root<DrilldownReportView>)root)).getResultList();
    }

    @Override
    public List<DrilldownReportView> findFunctionarywiseReportByRequest(DrilldownReportRequest reportRequest) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DrilldownReportView.class);
        Root root = criteriaQuery.from(DrilldownReportView.class);
        return this.entityManager.createQuery(this.generateReportByRequest((CriteriaQuery<DrilldownReportView>)criteriaQuery, reportRequest, criteriaBuilder, (Root<DrilldownReportView>)root)).getResultList();
    }

    private CriteriaQuery<DrilldownReportView> generateReportByEmployeeId(CriteriaQuery<DrilldownReportView> criteriaQuery, DrilldownReportRequest reportRequest, CriteriaBuilder criteriaBuilder, Root<DrilldownReportView> root) {
        criteriaQuery.multiselect(new Selection[]{root.get("complainantId"), root.get("crn"), root.get(CREATED_DATE), root.get("complainantName"), root.get("complaintDetail"), root.get(STATUS), root.get("boundaryName"), root.get("feedback"), root.get("isSLA")}).where(this.criteria(reportRequest, criteriaBuilder, root).toArray(new Predicate[0]));
        return criteriaQuery;
    }

    private CriteriaQuery<DrilldownReportView> generateReportByRequest(CriteriaQuery<DrilldownReportView> criteriaQuery, DrilldownReportRequest reportRequest, CriteriaBuilder criteriaBuilder, Root<DrilldownReportView> root) {
        criteriaQuery.multiselect(new Selection[]{root.get(EMPLOYEE_ID), root.get(EMPLOYEE_NAME), criteriaBuilder.sum((Expression)root.get(REGISTERED)), criteriaBuilder.sum((Expression)root.get(INPROCESS)), criteriaBuilder.sum((Expression)root.get(COMPLETED)), criteriaBuilder.sum((Expression)root.get(REOPENED)), criteriaBuilder.sum((Expression)root.get(REJECTED)), criteriaBuilder.sum((Expression)root.get(WITHINSLA)), criteriaBuilder.sum((Expression)root.get(BEYONDSLA))}).where(this.criteria(reportRequest, criteriaBuilder, root).toArray(new Predicate[0])).groupBy(new Expression[]{root.get(EMPLOYEE_ID), root.get(EMPLOYEE_NAME)});
        return criteriaQuery;
    }

    private List<Predicate> criteria(DrilldownReportRequest reportRequest, CriteriaBuilder criteriaBuilder, Root<DrilldownReportView> root) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (reportRequest.getFromDate() != null && reportRequest.getToDate() != null) {
            predicates.add(criteriaBuilder.between((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.startOfDay((Date)reportRequest.getFromDate()), (Comparable)DateUtils.endOfDay((Date)reportRequest.getToDate())));
        }
        if ("lastsevendays".equals(reportRequest.getComplaintDateType())) {
            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.endOfToday().minusDays(8).toDate()));
        }
        if ("lastthirtydays".equals(reportRequest.getComplaintDateType())) {
            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.endOfToday().minusDays(31).toDate()));
        }
        if ("lastninetydays".equals(reportRequest.getComplaintDateType())) {
            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.endOfToday().minusDays(91).toDate()));
        }
        if (reportRequest.getToDate() != null) {
            predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.endOfDay((Date)reportRequest.getToDate())));
        }
        if (reportRequest.getFromDate() != null) {
            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.startOfDay((Date)reportRequest.getFromDate())));
        }
        if (StringUtils.isNotBlank((String)reportRequest.getUsrid()) && StringUtils.isNotBlank((String)reportRequest.getStatus())) {
            predicates.add(criteriaBuilder.equal((Expression)root.get(EMPLOYEE_ID), (Object)reportRequest.getUsrid()));
        }
        if (StringUtils.isNotBlank((String)reportRequest.getStatus())) {
            predicates.addAll(this.predicatesForComplaints(reportRequest, criteriaBuilder, root));
        }
        return predicates;
    }

    private List<Predicate> predicatesForComplaints(DrilldownReportRequest reportRequest, CriteriaBuilder criteriaBuilder, Root<DrilldownReportView> root) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (REGISTERED.equalsIgnoreCase(reportRequest.getStatus())) {
            predicates.add(criteriaBuilder.equal((Expression)root.get(STATUS), (Object)"REGISTERED"));
        }
        if (INPROCESS.equalsIgnoreCase(reportRequest.getStatus())) {
            predicates.add(root.get(STATUS).in(new Object[]{"FORWARDED", "PROCESSING", "NOTCOMPLETED"}));
        }
        if (REJECTED.equalsIgnoreCase(reportRequest.getStatus())) {
            predicates.add(criteriaBuilder.equal((Expression)root.get(STATUS), (Object)"REJECTED"));
        }
        if (COMPLETED.equalsIgnoreCase(reportRequest.getStatus())) {
            predicates.add(root.get(STATUS).in(new Object[]{"WITHDRAWN", "COMPLETED", "CLOSED"}));
        }
        if (REOPENED.equalsIgnoreCase(reportRequest.getStatus())) {
            predicates.add(criteriaBuilder.equal((Expression)root.get(STATUS), (Object)"REOPENED"));
        }
        if ("Within SLA".equalsIgnoreCase(reportRequest.getStatus())) {
            predicates.add(criteriaBuilder.greaterThan((Expression)root.get(WITHINSLA), (Comparable)Integer.valueOf(0)));
        }
        if ("Beyond SLA".equalsIgnoreCase(reportRequest.getStatus())) {
            predicates.add(criteriaBuilder.greaterThan((Expression)root.get(BEYONDSLA), (Comparable)Integer.valueOf(0)));
        }
        return predicates;
    }
}

