/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.report.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.egov.infra.persistence.utils.Page;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.StringUtils;
import org.egov.pgr.report.entity.contract.DrilldownReportRequest;
import org.egov.pgr.report.entity.view.DrilldownReportView;
import org.egov.pgr.report.repository.DrilldownReportRepositoryCustom;
import org.springframework.data.domain.Sort;

public class DrilldownReportRepositoryImpl
implements DrilldownReportRepositoryCustom {
    private static final String CREATED_DATE = "createdDate";
    private static final String STATUS = "status";
    private static final String REGISTERED = "registered";
    private static final String INPROCESS = "inprocess";
    private static final String COMPLETED = "completed";
    private static final String REOPENED = "reopened";
    private static final String REJECTED = "rejected";
    private static final String WITHINSLA = "withinSLA";
    private static final String BEYONDSLA = "beyondSLA";
    private static final String PARENTBOUNDARY = "parentBoundary";
    private static final String LOCALITY = "locality";
    private static final String DEPARTMENT = "department";
    private static final String COMPLAINTTYPENAME = "complaintTypeName";
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<DrilldownReportView> findDrilldownRecords(DrilldownReportRequest reportRequest) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DrilldownReportView.class);
        Root root = criteriaQuery.from(DrilldownReportView.class);
        CriteriaQuery recordCountQuery = criteriaBuilder.createQuery(DrilldownReportView.class);
        Root countRoot = recordCountQuery.from(DrilldownReportView.class);
        Path<String> selection = null;
        selection = this.selectByBoundary(reportRequest, (Root<DrilldownReportView>)root) != null ? this.selectByBoundary(reportRequest, (Root<DrilldownReportView>)root) : this.selectbyDepartment(reportRequest, (Root<DrilldownReportView>)root);
        recordCountQuery.multiselect(new Selection[]{criteriaBuilder.count(selection)}).where(this.criteria(reportRequest, criteriaBuilder, (Root<DrilldownReportView>)countRoot).toArray(new Predicate[0])).groupBy(new Expression[]{selection});
        CriteriaQuery<DrilldownReportView> reportQuery = this.generateCriteriaToGetRecordsByRequest(reportRequest, (CriteriaQuery<DrilldownReportView>)criteriaQuery, criteriaBuilder, (Root<DrilldownReportView>)root);
        if (reportRequest.orderBy().equals(PARENTBOUNDARY) || reportRequest.orderBy().equals(LOCALITY) || reportRequest.orderBy().equals(DEPARTMENT) || reportRequest.orderBy().equals(COMPLAINTTYPENAME) || reportRequest.orderBy().equals("employeePosition")) {
            reportQuery.orderBy(new Order[]{reportRequest.orderDir().equals((Object)Sort.Direction.ASC) ? criteriaBuilder.asc((Expression)root.get(reportRequest.orderBy())) : criteriaBuilder.desc((Expression)root.get(reportRequest.orderBy()))});
        } else {
            reportQuery.orderBy(new Order[]{reportRequest.orderDir().equals((Object)Sort.Direction.ASC) ? criteriaBuilder.asc(criteriaBuilder.sum((Expression)root.get(reportRequest.orderBy()))) : criteriaBuilder.desc(criteriaBuilder.sum((Expression)root.get(reportRequest.orderBy())))});
        }
        return new Page(this.entityManager.createQuery(reportQuery), reportRequest.pageNumber() + 1, reportRequest.pageSize(), this.entityManager.createQuery(recordCountQuery).getResultList().size());
    }

    @Override
    public Page<DrilldownReportView> findDrilldownRecordsByComplaintTypeId(DrilldownReportRequest reportRequest) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DrilldownReportView.class);
        Root root = criteriaQuery.from(DrilldownReportView.class);
        CriteriaQuery countCriteriaQuery = criteriaBuilder.createQuery(DrilldownReportView.class);
        Root countRoot = countCriteriaQuery.from(DrilldownReportView.class);
        countCriteriaQuery.multiselect(new Selection[]{criteriaBuilder.count((Expression)countRoot.get("crn"))}).where(this.criteria(reportRequest, criteriaBuilder, (Root<DrilldownReportView>)countRoot).toArray(new Predicate[0])).groupBy(new Expression[]{countRoot.get("crn")});
        TypedQuery query = this.entityManager.createQuery(this.generateCriteriaToGetComplaints(reportRequest, (CriteriaQuery<DrilldownReportView>)criteriaQuery, criteriaBuilder, (Root<DrilldownReportView>)root).orderBy(new Order[]{reportRequest.orderDir().equals((Object)Sort.Direction.ASC) ? criteriaBuilder.asc((Expression)root.get(reportRequest.orderBy())) : criteriaBuilder.desc((Expression)root.get(reportRequest.orderBy()))}));
        TypedQuery countquery = this.entityManager.createQuery(countCriteriaQuery);
        return new Page(query, reportRequest.pageNumber() + 1, reportRequest.pageSize(), countquery.getResultList().size());
    }

    @Override
    public Object[] findDrilldownGrandTotal(DrilldownReportRequest reportRequest) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Object[].class);
        Root root = criteriaQuery.from(DrilldownReportView.class);
        criteriaQuery.multiselect(new Selection[]{criteriaBuilder.sum((Expression)root.get(REGISTERED)), criteriaBuilder.sum((Expression)root.get(INPROCESS)), criteriaBuilder.sum((Expression)root.get(COMPLETED)), criteriaBuilder.sum((Expression)root.get(REJECTED)), criteriaBuilder.sum((Expression)root.get(REOPENED)), criteriaBuilder.sum((Expression)root.get(WITHINSLA)), criteriaBuilder.sum((Expression)root.get(BEYONDSLA))}).where(this.criteria(reportRequest, criteriaBuilder, (Root<DrilldownReportView>)root).toArray(new Predicate[0]));
        return (Object[])this.entityManager.createQuery(criteriaQuery).getSingleResult();
    }

    @Override
    public List<DrilldownReportView> findDrilldownRecordsByRequest(DrilldownReportRequest reportRequest) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DrilldownReportView.class);
        Root root = criteriaQuery.from(DrilldownReportView.class);
        return this.entityManager.createQuery(this.generateCriteriaToGetComplaints(reportRequest, (CriteriaQuery<DrilldownReportView>)criteriaQuery, criteriaBuilder, (Root<DrilldownReportView>)root)).getResultList();
    }

    @Override
    public List<DrilldownReportView> findDrilldownRecordList(DrilldownReportRequest reportRequest) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(DrilldownReportView.class);
        Root root = criteriaQuery.from(DrilldownReportView.class);
        return this.entityManager.createQuery(this.generateCriteriaToGetRecordsByRequest(reportRequest, (CriteriaQuery<DrilldownReportView>)criteriaQuery, criteriaBuilder, (Root<DrilldownReportView>)root)).getResultList();
    }

    private CriteriaQuery<DrilldownReportView> generateCriteriaToGetComplaints(DrilldownReportRequest reportRequest, CriteriaQuery<DrilldownReportView> criteriaQuery, CriteriaBuilder criteriaBuilder, Root<DrilldownReportView> root) {
        criteriaQuery.multiselect(new Selection[]{root.get("complainantId"), root.get("crn"), root.get(CREATED_DATE), root.get("complainantName"), root.get("complaintDetail"), root.get(STATUS), root.get("boundaryName"), root.get("feedback"), root.get("isSLA")}).where(this.criteria(reportRequest, criteriaBuilder, root).toArray(new Predicate[0]));
        return criteriaQuery;
    }

    private CriteriaQuery<DrilldownReportView> generateCriteriaToGetRecordsByRequest(DrilldownReportRequest reportRequest, CriteriaQuery<DrilldownReportView> criteriaQuery, CriteriaBuilder criteriaBuilder, Root<DrilldownReportView> root) {
        Path<String> selection = null;
        selection = "ByBoundary".equals(reportRequest.getGroupBy()) ? this.selectByBoundary(reportRequest, root) : this.selectbyDepartment(reportRequest, root);
        criteriaQuery.multiselect(new Selection[]{selection, criteriaBuilder.sum((Expression)root.get(REGISTERED)), criteriaBuilder.sum((Expression)root.get(INPROCESS)), criteriaBuilder.sum((Expression)root.get(COMPLETED)), criteriaBuilder.sum((Expression)root.get(REJECTED)), criteriaBuilder.sum((Expression)root.get(REOPENED)), criteriaBuilder.sum((Expression)root.get(WITHINSLA)), criteriaBuilder.sum((Expression)root.get(BEYONDSLA))}).where(this.criteria(reportRequest, criteriaBuilder, root).toArray(new Predicate[0])).groupBy(new Expression[]{selection});
        return criteriaQuery;
    }

    private List<Predicate> criteria(DrilldownReportRequest reportRequest, CriteriaBuilder criteriaBuilder, Root<DrilldownReportView> root) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (reportRequest.getFromDate() != null && reportRequest.getToDate() != null) {
            predicates.add(criteriaBuilder.between((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.startOfDay((Date)reportRequest.getFromDate()), (Comparable)DateUtils.endOfDay((Date)reportRequest.getToDate())));
        }
        if ("lastsevendays".equals(reportRequest.getComplaintDateType())) {
            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.endOfToday().minusDays(8).toDate()));
        }
        if ("lastthirtydays".equals(reportRequest.getComplaintDateType())) {
            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.endOfToday().minusDays(31).toDate()));
        }
        if ("lastninetydays".equals(reportRequest.getComplaintDateType())) {
            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.endOfToday().minusDays(91).toDate()));
        }
        if (reportRequest.getToDate() != null && reportRequest.getFromDate() == null) {
            predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.endOfDay((Date)reportRequest.getToDate())));
        }
        if (reportRequest.getFromDate() != null && reportRequest.getToDate() == null) {
            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.startOfDay((Date)reportRequest.getFromDate())));
        }
        if (StringUtils.isNotBlank((String)reportRequest.getBoundary())) {
            predicates.add(criteriaBuilder.equal((Expression)root.get(PARENTBOUNDARY), (Object)reportRequest.getBoundary()));
        }
        if (StringUtils.isNotBlank((String)reportRequest.getDeptid())) {
            predicates.add(criteriaBuilder.equal((Expression)root.get(DEPARTMENT), (Object)reportRequest.getDeptid()));
        }
        if (StringUtils.isNotBlank((String)reportRequest.getLocality())) {
            predicates.add(criteriaBuilder.equal((Expression)root.get(LOCALITY), (Object)reportRequest.getLocality()));
        }
        if (StringUtils.isNotBlank((String)reportRequest.getComplainttypeid())) {
            predicates.add(criteriaBuilder.equal((Expression)root.get(COMPLAINTTYPENAME), (Object)reportRequest.getComplainttypeid()));
        }
        if (StringUtils.isNotBlank((String)reportRequest.getSelecteduserid())) {
            String userName = reportRequest.getSelecteduserid().split("~")[0];
            predicates.add(criteriaBuilder.equal((Expression)root.get("employeeName"), (Object)userName));
        }
        return predicates;
    }

    private Path<String> selectByBoundary(DrilldownReportRequest reportRequest, Root<DrilldownReportView> root) {
        Path selection = null;
        if (StringUtils.isNotBlank((String)reportRequest.getBoundary())) {
            selection = StringUtils.isNotBlank((String)reportRequest.getLocality()) ? this.selectbyDepartment(reportRequest, root) : root.get(LOCALITY);
        } else if ("ByBoundary".equals(reportRequest.getGroupBy())) {
            selection = root.get(PARENTBOUNDARY);
        }
        return selection;
    }

    private Path<String> selectbyDepartment(DrilldownReportRequest reportRequest, Root<DrilldownReportView> root) {
        Path selection = StringUtils.isNotBlank((String)reportRequest.getDeptid()) ? (StringUtils.isNotBlank((String)reportRequest.getComplainttypeid()) ? root.get("employeePosition") : root.get(COMPLAINTTYPENAME)) : root.get(DEPARTMENT);
        return selection;
    }
}

