/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.report.repository;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.egov.infra.persistence.utils.Page;
import org.egov.infra.utils.DateUtils;
import org.egov.pgr.report.entity.contract.AgeingReportRequest;
import org.egov.pgr.report.entity.view.AgeingReportView;
import org.egov.pgr.report.repository.AgeingReportRepositoryCustom;
import org.springframework.data.domain.Sort;

public class AgeingReportRepositoryImpl
implements AgeingReportRepositoryCustom {
    private static final String COMPLETED = "Completed";
    private static final String STATUS = "status";
    private static final String CREATED_DATE = "createddate";
    private static final String GREATER30 = "greater30";
    private static final String BETWEEN10_TO_30 = "btw10to30";
    private static final String BETWEEN5_TO_10 = "btw5to10";
    private static final String BETWEEN2_TO_5 = "btw2to5";
    private static final String LESSTHAN2 = "lsthn2";
    private static final String BOUNDARY = "boundary";
    private static final String DEPARTMENT = "department";
    private static final String BYDEPARTMENT = "ByDepartment";
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public Page<AgeingReportView> findByAgeingReportResult(AgeingReportRequest ageingReportRequest) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(AgeingReportView.class);
        CriteriaQuery countCriteriaQuery = criteriaBuilder.createQuery(AgeingReportView.class);
        Root root = criteriaQuery.from(AgeingReportView.class);
        Root countRoot = countCriteriaQuery.from(AgeingReportView.class);
        CriteriaQuery<AgeingReportView> searchQuery = BYDEPARTMENT.equals(ageingReportRequest.getMode()) ? this.findByDepartment((CriteriaQuery<AgeingReportView>)criteriaQuery, criteriaBuilder, (Root<AgeingReportView>)root, ageingReportRequest) : this.findByBoundary((CriteriaQuery<AgeingReportView>)criteriaQuery, criteriaBuilder, (Root<AgeingReportView>)root, ageingReportRequest);
        TypedQuery query = this.entityManager.createQuery(searchQuery);
        countCriteriaQuery.multiselect(new Selection[]{criteriaBuilder.count((Expression)countRoot)}).where(this.predicatecondition(ageingReportRequest, criteriaBuilder, (Root<AgeingReportView>)countRoot).toArray(new Predicate[0]));
        if (BYDEPARTMENT.equals(ageingReportRequest.getMode())) {
            countCriteriaQuery.groupBy(new Expression[]{countRoot.get(DEPARTMENT)});
        } else {
            countCriteriaQuery.groupBy(new Expression[]{countRoot.get(BOUNDARY)});
        }
        TypedQuery countquery = this.entityManager.createQuery(countCriteriaQuery);
        int recordTotal = countquery.getResultList().size();
        return new Page(query, ageingReportRequest.pageNumber() + 1, ageingReportRequest.pageSize(), recordTotal);
    }

    @Override
    public List<AgeingReportView> getAgeingReportRecords(AgeingReportRequest ageingReportRequest) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery listCriteriaQuery = criteriaBuilder.createQuery(AgeingReportView.class);
        Root rootList = listCriteriaQuery.from(AgeingReportView.class);
        CriteriaQuery<AgeingReportView> searchQuery = BYDEPARTMENT.equals(ageingReportRequest.getMode()) ? this.findByDepartment((CriteriaQuery<AgeingReportView>)listCriteriaQuery, criteriaBuilder, (Root<AgeingReportView>)rootList, ageingReportRequest) : this.findByBoundary((CriteriaQuery<AgeingReportView>)listCriteriaQuery, criteriaBuilder, (Root<AgeingReportView>)rootList, ageingReportRequest);
        return this.entityManager.createQuery(searchQuery).getResultList();
    }

    @Override
    public Object[] getGrandTotal(AgeingReportRequest ageingReportRequest) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Object[].class);
        Root root = criteriaQuery.from(AgeingReportView.class);
        criteriaQuery.multiselect(new Selection[]{criteriaBuilder.sum((Expression)root.get(GREATER30)), criteriaBuilder.sum((Expression)root.get(BETWEEN10_TO_30)), criteriaBuilder.sum((Expression)root.get(BETWEEN5_TO_10)), criteriaBuilder.sum((Expression)root.get(BETWEEN2_TO_5)), criteriaBuilder.sum((Expression)root.get(LESSTHAN2)), criteriaBuilder.sum(criteriaBuilder.sum((Expression)root.get(GREATER30), criteriaBuilder.sum((Expression)root.get(BETWEEN10_TO_30), criteriaBuilder.sum((Expression)root.get(BETWEEN5_TO_10), criteriaBuilder.sum((Expression)root.get(BETWEEN2_TO_5), (Expression)root.get(LESSTHAN2))))))}).where(this.predicatecondition(ageingReportRequest, criteriaBuilder, (Root<AgeingReportView>)root).toArray(new Predicate[0]));
        return (Object[])this.entityManager.createQuery(criteriaQuery).getSingleResult();
    }

    private CriteriaQuery<AgeingReportView> findByDepartment(CriteriaQuery<AgeingReportView> criteriaQuery, CriteriaBuilder criteriaBuilder, Root<AgeingReportView> root, AgeingReportRequest ageingReportRequest) {
        criteriaQuery.multiselect(new Selection[]{root.get(DEPARTMENT).alias("name"), criteriaBuilder.sum((Expression)root.get(GREATER30)), criteriaBuilder.sum((Expression)root.get(BETWEEN10_TO_30)), criteriaBuilder.sum((Expression)root.get(BETWEEN5_TO_10)), criteriaBuilder.sum((Expression)root.get(BETWEEN2_TO_5)), criteriaBuilder.sum((Expression)root.get(LESSTHAN2))}).where(this.predicatecondition(ageingReportRequest, criteriaBuilder, root).toArray(new Predicate[0])).groupBy(new Expression[]{root.get(DEPARTMENT)});
        return this.queryWithOrderBy(criteriaQuery, criteriaBuilder, root, ageingReportRequest);
    }

    private CriteriaQuery<AgeingReportView> findByBoundary(CriteriaQuery<AgeingReportView> criteriaQuery, CriteriaBuilder criteriaBuilder, Root<AgeingReportView> root, AgeingReportRequest ageingReportRequest) {
        criteriaQuery.multiselect(new Selection[]{root.get(BOUNDARY).alias("name"), criteriaBuilder.sum((Expression)root.get(GREATER30)), criteriaBuilder.sum((Expression)root.get(BETWEEN10_TO_30)), criteriaBuilder.sum((Expression)root.get(BETWEEN5_TO_10)), criteriaBuilder.sum((Expression)root.get(BETWEEN2_TO_5)), criteriaBuilder.sum((Expression)root.get(LESSTHAN2))}).where(this.predicatecondition(ageingReportRequest, criteriaBuilder, root).toArray(new Predicate[0])).groupBy(new Expression[]{root.get(BOUNDARY)});
        return this.queryWithOrderBy(criteriaQuery, criteriaBuilder, root, ageingReportRequest);
    }

    private List<Predicate> predicatecondition(AgeingReportRequest ageingReportRequest, CriteriaBuilder criteriaBuilder, Root<AgeingReportView> root) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (ageingReportRequest.getStatus().equals(COMPLETED)) {
            predicates.add(criteriaBuilder.or(new Predicate[]{criteriaBuilder.like((Expression)root.get(STATUS), "COMPLETED"), criteriaBuilder.like((Expression)root.get(STATUS), "WITHDRAWN"), criteriaBuilder.like((Expression)root.get(STATUS), "CLOSED")}));
        }
        if ("Pending".equals(ageingReportRequest.getStatus())) {
            predicates.add(criteriaBuilder.or(new Predicate[]{criteriaBuilder.like((Expression)root.get(STATUS), "REGISTERED"), criteriaBuilder.like((Expression)root.get(STATUS), "FORWARDED"), criteriaBuilder.like((Expression)root.get(STATUS), "PROCESSING"), criteriaBuilder.like((Expression)root.get(STATUS), "REOPENED")}));
        }
        if ("Rejected".equals(ageingReportRequest.getStatus())) {
            predicates.add(criteriaBuilder.or(new Predicate[]{criteriaBuilder.like((Expression)root.get(STATUS), "REJECTED")}));
        }
        if (ageingReportRequest.getFromDate() != null && ageingReportRequest.getToDate() != null) {
            predicates.add(criteriaBuilder.between((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.startOfDay((Date)ageingReportRequest.getFromDate()), (Comparable)DateUtils.endOfDay((Date)ageingReportRequest.getToDate())));
        }
        if ("lastsevendays".equals(ageingReportRequest.getComplaintDateType())) {
            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.endOfToday().minusDays(7).toDate()));
        }
        if ("lastthirtydays".equals(ageingReportRequest.getComplaintDateType())) {
            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.endOfToday().minusDays(30).toDate()));
        }
        if ("lastninetydays".equals(ageingReportRequest.getComplaintDateType())) {
            predicates.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.endOfToday().minusDays(90).toDate()));
        }
        if (ageingReportRequest.getToDate() != null) {
            predicates.add(criteriaBuilder.lessThanOrEqualTo((Expression)root.get(CREATED_DATE), (Comparable)DateUtils.endOfDay((Date)ageingReportRequest.getToDate())));
        }
        return predicates;
    }

    private CriteriaQuery<AgeingReportView> queryWithOrderBy(CriteriaQuery<AgeingReportView> criteriaQuery, CriteriaBuilder criteriaBuilder, Root<AgeingReportView> root, AgeingReportRequest ageingReportRequest) {
        if (ageingReportRequest.orderBy().equals(BOUNDARY) || ageingReportRequest.orderBy().equals(DEPARTMENT)) {
            criteriaQuery.orderBy(new Order[]{ageingReportRequest.orderDir().equals((Object)Sort.Direction.ASC) ? criteriaBuilder.asc((Expression)root.get(ageingReportRequest.orderBy())) : criteriaBuilder.desc((Expression)root.get(ageingReportRequest.orderBy()))});
        } else {
            criteriaQuery.orderBy(new Order[]{ageingReportRequest.orderDir().equals((Object)Sort.Direction.ASC) ? criteriaBuilder.asc(criteriaBuilder.sum((Expression)root.get(ageingReportRequest.orderBy()))) : criteriaBuilder.desc(criteriaBuilder.sum((Expression)root.get(ageingReportRequest.orderBy())))});
        }
        return criteriaQuery;
    }
}

