/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.report.entity.contract;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.web.support.json.adapter.DataTableJsonAdapter;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.service.QualityReviewService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QualityReviewAdaptor
implements DataTableJsonAdapter<Complaint> {
    @Autowired
    private QualityReviewService qualityReviewService;

    public JsonElement serialize(DataTable<Complaint> searchResponse, Type type, JsonSerializationContext jsc) {
        List searchResult = searchResponse.getData();
        JsonArray searchFormData = new JsonArray();
        searchResult.forEach(searchObject -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("crn", StringUtils.defaultIfBlank((String)searchObject.getCrn()));
            jsonObject.addProperty("grievanceType", StringUtils.defaultIfBlank((String)searchObject.getComplaintType().getName()));
            jsonObject.addProperty("owner", StringUtils.defaultIfBlank((String)searchObject.getComplainant().getName()));
            jsonObject.addProperty("location", StringUtils.defaultIfBlank((String)searchObject.getLocation().getName()));
            jsonObject.addProperty("status", StringUtils.defaultIfBlank((String)searchObject.getStatus().getName()));
            jsonObject.addProperty("department", StringUtils.defaultIfBlank((String)searchObject.getDepartment().getName()));
            jsonObject.addProperty("date", DateUtils.getFormattedDate((Date)searchObject.getCreatedDate(), (String)"dd/MM/yyyy hh:mm a").toString());
            jsonObject.addProperty("reviewed", StringUtils.toYesOrNo((boolean)this.qualityReviewService.getExistingQualityReviewByCRN(searchObject.getCrn()).isPresent()));
            searchFormData.add((JsonElement)jsonObject);
        });
        return this.enhance((JsonElement)searchFormData, searchResponse);
    }
}

