/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.report.entity.contract;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import org.egov.pgr.entity.Complaint;

public class PendingGrievanceAdaptor
implements JsonSerializer<Complaint> {
    public JsonElement serialize(Complaint complaint, Type type, JsonSerializationContext jsc) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("grievanceNumber", complaint.getCrn());
        jsonObject.addProperty("complaintType", null != complaint.getComplaintType() ? complaint.getComplaintType().getName() : "NA");
        jsonObject.addProperty("department", null != complaint.getDepartment() ? complaint.getDepartment().getName() : "N/A");
        if (complaint.getLocation() != null && complaint.getChildLocation() != null) {
            jsonObject.addProperty("location", null != complaint.getLocation() ? complaint.getChildLocation().getName() + " - " + complaint.getLocation().getName() : "N/A");
        } else {
            jsonObject.addProperty("location", null != complaint.getLocation() ? complaint.getLocation().getName() : "N/A");
        }
        jsonObject.addProperty("status", null != complaint.getStatus() ? complaint.getStatus().getName() : "N/A");
        jsonObject.addProperty("regDate", sdf.format(complaint.getCreatedDate()));
        jsonObject.addProperty("dueDate", sdf.format(complaint.getEscalationDate()));
        return jsonObject;
    }
}

