/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.report.entity.contract;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.web.support.json.adapter.DataTableJsonAdapter;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.pgr.entity.enums.CitizenFeedback;
import org.egov.pgr.report.entity.view.DrilldownReportView;

public class DrilldownAdaptor
implements DataTableJsonAdapter<DrilldownReportView> {
    public JsonElement serialize(DataTable<DrilldownReportView> reportResponse, Type type, JsonSerializationContext jsc) {
        List functionarywiseResult = reportResponse.getData();
        JsonArray drilldownReportData = new JsonArray();
        functionarywiseResult.forEach(reportObject -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("crn", StringUtils.defaultIfBlank((String)reportObject.getCrn()));
            jsonObject.addProperty("createddate", StringUtils.defaultIfBlank((String)DateUtils.getFormattedDate((Date)reportObject.getCreatedDate(), (String)"dd-MM-yyyy hh:mm a")));
            jsonObject.addProperty("complainantname", StringUtils.defaultIfBlank((String)reportObject.getComplainantName()));
            jsonObject.addProperty("details", StringUtils.defaultIfBlank((String)reportObject.getComplaintDetail()));
            jsonObject.addProperty("boundaryname", StringUtils.defaultIfBlank((String)reportObject.getBoundaryName()));
            jsonObject.addProperty("status", StringUtils.defaultIfBlank((String)reportObject.getStatus()));
            jsonObject.addProperty("complaintId", (Number)reportObject.getComplainantId());
            jsonObject.addProperty("feedback", CitizenFeedback.value(reportObject.getFeedback()));
            jsonObject.addProperty("issla", StringUtils.defaultIfBlank((String)reportObject.getIsSLA()));
            drilldownReportData.add((JsonElement)jsonObject);
        });
        return this.enhance((JsonElement)drilldownReportData, reportResponse);
    }
}

