/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.entity.contract;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.lang.reflect.Type;
import java.util.List;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.web.support.json.adapter.DataTableJsonAdapter;
import org.egov.infra.web.support.ui.DataTable;
import org.egov.pgr.entity.ComplaintType;

public class ComplaintTypeAdaptor
implements DataTableJsonAdapter<ComplaintType> {
    public JsonElement serialize(DataTable<ComplaintType> compaintTypeResponse, Type type, JsonSerializationContext jsc) {
        List complaintTypeResult = compaintTypeResponse.getData();
        JsonArray compalintTypeResultData = new JsonArray();
        complaintTypeResult.forEach(compaintType -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("name", compaintType.getName());
            jsonObject.addProperty("category", compaintType.getCategory().getName());
            jsonObject.addProperty("department", compaintType.getDepartment() != null ? compaintType.getDepartment().getName() : "N/A");
            jsonObject.addProperty("code", compaintType.getCode());
            jsonObject.addProperty("isActive", StringUtils.toYesOrNo((boolean)compaintType.getIsActive()));
            jsonObject.addProperty("description", StringUtils.defaultIfBlank((String)compaintType.getDescription()));
            jsonObject.addProperty("slahours", StringUtils.defaultIfBlank((String)compaintType.getSlaHours().toString()));
            jsonObject.addProperty("hasfinancialImpact", StringUtils.toYesOrNo((boolean)compaintType.isHasFinancialImpact()));
            compalintTypeResultData.add((JsonElement)jsonObject);
        });
        return this.enhance((JsonElement)compalintTypeResultData, compaintTypeResponse);
    }
}

