/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.elasticsearch.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.es.CityIndex;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.es.CityIndexService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.mapper.BeanMapperConfiguration;
import org.egov.pgr.elasticsearch.entity.ComplaintIndex;
import org.egov.pgr.elasticsearch.entity.contract.ComplaintDashBoardRequest;
import org.egov.pgr.elasticsearch.entity.contract.ComplaintDashBoardResponse;
import org.egov.pgr.elasticsearch.entity.contract.ComplaintSourceResponse;
import org.egov.pgr.elasticsearch.repository.ComplaintIndexAggregationBuilder;
import org.egov.pgr.elasticsearch.repository.ComplaintIndexRepository;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.Escalation;
import org.egov.pgr.entity.ReceivingMode;
import org.egov.pgr.entity.enums.ComplaintStatus;
import org.egov.pgr.service.ComplaintEscalationService;
import org.egov.pgr.service.ComplaintService;
import org.egov.pgr.service.ReceivingModeService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.missing.Missing;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.metrics.tophits.TopHits;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ComplaintIndexService {
    private static final String SOURCE = "source";
    private static final String GROUP_BY_FIELD_AGEING_FOR_HOURS = "groupByFieldAgeingForHours";
    private static final String GROUP_BY_FIELD_AGEING = "groupByFieldAgeing";
    private static final String INITIAL_FUNCTIONARY_MOBILE_NUMBER = "initialFunctionaryMobileNumber";
    private static final String DOMAIN_URL = "domainURL";
    private static final String ULB_NAME = "ulbName";
    private static final String ULB_GRADE = "ulbGrade";
    private static final String ULB_CODE = "ulbCode";
    private static final String DISTRICT_NAME = "districtName";
    private static final String REGION_NAME = "regionName";
    private static final String INITIAL_FUNCTIONARY_NAME = "initialFunctionaryName";
    private static final String CITY_GRADE = "cityGrade";
    private static final String CITY_REGION_NAME = "cityRegionName";
    private static final String GROUP_BY_FIELD = "groupByField";
    private static final String ULBWISE = "ulbwise";
    private static final String LOCALITY_NAME = "localityName";
    private static final String RE_OPENED_COMPLAINT_COUNT = "reOpenedComplaintCount";
    private static final String NOLOCALITY = "nolocality";
    private static final String CLOSED_COMPLAINT_COUNT = "closedComplaintCount";
    private static final String COMPLAINTRECORD = "complaintrecord";
    private static final String GROUP_BY_FIELD_SATISFACTION_AVERAGE = "groupByFieldSatisfactionAverage";
    private static final String GROUP_FIELDWISE_OPEN_AND_CLOSED_COUNT = "groupFieldWiseOpenAndClosedCount";
    private static final String WARDWISE = "wardwise";
    private static final String DEPARTMENTWISE = "departmentwise";
    private static final String PGR_COMPLAINT_VIEW_URL = "%s/pgr/complaint/view/%s";
    private static final String EXCLUDE_ZERO = "excludeZero";
    private static final String CITY_NAME = "cityName";
    private static final String CITY_DISTRICT_NAME = "cityDistrictName";
    private static final String WARD_NAME = "wardName";
    private static final String GROUP_BY_FIELD_SLA = "groupByFieldSla";
    private static final String DEPARTMENT_NAME = "departmentName";
    private static final String COMPLAINT_TYPEWISE = "complaintTypeWise";
    private static final String COMPLAINTS = "complaints";
    private static final String COMPLAINT_COUNT = "complaintCount";
    private static final String CITY_DISTRICT_CODE = "cityDistrictCode";
    private static final String RESPONSE_DETAILS = "responseDetails";
    @Autowired
    private CityService cityService;
    @Autowired
    private ComplaintEscalationService escalationService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private CityIndexService cityIndexService;
    @Autowired
    private ComplaintIndexRepository complaintIndexRepository;
    @Autowired
    private BeanMapperConfiguration beanMapperConfiguration;
    @Autowired
    private ComplaintService complaintService;
    @Autowired
    private ReceivingModeService receivingModeService;

    public void createComplaintIndex(Complaint complaint) {
        ComplaintIndex complaintIndex = new ComplaintIndex();
        this.beanMapperConfiguration.map((Object)complaint, (Object)complaintIndex);
        City city = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        complaintIndex.setCityCode(city.getCode());
        complaintIndex.setCityDistrictCode(city.getDistrictCode());
        complaintIndex.setCityDistrictName(city.getDistrictName());
        complaintIndex.setCityGrade(city.getGrade());
        complaintIndex.setCityDomainUrl(city.getDomainURL());
        complaintIndex.setCityName(city.getName());
        complaintIndex.setCityRegionName(city.getRegionName());
        complaintIndex.setSource(complaint.getReceivingMode().getName());
        complaintIndex.setClosed(false);
        complaintIndex.setComplaintIsClosed("N");
        complaintIndex.setIfClosed(0);
        complaintIndex.setComplaintDuration(0.0);
        complaintIndex.setDurationRange("");
        Position position = complaint.getAssignee();
        List assignments = this.assignmentService.getAssignmentsForPosition(position.getId(), new Date());
        Employee assignedUser = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee() : null;
        complaintIndex.setComplaintPeriod(0.0);
        complaintIndex.setComplaintSLADays(complaint.getComplaintType().getSlaHours().intValue());
        complaintIndex.setComplaintAgeingFromDue(0.0);
        complaintIndex.setIsSLA("Y");
        complaintIndex.setIfSLA(1);
        complaintIndex.setInitialFunctionaryName(assignedUser != null ? assignedUser.getName() + " : " + position.getDeptDesig().getDesignation().getName() : "NO ASSIGNMENT : " + position.getDeptDesig().getDesignation().getName());
        complaintIndex.setInitialFunctionaryAssigneddate(new Date());
        complaintIndex.setInitialFunctionarySLADays(this.getFunctionarySlaDays(complaint));
        complaintIndex.setInitialFunctionaryAgeingFromDue(0.0);
        complaintIndex.setInitialFunctionaryIsSLA("Y");
        complaintIndex.setInitialFunctionaryIfSLA(1);
        complaintIndex.setCurrentFunctionaryName(assignedUser != null ? assignedUser.getName() + " : " + position.getDeptDesig().getDesignation().getName() : "NO ASSIGNMENT : " + position.getDeptDesig().getDesignation().getName());
        complaintIndex.setCurrentFunctionaryMobileNumber(Objects.nonNull(assignedUser) ? assignedUser.getMobileNumber() : "");
        complaintIndex.setInitialFunctionaryMobileNumber(Objects.nonNull(assignedUser) ? assignedUser.getMobileNumber() : "");
        complaintIndex.setCurrentFunctionaryAssigneddate(new Date());
        complaintIndex.setCurrentFunctionarySLADays(this.getFunctionarySlaDays(complaint));
        complaintIndex.setCurrentFunctionaryAgeingFromDue(0.0);
        complaintIndex.setCurrentFunctionaryIsSLA("Y");
        complaintIndex.setCurrentFunctionaryIfSLA(1);
        complaintIndex.setEscalationLevel(0);
        complaintIndex.setReasonForRejection("");
        complaintIndex.setRegistered(1);
        complaintIndex.setInProcess(1);
        complaintIndex.setAddressed(0);
        complaintIndex.setRejected(0);
        complaintIndex.setReOpened(0);
        complaintIndex.setComplaintAgeingdaysFromDue(0L);
        this.complaintIndexRepository.save(complaintIndex);
    }

    public void updateComplaintIndex(Complaint complaint) {
        Employee assignedUser;
        ComplaintIndex complaintIndex = this.complaintIndexRepository.findByCrnAndCityCode(complaint.getCrn(), ApplicationThreadLocals.getCityCode());
        String status = complaintIndex.getComplaintStatusName();
        this.beanMapperConfiguration.map((Object)complaint, (Object)complaintIndex);
        City city = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        complaintIndex.setCityCode(city.getCode());
        complaintIndex.setCityDistrictCode(city.getDistrictCode());
        complaintIndex.setCityDistrictName(city.getDistrictName());
        complaintIndex.setCityGrade(city.getGrade());
        complaintIndex.setCityDomainUrl(city.getDomainURL());
        complaintIndex.setCityName(city.getName());
        complaintIndex.setCityRegionName(city.getRegionName());
        Position position = complaint.getAssignee();
        List assignments = this.assignmentService.getAssignmentsForPosition(position.getId(), new Date());
        Employee employee = assignedUser = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee() : null;
        if (complaint.nextOwnerId() != null && !complaint.nextOwnerId().equals(0L)) {
            complaintIndex.setCurrentFunctionaryName(assignedUser != null ? assignedUser.getName() + " : " + position.getDeptDesig().getDesignation().getName() : "NO ASSIGNMENT : " + position.getDeptDesig().getDesignation().getName());
            complaintIndex.setCurrentFunctionaryMobileNumber(Objects.nonNull(assignedUser) ? assignedUser.getMobileNumber() : "");
            complaintIndex.setCurrentFunctionaryAssigneddate(new Date());
            complaintIndex.setCurrentFunctionarySLADays(this.getFunctionarySlaDays(complaint));
        }
        if ((complaintIndex = this.updateComplaintLevelIndexFields(complaintIndex)).getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.COMPLETED.toString()) || complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.WITHDRAWN.toString()) || complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.REJECTED.toString())) {
            complaintIndex.setClosed(true);
            complaintIndex.setComplaintIsClosed("Y");
            complaintIndex.setIfClosed(1);
            complaintIndex.setClosedByFunctionaryName(assignedUser != null ? assignedUser.getName() + " : " + position.getDeptDesig().getDesignation().getName() : "NO ASSIGNMENT : " + position.getDeptDesig().getDesignation().getName());
            long duration = Math.abs(complaintIndex.getCreatedDate().getTime() - new Date().getTime()) / 86400000L;
            complaintIndex.setComplaintDuration(duration);
            if (duration < 3L) {
                complaintIndex.setDurationRange("(<3 days)");
            } else if (duration < 7L) {
                complaintIndex.setDurationRange("(3-7 days)");
            } else if (duration < 15L) {
                complaintIndex.setDurationRange("(8-15 days)");
            } else if (duration < 30L) {
                complaintIndex.setDurationRange("(16-30 days)");
            } else {
                complaintIndex.setDurationRange("(>30 days)");
            }
        } else {
            complaintIndex.setClosed(false);
            complaintIndex.setComplaintIsClosed("N");
            complaintIndex.setIfClosed(0);
            complaintIndex.setComplaintDuration(0.0);
            complaintIndex.setDurationRange("");
        }
        complaintIndex = this.updateComplaintIndexStatusRelatedFields(complaintIndex);
        if (complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.REOPENED.toString()) && !status.contains("REOPENED")) {
            complaintIndex.setComplaintReOpenedDate(new Date());
            complaintIndex.setClosed(false);
            complaintIndex.setComplaintIsClosed("N");
            complaintIndex.setIfClosed(0);
        }
        if (complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.REJECTED.toString())) {
            complaintIndex.setReasonForRejection(complaint.approverComment());
        }
        this.complaintIndexRepository.save(complaintIndex);
    }

    public void updateComplaintEscalationIndexValues(Complaint complaint) {
        ComplaintIndex complaintIndex = this.complaintIndexRepository.findByCrnAndCityCode(complaint.getCrn(), ApplicationThreadLocals.getCityCode());
        this.beanMapperConfiguration.map((Object)complaint, (Object)complaintIndex);
        Position position = complaint.getAssignee();
        List assignments = this.assignmentService.getAssignmentsForPosition(position.getId(), new Date());
        Employee assignedUser = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee() : null;
        City city = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        complaintIndex.setCityCode(city.getCode());
        complaintIndex.setCityDistrictCode(city.getDistrictCode());
        complaintIndex.setCityDistrictName(city.getDistrictName());
        complaintIndex.setCityGrade(city.getGrade());
        complaintIndex.setCityDomainUrl(city.getDomainURL());
        complaintIndex.setCityName(city.getName());
        complaintIndex.setCityRegionName(city.getRegionName());
        complaintIndex.setCurrentFunctionaryName(assignedUser != null ? assignedUser.getName() + " : " + position.getDeptDesig().getDesignation().getName() : "NO ASSIGNMENT : " + position.getDeptDesig().getDesignation().getName());
        complaintIndex.setCurrentFunctionaryMobileNumber(Objects.nonNull(assignedUser) ? assignedUser.getMobileNumber() : "");
        complaintIndex.setCurrentFunctionaryAssigneddate(new Date());
        complaintIndex.setCurrentFunctionarySLADays(this.getFunctionarySlaDays(complaint));
        complaintIndex = this.updateComplaintLevelIndexFields(complaintIndex);
        int escalationLevel = complaintIndex.getEscalationLevel();
        if (escalationLevel == 0) {
            complaintIndex.setEscalation1FunctionaryName(assignedUser != null ? assignedUser.getName() + " : " + position.getDeptDesig().getDesignation().getName() : "NO ASSIGNMENT : " + position.getDeptDesig().getDesignation().getName());
            complaintIndex.setEscalation1FunctionaryAssigneddate(new Date());
            complaintIndex.setEscalation1FunctionarySLADays(this.getFunctionarySlaDays(complaint));
            complaintIndex.setEscalation1FunctionaryAgeingFromDue(0.0);
            complaintIndex.setEscalation1FunctionaryIsSLA("Y");
            complaintIndex.setEscalation1FunctionaryIfSLA(1);
            complaintIndex.setEscalationLevel(++escalationLevel);
        } else if (escalationLevel == 1) {
            complaintIndex.setEscalation2FunctionaryName(assignedUser != null ? assignedUser.getName() + " : " + position.getDeptDesig().getDesignation().getName() : "NO ASSIGNMENT : " + position.getDeptDesig().getDesignation().getName());
            complaintIndex.setEscalation2FunctionaryAssigneddate(new Date());
            complaintIndex.setEscalation2FunctionarySLADays(this.getFunctionarySlaDays(complaint));
            complaintIndex.setEscalation2FunctionaryAgeingFromDue(0.0);
            complaintIndex.setEscalation2FunctionaryIsSLA("Y");
            complaintIndex.setEscalation2FunctionaryIfSLA(1);
            complaintIndex.setEscalationLevel(++escalationLevel);
        } else if (escalationLevel == 2) {
            complaintIndex.setEscalation3FunctionaryName(assignedUser != null ? assignedUser.getName() + " : " + position.getDeptDesig().getDesignation().getName() : "NO ASSIGNMENT : " + position.getDeptDesig().getDesignation().getName());
            complaintIndex.setEscalation3FunctionaryAssigneddate(new Date());
            complaintIndex.setEscalation3FunctionarySLADays(this.getFunctionarySlaDays(complaint));
            complaintIndex.setEscalation3FunctionaryAgeingFromDue(0.0);
            complaintIndex.setEscalation3FunctionaryIsSLA("Y");
            complaintIndex.setEscalation3FunctionaryIfSLA(1);
            complaintIndex.setEscalationLevel(++escalationLevel);
        }
        complaintIndex = this.updateEscalationLevelIndexFields(complaintIndex);
        complaintIndex = this.updateComplaintIndexStatusRelatedFields(complaintIndex);
        this.complaintIndexRepository.save(complaintIndex);
    }

    public void updateAllOpenComplaintIndex() {
        List<Complaint> openComplaints = this.complaintService.getOpenComplaints();
        for (Complaint complaint : openComplaints) {
            this.updateOpenComplaintIndex(complaint);
        }
    }

    public void updateOpenComplaintIndex(Complaint complaint) {
        ComplaintIndex complaintIndex = this.complaintIndexRepository.findByCrnAndCityCode(complaint.getCrn(), ApplicationThreadLocals.getCityCode());
        this.beanMapperConfiguration.map((Object)complaint, (Object)complaintIndex);
        complaintIndex = this.updateComplaintLevelIndexFields(complaintIndex);
        complaintIndex = this.updateEscalationLevelIndexFields(complaintIndex);
        complaintIndex = this.updateComplaintIndexStatusRelatedFields(complaintIndex);
        this.complaintIndexRepository.save(complaintIndex);
    }

    public ComplaintIndex updateComplaintLevelIndexFields(ComplaintIndex complaintIndex) {
        long days = Math.abs(new Date().getTime() - complaintIndex.getCreatedDate().getTime()) / 86400000L;
        complaintIndex.setComplaintPeriod(days);
        Date lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getCreatedDate(), (int)((int)complaintIndex.getComplaintSLADays()));
        Date currentDate = new Date();
        if (lastDateToResolve.getTime() - currentDate.getTime() >= 0L) {
            complaintIndex.setComplaintAgeingFromDue(0.0);
            complaintIndex.setComplaintAgeingdaysFromDue(0L);
            complaintIndex.setIsSLA("Y");
            complaintIndex.setIfSLA(1);
        } else {
            long ageingDuehours = Math.abs(currentDate.getTime() - lastDateToResolve.getTime()) / 3600000L;
            long ageingDueDays = Math.abs(currentDate.getTime() - lastDateToResolve.getTime()) / 86400000L;
            complaintIndex.setComplaintAgeingFromDue(ageingDuehours);
            complaintIndex.setComplaintAgeingdaysFromDue(ageingDueDays);
            complaintIndex.setIsSLA("N");
            complaintIndex.setIfSLA(0);
        }
        if (complaintIndex.getInitialFunctionaryAssigneddate() != null) {
            lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getInitialFunctionaryAssigneddate(), (int)((int)complaintIndex.getInitialFunctionarySLADays()));
            if (lastDateToResolve.getTime() - new Date().getTime() >= 0L) {
                complaintIndex.setInitialFunctionaryAgeingFromDue(0.0);
                complaintIndex.setInitialFunctionaryIsSLA("Y");
                complaintIndex.setInitialFunctionaryIfSLA(1);
            } else {
                long initialFunctionaryAgeingDueHours = Math.abs(new Date().getTime() - lastDateToResolve.getTime()) / 3600000L;
                complaintIndex.setInitialFunctionaryAgeingFromDue(initialFunctionaryAgeingDueHours);
                complaintIndex.setInitialFunctionaryIsSLA("N");
                complaintIndex.setInitialFunctionaryIfSLA(0);
            }
        }
        if (complaintIndex.getCurrentFunctionaryAssigneddate() != null) {
            lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getCurrentFunctionaryAssigneddate(), (int)((int)complaintIndex.getCurrentFunctionarySLADays()));
            if (lastDateToResolve.getTime() - new Date().getTime() >= 0L) {
                complaintIndex.setCurrentFunctionaryAgeingFromDue(0.0);
                complaintIndex.setCurrentFunctionaryIsSLA("Y");
                complaintIndex.setCurrentFunctionaryIfSLA(1);
            } else {
                long currentFunctionaryAgeingDueHours = Math.abs(new Date().getTime() - lastDateToResolve.getTime()) / 3600000L;
                complaintIndex.setCurrentFunctionaryAgeingFromDue(currentFunctionaryAgeingDueHours);
                complaintIndex.setCurrentFunctionaryIsSLA("N");
                complaintIndex.setCurrentFunctionaryIfSLA(0);
            }
        }
        return complaintIndex;
    }

    public ComplaintIndex updateEscalationLevelIndexFields(ComplaintIndex complaintIndex) {
        Date lastDateToResolve;
        if (complaintIndex.getEscalation1FunctionaryAssigneddate() != null) {
            lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getEscalation1FunctionaryAssigneddate(), (int)((int)complaintIndex.getEscalation1FunctionarySLADays()));
            if (lastDateToResolve.getTime() - new Date().getTime() >= 0L) {
                complaintIndex.setEscalation1FunctionaryAgeingFromDue(0.0);
                complaintIndex.setEscalation1FunctionaryIsSLA("Y");
                complaintIndex.setEscalation1FunctionaryIfSLA(1);
            } else {
                long escalation1FunctionaryAgeingDueHours = Math.abs(new Date().getTime() - lastDateToResolve.getTime()) / 3600000L;
                complaintIndex.setEscalation1FunctionaryAgeingFromDue(escalation1FunctionaryAgeingDueHours);
                complaintIndex.setEscalation1FunctionaryIsSLA("N");
                complaintIndex.setEscalation1FunctionaryIfSLA(0);
            }
        }
        if (complaintIndex.getEscalation2FunctionaryAssigneddate() != null) {
            lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getEscalation2FunctionaryAssigneddate(), (int)((int)complaintIndex.getEscalation2FunctionarySLADays()));
            if (lastDateToResolve.getTime() - new Date().getTime() >= 0L) {
                complaintIndex.setEscalation2FunctionaryAgeingFromDue(0.0);
                complaintIndex.setEscalation2FunctionaryIsSLA("Y");
                complaintIndex.setEscalation2FunctionaryIfSLA(1);
            } else {
                long escalation2FunctionaryAgeingDueHours = Math.abs(new Date().getTime() - lastDateToResolve.getTime()) / 3600000L;
                complaintIndex.setEscalation2FunctionaryAgeingFromDue(escalation2FunctionaryAgeingDueHours);
                complaintIndex.setEscalation2FunctionaryIsSLA("N");
                complaintIndex.setEscalation2FunctionaryIfSLA(0);
            }
        }
        if (complaintIndex.getEscalation3FunctionaryAssigneddate() != null) {
            lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getEscalation3FunctionaryAssigneddate(), (int)((int)complaintIndex.getEscalation3FunctionarySLADays()));
            if (lastDateToResolve.getTime() - new Date().getTime() >= 0L) {
                complaintIndex.setEscalation3FunctionaryAgeingFromDue(0.0);
                complaintIndex.setEscalation3FunctionaryIsSLA("Y");
                complaintIndex.setEscalation3FunctionaryIfSLA(1);
            } else {
                long escalation3FunctionaryAgeingDueHours = Math.abs(new Date().getTime() - lastDateToResolve.getTime()) / 3600000L;
                complaintIndex.setEscalation3FunctionaryAgeingFromDue(escalation3FunctionaryAgeingDueHours);
                complaintIndex.setEscalation3FunctionaryIsSLA("N");
                complaintIndex.setEscalation3FunctionaryIfSLA(0);
            }
        }
        return complaintIndex;
    }

    private ComplaintIndex updateComplaintIndexStatusRelatedFields(ComplaintIndex complaintIndex) {
        if (complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.PROCESSING.toString()) || complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.FORWARDED.toString()) || complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.REGISTERED.toString())) {
            complaintIndex.setInProcess(1);
            complaintIndex.setAddressed(0);
            complaintIndex.setRejected(0);
        }
        if (complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.COMPLETED.toString()) || complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.WITHDRAWN.toString())) {
            complaintIndex.setInProcess(0);
            complaintIndex.setAddressed(1);
            complaintIndex.setRejected(0);
        }
        if (complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.REJECTED.toString())) {
            complaintIndex.setInProcess(0);
            complaintIndex.setAddressed(0);
            complaintIndex.setRejected(1);
        }
        if (complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.REOPENED.toString())) {
            complaintIndex.setInProcess(1);
            complaintIndex.setAddressed(0);
            complaintIndex.setRejected(0);
            complaintIndex.setReOpened(1);
        }
        return complaintIndex;
    }

    private long getFunctionarySlaDays(Complaint complaint) {
        Position position = complaint.getAssignee();
        Designation designation = position.getDeptDesig().getDesignation();
        Escalation complaintEscalation = this.escalationService.getEscalationBycomplaintTypeAndDesignation(complaint.getComplaintType().getId(), designation.getId());
        if (complaintEscalation != null) {
            return complaintEscalation.getNoOfHrs().intValue();
        }
        return 0L;
    }

    public Map<String, Object> getGrievanceReport(ComplaintDashBoardRequest complaintDashBoardRequest) {
        Terms slaTerms;
        Terms openAndClosedTerms;
        Avg groupByFieldAverageSatisfaction;
        ComplaintDashBoardResponse responseDetail;
        Terms slaTerms2;
        Terms openAndClosedTerms2;
        Avg groupByFieldAverageSatisfaction2;
        SearchHit[] hit;
        TopHits topHits;
        Iterator responseDetail2;
        Object ulbTerms;
        String groupByField = ComplaintIndexAggregationBuilder.getAggregationGroupingField(complaintDashBoardRequest);
        Map response = this.complaintIndexRepository.findAllGrievanceByFilter(complaintDashBoardRequest, this.getFilterQuery(complaintDashBoardRequest), groupByField);
        SearchResponse consolidatedResponse = (SearchResponse)response.get("consolidatedResponse");
        SearchResponse tableResponse = (SearchResponse)response.get("tableResponse");
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<Object> responseDetailsList = new ArrayList<Object>();
        ValueCount totalCount = (ValueCount)((SearchResponse)response.get("consolidatedResponse")).getAggregations().get("countAggregation");
        result.put("TotalComplaint", totalCount.getValue());
        Filter filter = (Filter)consolidatedResponse.getAggregations().get("agg");
        Avg averageAgeing = (Avg)filter.getAggregations().get("AgeingInWeeks");
        result.put("AvgAgeingInWeeks", averageAgeing.getValue() / 7.0);
        Range satisfactionAverage = (Range)consolidatedResponse.getAggregations().get(EXCLUDE_ZERO);
        Avg averageSatisfaction = (Avg)((Range.Bucket)satisfactionAverage.getBuckets().get(0)).getAggregations().get("satisfactionAverage");
        result.put("AvgCustomeSatisfactionIndex", averageSatisfaction.getValue());
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getUlbCode())) {
            CityIndex city = this.cityIndexService.findOne(complaintDashBoardRequest.getUlbCode());
            result.put(REGION_NAME, city.getRegionname());
            result.put(DISTRICT_NAME, city.getDistrictname());
            result.put(ULB_CODE, city.getCitycode());
            result.put(ULB_GRADE, city.getCitygrade());
            result.put(ULB_NAME, city.getName());
            result.put(DOMAIN_URL, city.getDomainurl());
        }
        Terms terms = (Terms)consolidatedResponse.getAggregations().get("closedCount");
        for (Terms.Bucket bucket : terms.getBuckets()) {
            if (bucket.getKeyAsNumber().intValue() == 1) {
                result.put("ClosedComplaints", bucket.getDocCount());
                continue;
            }
            result.put("OpenComplaints", bucket.getDocCount());
        }
        terms = (Terms)consolidatedResponse.getAggregations().get("slaCount");
        for (Terms.Bucket bucket : terms.getBuckets()) {
            if (bucket.getKeyAsNumber().intValue() == 1) {
                result.put("WithinSLACount", bucket.getDocCount());
                continue;
            }
            result.put("OutSideSLACount", bucket.getDocCount());
        }
        Range currentYearCount = (Range)consolidatedResponse.getAggregations().get("currentYear");
        result.put("CYTDComplaint", ((Range.Bucket)currentYearCount.getBuckets().get(0)).getDocCount());
        Range todaysCount = (Range)consolidatedResponse.getAggregations().get("todaysComplaintCount");
        result.put("todaysComplaintsCount", ((Range.Bucket)todaysCount.getBuckets().get(0)).getDocCount());
        if (complaintDashBoardRequest.getType().equals("allwards")) {
            ulbTerms = (Terms)tableResponse.getAggregations().get(ULBWISE);
            for (Terms.Bucket ulbBucket : ulbTerms.getBuckets()) {
                terms = (Terms)ulbBucket.getAggregations().get(GROUP_BY_FIELD);
                for (Object bucket : terms.getBuckets()) {
                    ComplaintDashBoardResponse responseDetail3 = this.populateResponse(complaintDashBoardRequest, (Terms.Bucket)bucket, groupByField);
                    responseDetail3.setTotalComplaintCount(bucket.getDocCount());
                    TopHits topHits2 = (TopHits)bucket.getAggregations().get(COMPLAINTRECORD);
                    SearchHit[] hit2 = topHits2.getHits().getHits();
                    responseDetail3.setUlbCode((String)hit2[0].field("cityCode").getValue());
                    responseDetail3.setUlbName((String)hit2[0].field(CITY_NAME).getValue());
                    responseDetail3.setDistrictName((String)hit2[0].field(CITY_DISTRICT_NAME).getValue());
                    responseDetail3.setWardName((String)hit2[0].field(WARD_NAME).getValue());
                    satisfactionAverage = (Range)bucket.getAggregations().get(EXCLUDE_ZERO);
                    Avg groupByFieldAverageSatisfaction3 = (Avg)((Range.Bucket)satisfactionAverage.getBuckets().get(0)).getAggregations().get(GROUP_BY_FIELD_SATISFACTION_AVERAGE);
                    if (Double.isNaN(groupByFieldAverageSatisfaction3.getValue())) {
                        responseDetail3.setAvgSatisfactionIndex(0.0);
                    } else {
                        responseDetail3.setAvgSatisfactionIndex(groupByFieldAverageSatisfaction3.getValue());
                    }
                    Terms openAndClosedTerms3 = (Terms)bucket.getAggregations().get(GROUP_FIELDWISE_OPEN_AND_CLOSED_COUNT);
                    for (Terms.Bucket closedCountbucket : openAndClosedTerms3.getBuckets()) {
                        Terms slaTerms3;
                        if (closedCountbucket.getKeyAsNumber().intValue() == 1) {
                            responseDetail3.setClosedComplaintCount(closedCountbucket.getDocCount());
                            slaTerms3 = (Terms)closedCountbucket.getAggregations().get(GROUP_BY_FIELD_SLA);
                            for (Terms.Bucket slaBucket : slaTerms3.getBuckets()) {
                                if (slaBucket.getKeyAsNumber().intValue() == 1) {
                                    responseDetail3.setClosedWithinSLACount(slaBucket.getDocCount());
                                    continue;
                                }
                                responseDetail3.setClosedOutSideSLACount(slaBucket.getDocCount());
                            }
                            this.setAgeingResults(responseDetail3, closedCountbucket, GROUP_BY_FIELD_AGEING, GROUP_BY_FIELD_AGEING_FOR_HOURS);
                            continue;
                        }
                        responseDetail3.setOpenComplaintCount(closedCountbucket.getDocCount());
                        slaTerms3 = (Terms)closedCountbucket.getAggregations().get(GROUP_BY_FIELD_SLA);
                        for (Terms.Bucket slaBucket : slaTerms3.getBuckets()) {
                            if (slaBucket.getKeyAsNumber().intValue() == 1) {
                                responseDetail3.setOpenWithinSLACount(slaBucket.getDocCount());
                                continue;
                            }
                            responseDetail3.setOpenOutSideSLACount(slaBucket.getDocCount());
                        }
                    }
                    responseDetailsList.add(responseDetail3);
                }
            }
        } else if (complaintDashBoardRequest.getType().equals("alllocalities")) {
            ulbTerms = (Terms)tableResponse.getAggregations().get(ULBWISE);
            for (Terms.Bucket ulbBucket : ulbTerms.getBuckets()) {
                Terms wardTerms = (Terms)ulbBucket.getAggregations().get(WARDWISE);
                for (Terms.Bucket wardBucket : wardTerms.getBuckets()) {
                    terms = (Terms)wardBucket.getAggregations().get(GROUP_BY_FIELD);
                    for (Terms.Bucket bucket : terms.getBuckets()) {
                        responseDetail2 = this.populateResponse(complaintDashBoardRequest, bucket, groupByField);
                        ((ComplaintDashBoardResponse)((Object)responseDetail2)).setTotalComplaintCount(bucket.getDocCount());
                        topHits = (TopHits)bucket.getAggregations().get(COMPLAINTRECORD);
                        hit = topHits.getHits().getHits();
                        ((ComplaintDashBoardResponse)((Object)responseDetail2)).setUlbCode((String)hit[0].field("cityCode").getValue());
                        ((ComplaintDashBoardResponse)((Object)responseDetail2)).setUlbName((String)hit[0].field(CITY_NAME).getValue());
                        ((ComplaintDashBoardResponse)((Object)responseDetail2)).setDistrictName((String)hit[0].field(CITY_DISTRICT_NAME).getValue());
                        ((ComplaintDashBoardResponse)((Object)responseDetail2)).setWardName((String)hit[0].field(WARD_NAME).getValue());
                        ((ComplaintDashBoardResponse)((Object)responseDetail2)).setLocalityName((String)hit[0].field(LOCALITY_NAME).getValue());
                        satisfactionAverage = (Range)bucket.getAggregations().get(EXCLUDE_ZERO);
                        groupByFieldAverageSatisfaction2 = (Avg)((Range.Bucket)satisfactionAverage.getBuckets().get(0)).getAggregations().get(GROUP_BY_FIELD_SATISFACTION_AVERAGE);
                        if (Double.isNaN(groupByFieldAverageSatisfaction2.getValue())) {
                            ((ComplaintDashBoardResponse)((Object)responseDetail2)).setAvgSatisfactionIndex(0.0);
                        } else {
                            ((ComplaintDashBoardResponse)((Object)responseDetail2)).setAvgSatisfactionIndex(groupByFieldAverageSatisfaction2.getValue());
                        }
                        openAndClosedTerms2 = (Terms)bucket.getAggregations().get(GROUP_FIELDWISE_OPEN_AND_CLOSED_COUNT);
                        for (Terms.Bucket closedCountbucket : openAndClosedTerms2.getBuckets()) {
                            if (closedCountbucket.getKeyAsNumber().intValue() == 1) {
                                ((ComplaintDashBoardResponse)((Object)responseDetail2)).setClosedComplaintCount(closedCountbucket.getDocCount());
                                slaTerms2 = (Terms)closedCountbucket.getAggregations().get(GROUP_BY_FIELD_SLA);
                                for (Terms.Bucket slaBucket : slaTerms2.getBuckets()) {
                                    if (slaBucket.getKeyAsNumber().intValue() == 1) {
                                        ((ComplaintDashBoardResponse)((Object)responseDetail2)).setClosedWithinSLACount(slaBucket.getDocCount());
                                        continue;
                                    }
                                    ((ComplaintDashBoardResponse)((Object)responseDetail2)).setClosedOutSideSLACount(slaBucket.getDocCount());
                                }
                                this.setAgeingResults((ComplaintDashBoardResponse)((Object)responseDetail2), closedCountbucket, GROUP_BY_FIELD_AGEING, GROUP_BY_FIELD_AGEING_FOR_HOURS);
                                continue;
                            }
                            ((ComplaintDashBoardResponse)((Object)responseDetail2)).setOpenComplaintCount(closedCountbucket.getDocCount());
                            slaTerms2 = (Terms)closedCountbucket.getAggregations().get(GROUP_BY_FIELD_SLA);
                            for (Terms.Bucket slaBucket : slaTerms2.getBuckets()) {
                                if (slaBucket.getKeyAsNumber().intValue() == 1) {
                                    ((ComplaintDashBoardResponse)((Object)responseDetail2)).setOpenWithinSLACount(slaBucket.getDocCount());
                                    continue;
                                }
                                ((ComplaintDashBoardResponse)((Object)responseDetail2)).setOpenOutSideSLACount(slaBucket.getDocCount());
                            }
                        }
                        responseDetailsList.add(responseDetail2);
                    }
                }
            }
        } else if (complaintDashBoardRequest.getType().equals("allfunctionary")) {
            ulbTerms = (Terms)tableResponse.getAggregations().get(ULBWISE);
            for (Terms.Bucket ulbBucket : ulbTerms.getBuckets()) {
                Terms deptTerms = (Terms)ulbBucket.getAggregations().get(DEPARTMENTWISE);
                for (Object deptBucket : deptTerms.getBuckets()) {
                    terms = (Terms)deptBucket.getAggregations().get(GROUP_BY_FIELD);
                    for (Terms.Bucket bucket : terms.getBuckets()) {
                        responseDetail2 = this.populateResponse(complaintDashBoardRequest, bucket, groupByField);
                        ((ComplaintDashBoardResponse)((Object)responseDetail2)).setTotalComplaintCount(bucket.getDocCount());
                        topHits = (TopHits)bucket.getAggregations().get(COMPLAINTRECORD);
                        hit = topHits.getHits().getHits();
                        ((ComplaintDashBoardResponse)((Object)responseDetail2)).setUlbCode((String)hit[0].field("cityCode").getValue());
                        ((ComplaintDashBoardResponse)((Object)responseDetail2)).setUlbName((String)hit[0].field(CITY_NAME).getValue());
                        ((ComplaintDashBoardResponse)((Object)responseDetail2)).setDistrictName((String)hit[0].field(CITY_DISTRICT_NAME).getValue());
                        ((ComplaintDashBoardResponse)((Object)responseDetail2)).setDepartmentName((String)hit[0].field(DEPARTMENT_NAME).getValue());
                        if (hit[0].field(INITIAL_FUNCTIONARY_MOBILE_NUMBER) != null) {
                            ((ComplaintDashBoardResponse)((Object)responseDetail2)).setFunctionaryMobileNumber((String)hit[0].field(INITIAL_FUNCTIONARY_MOBILE_NUMBER).getValue());
                        }
                        ((ComplaintDashBoardResponse)((Object)responseDetail2)).setFunctionaryName(bucket.getKeyAsString());
                        satisfactionAverage = (Range)bucket.getAggregations().get(EXCLUDE_ZERO);
                        groupByFieldAverageSatisfaction2 = (Avg)((Range.Bucket)satisfactionAverage.getBuckets().get(0)).getAggregations().get(GROUP_BY_FIELD_SATISFACTION_AVERAGE);
                        if (Double.isNaN(groupByFieldAverageSatisfaction2.getValue())) {
                            ((ComplaintDashBoardResponse)((Object)responseDetail2)).setAvgSatisfactionIndex(0.0);
                        } else {
                            ((ComplaintDashBoardResponse)((Object)responseDetail2)).setAvgSatisfactionIndex(groupByFieldAverageSatisfaction2.getValue());
                        }
                        openAndClosedTerms2 = (Terms)bucket.getAggregations().get(GROUP_FIELDWISE_OPEN_AND_CLOSED_COUNT);
                        for (Terms.Bucket closedCountbucket : openAndClosedTerms2.getBuckets()) {
                            if (closedCountbucket.getKeyAsNumber().intValue() == 1) {
                                ((ComplaintDashBoardResponse)((Object)responseDetail2)).setClosedComplaintCount(closedCountbucket.getDocCount());
                                slaTerms2 = (Terms)closedCountbucket.getAggregations().get(GROUP_BY_FIELD_SLA);
                                for (Terms.Bucket slaBucket : slaTerms2.getBuckets()) {
                                    if (slaBucket.getKeyAsNumber().intValue() == 1) {
                                        ((ComplaintDashBoardResponse)((Object)responseDetail2)).setClosedWithinSLACount(slaBucket.getDocCount());
                                        continue;
                                    }
                                    ((ComplaintDashBoardResponse)((Object)responseDetail2)).setClosedOutSideSLACount(slaBucket.getDocCount());
                                }
                                this.setAgeingResults((ComplaintDashBoardResponse)((Object)responseDetail2), closedCountbucket, GROUP_BY_FIELD_AGEING, GROUP_BY_FIELD_AGEING_FOR_HOURS);
                                continue;
                            }
                            ((ComplaintDashBoardResponse)((Object)responseDetail2)).setOpenComplaintCount(closedCountbucket.getDocCount());
                            slaTerms2 = (Terms)closedCountbucket.getAggregations().get(GROUP_BY_FIELD_SLA);
                            for (Terms.Bucket slaBucket : slaTerms2.getBuckets()) {
                                if (slaBucket.getKeyAsNumber().intValue() == 1) {
                                    ((ComplaintDashBoardResponse)((Object)responseDetail2)).setOpenWithinSLACount(slaBucket.getDocCount());
                                    continue;
                                }
                                ((ComplaintDashBoardResponse)((Object)responseDetail2)).setOpenOutSideSLACount(slaBucket.getDocCount());
                            }
                        }
                        responseDetailsList.add(responseDetail2);
                    }
                }
            }
        } else {
            terms = (Terms)tableResponse.getAggregations().get(GROUP_BY_FIELD);
            for (Terms.Bucket bucket : terms.getBuckets()) {
                responseDetail = this.populateResponse(complaintDashBoardRequest, bucket, groupByField);
                responseDetail.setTotalComplaintCount(bucket.getDocCount());
                satisfactionAverage = (Range)bucket.getAggregations().get(EXCLUDE_ZERO);
                groupByFieldAverageSatisfaction = (Avg)((Range.Bucket)satisfactionAverage.getBuckets().get(0)).getAggregations().get(GROUP_BY_FIELD_SATISFACTION_AVERAGE);
                if (Double.isNaN(groupByFieldAverageSatisfaction.getValue())) {
                    responseDetail.setAvgSatisfactionIndex(0.0);
                } else {
                    responseDetail.setAvgSatisfactionIndex(groupByFieldAverageSatisfaction.getValue());
                }
                openAndClosedTerms = (Terms)bucket.getAggregations().get(GROUP_FIELDWISE_OPEN_AND_CLOSED_COUNT);
                for (Terms.Bucket closedCountbucket : openAndClosedTerms.getBuckets()) {
                    if (closedCountbucket.getKeyAsNumber().intValue() == 1) {
                        responseDetail.setClosedComplaintCount(closedCountbucket.getDocCount());
                        slaTerms = (Terms)closedCountbucket.getAggregations().get(GROUP_BY_FIELD_SLA);
                        for (Terms.Bucket slaBucket : slaTerms.getBuckets()) {
                            if (slaBucket.getKeyAsNumber().intValue() == 1) {
                                responseDetail.setClosedWithinSLACount(slaBucket.getDocCount());
                                continue;
                            }
                            responseDetail.setClosedOutSideSLACount(slaBucket.getDocCount());
                        }
                        this.setAgeingResults(responseDetail, closedCountbucket, GROUP_BY_FIELD_AGEING, GROUP_BY_FIELD_AGEING_FOR_HOURS);
                        continue;
                    }
                    responseDetail.setOpenComplaintCount(closedCountbucket.getDocCount());
                    slaTerms = (Terms)closedCountbucket.getAggregations().get(GROUP_BY_FIELD_SLA);
                    for (Terms.Bucket slaBucket : slaTerms.getBuckets()) {
                        if (slaBucket.getKeyAsNumber().intValue() == 1) {
                            responseDetail.setOpenWithinSLACount(slaBucket.getDocCount());
                            continue;
                        }
                        responseDetail.setOpenOutSideSLACount(slaBucket.getDocCount());
                    }
                }
                responseDetailsList.add(responseDetail);
            }
        }
        if (groupByField.equals(LOCALITY_NAME)) {
            SearchResponse localityMissingResponse = (SearchResponse)response.get("noLocality");
            Missing noLocalityTerms = (Missing)localityMissingResponse.getAggregations().get(NOLOCALITY);
            responseDetail = new ComplaintDashBoardResponse();
            responseDetail.setLocalityName("N/A");
            responseDetail.setTotalComplaintCount(noLocalityTerms.getDocCount());
            satisfactionAverage = (Range)noLocalityTerms.getAggregations().get(EXCLUDE_ZERO);
            groupByFieldAverageSatisfaction = (Avg)((Range.Bucket)satisfactionAverage.getBuckets().get(0)).getAggregations().get(GROUP_BY_FIELD_SATISFACTION_AVERAGE);
            if (Double.isNaN(groupByFieldAverageSatisfaction.getValue())) {
                responseDetail.setAvgSatisfactionIndex(0.0);
            } else {
                responseDetail.setAvgSatisfactionIndex(groupByFieldAverageSatisfaction.getValue());
            }
            openAndClosedTerms = (Terms)noLocalityTerms.getAggregations().get(GROUP_FIELDWISE_OPEN_AND_CLOSED_COUNT);
            for (Terms.Bucket closedCountbucket : openAndClosedTerms.getBuckets()) {
                if (closedCountbucket.getKeyAsNumber().intValue() == 1) {
                    responseDetail.setClosedComplaintCount(closedCountbucket.getDocCount());
                    slaTerms = (Terms)closedCountbucket.getAggregations().get(GROUP_BY_FIELD_SLA);
                    for (Terms.Bucket slaBucket : slaTerms.getBuckets()) {
                        if (slaBucket.getKeyAsNumber().intValue() == 1) {
                            responseDetail.setClosedWithinSLACount(slaBucket.getDocCount());
                            continue;
                        }
                        responseDetail.setClosedOutSideSLACount(slaBucket.getDocCount());
                    }
                    this.setAgeingResults(responseDetail, closedCountbucket, GROUP_BY_FIELD_AGEING, GROUP_BY_FIELD_AGEING_FOR_HOURS);
                    continue;
                }
                responseDetail.setOpenComplaintCount(closedCountbucket.getDocCount());
                slaTerms = (Terms)closedCountbucket.getAggregations().get(GROUP_BY_FIELD_SLA);
                for (Terms.Bucket slaBucket : slaTerms.getBuckets()) {
                    if (slaBucket.getKeyAsNumber().intValue() == 1) {
                        responseDetail.setOpenWithinSLACount(slaBucket.getDocCount());
                        continue;
                    }
                    responseDetail.setOpenOutSideSLACount(slaBucket.getDocCount());
                }
            }
            responseDetailsList.add(responseDetail);
        }
        result.put(RESPONSE_DETAILS, responseDetailsList);
        ArrayList<ComplaintDashBoardResponse> complaintTypeList = new ArrayList<ComplaintDashBoardResponse>();
        terms = (Terms)tableResponse.getAggregations().get(COMPLAINT_TYPEWISE);
        for (Terms.Bucket bucket : terms.getBuckets()) {
            ComplaintDashBoardResponse complaintType = new ComplaintDashBoardResponse();
            complaintType = this.setDefaultValues(complaintType);
            complaintType.setComplaintTypeName(bucket.getKey().toString());
            complaintType.setTotalComplaintCount(bucket.getDocCount());
            satisfactionAverage = (Range)bucket.getAggregations().get(EXCLUDE_ZERO);
            Avg complaintTypeAverageSatisfaction = (Avg)((Range.Bucket)satisfactionAverage.getBuckets().get(0)).getAggregations().get("complaintTypeSatisfactionAverage");
            if (Double.isNaN(complaintTypeAverageSatisfaction.getValue())) {
                complaintType.setAvgSatisfactionIndex(0.0);
            } else {
                complaintType.setAvgSatisfactionIndex(complaintTypeAverageSatisfaction.getValue());
            }
            Terms openAndClosedTerms4 = (Terms)bucket.getAggregations().get("complaintTypeWiseOpenAndClosedCount");
            for (Terms.Bucket closedCountbucket : openAndClosedTerms4.getBuckets()) {
                Terms slaTerms4;
                if (closedCountbucket.getKeyAsNumber().intValue() == 1) {
                    complaintType.setClosedComplaintCount(closedCountbucket.getDocCount());
                    slaTerms4 = (Terms)closedCountbucket.getAggregations().get("complaintTypeSla");
                    for (Terms.Bucket slaBucket : slaTerms4.getBuckets()) {
                        if (slaBucket.getKeyAsNumber().intValue() == 1) {
                            complaintType.setClosedWithinSLACount(slaBucket.getDocCount());
                            continue;
                        }
                        complaintType.setClosedOutSideSLACount(slaBucket.getDocCount());
                    }
                    this.setAgeingResults(complaintType, closedCountbucket, "ComplaintTypeAgeing", "hourwiseComplaintTypeAgeing");
                    continue;
                }
                complaintType.setOpenComplaintCount(closedCountbucket.getDocCount());
                slaTerms4 = (Terms)closedCountbucket.getAggregations().get("complaintTypeSla");
                for (Terms.Bucket slaBucket : slaTerms4.getBuckets()) {
                    if (slaBucket.getKeyAsNumber().intValue() == 1) {
                        complaintType.setOpenWithinSLACount(slaBucket.getDocCount());
                        continue;
                    }
                    complaintType.setOpenOutSideSLACount(slaBucket.getDocCount());
                }
            }
            complaintTypeList.add(complaintType);
        }
        result.put("complaintTypes", complaintTypeList);
        return result;
    }

    private void setAgeingResults(ComplaintDashBoardResponse responseDetail, Terms.Bucket closedCountbucket, String weeklyAggregation, String hourlyAggregation) {
        Range ageingRange = (Range)closedCountbucket.getAggregations().get(weeklyAggregation);
        Range.Bucket rangeBucket = (Range.Bucket)ageingRange.getBuckets().get(0);
        responseDetail.setAgeingGroup1(rangeBucket.getDocCount());
        rangeBucket = (Range.Bucket)ageingRange.getBuckets().get(1);
        responseDetail.setAgeingGroup2(rangeBucket.getDocCount());
        rangeBucket = (Range.Bucket)ageingRange.getBuckets().get(2);
        responseDetail.setAgeingGroup3(rangeBucket.getDocCount());
        rangeBucket = (Range.Bucket)ageingRange.getBuckets().get(3);
        responseDetail.setAgeingGroup4(rangeBucket.getDocCount());
        Range hourlyAgeingRange = (Range)closedCountbucket.getAggregations().get(hourlyAggregation);
        Range.Bucket hourlyRangeBucket = (Range.Bucket)hourlyAgeingRange.getBuckets().get(0);
        responseDetail.setAgeingGroup5(hourlyRangeBucket.getDocCount());
        hourlyRangeBucket = (Range.Bucket)hourlyAgeingRange.getBuckets().get(1);
        responseDetail.setAgeingGroup6(hourlyRangeBucket.getDocCount());
        hourlyRangeBucket = (Range.Bucket)hourlyAgeingRange.getBuckets().get(2);
        responseDetail.setAgeingGroup7(hourlyRangeBucket.getDocCount());
        hourlyRangeBucket = (Range.Bucket)hourlyAgeingRange.getBuckets().get(3);
        responseDetail.setAgeingGroup8(hourlyRangeBucket.getDocCount());
    }

    public Map<String, Object> getComplaintTypeReport(ComplaintDashBoardRequest complaintDashBoardRequest) {
        Object reOpenedComplaints;
        Terms openAndClosedTerms;
        ComplaintDashBoardResponse responseDetail;
        String groupByField = ComplaintIndexAggregationBuilder.getAggregationGroupingField(complaintDashBoardRequest);
        Map complaintTypeResponse = this.complaintIndexRepository.findAllGrievanceByComplaintType(complaintDashBoardRequest, this.getFilterQuery(complaintDashBoardRequest), groupByField);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getUlbCode())) {
            CityIndex city = this.cityIndexService.findOne(complaintDashBoardRequest.getUlbCode());
            result.put(REGION_NAME, city.getRegionname());
            result.put(DISTRICT_NAME, city.getDistrictname());
            result.put(ULB_CODE, city.getCitycode());
            result.put(ULB_GRADE, city.getCitygrade());
            result.put(ULB_NAME, city.getName());
            result.put(DOMAIN_URL, city.getDomainurl());
        }
        ArrayList<ComplaintDashBoardResponse> responseDetailsList = new ArrayList<ComplaintDashBoardResponse>();
        Terms terms = (Terms)((SearchResponse)complaintTypeResponse.get("tableResponse")).getAggregations().get(GROUP_BY_FIELD);
        for (Terms.Bucket bucket : terms.getBuckets()) {
            Object closedCountbucket2;
            responseDetail = this.populateResponse(complaintDashBoardRequest, bucket, groupByField);
            responseDetail.setTotalComplaintCount(bucket.getDocCount());
            openAndClosedTerms = (Terms)bucket.getAggregations().get(CLOSED_COMPLAINT_COUNT);
            for (Object closedCountbucket2 : openAndClosedTerms.getBuckets()) {
                if (closedCountbucket2.getKeyAsNumber().intValue() == 1) {
                    responseDetail.setClosedComplaintCount(closedCountbucket2.getDocCount());
                    continue;
                }
                responseDetail.setOpenComplaintCount(closedCountbucket2.getDocCount());
            }
            reOpenedComplaints = (Terms)bucket.getAggregations().get(RE_OPENED_COMPLAINT_COUNT);
            closedCountbucket2 = reOpenedComplaints.getBuckets().iterator();
            while (closedCountbucket2.hasNext()) {
                Terms.Bucket reOpenedCountbucket = (Terms.Bucket)closedCountbucket2.next();
                if (reOpenedCountbucket.getKeyAsNumber().intValue() != 1) continue;
                responseDetail.setReOpenedComplaintCount(reOpenedCountbucket.getDocCount());
            }
            responseDetailsList.add(responseDetail);
        }
        if (groupByField.equals(LOCALITY_NAME)) {
            SearchResponse localityMissingResponse = (SearchResponse)complaintTypeResponse.get("otherLocalities");
            Missing noLocalityTerms = (Missing)localityMissingResponse.getAggregations().get(NOLOCALITY);
            responseDetail = new ComplaintDashBoardResponse();
            responseDetail.setTotalComplaintCount(noLocalityTerms.getDocCount());
            responseDetail.setLocalityName("Others");
            openAndClosedTerms = (Terms)noLocalityTerms.getAggregations().get(CLOSED_COMPLAINT_COUNT);
            for (Object closedCountbucket2 : openAndClosedTerms.getBuckets()) {
                if (closedCountbucket2.getKeyAsNumber().intValue() == 1) {
                    responseDetail.setClosedComplaintCount(closedCountbucket2.getDocCount());
                    continue;
                }
                responseDetail.setOpenComplaintCount(closedCountbucket2.getDocCount());
            }
            reOpenedComplaints = (Terms)noLocalityTerms.getAggregations().get(RE_OPENED_COMPLAINT_COUNT);
            for (Terms.Bucket reOpenedCountbucket : reOpenedComplaints.getBuckets()) {
                if (reOpenedCountbucket.getKeyAsNumber().intValue() != 1) continue;
                responseDetail.setReOpenedComplaintCount(reOpenedCountbucket.getDocCount());
            }
            responseDetailsList.add(responseDetail);
        }
        result.put(COMPLAINTS, responseDetailsList);
        return result;
    }

    public Map<String, Object> getAllFunctionaryResponse(ComplaintDashBoardRequest complaintDashBoardRequest) {
        SearchResponse complaintTypeResponse = this.complaintIndexRepository.findByAllFunctionary(complaintDashBoardRequest, this.getFilterQuery(complaintDashBoardRequest));
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<ComplaintDashBoardResponse> responseDetailsList = new ArrayList<ComplaintDashBoardResponse>();
        Terms ulbTerms = (Terms)complaintTypeResponse.getAggregations().get(ULBWISE);
        for (Terms.Bucket ulbBucket : ulbTerms.getBuckets()) {
            Terms departmentTerms = (Terms)ulbBucket.getAggregations().get(DEPARTMENTWISE);
            for (Terms.Bucket departmentBucket : departmentTerms.getBuckets()) {
                Terms functionaryTerms = (Terms)departmentBucket.getAggregations().get("functionarywise");
                for (Terms.Bucket functionaryBucket : functionaryTerms.getBuckets()) {
                    ComplaintDashBoardResponse responseDetail = new ComplaintDashBoardResponse();
                    responseDetail.setTotalComplaintCount(functionaryBucket.getDocCount());
                    responseDetail.setFunctionaryName(functionaryBucket.getKeyAsString());
                    TopHits topHits = (TopHits)functionaryBucket.getAggregations().get(COMPLAINTRECORD);
                    SearchHit[] hit = topHits.getHits().getHits();
                    responseDetail.setUlbCode((String)hit[0].field("cityCode").getValue());
                    responseDetail.setUlbName((String)hit[0].field(CITY_NAME).getValue());
                    responseDetail.setDistrictName((String)hit[0].field(CITY_DISTRICT_NAME).getValue());
                    responseDetail.setDepartmentName((String)hit[0].field(DEPARTMENT_NAME).getValue());
                    String initialFunctionaryNumber = hit[0].field(INITIAL_FUNCTIONARY_MOBILE_NUMBER) == null ? "N/A" : (String)hit[0].field(INITIAL_FUNCTIONARY_MOBILE_NUMBER).getValue();
                    responseDetail.setFunctionaryMobileNumber(initialFunctionaryNumber);
                    Terms openAndClosedTerms = (Terms)functionaryBucket.getAggregations().get(CLOSED_COMPLAINT_COUNT);
                    for (Terms.Bucket closedCountbucket : openAndClosedTerms.getBuckets()) {
                        if (closedCountbucket.getKeyAsNumber().intValue() == 1) {
                            responseDetail.setClosedComplaintCount(closedCountbucket.getDocCount());
                            continue;
                        }
                        responseDetail.setOpenComplaintCount(closedCountbucket.getDocCount());
                    }
                    Terms reOpenedComplaints = (Terms)functionaryBucket.getAggregations().get(RE_OPENED_COMPLAINT_COUNT);
                    for (Terms.Bucket reOpenedCountbucket : reOpenedComplaints.getBuckets()) {
                        if (reOpenedCountbucket.getKeyAsNumber().intValue() != 1) continue;
                        responseDetail.setReOpenedComplaintCount(reOpenedCountbucket.getDocCount());
                    }
                    responseDetailsList.add(responseDetail);
                }
            }
        }
        result.put(COMPLAINTS, responseDetailsList);
        return result;
    }

    public Map<String, Object> getAllUlbResponse(ComplaintDashBoardRequest complaintDashBoardRequest) {
        SearchResponse ulbWiseResponse = this.complaintIndexRepository.findByAllUlb(complaintDashBoardRequest, this.getFilterQuery(complaintDashBoardRequest));
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<ComplaintDashBoardResponse> responseDetailsList = new ArrayList<ComplaintDashBoardResponse>();
        Terms ulbTerms = (Terms)ulbWiseResponse.getAggregations().get(ULBWISE);
        for (Terms.Bucket ulbBucket : ulbTerms.getBuckets()) {
            ComplaintDashBoardResponse responseDetail = new ComplaintDashBoardResponse();
            responseDetail.setTotalComplaintCount(ulbBucket.getDocCount());
            TopHits topHits = (TopHits)ulbBucket.getAggregations().get(COMPLAINTRECORD);
            SearchHit[] hit = topHits.getHits().getHits();
            responseDetail.setUlbCode((String)hit[0].field("cityCode").getValue());
            responseDetail.setUlbName((String)hit[0].field(CITY_NAME).getValue());
            responseDetail.setDistrictName((String)hit[0].field(CITY_DISTRICT_NAME).getValue());
            Terms openAndClosedTerms = (Terms)ulbBucket.getAggregations().get(COMPLAINT_COUNT);
            for (Terms.Bucket closedCountbucket : openAndClosedTerms.getBuckets()) {
                if (closedCountbucket.getKeyAsNumber().intValue() == 1) {
                    responseDetail.setClosedComplaintCount(closedCountbucket.getDocCount());
                    continue;
                }
                responseDetail.setOpenComplaintCount(closedCountbucket.getDocCount());
            }
            Terms reOpenedComplaints = (Terms)ulbBucket.getAggregations().get(RE_OPENED_COMPLAINT_COUNT);
            for (Terms.Bucket reOpenedCountbucket : reOpenedComplaints.getBuckets()) {
                if (reOpenedCountbucket.getKeyAsNumber().intValue() != 1) continue;
                responseDetail.setReOpenedComplaintCount(reOpenedCountbucket.getDocCount());
            }
            responseDetailsList.add(responseDetail);
        }
        result.put(COMPLAINTS, responseDetailsList);
        return result;
    }

    public Map<String, Object> getAllWardResponse(ComplaintDashBoardRequest complaintDashBoardRequest) {
        SearchResponse ulbWiseResponse = this.complaintIndexRepository.findBYAllWards(complaintDashBoardRequest, this.getFilterQuery(complaintDashBoardRequest));
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<ComplaintDashBoardResponse> responseDetailsList = new ArrayList<ComplaintDashBoardResponse>();
        Terms ulbTerms = (Terms)ulbWiseResponse.getAggregations().get(ULBWISE);
        for (Terms.Bucket ulbBucket : ulbTerms.getBuckets()) {
            Terms wardTerms = (Terms)ulbBucket.getAggregations().get(WARDWISE);
            for (Terms.Bucket wardBucket : wardTerms.getBuckets()) {
                ComplaintDashBoardResponse responseDetail = new ComplaintDashBoardResponse();
                responseDetail.setTotalComplaintCount(wardBucket.getDocCount());
                TopHits topHits = (TopHits)wardBucket.getAggregations().get(COMPLAINTRECORD);
                SearchHit[] hit = topHits.getHits().getHits();
                responseDetail.setUlbCode((String)hit[0].field("cityCode").getValue());
                responseDetail.setUlbName((String)hit[0].field(CITY_NAME).getValue());
                responseDetail.setDistrictName((String)hit[0].field(CITY_DISTRICT_NAME).getValue());
                responseDetail.setWardName((String)hit[0].field(WARD_NAME).getValue());
                Terms openAndClosedTerms = (Terms)wardBucket.getAggregations().get(COMPLAINT_COUNT);
                for (Terms.Bucket closedCountbucket : openAndClosedTerms.getBuckets()) {
                    if (closedCountbucket.getKeyAsNumber().intValue() == 1) {
                        responseDetail.setClosedComplaintCount(closedCountbucket.getDocCount());
                        continue;
                    }
                    responseDetail.setOpenComplaintCount(closedCountbucket.getDocCount());
                }
                Terms reOpenedComplaints = (Terms)wardBucket.getAggregations().get(RE_OPENED_COMPLAINT_COUNT);
                for (Terms.Bucket reOpenedCountbucket : reOpenedComplaints.getBuckets()) {
                    if (reOpenedCountbucket.getKeyAsNumber().intValue() != 1) continue;
                    responseDetail.setReOpenedComplaintCount(reOpenedCountbucket.getDocCount());
                }
                responseDetailsList.add(responseDetail);
            }
        }
        result.put(COMPLAINTS, responseDetailsList);
        return result;
    }

    public Map<String, Object> getAllLocalityResponse(ComplaintDashBoardRequest complaintDashBoardRequest) {
        SearchResponse localityWiseResponse = this.complaintIndexRepository.findBYAllLocalities(complaintDashBoardRequest, this.getFilterQuery(complaintDashBoardRequest));
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<ComplaintDashBoardResponse> responseDetailsList = new ArrayList<ComplaintDashBoardResponse>();
        Terms ulbTerms = (Terms)localityWiseResponse.getAggregations().get(ULBWISE);
        for (Terms.Bucket ulbBucket : ulbTerms.getBuckets()) {
            Terms wardTerms = (Terms)ulbBucket.getAggregations().get(WARDWISE);
            for (Terms.Bucket wardBucket : wardTerms.getBuckets()) {
                Terms localityTerms = (Terms)wardBucket.getAggregations().get("localitywise");
                for (Terms.Bucket localityBucket : localityTerms.getBuckets()) {
                    ComplaintDashBoardResponse responseDetail = new ComplaintDashBoardResponse();
                    responseDetail.setTotalComplaintCount(localityBucket.getDocCount());
                    TopHits topHits = (TopHits)localityBucket.getAggregations().get(COMPLAINTRECORD);
                    SearchHit[] hit = topHits.getHits().getHits();
                    responseDetail.setUlbCode((String)hit[0].field("cityCode").getValue());
                    responseDetail.setUlbName((String)hit[0].field(CITY_NAME).getValue());
                    responseDetail.setDistrictName((String)hit[0].field(CITY_DISTRICT_NAME).getValue());
                    responseDetail.setWardName((String)hit[0].field(WARD_NAME).getValue());
                    responseDetail.setLocalityName((String)hit[0].field(LOCALITY_NAME).getValue());
                    Terms openAndClosedTerms = (Terms)localityBucket.getAggregations().get(COMPLAINT_COUNT);
                    for (Terms.Bucket closedCountbucket : openAndClosedTerms.getBuckets()) {
                        if (closedCountbucket.getKeyAsNumber().intValue() == 1) {
                            responseDetail.setClosedComplaintCount(closedCountbucket.getDocCount());
                            continue;
                        }
                        responseDetail.setOpenComplaintCount(closedCountbucket.getDocCount());
                    }
                    Terms reOpenedComplaints = (Terms)wardBucket.getAggregations().get(RE_OPENED_COMPLAINT_COUNT);
                    for (Terms.Bucket reOpenedCountbucket : reOpenedComplaints.getBuckets()) {
                        if (reOpenedCountbucket.getKeyAsNumber().intValue() != 1) continue;
                        responseDetail.setReOpenedComplaintCount(reOpenedCountbucket.getDocCount());
                    }
                    responseDetailsList.add(responseDetail);
                }
            }
        }
        Missing noLocalityTerms = (Missing)localityWiseResponse.getAggregations().get(NOLOCALITY);
        ComplaintDashBoardResponse responseDetail = new ComplaintDashBoardResponse();
        responseDetail.setTotalComplaintCount(noLocalityTerms.getDocCount());
        responseDetail.setLocalityName("N/A");
        Terms openAndClosedComplaintsCount = (Terms)noLocalityTerms.getAggregations().get("noLocalityComplaintCount");
        for (Terms.Bucket noLocalityCountBucket : openAndClosedComplaintsCount.getBuckets()) {
            if (noLocalityCountBucket.getKeyAsNumber().intValue() == 1) {
                responseDetail.setClosedComplaintCount(noLocalityCountBucket.getDocCount());
                continue;
            }
            responseDetail.setOpenComplaintCount(noLocalityCountBucket.getDocCount());
        }
        responseDetailsList.add(responseDetail);
        result.put(COMPLAINTS, responseDetailsList);
        return result;
    }

    public Map<String, Object> getSourceWiseResponse(ComplaintDashBoardRequest complaintDashBoardRequest) {
        Terms terms;
        Terms ulbTerms;
        String groupByField = ComplaintIndexAggregationBuilder.getAggregationGroupingField(complaintDashBoardRequest);
        SearchResponse sourceWiseResponse = this.complaintIndexRepository.findAllGrievanceBySource(complaintDashBoardRequest, this.getFilterQuery(complaintDashBoardRequest), groupByField);
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<ComplaintSourceResponse> responseDetailsList = new ArrayList<ComplaintSourceResponse>();
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getUlbCode())) {
            CityIndex city = this.cityIndexService.findOne(complaintDashBoardRequest.getUlbCode());
            result.put(REGION_NAME, city.getRegionname());
            result.put(DISTRICT_NAME, city.getDistrictname());
            result.put(ULB_CODE, city.getCitycode());
            result.put(ULB_GRADE, city.getCitygrade());
            result.put(ULB_NAME, city.getName());
            result.put(DOMAIN_URL, city.getDomainurl());
        }
        if (complaintDashBoardRequest.getType().equals("allwards")) {
            ulbTerms = (Terms)sourceWiseResponse.getAggregations().get(ULBWISE);
            for (Terms.Bucket ulbBucket : ulbTerms.getBuckets()) {
                Terms terms2 = (Terms)ulbBucket.getAggregations().get(GROUP_BY_FIELD);
                responseDetailsList = this.getResponseDetailsList(groupByField, terms2, responseDetailsList, complaintDashBoardRequest);
            }
        } else if (complaintDashBoardRequest.getType().equals("alllocalities")) {
            ulbTerms = (Terms)sourceWiseResponse.getAggregations().get(ULBWISE);
            for (Terms.Bucket ulbBucket : ulbTerms.getBuckets()) {
                Terms wardTerms = (Terms)ulbBucket.getAggregations().get(WARDWISE);
                for (Terms.Bucket wardBucket : wardTerms.getBuckets()) {
                    terms = (Terms)wardBucket.getAggregations().get(GROUP_BY_FIELD);
                    responseDetailsList = this.getResponseDetailsList(groupByField, terms, responseDetailsList, complaintDashBoardRequest);
                }
            }
        } else if (complaintDashBoardRequest.getType().equals("allfunctionary")) {
            ulbTerms = (Terms)sourceWiseResponse.getAggregations().get(ULBWISE);
            for (Terms.Bucket ulbBucket : ulbTerms.getBuckets()) {
                Terms deptTerms = (Terms)ulbBucket.getAggregations().get(DEPARTMENTWISE);
                for (Terms.Bucket deptBucket : deptTerms.getBuckets()) {
                    terms = (Terms)deptBucket.getAggregations().get(GROUP_BY_FIELD);
                    responseDetailsList = this.getResponseDetailsList(groupByField, terms, responseDetailsList, complaintDashBoardRequest);
                }
            }
        } else {
            Terms terms3 = (Terms)sourceWiseResponse.getAggregations().get(GROUP_BY_FIELD);
            responseDetailsList = this.getResponseDetailsList(groupByField, terms3, responseDetailsList, complaintDashBoardRequest);
        }
        result.put(RESPONSE_DETAILS, responseDetailsList);
        ArrayList<ComplaintSourceResponse> complaintTypeList = new ArrayList<ComplaintSourceResponse>();
        Terms terms4 = (Terms)sourceWiseResponse.getAggregations().get(COMPLAINT_TYPEWISE);
        for (Terms.Bucket bucket : terms4.getBuckets()) {
            ComplaintSourceResponse complaintSouce = new ComplaintSourceResponse();
            complaintSouce.setComplaintTypeName(bucket.getKey().toString());
            ArrayList<HashMap<String, Long>> list = new ArrayList<HashMap<String, Long>>();
            Terms sourceTerms = (Terms)bucket.getAggregations().get("complaintTypeWiseSource");
            for (Terms.Bucket sourceBucket : sourceTerms.getBuckets()) {
                HashMap<String, Long> sourceMap = new HashMap<String, Long>();
                sourceMap.put(sourceBucket.getKeyAsString(), sourceBucket.getDocCount());
                list.add(sourceMap);
            }
            complaintSouce.setSourceList(list);
            complaintTypeList.add(complaintSouce);
        }
        result.put(COMPLAINT_TYPEWISE, complaintTypeList);
        return result;
    }

    private List<ComplaintSourceResponse> getResponseDetailsList(String groupByField, Terms terms, List<ComplaintSourceResponse> responseDetailsList, ComplaintDashBoardRequest complaintDashBoardRequest) {
        for (Terms.Bucket bucket : terms.getBuckets()) {
            CityIndex city;
            ComplaintSourceResponse complaintSouce = new ComplaintSourceResponse();
            TopHits topHits = (TopHits)bucket.getAggregations().get(COMPLAINTRECORD);
            SearchHit[] hit = topHits.getHits().getHits();
            complaintSouce.setUlbName((String)hit[0].field(CITY_NAME).getValue());
            complaintSouce.setDistrictName((String)hit[0].field(CITY_DISTRICT_NAME).getValue());
            complaintSouce.setWardName((String)hit[0].field(WARD_NAME).getValue());
            if (hit[0].field(DEPARTMENT_NAME) != null) {
                complaintSouce.setDepartmentName((String)hit[0].field(DEPARTMENT_NAME).getValue());
            }
            if (hit[0].field(INITIAL_FUNCTIONARY_NAME) != null) {
                complaintSouce.setFunctionaryName((String)hit[0].field(INITIAL_FUNCTIONARY_NAME).getValue());
            }
            if (hit[0].field(INITIAL_FUNCTIONARY_MOBILE_NUMBER) != null) {
                complaintSouce.setFunctionaryMobileNumber((String)hit[0].field(INITIAL_FUNCTIONARY_MOBILE_NUMBER).getValue());
            }
            if (CITY_REGION_NAME.equals(groupByField)) {
                complaintSouce.setRegionName(bucket.getKeyAsString());
            }
            if (CITY_GRADE.equals(groupByField)) {
                complaintSouce.setUlbGrade(bucket.getKeyAsString());
            }
            if (CITY_DISTRICT_CODE.equals(groupByField)) {
                city = this.cityIndexService.findByDistrictCode(bucket.getKeyAsString());
                complaintSouce.setDistrictName(city.getDistrictname());
            }
            if ("cityCode".equals(groupByField)) {
                city = this.cityIndexService.findByCitycode(bucket.getKeyAsString());
                complaintSouce.setDistrictName(city.getDistrictname());
                complaintSouce.setUlbName(city.getName());
                complaintSouce.setUlbGrade(city.getCitygrade());
                complaintSouce.setUlbCode(city.getCitycode());
                complaintSouce.setDomainURL(city.getDomainurl());
            }
            if (DEPARTMENT_NAME.equals(groupByField)) {
                complaintSouce.setDepartmentName(bucket.getKeyAsString());
            }
            if (WARD_NAME.equals(groupByField)) {
                complaintSouce.setWardName(bucket.getKeyAsString());
            }
            if (LOCALITY_NAME.equals(groupByField)) {
                complaintSouce.setLocalityName(bucket.getKeyAsString());
            }
            if (INITIAL_FUNCTIONARY_NAME.equals(groupByField) && !complaintDashBoardRequest.getType().equalsIgnoreCase("allfunctionary")) {
                complaintSouce.setFunctionaryName(bucket.getKeyAsString());
                String mobileNumber = this.complaintIndexRepository.getFunctionryMobileNumber(bucket.getKeyAsString());
                complaintSouce.setFunctionaryMobileNumber(StringUtils.defaultString((String)mobileNumber, (String)"N/A"));
            }
            ArrayList<HashMap<String, Long>> list = new ArrayList<HashMap<String, Long>>();
            Terms sourceTerms = (Terms)bucket.getAggregations().get("groupByFieldSource");
            for (Terms.Bucket sourceBucket : sourceTerms.getBuckets()) {
                HashMap<String, Long> sourceMap = new HashMap<String, Long>();
                sourceMap.put(sourceBucket.getKeyAsString(), sourceBucket.getDocCount());
                list.add(sourceMap);
            }
            complaintSouce.setSourceList(list);
            responseDetailsList.add(complaintSouce);
        }
        return responseDetailsList;
    }

    public Iterable<ComplaintIndex> searchComplaintIndex(BoolQueryBuilder searchQuery) {
        return this.complaintIndexRepository.search((QueryBuilder)searchQuery);
    }

    private BoolQueryBuilder getFilterQuery(ComplaintDashBoardRequest complaintDashBoardRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"registered", (int)1));
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getToDate())) {
            boolQuery = boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"createdDate").from(complaintDashBoardRequest.getFromDate()).to(complaintDashBoardRequest.getToDate()));
        }
        if (complaintDashBoardRequest.getType().equalsIgnoreCase("allulb") || complaintDashBoardRequest.getType().equalsIgnoreCase("allwards") || complaintDashBoardRequest.getType().equalsIgnoreCase("alllocalities") || complaintDashBoardRequest.getType().equalsIgnoreCase("allfunctionary")) {
            boolQuery = this.filterBasedOnSource(complaintDashBoardRequest, boolQuery);
            return boolQuery;
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getRegionName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_REGION_NAME, (Object)complaintDashBoardRequest.getRegionName()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getUlbGrade())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_GRADE, (Object)complaintDashBoardRequest.getUlbGrade()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getCategoryId())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"categoryId", (Object)complaintDashBoardRequest.getCategoryId()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getDistrictName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CITY_DISTRICT_NAME, (Object)complaintDashBoardRequest.getDistrictName()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getUlbCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityCode", (Object)complaintDashBoardRequest.getUlbCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getWardNo())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"wardNo", (Object)complaintDashBoardRequest.getWardNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getDepartmentCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"departmentCode", (Object)complaintDashBoardRequest.getDepartmentCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getComplaintTypeCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"complaintTypeCode", (Object)complaintDashBoardRequest.getComplaintTypeCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getLocalityName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)LOCALITY_NAME, (Object)complaintDashBoardRequest.getLocalityName()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getFunctionaryName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)INITIAL_FUNCTIONARY_NAME, (Object)complaintDashBoardRequest.getFunctionaryName()));
        }
        boolQuery = this.filterBasedOnSource(complaintDashBoardRequest, boolQuery);
        return boolQuery;
    }

    private BoolQueryBuilder filterBasedOnSource(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder boolQuery) {
        BoolQueryBuilder sourceQuery = boolQuery;
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getIncludedSources())) {
            sourceQuery = sourceQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)SOURCE, (String[])complaintDashBoardRequest.getIncludedSources().split("~")));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getExcludedSources())) {
            sourceQuery = sourceQuery.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)SOURCE, (String[])complaintDashBoardRequest.getExcludedSources().split("~")));
        }
        return sourceQuery;
    }

    private ComplaintDashBoardResponse populateResponse(ComplaintDashBoardRequest complaintDashBoardRequest, Terms.Bucket bucket, String groupByField) {
        CityIndex city;
        ComplaintDashBoardResponse responseDetail = new ComplaintDashBoardResponse();
        responseDetail = this.setDefaultValues(responseDetail);
        if (CITY_REGION_NAME.equals(groupByField)) {
            responseDetail.setRegionName(bucket.getKeyAsString());
        }
        if (CITY_GRADE.equals(groupByField)) {
            responseDetail.setUlbGrade(bucket.getKeyAsString());
        }
        if ("cityCode".equals(groupByField) && "ulb".equalsIgnoreCase(complaintDashBoardRequest.getType())) {
            city = this.cityIndexService.findOne(bucket.getKeyAsString());
            responseDetail.setUlbName(city.getName());
            responseDetail.setUlbCode(city.getCitycode());
        }
        if (CITY_DISTRICT_CODE.equals(groupByField)) {
            city = this.cityIndexService.findByDistrictCode(bucket.getKeyAsString());
            responseDetail.setDistrictName(city.getDistrictname());
        }
        if ("cityCode".equals(groupByField) && !complaintDashBoardRequest.getType().equals("ulb")) {
            city = this.cityIndexService.findOne(bucket.getKeyAsString());
            responseDetail.setDistrictName(city.getDistrictname());
            responseDetail.setUlbName(city.getName());
            responseDetail.setUlbGrade(city.getCitygrade());
            responseDetail.setUlbCode(city.getCitycode());
            responseDetail.setDomainURL(city.getDomainurl());
        }
        if (DEPARTMENT_NAME.equals(groupByField)) {
            responseDetail.setDepartmentName(bucket.getKeyAsString());
        }
        if (WARD_NAME.equals(groupByField)) {
            responseDetail.setWardName(bucket.getKeyAsString());
        }
        if (LOCALITY_NAME.equals(groupByField)) {
            responseDetail.setLocalityName(bucket.getKeyAsString());
        }
        if (INITIAL_FUNCTIONARY_NAME.equals(groupByField) && !complaintDashBoardRequest.getType().equalsIgnoreCase("allfunctionary")) {
            responseDetail.setFunctionaryName(bucket.getKeyAsString());
            String mobileNumber = this.complaintIndexRepository.getFunctionryMobileNumber(bucket.getKeyAsString());
            responseDetail.setFunctionaryMobileNumber(mobileNumber);
        }
        return responseDetail;
    }

    private ComplaintDashBoardResponse setDefaultValues(ComplaintDashBoardResponse response) {
        response.setDistrictName("");
        response.setUlbName("");
        response.setWardName("");
        response.setDepartmentName("");
        response.setFunctionaryName("");
        response.setLocalityName("");
        response.setComplaintTypeName("");
        response.setUlbGrade("");
        response.setUlbCode("");
        response.setDomainURL("");
        return response;
    }

    public List<String> getSourceNameList() {
        ArrayList<String> sourceList = new ArrayList<String>();
        List<ReceivingMode> receivingModes = this.receivingModeService.getReceivingModes();
        for (ReceivingMode receivingMode : receivingModes) {
            sourceList.add(receivingMode.getName());
        }
        return sourceList;
    }

    public List<ComplaintIndex> getFunctionaryWiseComplaints(String functionaryName) {
        List complaints = this.complaintIndexRepository.findAllComplaintsBySource(INITIAL_FUNCTIONARY_NAME, functionaryName);
        this.setComplaintViewURL(complaints);
        return complaints;
    }

    public List<ComplaintIndex> getLocalityWiseComplaints(String localityName) {
        List complaints = this.complaintIndexRepository.findAllComplaintsBySource(LOCALITY_NAME, localityName);
        this.setComplaintViewURL(complaints);
        return complaints;
    }

    public List<ComplaintIndex> getFilteredComplaints(ComplaintDashBoardRequest complaintDashBoardRequest, String fieldName, String fieldValue, Integer lowerLimit, Integer upperLimit) {
        BoolQueryBuilder boolQuery = this.getFilterQuery(complaintDashBoardRequest);
        if (StringUtils.isNotBlank((CharSequence)fieldValue)) {
            boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)fieldName, (Object)fieldValue));
        } else {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"ifClosed", (Object)1)).filter((QueryBuilder)QueryBuilders.rangeQuery((String)fieldName).gte((Object)lowerLimit).lte((Object)upperLimit));
        }
        List complaints = this.complaintIndexRepository.findAllComplaintsByField(complaintDashBoardRequest, boolQuery);
        this.setComplaintViewURL(complaints);
        return complaints;
    }

    private void setComplaintViewURL(List<ComplaintIndex> complaints) {
        for (ComplaintIndex complaint : complaints) {
            if (!StringUtils.isNotBlank((CharSequence)complaint.getCityCode())) continue;
            CityIndex city = this.cityIndexService.findOne(complaint.getCityCode());
            complaint.setUrl(String.format(PGR_COMPLAINT_VIEW_URL, city.getDomainurl(), complaint.getCrn()));
        }
    }

    public Map<String, Object> getAvrgRating(ComplaintDashBoardRequest complaintDashBoardRequest) {
        Terms ulbTerms;
        String groupByField = ComplaintIndexAggregationBuilder.getAggregationGroupingField(complaintDashBoardRequest);
        SearchResponse functionaryWiseResponse = this.complaintIndexRepository.findRatingByGroupByField(complaintDashBoardRequest, this.getFilterQuery(complaintDashBoardRequest), groupByField);
        HashMap<String, Object> result = new HashMap<String, Object>();
        List<ComplaintDashBoardResponse> responseDetailsList = new ArrayList<ComplaintDashBoardResponse>();
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getUlbCode())) {
            CityIndex city = this.cityIndexService.findOne(complaintDashBoardRequest.getUlbCode());
            result.put(REGION_NAME, city.getRegionname());
            result.put(DISTRICT_NAME, city.getDistrictname());
            result.put(ULB_CODE, city.getCitycode());
            result.put(ULB_GRADE, city.getCitygrade());
            result.put(ULB_NAME, city.getName());
            result.put(DOMAIN_URL, city.getDomainurl());
        }
        if (complaintDashBoardRequest.getType().equals("allwards")) {
            ulbTerms = (Terms)functionaryWiseResponse.getAggregations().get(ULBWISE);
            for (Terms.Bucket ulbBucket : ulbTerms.getBuckets()) {
                Terms terms = (Terms)ulbBucket.getAggregations().get(GROUP_BY_FIELD);
                responseDetailsList = this.getResponseList(groupByField, terms, responseDetailsList, complaintDashBoardRequest);
            }
        } else if (complaintDashBoardRequest.getType().equals("alllocalities")) {
            ulbTerms = (Terms)functionaryWiseResponse.getAggregations().get(ULBWISE);
            for (Terms.Bucket ulbBucket : ulbTerms.getBuckets()) {
                Terms wardTerms = (Terms)ulbBucket.getAggregations().get(WARDWISE);
                for (Terms.Bucket wardBucket : wardTerms.getBuckets()) {
                    Terms terms = (Terms)wardBucket.getAggregations().get(GROUP_BY_FIELD);
                    responseDetailsList = this.getResponseList(groupByField, terms, responseDetailsList, complaintDashBoardRequest);
                }
            }
        } else if (complaintDashBoardRequest.getType().equals("allfunctionary")) {
            ulbTerms = (Terms)functionaryWiseResponse.getAggregations().get(ULBWISE);
            for (Terms.Bucket ulbBucket : ulbTerms.getBuckets()) {
                Terms deptTerms = (Terms)ulbBucket.getAggregations().get(DEPARTMENTWISE);
                for (Terms.Bucket deptBucket : deptTerms.getBuckets()) {
                    Terms terms = (Terms)deptBucket.getAggregations().get(GROUP_BY_FIELD);
                    responseDetailsList = this.getResponseList(groupByField, terms, responseDetailsList, complaintDashBoardRequest);
                }
            }
        } else {
            Terms terms = (Terms)functionaryWiseResponse.getAggregations().get(GROUP_BY_FIELD);
            responseDetailsList = this.getResponseList(groupByField, terms, responseDetailsList, complaintDashBoardRequest);
        }
        result.put(RESPONSE_DETAILS, responseDetailsList);
        return result;
    }

    private List<ComplaintDashBoardResponse> getResponseList(String groupByField, Terms terms, List<ComplaintDashBoardResponse> responseDetailsList, ComplaintDashBoardRequest complaintDashBoardRequest) {
        for (Terms.Bucket bucket : terms.getBuckets()) {
            CityIndex city;
            ComplaintDashBoardResponse complaintDashBoardResponse = new ComplaintDashBoardResponse();
            TopHits topHits = (TopHits)bucket.getAggregations().get(COMPLAINTRECORD);
            SearchHit[] hit = topHits.getHits().getHits();
            complaintDashBoardResponse.setUlbName((String)hit[0].field(CITY_NAME).getValue());
            complaintDashBoardResponse.setDistrictName((String)hit[0].field(CITY_DISTRICT_NAME).getValue());
            complaintDashBoardResponse.setWardName((String)hit[0].field(WARD_NAME).getValue());
            if (hit[0].field(DEPARTMENT_NAME) != null) {
                complaintDashBoardResponse.setDepartmentName((String)hit[0].field(DEPARTMENT_NAME).getValue());
            }
            if (hit[0].field(INITIAL_FUNCTIONARY_NAME) != null) {
                complaintDashBoardResponse.setFunctionaryName((String)hit[0].field(INITIAL_FUNCTIONARY_NAME).getValue());
            }
            if (hit[0].field(INITIAL_FUNCTIONARY_MOBILE_NUMBER) != null) {
                complaintDashBoardResponse.setFunctionaryMobileNumber((String)hit[0].field(INITIAL_FUNCTIONARY_MOBILE_NUMBER).getValue());
            }
            if (CITY_REGION_NAME.equals(groupByField)) {
                complaintDashBoardResponse.setRegionName(bucket.getKeyAsString());
            }
            if (CITY_GRADE.equals(groupByField)) {
                complaintDashBoardResponse.setUlbGrade(bucket.getKeyAsString());
            }
            if (CITY_DISTRICT_CODE.equals(groupByField)) {
                city = this.cityIndexService.findByDistrictCode(bucket.getKeyAsString());
                complaintDashBoardResponse.setDistrictName(city.getDistrictname());
            }
            if ("cityCode".equals(groupByField)) {
                city = this.cityIndexService.findByCitycode(bucket.getKeyAsString());
                complaintDashBoardResponse.setDistrictName(city.getDistrictname());
                complaintDashBoardResponse.setUlbName(city.getName());
                complaintDashBoardResponse.setUlbGrade(city.getCitygrade());
                complaintDashBoardResponse.setUlbCode(city.getCitycode());
                complaintDashBoardResponse.setDomainURL(city.getDomainurl());
            }
            if (DEPARTMENT_NAME.equals(groupByField)) {
                complaintDashBoardResponse.setDepartmentName(bucket.getKeyAsString());
            }
            if (WARD_NAME.equals(groupByField)) {
                complaintDashBoardResponse.setWardName(bucket.getKeyAsString());
            }
            if (LOCALITY_NAME.equals(groupByField)) {
                complaintDashBoardResponse.setLocalityName(bucket.getKeyAsString());
            }
            if (INITIAL_FUNCTIONARY_NAME.equals(groupByField) && !complaintDashBoardRequest.getType().equalsIgnoreCase("allfunctionary")) {
                complaintDashBoardResponse.setFunctionaryName(bucket.getKeyAsString());
                String mobileNumber = this.complaintIndexRepository.getFunctionryMobileNumber(bucket.getKeyAsString());
                complaintDashBoardResponse.setFunctionaryMobileNumber(StringUtils.defaultString((String)mobileNumber, (String)"N/A"));
            }
            Terms functionaryTerms = (Terms)bucket.getAggregations().get("groupByInitialFunctionary");
            ArrayList<String> functionaryNames = new ArrayList<String>();
            for (Terms.Bucket fnBucket : functionaryTerms.getBuckets()) {
                functionaryNames.add(fnBucket.getKeyAsString());
            }
            complaintDashBoardResponse.setFunctionaryCount(functionaryNames.size());
            this.updateClosedAndAvgSatisfactionIndex(bucket, complaintDashBoardResponse);
            responseDetailsList.add(complaintDashBoardResponse);
        }
        return responseDetailsList;
    }

    private void updateClosedAndAvgSatisfactionIndex(Terms.Bucket bucket, ComplaintDashBoardResponse complaintDashBoardResponse) {
        Terms closedCount = (Terms)bucket.getAggregations().get("closedcount");
        for (Terms.Bucket ratingbucket : closedCount.getBuckets()) {
            Range satisfactionAverage;
            Avg averageSatisfaction;
            if (ratingbucket.getKeyAsNumber().intValue() == 1) {
                complaintDashBoardResponse.setClosedComplaintCount(ratingbucket.getDocCount());
            }
            if (Double.isNaN((averageSatisfaction = (Avg)((Range.Bucket)(satisfactionAverage = (Range)ratingbucket.getAggregations().get(EXCLUDE_ZERO)).getBuckets().get(0)).getAggregations().get("satisfactionAverage")).getValue())) {
                complaintDashBoardResponse.setAvgSatisfactionIndex(0.0);
                continue;
            }
            complaintDashBoardResponse.setAvgSatisfactionIndex(averageSatisfaction.getValue());
        }
    }
}

