/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.elasticsearch.repository;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.pgr.elasticsearch.entity.ComplaintIndex;
import org.egov.pgr.elasticsearch.entity.contract.ComplaintDashBoardRequest;
import org.egov.pgr.elasticsearch.repository.ComplaintIndexAggregationBuilder;
import org.egov.pgr.elasticsearch.repository.ComplaintIndexCustomRepository;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.missing.MissingBuilder;
import org.elasticsearch.search.aggregations.bucket.range.RangeBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;

public class ComplaintIndexRepositoryImpl
implements ComplaintIndexCustomRepository {
    public static final String INITIAL_FUNCTIONARY_NAME = "initialFunctionaryName";
    private static final String REMAINING_HOURS = "remainingHours";
    private static final String GROUP_BY_FIELD_AGEING_FOR_HOURS = "groupByFieldAgeingForHours";
    private static final String COMPLAINT_AGEING_FROM_DUE = "complaintAgeingFromDue";
    private static final String HOURWISE_COMPLAINT_TYPE_AGEING = "hourwiseComplaintTypeAgeing";
    private static final String INITIAL_FUNCTIONARY_MOBILE_NUMBER = "initialFunctionaryMobileNumber";
    private static final String DEPARTMENT_CODE = "departmentCode";
    private static final String DEPARTMENTWISE = "departmentwise";
    private static final String CITY_DISTRICT_NAME = "cityDistrictName";
    private static final String WARDWISE = "wardwise";
    private static final String GROUP_BY_FIELD = "groupByField";
    private static final String ULBWISE = "ulbwise";
    private static final String IF_SLA = "ifSLA";
    private static final String IF_CLOSED = "ifClosed";
    private static final String LOCALITY_NAME = "localityName";
    private static final String RE_OPENED = "reOpened";
    private static final String RE_OPENED_COMPLAINT_COUNT = "reOpenedComplaintCount";
    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    private static final String GROUP_BY_FUNCTIONARY = "groupByInitialFunctionary";
    private static final String AGGR_CLOSEDCOUNT = "closedcount";
    private static final String COMPLAINT_RECORD = "complaintrecord";
    private static final String DEPARTMENT_NAME = "departmentName";
    private static final String REMAINING_MONTHS = "remainingMonths";
    private static final String COMPLAINT_COUNT = "complaintCount";
    private static final String COMPLAINT_TYPEWISE_SOURCE = "complaintTypeWiseSource";
    private static final String SOURCE = "source";
    private static final String GROUP_BY_FIELD_SOURCE = "groupByFieldSource";
    private static final String CLOSED_COMPLAINT_COUNT = "closedComplaintCount";
    private static final String NOLOCALITY = "nolocality";
    private static final String GROUP_BY_FIELD_SLA = "groupByFieldSla";
    private static final String GROUP_BY_FIELD_AGEING = "groupByFieldAgeing";
    private static final String GROUP_FIELD_WISE_OPEN_AND_CLOSED_COUNT = "groupFieldWiseOpenAndClosedCount";
    private static final String GROUP_BY_FIELD_SATISFACTION_AVERAGE = "groupByFieldSatisfactionAverage";
    private static final String COMPLAINT_TYPE_SLA = "complaintTypeSla";
    private static final String TWELVE_HOURS = "12hours";
    private static final String THREE_MONTHS = "3months";
    private static final String ONE_MONTH = "1month";
    private static final String ONE_WEEK = "1week";
    private static final String COMPLAINT_TYPE_AGEING = "ComplaintTypeAgeing";
    private static final String COMPLAINT_TYPE_WISE_OPEN_AND_CLOSED_COUNT = "complaintTypeWiseOpenAndClosedCount";
    private static final String COMPLAINT_TYPE_SATISFACTION_AVERAGE = "complaintTypeSatisfactionAverage";
    private static final String COMPLAINT_TYPE_NAME = "complaintTypeName";
    private static final String COMPLAINT_TYPE_WISE = "complaintTypeWise";
    private static final String SATISFACTION_INDEX = "satisfactionIndex";
    private static final String SATISFACTION_AVERAGE = "satisfactionAverage";
    private static final String COMPLAINT_AGEINGDAYS_FROM_DUE = "complaintAgeingdaysFromDue";
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    @Override
    public Map<String, SearchResponse> findAllGrievanceByFilter(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query, String grouByField) {
        DateTime toDate;
        DateTime fromDate = new DateTime();
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getToDate())) {
            fromDate = new DateTime((Object)complaintDashBoardRequest.getFromDate());
            toDate = fromDate.plusDays(1);
        } else {
            toDate = fromDate.plusDays(1);
        }
        int size = 120;
        if (complaintDashBoardRequest.getSize() >= 0) {
            size = complaintDashBoardRequest.getSize();
        }
        DateTime currentYearFromDate = new DateTime();
        currentYearFromDate = fromDate.getMonthOfYear() < 4 ? currentYearFromDate.minusYears(1).withMonthOfYear(4).dayOfMonth().withMinimumValue() : currentYearFromDate.withMonthOfYear(4).dayOfMonth().withMinimumValue();
        SearchResponse consolidatedResponse = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCount("countAggregation", "crn")).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping("closedCount", IF_CLOSED, 2)).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping("slaCount", IF_SLA, 2)).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithFilter(IF_CLOSED, 1, "AgeingInWeeks", COMPLAINT_AGEINGDAYS_FROM_DUE)).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithExclusion(SATISFACTION_AVERAGE, SATISFACTION_INDEX)).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountBetweenSpecifiedDates("currentYear", "createdDate", currentYearFromDate.toString(formatter), new DateTime().toString(formatter))).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountBetweenSpecifiedDates("todaysComplaintCount", "createdDate", fromDate.toString(formatter), toDate.toString(formatter))).execute().actionGet();
        SearchResponse tableResponse = complaintDashBoardRequest.getType().equalsIgnoreCase("allwards") ? (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGroupingAndOrder(COMPLAINT_TYPE_WISE, COMPLAINT_TYPE_NAME, size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithExclusion(COMPLAINT_TYPE_SATISFACTION_AVERAGE, SATISFACTION_INDEX)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPE_WISE_OPEN_AND_CLOSED_COUNT, IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)COMPLAINT_TYPE_AGEING).field(COMPLAINT_AGEINGDAYS_FROM_DUE)).addRange(ONE_WEEK, 0.0, 8.0).addRange(ONE_MONTH, 8.0, 32.0).addRange(THREE_MONTHS, 32.0, 91.0).addUnboundedFrom(REMAINING_MONTHS, 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)HOURWISE_COMPLAINT_TYPE_AGEING).field(COMPLAINT_AGEING_FROM_DUE)).addRange(TWELVE_HOURS, 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange(ONE_WEEK, 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPE_SLA, IF_SLA, 2)))).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGroupingAndOrder(GROUP_BY_FIELD, grouByField, size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithExclusion(GROUP_BY_FIELD_SATISFACTION_AVERAGE, SATISFACTION_INDEX)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)COMPLAINT_RECORD).addField("cityCode").addField(CITY_DISTRICT_NAME).addField("cityName").addField("wardName").setSize(1)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_FIELD_WISE_OPEN_AND_CLOSED_COUNT, IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING).field(COMPLAINT_AGEINGDAYS_FROM_DUE)).addRange(ONE_WEEK, 0.0, 8.0).addRange(ONE_MONTH, 8.0, 32.0).addRange(THREE_MONTHS, 32.0, 91.0).addUnboundedFrom(REMAINING_MONTHS, 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING_FOR_HOURS).field(COMPLAINT_AGEING_FROM_DUE)).addRange(TWELVE_HOURS, 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange(ONE_WEEK, 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD_SLA, IF_SLA, 2))))).execute().actionGet() : (complaintDashBoardRequest.getType().equalsIgnoreCase("alllocalities") ? (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGroupingAndOrder(COMPLAINT_TYPE_WISE, COMPLAINT_TYPE_NAME, size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithExclusion(COMPLAINT_TYPE_SATISFACTION_AVERAGE, SATISFACTION_INDEX)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPE_WISE_OPEN_AND_CLOSED_COUNT, IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)COMPLAINT_TYPE_AGEING).field(COMPLAINT_AGEINGDAYS_FROM_DUE)).addRange(ONE_WEEK, 0.0, 8.0).addRange(ONE_MONTH, 8.0, 32.0).addRange(THREE_MONTHS, 32.0, 91.0).addUnboundedFrom(REMAINING_MONTHS, 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)HOURWISE_COMPLAINT_TYPE_AGEING).field(COMPLAINT_AGEING_FROM_DUE)).addRange(TWELVE_HOURS, 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange(ONE_WEEK, 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPE_SLA, IF_SLA, 2)))).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)WARDWISE).field("wardNo")).size(size).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGroupingAndOrder(GROUP_BY_FIELD, grouByField, size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithExclusion(GROUP_BY_FIELD_SATISFACTION_AVERAGE, SATISFACTION_INDEX)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)COMPLAINT_RECORD).addField("cityCode").addField(CITY_DISTRICT_NAME).addField("cityName").addField("wardName").addField(LOCALITY_NAME).setSize(1)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_FIELD_WISE_OPEN_AND_CLOSED_COUNT, IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING).field(COMPLAINT_AGEINGDAYS_FROM_DUE)).addRange(ONE_WEEK, 0.0, 8.0).addRange(ONE_MONTH, 8.0, 32.0).addRange(THREE_MONTHS, 32.0, 91.0).addUnboundedFrom(REMAINING_MONTHS, 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING_FOR_HOURS).field(COMPLAINT_AGEING_FROM_DUE)).addRange(TWELVE_HOURS, 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange(ONE_WEEK, 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD_SLA, IF_SLA, 2)))))).execute().actionGet() : (complaintDashBoardRequest.getType().equalsIgnoreCase("allfunctionary") ? (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGroupingAndOrder(COMPLAINT_TYPE_WISE, COMPLAINT_TYPE_NAME, size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithExclusion(COMPLAINT_TYPE_SATISFACTION_AVERAGE, SATISFACTION_INDEX)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPE_WISE_OPEN_AND_CLOSED_COUNT, IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)COMPLAINT_TYPE_AGEING).field(COMPLAINT_AGEINGDAYS_FROM_DUE)).addRange(ONE_WEEK, 0.0, 8.0).addRange(ONE_MONTH, 8.0, 32.0).addRange(THREE_MONTHS, 32.0, 91.0).addUnboundedFrom(REMAINING_MONTHS, 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)HOURWISE_COMPLAINT_TYPE_AGEING).field(COMPLAINT_AGEING_FROM_DUE)).addRange(TWELVE_HOURS, 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange(ONE_WEEK, 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPE_SLA, IF_SLA, 2)))).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)DEPARTMENTWISE).field(DEPARTMENT_CODE)).size(size).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGroupingAndOrder(GROUP_BY_FIELD, grouByField, size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithExclusion(GROUP_BY_FIELD_SATISFACTION_AVERAGE, SATISFACTION_INDEX)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)COMPLAINT_RECORD).addField("cityCode").addField(CITY_DISTRICT_NAME).addField("cityName").addField(DEPARTMENT_NAME).addField(INITIAL_FUNCTIONARY_MOBILE_NUMBER).setSize(1)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_FIELD_WISE_OPEN_AND_CLOSED_COUNT, IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING).field(COMPLAINT_AGEINGDAYS_FROM_DUE)).addRange(ONE_WEEK, 0.0, 8.0).addRange(ONE_MONTH, 8.0, 32.0).addRange(THREE_MONTHS, 32.0, 91.0).addUnboundedFrom(REMAINING_MONTHS, 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING_FOR_HOURS).field(COMPLAINT_AGEING_FROM_DUE)).addRange(TWELVE_HOURS, 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange(ONE_WEEK, 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD_SLA, IF_SLA, 2)))))).execute().actionGet() : (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGroupingAndOrder(COMPLAINT_TYPE_WISE, COMPLAINT_TYPE_NAME, size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithExclusion(COMPLAINT_TYPE_SATISFACTION_AVERAGE, SATISFACTION_INDEX)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPE_WISE_OPEN_AND_CLOSED_COUNT, IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)COMPLAINT_TYPE_AGEING).field(COMPLAINT_AGEINGDAYS_FROM_DUE)).addRange(ONE_WEEK, 0.0, 8.0).addRange(ONE_MONTH, 8.0, 32.0).addRange(THREE_MONTHS, 32.0, 91.0).addUnboundedFrom(REMAINING_MONTHS, 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)HOURWISE_COMPLAINT_TYPE_AGEING).field(COMPLAINT_AGEING_FROM_DUE)).addRange(TWELVE_HOURS, 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange(ONE_WEEK, 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPE_SLA, IF_SLA, 2)))).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGroupingAndOrder(GROUP_BY_FIELD, grouByField, size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithExclusion(GROUP_BY_FIELD_SATISFACTION_AVERAGE, SATISFACTION_INDEX)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_FIELD_WISE_OPEN_AND_CLOSED_COUNT, IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING).field(COMPLAINT_AGEINGDAYS_FROM_DUE)).addRange(ONE_WEEK, 0.0, 8.0).addRange(ONE_MONTH, 8.0, 32.0).addRange(THREE_MONTHS, 32.0, 91.0).addUnboundedFrom(REMAINING_MONTHS, 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING_FOR_HOURS).field(COMPLAINT_AGEING_FROM_DUE)).addRange(TWELVE_HOURS, 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange(ONE_WEEK, 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD_SLA, IF_SLA, 2)))).execute().actionGet()));
        HashMap<String, SearchResponse> result = new HashMap<String, SearchResponse>();
        if (grouByField.equals(LOCALITY_NAME)) {
            SearchResponse localityMissingResponse = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)((MissingBuilder)AggregationBuilders.missing((String)NOLOCALITY).field(LOCALITY_NAME).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithExclusion(GROUP_BY_FIELD_SATISFACTION_AVERAGE, SATISFACTION_INDEX))).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_FIELD_WISE_OPEN_AND_CLOSED_COUNT, IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING).field(COMPLAINT_AGEINGDAYS_FROM_DUE)).addRange(ONE_WEEK, 0.0, 8.0).addRange(ONE_MONTH, 8.0, 32.0).addRange(THREE_MONTHS, 32.0, 91.0).addUnboundedFrom(REMAINING_MONTHS, 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING_FOR_HOURS).field(COMPLAINT_AGEING_FROM_DUE)).addRange(TWELVE_HOURS, 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange(ONE_WEEK, 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD_SLA, IF_SLA, 2)))).execute().actionGet();
            result.put("noLocality", localityMissingResponse);
        }
        result.put("consolidatedResponse", consolidatedResponse);
        result.put("tableResponse", tableResponse);
        return result;
    }

    @Override
    public String getWardName(String wardNo) {
        SearchResponse response = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setSize(1).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"wardNo", (Object)wardNo)).execute().actionGet();
        Iterator searchHits = response.getHits().iterator();
        return searchHits.hasNext() ? ((SearchHit)searchHits.next()).getSource().get("wardName").toString() : "";
    }

    @Override
    public Map<String, SearchResponse> findAllGrievanceByComplaintType(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query, String grouByField) {
        HashMap<String, SearchResponse> response = new HashMap<String, SearchResponse>();
        SearchResponse tableResponse = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD, grouByField, 120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(CLOSED_COMPLAINT_COUNT, IF_CLOSED, 2)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(RE_OPENED_COMPLAINT_COUNT, RE_OPENED, 2))).execute().actionGet();
        response.put("tableResponse", tableResponse);
        if (grouByField.equals(LOCALITY_NAME)) {
            SearchResponse otherLocalitiesResponse = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)((MissingBuilder)AggregationBuilders.missing((String)NOLOCALITY).field(LOCALITY_NAME).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(CLOSED_COMPLAINT_COUNT, IF_CLOSED, 2))).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(RE_OPENED_COMPLAINT_COUNT, RE_OPENED, 2))).execute().actionGet();
            response.put("otherLocalities", otherLocalitiesResponse);
        }
        return response;
    }

    @Override
    public SearchResponse findAllGrievanceBySource(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query, String grouByField) {
        SearchResponse tableResponse = complaintDashBoardRequest.getType().equalsIgnoreCase("allwards") ? (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD, grouByField, 120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD_SOURCE, SOURCE, 30)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)COMPLAINT_RECORD).addField("wardName").addField("cityName").addField(CITY_DISTRICT_NAME).addField(INITIAL_FUNCTIONARY_NAME).addField(INITIAL_FUNCTIONARY_MOBILE_NUMBER).setSize(1)))).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPE_WISE, COMPLAINT_TYPE_NAME, 120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPEWISE_SOURCE, SOURCE, 30))).execute().actionGet() : (complaintDashBoardRequest.getType().equalsIgnoreCase("alllocalities") ? (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)WARDWISE).field("wardNo")).size(120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD, grouByField, 120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD_SOURCE, SOURCE, 30)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)COMPLAINT_RECORD).addField("wardName").addField("cityName").addField(CITY_DISTRICT_NAME).addField(INITIAL_FUNCTIONARY_NAME).addField(INITIAL_FUNCTIONARY_MOBILE_NUMBER).addField(DEPARTMENT_NAME).setSize(1))))).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPE_WISE, COMPLAINT_TYPE_NAME, 120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPEWISE_SOURCE, SOURCE, 30))).execute().actionGet() : (complaintDashBoardRequest.getType().equalsIgnoreCase("allfunctionary") ? (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)DEPARTMENTWISE).field(DEPARTMENT_CODE)).size(120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD, grouByField, 120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD_SOURCE, SOURCE, 30)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)COMPLAINT_RECORD).addField("wardName").addField("cityName").addField(CITY_DISTRICT_NAME).addField(INITIAL_FUNCTIONARY_NAME).addField(INITIAL_FUNCTIONARY_MOBILE_NUMBER).addField(DEPARTMENT_NAME).setSize(1))))).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPE_WISE, COMPLAINT_TYPE_NAME, 120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPEWISE_SOURCE, SOURCE, 30))).execute().actionGet() : (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD, grouByField, 120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD_SOURCE, SOURCE, 30)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)COMPLAINT_RECORD).addField("wardName").addField("cityName").addField(CITY_DISTRICT_NAME).addField(INITIAL_FUNCTIONARY_NAME).addField(INITIAL_FUNCTIONARY_MOBILE_NUMBER).setSize(1))).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPE_WISE, COMPLAINT_TYPE_NAME, 120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_TYPEWISE_SOURCE, SOURCE, 30))).execute().actionGet()));
        return tableResponse;
    }

    @Override
    public String getFunctionryMobileNumber(String functionaryName) {
        SearchResponse response = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setSize(1).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)INITIAL_FUNCTIONARY_NAME, (Object)functionaryName)).execute().actionGet();
        Iterator searchHits = response.getHits().iterator();
        return searchHits.hasNext() ? ((SearchHit)searchHits.next()).getSource().get(INITIAL_FUNCTIONARY_MOBILE_NUMBER).toString() : "";
    }

    @Override
    public SearchResponse findByAllFunctionary(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query) {
        int size = 1000;
        if (complaintDashBoardRequest.getSize() >= 0) {
            size = complaintDashBoardRequest.getSize();
        }
        return (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)DEPARTMENTWISE).field(DEPARTMENT_CODE)).size(size).subAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"functionarywise").field(INITIAL_FUNCTIONARY_NAME)).size(size).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)COMPLAINT_RECORD).addField("cityName").addField("cityCode").addField(CITY_DISTRICT_NAME).addField(DEPARTMENT_NAME).addField(INITIAL_FUNCTIONARY_MOBILE_NUMBER).setSize(1))).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(CLOSED_COMPLAINT_COUNT, IF_CLOSED, 2))).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(RE_OPENED_COMPLAINT_COUNT, RE_OPENED, 2))))).execute().actionGet();
    }

    @Override
    public SearchResponse findByAllUlb(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query) {
        int size = 120;
        if (complaintDashBoardRequest.getSize() >= 0) {
            size = complaintDashBoardRequest.getSize();
        }
        return (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setSize(0).setQuery((QueryBuilder)query).addAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(size).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)COMPLAINT_RECORD).addField("cityCode").addField(CITY_DISTRICT_NAME).addField("cityName").setSize(1))).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithExclusion(GROUP_BY_FIELD_SATISFACTION_AVERAGE, SATISFACTION_INDEX))).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_COUNT, IF_CLOSED, 2))).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_FIELD_WISE_OPEN_AND_CLOSED_COUNT, IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING).field(COMPLAINT_AGEINGDAYS_FROM_DUE)).addRange(ONE_WEEK, 0.0, 8.0).addRange(ONE_MONTH, 8.0, 32.0).addRange(THREE_MONTHS, 32.0, 91.0).addUnboundedFrom(REMAINING_MONTHS, 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING_FOR_HOURS).field(COMPLAINT_AGEING_FROM_DUE)).addRange(TWELVE_HOURS, 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange(ONE_WEEK, 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD_SLA, IF_SLA, 2)))).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(RE_OPENED_COMPLAINT_COUNT, RE_OPENED, 2))).execute().actionGet();
    }

    @Override
    public SearchResponse findBYAllWards(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query) {
        int size = 1000;
        if (complaintDashBoardRequest.getSize() >= 0) {
            size = complaintDashBoardRequest.getSize();
        }
        return (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setSize(0).setQuery((QueryBuilder)query).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)WARDWISE).field("wardNo")).size(size).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)COMPLAINT_RECORD).addField("cityCode").addField(CITY_DISTRICT_NAME).addField("cityName").addField("wardName").setSize(1))).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_COUNT, IF_CLOSED, 2))).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(RE_OPENED_COMPLAINT_COUNT, RE_OPENED, 2)))).execute().actionGet();
    }

    @Override
    public SearchResponse findBYAllLocalities(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query) {
        int size = 1000;
        if (complaintDashBoardRequest.getSize() >= 0) {
            size = complaintDashBoardRequest.getSize();
        }
        return (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setSize(0).setQuery((QueryBuilder)query).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)WARDWISE).field("wardNo")).size(size).subAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"localitywise").field(LOCALITY_NAME)).size(size).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)COMPLAINT_RECORD).addField("cityCode").addField(CITY_DISTRICT_NAME).addField("cityName").addField("wardName").addField(LOCALITY_NAME).setSize(1))).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(COMPLAINT_COUNT, IF_CLOSED, 2)))).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(RE_OPENED_COMPLAINT_COUNT, RE_OPENED, 2)))).addAggregation((AbstractAggregationBuilder)AggregationBuilders.missing((String)NOLOCALITY).field(LOCALITY_NAME).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping("noLocalityComplaintCount", IF_CLOSED, 2))).execute().actionGet();
    }

    @Override
    public List<ComplaintIndex> findAllComplaintsBySource(String fieldName, String paramValue) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchQuery((String)fieldName, (Object)paramValue)).withPageable((Pageable)new PageRequest(0, 5000)).build();
        return this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, ComplaintIndex.class);
    }

    @Override
    public List<ComplaintIndex> findAllComplaintsByField(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query) {
        SortOrder sortOrder = complaintDashBoardRequest.getSortDirection().equals("ASC") ? SortOrder.ASC : SortOrder.DESC;
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)query).withSort((SortBuilder)new FieldSortBuilder(complaintDashBoardRequest.getSortField()).order(sortOrder)).withPageable((Pageable)new PageRequest(0, complaintDashBoardRequest.getSize())).build();
        return this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, ComplaintIndex.class);
    }

    @Override
    public SearchResponse findRatingByGroupByField(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query, String grouByField) {
        SearchResponse tableResponse = complaintDashBoardRequest.getType().equalsIgnoreCase("allwards") ? (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD, grouByField, 120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FUNCTIONARY, INITIAL_FUNCTIONARY_NAME, 1000)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)COMPLAINT_RECORD).addField("wardName").addField("cityName").addField(CITY_DISTRICT_NAME).addField(INITIAL_FUNCTIONARY_NAME).addField(INITIAL_FUNCTIONARY_MOBILE_NUMBER).setSize(1)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(AGGR_CLOSEDCOUNT, IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithExclusion(SATISFACTION_AVERAGE, SATISFACTION_INDEX))))).execute().actionGet() : (complaintDashBoardRequest.getType().equalsIgnoreCase("alllocalities") ? (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)WARDWISE).field("wardNo")).size(120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD, grouByField, 120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FUNCTIONARY, INITIAL_FUNCTIONARY_NAME, 1000)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)COMPLAINT_RECORD).addField("wardName").addField("cityName").addField(CITY_DISTRICT_NAME).addField(INITIAL_FUNCTIONARY_NAME).addField(INITIAL_FUNCTIONARY_MOBILE_NUMBER).addField(DEPARTMENT_NAME).setSize(1)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(AGGR_CLOSEDCOUNT, IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithExclusion(SATISFACTION_AVERAGE, SATISFACTION_INDEX)))))).execute().actionGet() : (complaintDashBoardRequest.getType().equalsIgnoreCase("allfunctionary") ? (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)DEPARTMENTWISE).field(DEPARTMENT_CODE)).size(120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD, grouByField, 120).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FUNCTIONARY, INITIAL_FUNCTIONARY_NAME, 1000)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)COMPLAINT_RECORD).addField("wardName").addField("cityName").addField(CITY_DISTRICT_NAME).addField(INITIAL_FUNCTIONARY_NAME).addField(INITIAL_FUNCTIONARY_MOBILE_NUMBER).addField(DEPARTMENT_NAME).setSize(1)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(AGGR_CLOSEDCOUNT, IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithExclusion(SATISFACTION_AVERAGE, SATISFACTION_INDEX)))))).execute().actionGet() : (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FIELD, grouByField, 30).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(GROUP_BY_FUNCTIONARY, INITIAL_FUNCTIONARY_NAME, 1000)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)COMPLAINT_RECORD).addField(CITY_DISTRICT_NAME).addField("cityCode").addField("cityName").addField("wardName").setSize(1)).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getCountWithGrouping(AGGR_CLOSEDCOUNT, IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)ComplaintIndexAggregationBuilder.getAverageWithExclusion(SATISFACTION_AVERAGE, SATISFACTION_INDEX)))).execute().actionGet()));
        return tableResponse;
    }
}

