/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.elasticsearch.repository;

import org.apache.commons.lang3.StringUtils;
import org.egov.pgr.elasticsearch.entity.contract.ComplaintDashBoardRequest;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.range.RangeBuilder;
import org.elasticsearch.search.aggregations.bucket.range.date.DateRangeBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCountBuilder;

public final class ComplaintIndexAggregationBuilder {
    private static final String INITIAL_FUNCTIONARY_NAME = "initialFunctionaryName";
    private static final String LOCALITY_NAME = "localityName";
    private static final String CITY_CODE = "cityCode";

    private ComplaintIndexAggregationBuilder() {
    }

    public static AggregationBuilder getCountWithGrouping(String aggregationName, String fieldName, int size) {
        return ((TermsBuilder)AggregationBuilders.terms((String)aggregationName).field(fieldName)).size(size);
    }

    public static AggregationBuilder getCountWithGroupingAndOrder(String aggregationName, String fieldName, int size, String sortField, String sortOrder) {
        TermsBuilder aggregation = ((TermsBuilder)AggregationBuilders.terms((String)aggregationName).field(fieldName)).size(size);
        if (StringUtils.isNotBlank((CharSequence)sortField) && StringUtils.isNotEmpty((CharSequence)sortField) && sortField.equalsIgnoreCase("complaintCount")) {
            Boolean order = true;
            if (StringUtils.isNotEmpty((CharSequence)sortOrder) && StringUtils.isNotBlank((CharSequence)sortOrder) && StringUtils.equalsIgnoreCase((CharSequence)sortOrder, (CharSequence)"desc")) {
                order = false;
            }
            aggregation.order(Terms.Order.aggregation((String)"_count", (boolean)order));
        }
        return aggregation;
    }

    public static ValueCountBuilder getCount(String aggregationName, String fieldName) {
        return (ValueCountBuilder)AggregationBuilders.count((String)aggregationName).field(fieldName);
    }

    public static MetricsAggregationBuilder getAverage(String aggregationName, String fieldName) {
        return AggregationBuilders.avg((String)aggregationName).field(fieldName);
    }

    public static AggregationBuilder getCountBetweenSpecifiedDates(String aggregationName, String fieldName, String fromDate, String toDate) {
        return ((DateRangeBuilder)AggregationBuilders.dateRange((String)aggregationName).field(fieldName)).addRange((Object)fromDate, (Object)toDate);
    }

    public static AggregationBuilder getAverageWithFilter(String filterField, int filterValue, String aggregationName, String fieldName) {
        return AggregationBuilders.filter((String)"agg").filter((QueryBuilder)QueryBuilders.termQuery((String)filterField, (int)filterValue)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)aggregationName).field(fieldName));
    }

    public static AggregationBuilder getAverageWithExclusion(String aggregationName, String fieldName) {
        return ((RangeBuilder)AggregationBuilders.range((String)"excludeZero").field("satisfactionIndex")).addUnboundedFrom("exclusionValue", 1.0).subAggregation((AbstractAggregationBuilder)AggregationBuilders.avg((String)aggregationName).field(fieldName));
    }

    public static String getAggregationGroupingField(ComplaintDashBoardRequest complaintDashBoardRequest) {
        String aggregationField = "cityDistrictCode";
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getType())) {
            if (complaintDashBoardRequest.getType().equalsIgnoreCase("region")) {
                aggregationField = "cityRegionName";
            }
            if (complaintDashBoardRequest.getType().equalsIgnoreCase("district")) {
                aggregationField = "cityDistrictCode";
            }
            if (complaintDashBoardRequest.getType().equalsIgnoreCase("ulbGrade")) {
                aggregationField = "cityGrade";
            }
            if (complaintDashBoardRequest.getType().equalsIgnoreCase("ulb")) {
                aggregationField = CITY_CODE;
            }
            if (complaintDashBoardRequest.getType().equalsIgnoreCase("department")) {
                aggregationField = "departmentName";
            }
            if (complaintDashBoardRequest.getType().equalsIgnoreCase("ward")) {
                aggregationField = StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getWardNo()) ? LOCALITY_NAME : "wardName";
            }
            if (complaintDashBoardRequest.getType().equalsIgnoreCase("allulb")) {
                aggregationField = CITY_CODE;
            }
            if (complaintDashBoardRequest.getType().equalsIgnoreCase("allwards")) {
                aggregationField = "wardNo";
            }
            if (complaintDashBoardRequest.getType().equalsIgnoreCase("alllocalities")) {
                aggregationField = LOCALITY_NAME;
            }
            if (complaintDashBoardRequest.getType().equalsIgnoreCase("allfunctionary")) {
                aggregationField = INITIAL_FUNCTIONARY_NAME;
            }
            return aggregationField;
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getDistrictName()) || StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getUlbGrade())) {
            aggregationField = CITY_CODE;
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getUlbCode())) {
            aggregationField = "departmentName";
            if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getType()) && complaintDashBoardRequest.getType().equalsIgnoreCase("ward")) {
                aggregationField = "wardName";
            }
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getUlbCode()) && StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getWardNo())) {
            aggregationField = LOCALITY_NAME;
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getUlbCode()) && StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getDepartmentCode())) {
            aggregationField = INITIAL_FUNCTIONARY_NAME;
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getLocalityName())) {
            aggregationField = INITIAL_FUNCTIONARY_NAME;
        }
        return aggregationField;
    }
}

