/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.config;

import java.util.HashMap;
import javax.sql.DataSource;
import org.egov.infra.config.scheduling.QuartzSchedulerConfiguration;
import org.egov.infra.config.scheduling.SchedulerConfigCondition;
import org.egov.pgr.scheduler.jobs.ComplaintEscalationJob;
import org.egov.pgr.scheduler.jobs.ComplaintIndexingJob;
import org.quartz.Trigger;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.quartz.CronTriggerFactoryBean;
import org.springframework.scheduling.quartz.JobDetailFactoryBean;
import org.springframework.scheduling.quartz.SchedulerFactoryBean;

@Configuration
@Conditional(value={SchedulerConfigCondition.class})
public class GrievanceSchedulerConfiguration
extends QuartzSchedulerConfiguration {
    @Bean(destroyMethod="destroy")
    public SchedulerFactoryBean pgrScheduler(DataSource dataSource) {
        SchedulerFactoryBean pgrScheduler = this.createScheduler(dataSource);
        pgrScheduler.setSchedulerName("pgr-scheduler");
        pgrScheduler.setAutoStartup(true);
        pgrScheduler.setOverwriteExistingJobs(true);
        pgrScheduler.setTriggers(new Trigger[]{this.complaintEscalationCronTrigger().getObject(), this.complaintIndexingCronTrigger().getObject()});
        return pgrScheduler;
    }

    @Bean(value={"complaintEscalationJob"})
    public ComplaintEscalationJob complaintEscalationJob() {
        return new ComplaintEscalationJob();
    }

    @Bean
    public JobDetailFactoryBean complaintEscalationJobDetail() {
        JobDetailFactoryBean escalationJobDetail = new JobDetailFactoryBean();
        escalationJobDetail.setGroup("PGR_JOB_GROUP");
        escalationJobDetail.setName("PGR_ESCALATION_JOB");
        escalationJobDetail.setDurability(true);
        escalationJobDetail.setJobClass(ComplaintEscalationJob.class);
        escalationJobDetail.setRequestsRecovery(true);
        HashMap<String, String> jobDetailMap = new HashMap<String, String>();
        jobDetailMap.put("jobBeanName", "complaintEscalationJob");
        jobDetailMap.put("userName", "system");
        jobDetailMap.put("cityDataRequired", "true");
        jobDetailMap.put("moduleName", "pgr");
        escalationJobDetail.setJobDataAsMap(jobDetailMap);
        return escalationJobDetail;
    }

    @Bean
    public CronTriggerFactoryBean complaintEscalationCronTrigger() {
        CronTriggerFactoryBean escalationCron = new CronTriggerFactoryBean();
        escalationCron.setJobDetail(this.complaintEscalationJobDetail().getObject());
        escalationCron.setGroup("PGR_TRIGGER_GROUP");
        escalationCron.setName("PGR_ESCALATION_TRIGGER");
        escalationCron.setCronExpression("0 */52 * * * ?");
        return escalationCron;
    }

    @Bean(value={"complaintIndexingJob"})
    public ComplaintIndexingJob complaintIndexingJob() {
        return new ComplaintIndexingJob();
    }

    @Bean
    public JobDetailFactoryBean complaintIndexingJobDetail() {
        JobDetailFactoryBean complaintIndexingJobDetail = new JobDetailFactoryBean();
        complaintIndexingJobDetail.setGroup("PGR_JOB_GROUP");
        complaintIndexingJobDetail.setName("PGR_INDEX_JOB");
        complaintIndexingJobDetail.setDurability(true);
        complaintIndexingJobDetail.setJobClass(ComplaintIndexingJob.class);
        complaintIndexingJobDetail.setRequestsRecovery(true);
        HashMap<String, String> jobDetailMap = new HashMap<String, String>();
        jobDetailMap.put("jobBeanName", "complaintIndexingJob");
        jobDetailMap.put("userName", "system");
        jobDetailMap.put("cityDataRequired", "true");
        jobDetailMap.put("moduleName", "pgr");
        complaintIndexingJobDetail.setJobDataAsMap(jobDetailMap);
        return complaintIndexingJobDetail;
    }

    @Bean
    public CronTriggerFactoryBean complaintIndexingCronTrigger() {
        CronTriggerFactoryBean escalationCron = new CronTriggerFactoryBean();
        escalationCron.setJobDetail(this.complaintIndexingJobDetail().getObject());
        escalationCron.setGroup("PGR_TRIGGER_GROUP");
        escalationCron.setName("PGR_INDEX_TRIGGER");
        escalationCron.setCronExpression("0 0 2 * * ?");
        return escalationCron;
    }
}

