/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.pgr.entity.ComplaintType;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Unique(fields={"name"}, enableDfltMsg=true)
@Table(name="egpgr_complainttype_category")
@SequenceGenerator(name="SEQ_EGPGR_COMPLAINTTYPE_CATEGORY", sequenceName="SEQ_EGPGR_COMPLAINTTYPE_CATEGORY", allocationSize=1)
public class ComplaintTypeCategory
extends AbstractPersistable<Long> {
    public static final String SEQ_COMP_TYPE_CATEGORY = "SEQ_EGPGR_COMPLAINTTYPE_CATEGORY";
    private static final long serialVersionUID = 2739365086791183614L;
    @Id
    @GeneratedValue(generator="SEQ_EGPGR_COMPLAINTTYPE_CATEGORY", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @SafeHtml
    @Length(min=5, max=100)
    private String name;
    @SafeHtml
    @Length(max=200)
    private String localName;
    @SafeHtml
    @Length(max=250)
    private String description;
    @OneToMany(mappedBy="category", fetch=FetchType.EAGER)
    @Fetch(value=FetchMode.SUBSELECT)
    @JsonIgnore
    private List<ComplaintType> complaintTypes;

    public Long getId() {
        return this.id;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ComplaintType> getComplaintTypes() {
        return this.complaintTypes;
    }

    public void setComplaintTypes(List<ComplaintType> complaintTypes) {
        this.complaintTypes = complaintTypes;
    }
}

