/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service.reports;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.pgr.entity.dto.RouterEscalationForm;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class RouterEscalationService {
    @PersistenceContext
    private EntityManager entityManager;

    public List<RouterEscalationForm> search(RouterEscalationForm routerEscalationForm) {
        SQLQuery finalQuery = this.prepareQuery(routerEscalationForm);
        finalQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(RouterEscalationForm.class));
        if (routerEscalationForm.getCategory() != null) {
            finalQuery.setParameter("categoryId", (Object)routerEscalationForm.getCategory());
        }
        if (routerEscalationForm.getComplainttype() != null) {
            finalQuery.setParameter("ctnameId", (Object)routerEscalationForm.getComplainttype());
        }
        if (routerEscalationForm.getBoundary() != null) {
            finalQuery.setParameter("bndryId", (Object)routerEscalationForm.getBoundary());
        }
        if (routerEscalationForm.getPosition() != null) {
            finalQuery.setParameter("posId", (Object)routerEscalationForm.getPosition());
        }
        return finalQuery.list();
    }

    private SQLQuery prepareQuery(RouterEscalationForm routerEscalationForm) {
        StringBuilder whereQry = new StringBuilder();
        StringBuilder selectQry = new StringBuilder("select \"ctname\", \"bndryname\", \"routerposname\", \"esclvl1posname\", \"esclvl2posname\", \"esclvl3posname\" from pgr_router_escalation_view where 1=1 ");
        if (routerEscalationForm.getCategory() != null) {
            whereQry = whereQry.append(" and categoryid = :categoryId");
        }
        if (routerEscalationForm.getComplainttype() != null) {
            whereQry = whereQry.append(" and ctid = :ctnameId");
        }
        if (routerEscalationForm.getBoundary() != null) {
            whereQry = whereQry.append(" and bndryid = :bndryId");
        }
        if (routerEscalationForm.getPosition() != null) {
            whereQry = whereQry.append(" and routerpos = :posId");
        }
        return ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(selectQry.append((CharSequence)whereQry).toString());
    }
}

