/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service.reports;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AgeingReportService {
    private static final String COMPLAINTSTATUS_COMPLETED = "Completed";
    private static final String COMPLAINTSTATUS_REJECTED = "Rejected";
    @PersistenceContext
    private EntityManager entityManager;

    public SQLQuery getageingReportQuery(DateTime fromDate, DateTime toDate, String typeofReport, String complaintDateType, String groupBy) {
        StringBuilder query = new StringBuilder();
        if (groupBy != null && !"".equals(groupBy) && groupBy.equalsIgnoreCase("ByBoundary")) {
            query.append("SELECT bndry.name as name, ");
        } else {
            query.append("SELECT dept.name as name, ");
        }
        if (COMPLAINTSTATUS_COMPLETED.equals(typeofReport) || COMPLAINTSTATUS_REJECTED.equals(typeofReport)) {
            query.append(" COUNT(CASE WHEN date_part('day',(cd.createddate - state.createddate)) > :grtthn30 THEN 1 END) grtthn30, ");
            query.append(" COUNT(CASE WHEN date_part('day',(cd.createddate - state.createddate)) BETWEEN :grtthn10 AND :lsthn30 THEN 1 END) btw10to30, ");
            query.append(" COUNT(CASE WHEN date_part('day',(cd.createddate - state.createddate)) BETWEEN :grtthn5 AND :lsthn10 THEN 1 END) btw5to10, ");
            query.append(" COUNT(CASE WHEN date_part('day',(cd.createddate - state.createddate)) BETWEEN :grtthn2 AND :lsthn5 THEN 1 END) btw2to5, ");
            query.append(" COUNT(CASE WHEN date_part('day',(cd.createddate - state.createddate)) BETWEEN :zero AND :lsthn2 THEN 1 END) lsthn2 ");
            query.append(" FROM egpgr_complaintstatus cs  ,egpgr_complainttype ctype, eg_wf_states state, egpgr_complaint cd  ");
        } else {
            query.append(" COUNT(CASE WHEN cd.createddate < :grtthn30 THEN 1 END) grtthn30, ");
            query.append(" COUNT(CASE WHEN cd.createddate BETWEEN :lsthn10 AND :grtthn30 THEN 1 END) btw10to30, ");
            query.append(" COUNT(CASE WHEN cd.createddate BETWEEN :lsthn5 AND  :grtthn10 THEN 1 END) btw5to10, ");
            query.append(" COUNT(CASE WHEN cd.createddate BETWEEN :lsthn2 AND  :grtthn5 THEN 1 END) btw2to5, ");
            query.append(" COUNT(CASE WHEN cd.createddate BETWEEN :lsthn2 AND :currdate THEN 1 END) lsthn2 ");
            query.append(" FROM egpgr_complaintstatus cs  ,egpgr_complainttype ctype ,egpgr_complaint cd  ");
        }
        if ("ByBoundary".equals(groupBy)) {
            query.append("  left JOIN eg_boundary bndry on cd.location =bndry.id ");
        } else {
            query.append("  left JOIN eg_department dept on cd.department =dept.id ");
        }
        this.buildWhereClause(fromDate, toDate, typeofReport, complaintDateType, query);
        if ("ByBoundary".equals(groupBy)) {
            query.append("  group by bndry.name ");
        } else {
            query.append("  group by dept.name ");
        }
        return this.setParameterForAgeingReport(query.toString(), typeofReport, fromDate, toDate, complaintDateType);
    }

    private void buildWhereClause(DateTime fromDate, DateTime toDate, String typeofReport, String complaintDateType, StringBuilder query) {
        if (COMPLAINTSTATUS_COMPLETED.equals(typeofReport)) {
            query.append(" WHERE  cd.state_id=state.id and  cd.status  = cs.id and cd.complainttype= ctype.id  ");
            query.append(" AND cs.name IN ('COMPLETED', 'WITHDRAWN','CLOSED') ");
        } else if (COMPLAINTSTATUS_REJECTED.equals(typeofReport)) {
            query.append(" WHERE  cd.state_id=state.id and  cd.status  = cs.id and cd.complainttype= ctype.id  ");
            query.append(" AND cs.name IN ('REJECTED') ");
        } else {
            query.append(" WHERE cd.status  = cs.id and cd.complainttype= ctype.id  ");
            query.append(" AND cs.name IN ('REGISTERED','FORWARDED', 'PROCESSING','REOPENED') ");
        }
        if (fromDate != null && toDate != null) {
            query.append(" and ( cd.createddate BETWEEN :fromDates and :toDates) ");
        } else if ("lastsevendays".equals(complaintDateType) || "lastthirtydays".equals(complaintDateType) || "lastninetydays".equals(complaintDateType) || fromDate != null) {
            query.append(" and cd.createddate >=   :fromDates ");
        } else if (toDate != null) {
            query.append(" and cd.createddate <=  :toDates ");
        }
    }

    private SQLQuery setParameterForAgeingReport(String querykey, String typeofReport, DateTime fromDate, DateTime toDate, String complaintDateType) {
        SQLQuery qry = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(querykey);
        if (COMPLAINTSTATUS_COMPLETED.equals(typeofReport) || COMPLAINTSTATUS_REJECTED.equals(typeofReport)) {
            qry.setParameter("grtthn30", (Object)30);
            qry.setParameter("lsthn30", (Object)30);
            qry.setParameter("grtthn10", (Object)10.0001);
            qry.setParameter("grtthn5", (Object)5.0001);
            qry.setParameter("lsthn10", (Object)10);
            qry.setParameter("lsthn5", (Object)5);
            qry.setParameter("lsthn2", (Object)2);
            qry.setParameter("grtthn2", (Object)2.0001);
            qry.setParameter("zero", (Object)0);
        } else {
            qry.setParameter("grtthn30", (Object)this.getCurrentDateWithOutTime().minusDays(30).toDate());
            qry.setParameter("grtthn10", (Object)this.getCurrentDateWithOutTime().minusDays(11).toDate());
            qry.setParameter("grtthn5", (Object)this.getCurrentDateWithOutTime().minusDays(6).toDate());
            qry.setParameter("lsthn10", (Object)this.getCurrentDateWithEndOfDayTime().minusDays(10).toDate());
            qry.setParameter("lsthn5", (Object)this.getCurrentDateWithOutTime().minusDays(5).toDate());
            qry.setParameter("lsthn2", (Object)this.getCurrentDateWithOutTime().minusDays(2).toDate());
            qry.setParameter("currdate", (Object)this.getCurrentDateWithEndOfDayTime().toDate());
        }
        if ("lastsevendays".equals(complaintDateType)) {
            qry.setParameter("fromDates", (Object)this.getCurrentDateWithOutTime().minusDays(7).toDate());
        } else if ("lastthirtydays".equals(complaintDateType)) {
            qry.setParameter("fromDates", (Object)this.getCurrentDateWithOutTime().minusDays(30).toDate());
        } else if ("lastninetydays".equals(complaintDateType)) {
            qry.setParameter("fromDates", (Object)this.getCurrentDateWithOutTime().minusDays(90).toDate());
        } else if (fromDate != null && toDate != null) {
            qry.setParameter("fromDates", (Object)this.resetTimeByPassingDate(fromDate));
            qry.setParameter("toDates", (Object)this.getEndOfDayByDate(toDate));
        } else if (fromDate != null) {
            qry.setParameter("fromDates", (Object)this.resetTimeByPassingDate(fromDate));
        } else if (toDate != null) {
            qry.setParameter("toDates", (Object)this.getEndOfDayByDate(toDate));
        }
        return qry;
    }

    private Date getEndOfDayByDate(DateTime fromDate) {
        return fromDate.withTime(23, 59, 59, 999).toDate();
    }

    private Date resetTimeByPassingDate(DateTime fromDate) {
        return fromDate.withTime(0, 0, 0, 0).toDate();
    }

    private DateTime getCurrentDateWithOutTime() {
        return new LocalDateTime().withTime(0, 0, 0, 0).toDateTime();
    }

    private DateTime getCurrentDateWithEndOfDayTime() {
        return new LocalDateTime().withTime(23, 59, 59, 999).toDateTime();
    }
}

