/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.repository.es;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.pgr.entity.es.ComplaintDashBoardRequest;
import org.egov.pgr.entity.es.ComplaintIndex;
import org.egov.pgr.repository.es.ComplaintIndexCustomRepository;
import org.egov.pgr.repository.es.util.ComplaintElasticsearchUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.missing.MissingBuilder;
import org.elasticsearch.search.aggregations.bucket.range.RangeBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;

public class ComplaintIndexRepositoryImpl
implements ComplaintIndexCustomRepository {
    private static final String REMAINING_HOURS = "remainingHours";
    private static final String GROUP_BY_FIELD_AGEING_FOR_HOURS = "groupByFieldAgeingForHours";
    private static final String COMPLAINT_AGEING_FROM_DUE = "complaintAgeingFromDue";
    private static final String HOURWISE_COMPLAINT_TYPE_AGEING = "hourwiseComplaintTypeAgeing";
    private static final String INITIAL_FUNCTIONARY_MOBILE_NUMBER = "initialFunctionaryMobileNumber";
    private static final String DEPARTMENT_CODE = "departmentCode";
    private static final String DEPARTMENTWISE = "departmentwise";
    private static final String CITY_DISTRICT_NAME = "cityDistrictName";
    private static final String WARDWISE = "wardwise";
    private static final String GROUP_BY_FIELD = "groupByField";
    private static final String ULBWISE = "ulbwise";
    private static final String IF_SLA = "ifSLA";
    private static final String IF_CLOSED = "ifClosed";
    private static final String LOCALITY_NAME = "localityName";
    private static final String RE_OPENED = "reOpened";
    private static final String RE_OPENED_COMPLAINT_COUNT = "reOpenedComplaintCount";
    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    @Override
    public Map<String, SearchResponse> findAllGrievanceByFilter(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query, String grouByField) {
        DateTime toDate;
        DateTime fromDate = new DateTime();
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getToDate())) {
            fromDate = new DateTime((Object)complaintDashBoardRequest.getFromDate());
            toDate = fromDate.plusDays(1);
        } else {
            toDate = fromDate.plusDays(1);
        }
        int size = 120;
        if (complaintDashBoardRequest.getSize() >= 0) {
            size = complaintDashBoardRequest.getSize();
        }
        DateTime currentYearFromDate = new DateTime();
        currentYearFromDate = fromDate.getMonthOfYear() < 4 ? currentYearFromDate.minusYears(1).withMonthOfYear(4).dayOfMonth().withMinimumValue() : currentYearFromDate.withMonthOfYear(4).dayOfMonth().withMinimumValue();
        SearchResponse consolidatedResponse = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCount("countAggregation", "crn")).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("closedCount", IF_CLOSED, 2)).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("slaCount", IF_SLA, 2)).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithFilter(IF_CLOSED, 1, "AgeingInWeeks", "complaintAgeingdaysFromDue")).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithExclusion("satisfactionAverage", "satisfactionIndex")).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountBetweenSpecifiedDates("currentYear", "createdDate", currentYearFromDate.toString(formatter), new DateTime().toString(formatter))).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountBetweenSpecifiedDates("todaysComplaintCount", "createdDate", fromDate.toString(formatter), toDate.toString(formatter))).execute().actionGet();
        SearchResponse tableResponse = complaintDashBoardRequest.getType().equalsIgnoreCase("allwards") ? (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGroupingAndOrder("complaintTypeWise", "complaintTypeName", size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithExclusion("complaintTypeSatisfactionAverage", "satisfactionIndex")).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeWiseOpenAndClosedCount", IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)"ComplaintTypeAgeing").field("complaintAgeingdaysFromDue")).addRange("1week", 0.0, 8.0).addRange("1month", 8.0, 32.0).addRange("3months", 32.0, 91.0).addUnboundedFrom("remainingMonths", 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)HOURWISE_COMPLAINT_TYPE_AGEING).field(COMPLAINT_AGEING_FROM_DUE)).addRange("12hours", 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange("1week", 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeSla", IF_SLA, 2)))).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGroupingAndOrder(GROUP_BY_FIELD, grouByField, size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithExclusion("groupByFieldSatisfactionAverage", "satisfactionIndex")).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)"complaintrecord").addField("cityCode").addField(CITY_DISTRICT_NAME).addField("cityName").addField("wardName").setSize(1)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupFieldWiseOpenAndClosedCount", IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)"groupByFieldAgeing").field("complaintAgeingdaysFromDue")).addRange("1week", 0.0, 8.0).addRange("1month", 8.0, 32.0).addRange("3months", 32.0, 91.0).addUnboundedFrom("remainingMonths", 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING_FOR_HOURS).field(COMPLAINT_AGEING_FROM_DUE)).addRange("12hours", 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange("1week", 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupByFieldSla", IF_SLA, 2))))).execute().actionGet() : (complaintDashBoardRequest.getType().equalsIgnoreCase("alllocalities") ? (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGroupingAndOrder("complaintTypeWise", "complaintTypeName", size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithExclusion("complaintTypeSatisfactionAverage", "satisfactionIndex")).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeWiseOpenAndClosedCount", IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)"ComplaintTypeAgeing").field("complaintAgeingdaysFromDue")).addRange("1week", 0.0, 8.0).addRange("1month", 8.0, 32.0).addRange("3months", 32.0, 91.0).addUnboundedFrom("remainingMonths", 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)HOURWISE_COMPLAINT_TYPE_AGEING).field(COMPLAINT_AGEING_FROM_DUE)).addRange("12hours", 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange("1week", 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeSla", IF_SLA, 2)))).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)WARDWISE).field("wardNo")).size(size).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGroupingAndOrder(GROUP_BY_FIELD, grouByField, size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithExclusion("groupByFieldSatisfactionAverage", "satisfactionIndex")).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)"complaintrecord").addField("cityCode").addField(CITY_DISTRICT_NAME).addField("cityName").addField("wardName").addField(LOCALITY_NAME).setSize(1)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupFieldWiseOpenAndClosedCount", IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)"groupByFieldAgeing").field("complaintAgeingdaysFromDue")).addRange("1week", 0.0, 8.0).addRange("1month", 8.0, 32.0).addRange("3months", 32.0, 91.0).addUnboundedFrom("remainingMonths", 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING_FOR_HOURS).field(COMPLAINT_AGEING_FROM_DUE)).addRange("12hours", 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange("1week", 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupByFieldSla", IF_SLA, 2)))))).execute().actionGet() : (complaintDashBoardRequest.getType().equalsIgnoreCase("allfunctionary") ? (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGroupingAndOrder("complaintTypeWise", "complaintTypeName", size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithExclusion("complaintTypeSatisfactionAverage", "satisfactionIndex")).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeWiseOpenAndClosedCount", IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)"ComplaintTypeAgeing").field("complaintAgeingdaysFromDue")).addRange("1week", 0.0, 8.0).addRange("1month", 8.0, 32.0).addRange("3months", 32.0, 91.0).addUnboundedFrom("remainingMonths", 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)HOURWISE_COMPLAINT_TYPE_AGEING).field(COMPLAINT_AGEING_FROM_DUE)).addRange("12hours", 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange("1week", 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeSla", IF_SLA, 2)))).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)DEPARTMENTWISE).field(DEPARTMENT_CODE)).size(size).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGroupingAndOrder(GROUP_BY_FIELD, grouByField, size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithExclusion("groupByFieldSatisfactionAverage", "satisfactionIndex")).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)"complaintrecord").addField("cityCode").addField(CITY_DISTRICT_NAME).addField("cityName").addField("departmentName").addField(INITIAL_FUNCTIONARY_MOBILE_NUMBER).setSize(1)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupFieldWiseOpenAndClosedCount", IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)"groupByFieldAgeing").field("complaintAgeingdaysFromDue")).addRange("1week", 0.0, 8.0).addRange("1month", 8.0, 32.0).addRange("3months", 32.0, 91.0).addUnboundedFrom("remainingMonths", 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING_FOR_HOURS).field(COMPLAINT_AGEING_FROM_DUE)).addRange("12hours", 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange("1week", 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupByFieldSla", IF_SLA, 2)))))).execute().actionGet() : (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGroupingAndOrder("complaintTypeWise", "complaintTypeName", size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithExclusion("complaintTypeSatisfactionAverage", "satisfactionIndex")).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeWiseOpenAndClosedCount", IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)"ComplaintTypeAgeing").field("complaintAgeingdaysFromDue")).addRange("1week", 0.0, 8.0).addRange("1month", 8.0, 32.0).addRange("3months", 32.0, 91.0).addUnboundedFrom("remainingMonths", 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)HOURWISE_COMPLAINT_TYPE_AGEING).field(COMPLAINT_AGEING_FROM_DUE)).addRange("12hours", 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange("1week", 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeSla", IF_SLA, 2)))).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGroupingAndOrder(GROUP_BY_FIELD, grouByField, size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithExclusion("groupByFieldSatisfactionAverage", "satisfactionIndex")).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupFieldWiseOpenAndClosedCount", IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)"groupByFieldAgeing").field("complaintAgeingdaysFromDue")).addRange("1week", 0.0, 8.0).addRange("1month", 8.0, 32.0).addRange("3months", 32.0, 91.0).addUnboundedFrom("remainingMonths", 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING_FOR_HOURS).field(COMPLAINT_AGEING_FROM_DUE)).addRange("12hours", 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange("1week", 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupByFieldSla", IF_SLA, 2)))).execute().actionGet()));
        HashMap<String, SearchResponse> result = new HashMap<String, SearchResponse>();
        if (grouByField.equals(LOCALITY_NAME)) {
            SearchResponse localityMissingResponse = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)((MissingBuilder)AggregationBuilders.missing((String)"nolocality").field(LOCALITY_NAME).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithExclusion("groupByFieldSatisfactionAverage", "satisfactionIndex"))).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupFieldWiseOpenAndClosedCount", IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)"groupByFieldAgeing").field("complaintAgeingdaysFromDue")).addRange("1week", 0.0, 8.0).addRange("1month", 8.0, 32.0).addRange("3months", 32.0, 91.0).addUnboundedFrom("remainingMonths", 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING_FOR_HOURS).field(COMPLAINT_AGEING_FROM_DUE)).addRange("12hours", 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange("1week", 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupByFieldSla", IF_SLA, 2)))).execute().actionGet();
            result.put("noLocality", localityMissingResponse);
        }
        result.put("consolidatedResponse", consolidatedResponse);
        result.put("tableResponse", tableResponse);
        return result;
    }

    @Override
    public String getWardName(String wardNo) {
        SearchResponse response = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setSize(1).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"wardNo", (Object)wardNo)).execute().actionGet();
        Iterator iterator = response.getHits().iterator();
        if (iterator.hasNext()) {
            SearchHit hit = (SearchHit)iterator.next();
            Map fields = hit.getSource();
            return fields.get("wardName").toString();
        }
        return "";
    }

    @Override
    public SearchResponse findAllGrievanceByComplaintType(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query, String grouByField) {
        return (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping(GROUP_BY_FIELD, grouByField, 120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("closedComplaintCount", IF_CLOSED, 2)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping(RE_OPENED_COMPLAINT_COUNT, RE_OPENED, 2))).execute().actionGet();
    }

    @Override
    public SearchResponse findAllGrievanceBySource(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query, String grouByField) {
        SearchResponse tableResponse = complaintDashBoardRequest.getType().equalsIgnoreCase("allwards") ? (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping(GROUP_BY_FIELD, grouByField, 120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupByFieldSource", "source", 30)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)"complaintrecord").addField("wardName").addField("cityName").addField(CITY_DISTRICT_NAME).addField("initialFunctionaryName").addField(INITIAL_FUNCTIONARY_MOBILE_NUMBER).setSize(1)))).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeWise", "complaintTypeName", 120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeWiseSource", "source", 30))).execute().actionGet() : (complaintDashBoardRequest.getType().equalsIgnoreCase("alllocalities") ? (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)WARDWISE).field("wardNo")).size(120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping(GROUP_BY_FIELD, grouByField, 120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupByFieldSource", "source", 30)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)"complaintrecord").addField("wardName").addField("cityName").addField(CITY_DISTRICT_NAME).addField("initialFunctionaryName").addField(INITIAL_FUNCTIONARY_MOBILE_NUMBER).addField("departmentName").setSize(1))))).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeWise", "complaintTypeName", 120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeWiseSource", "source", 30))).execute().actionGet() : (complaintDashBoardRequest.getType().equalsIgnoreCase("allfunctionary") ? (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)DEPARTMENTWISE).field(DEPARTMENT_CODE)).size(120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping(GROUP_BY_FIELD, grouByField, 120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupByFieldSource", "source", 30)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)"complaintrecord").addField("wardName").addField("cityName").addField(CITY_DISTRICT_NAME).addField("initialFunctionaryName").addField(INITIAL_FUNCTIONARY_MOBILE_NUMBER).addField("departmentName").setSize(1))))).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeWise", "complaintTypeName", 120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeWiseSource", "source", 30))).execute().actionGet() : (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping(GROUP_BY_FIELD, grouByField, 120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupByFieldSource", "source", 30)).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)"complaintrecord").addField("wardName").addField("cityName").addField(CITY_DISTRICT_NAME).addField("initialFunctionaryName").addField(INITIAL_FUNCTIONARY_MOBILE_NUMBER).setSize(1))).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeWise", "complaintTypeName", 120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeWiseSource", "source", 30))).execute().actionGet()));
        return tableResponse;
    }

    @Override
    public String getFunctionryMobileNumber(String functionaryName) {
        SearchResponse response = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setSize(1).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"initialFunctionaryName", (Object)functionaryName)).execute().actionGet();
        Iterator iterator = response.getHits().iterator();
        if (iterator.hasNext()) {
            SearchHit hit = (SearchHit)iterator.next();
            Map fields = hit.getSource();
            return fields.get(INITIAL_FUNCTIONARY_MOBILE_NUMBER).toString();
        }
        return "";
    }

    @Override
    public SearchResponse findByAllFunctionary(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query) {
        int size = 1000;
        if (complaintDashBoardRequest.getSize() >= 0) {
            size = complaintDashBoardRequest.getSize();
        }
        return (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)DEPARTMENTWISE).field(DEPARTMENT_CODE)).size(size).subAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"functionarywise").field("initialFunctionaryName")).size(size).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)"complaintrecord").addField("cityName").addField("cityCode").addField(CITY_DISTRICT_NAME).addField("departmentName").addField(INITIAL_FUNCTIONARY_MOBILE_NUMBER).setSize(1))).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("closedComplaintCount", IF_CLOSED, 2))).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping(RE_OPENED_COMPLAINT_COUNT, RE_OPENED, 2))))).execute().actionGet();
    }

    @Override
    public SearchResponse findByAllUlb(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query) {
        int size = 120;
        if (complaintDashBoardRequest.getSize() >= 0) {
            size = complaintDashBoardRequest.getSize();
        }
        return (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setSize(0).setQuery((QueryBuilder)query).addAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(size).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)"complaintrecord").addField("cityCode").addField(CITY_DISTRICT_NAME).addField("cityName").setSize(1))).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithExclusion("groupByFieldSatisfactionAverage", "satisfactionIndex"))).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintCount", IF_CLOSED, 2))).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupFieldWiseOpenAndClosedCount", IF_CLOSED, 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)"groupByFieldAgeing").field("complaintAgeingdaysFromDue")).addRange("1week", 0.0, 8.0).addRange("1month", 8.0, 32.0).addRange("3months", 32.0, 91.0).addUnboundedFrom("remainingMonths", 91.0)).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)GROUP_BY_FIELD_AGEING_FOR_HOURS).field(COMPLAINT_AGEING_FROM_DUE)).addRange("12hours", 0.0, 13.0).addRange("1day", 13.0, 25.0).addRange("1week", 25.0, 169.0).addUnboundedFrom(REMAINING_HOURS, 169.0)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupByFieldSla", IF_SLA, 2)))).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping(RE_OPENED_COMPLAINT_COUNT, RE_OPENED, 2))).execute().actionGet();
    }

    @Override
    public SearchResponse findBYAllWards(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query) {
        int size = 1000;
        if (complaintDashBoardRequest.getSize() >= 0) {
            size = complaintDashBoardRequest.getSize();
        }
        return (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setSize(0).setQuery((QueryBuilder)query).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)WARDWISE).field("wardNo")).size(size).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)"complaintrecord").addField("cityCode").addField(CITY_DISTRICT_NAME).addField("cityName").addField("wardName").setSize(1))).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintCount", IF_CLOSED, 2))).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping(RE_OPENED_COMPLAINT_COUNT, RE_OPENED, 2)))).execute().actionGet();
    }

    @Override
    public SearchResponse findBYAllLocalities(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query) {
        int size = 1000;
        if (complaintDashBoardRequest.getSize() >= 0) {
            size = complaintDashBoardRequest.getSize();
        }
        return (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setSize(0).setQuery((QueryBuilder)query).addAggregation((AbstractAggregationBuilder)((TermsBuilder)AggregationBuilders.terms((String)ULBWISE).field("cityCode")).size(120).subAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)WARDWISE).field("wardNo")).size(size).subAggregation((AbstractAggregationBuilder)((TermsBuilder)((TermsBuilder)AggregationBuilders.terms((String)"localitywise").field(LOCALITY_NAME)).size(size).subAggregation((AbstractAggregationBuilder)AggregationBuilders.topHits((String)"complaintrecord").addField("cityCode").addField(CITY_DISTRICT_NAME).addField("cityName").addField("wardName").addField(LOCALITY_NAME).setSize(1))).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintCount", IF_CLOSED, 2)))).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping(RE_OPENED_COMPLAINT_COUNT, RE_OPENED, 2)))).addAggregation((AbstractAggregationBuilder)AggregationBuilders.missing((String)"nolocality").field(LOCALITY_NAME).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("noLocalityComplaintCount", IF_CLOSED, 2))).execute().actionGet();
    }

    @Override
    public List<ComplaintIndex> findAllComplaintsBySource(String fieldName, String paramValue) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchQuery((String)fieldName, (Object)paramValue)).withPageable((Pageable)new PageRequest(0, 5000)).build();
        return this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, ComplaintIndex.class);
    }

    @Override
    public List<ComplaintIndex> findAllComplaintsByField(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query) {
        SortOrder sortOrder = complaintDashBoardRequest.getSortDirection().equals("ASC") ? SortOrder.ASC : SortOrder.DESC;
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)query).withSort((SortBuilder)new FieldSortBuilder(complaintDashBoardRequest.getSortField()).order(sortOrder)).withPageable((Pageable)new PageRequest(0, complaintDashBoardRequest.getSize())).build();
        return this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, ComplaintIndex.class);
    }
}

