/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.admin.master.service.RoleService;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.pgr.config.properties.PgrApplicationProperties;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.enums.ComplaintStatus;
import org.egov.pgr.repository.ComplaintRepository;
import org.egov.pgr.service.ComplaintCommunicationService;
import org.egov.pgr.service.ComplaintRouterService;
import org.egov.pgr.service.ComplaintStatusService;
import org.egov.pgr.service.EscalationService;
import org.egov.pgr.service.ForwardSkippablePositionService;
import org.egov.pgr.service.PriorityService;
import org.egov.pgr.service.es.ComplaintIndexService;
import org.egov.pgr.utils.constants.PGRConstants;
import org.egov.pims.commons.Position;
import org.egov.portal.entity.PortalInbox;
import org.egov.portal.entity.PortalInboxBuilder;
import org.egov.portal.service.PortalInboxService;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ComplaintService {
    private static final String RE_OPENED = "REOPENED";
    private static final String COMPLAINT_STATUS_NAME = "complaintStatus.name";
    private static final Logger LOG = LoggerFactory.getLogger(ComplaintService.class);
    @Autowired
    private ComplaintRepository complaintRepository;
    @Autowired
    private ComplaintStatusService complaintStatusService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ComplaintRouterService complaintRouterService;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    private EscalationService escalationService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private AssignmentService assignmentService;
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private ComplaintIndexService complaintIndexService;
    @Autowired
    private PgrApplicationProperties pgrApplicationProperties;
    @Autowired
    private PriorityService priorityService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private ForwardSkippablePositionService forwardSkippablePositionService;
    @Autowired
    private ComplaintCommunicationService complaintCommunicationService;
    @Autowired
    private PortalInboxService portalInboxService;

    @Transactional
    public Complaint createComplaint(Complaint complaint) {
        if (org.egov.infra.utils.StringUtils.isBlank((String)complaint.getCrn())) {
            complaint.setCrn(this.applicationNumberGenerator.generate());
        }
        User user = this.securityUtils.getCurrentUser();
        complaint.getComplainant().setUserDetail(user);
        if (!SecurityUtils.isCurrentUserAnonymous() && this.securityUtils.currentUserType().equals((Object)UserType.CITIZEN)) {
            complaint.getComplainant().setEmail(user.getEmailId());
            complaint.getComplainant().setName(user.getName());
            complaint.getComplainant().setMobile(user.getMobileNumber());
        }
        complaint.setStatus(this.complaintStatusService.getByName("REGISTERED"));
        if (complaint.getLocation() == null && complaint.getLat() > 0.0 && complaint.getLng() > 0.0) {
            try {
                Long bndryId = this.boundaryService.getBoundaryIdFromShapefile(Double.valueOf(complaint.getLat()), Double.valueOf(complaint.getLng()));
                if (bndryId == null || bndryId == 0L) {
                    throw new ValidationException("gis.location.info.not.found");
                }
                Boundary location = this.boundaryService.getBoundaryById(bndryId);
                complaint.setLocation(location);
            }
            catch (Exception e) {
                LOG.error("No GIS data found", (Throwable)e);
                throw new ValidationException("gis.location.info.not.found");
            }
        }
        Position assignee = this.complaintRouterService.getAssignee(complaint);
        complaint.transition().start().withSenderName(complaint.getComplainant().getName()).withComments("Grievance registered with Complaint Number : " + complaint.getCrn()).withStateValue(complaint.getStatus().getName()).withOwner(assignee).withDateInfo(new Date());
        complaint.setAssignee(assignee);
        complaint.setEscalationDate(new Date());
        complaint.setEscalationDate(this.escalationService.getExpiryDate(complaint));
        if (null != complaint.getComplaintType() && null != complaint.getComplaintType().getDepartment()) {
            complaint.setDepartment(complaint.getComplaintType().getDepartment());
        } else if (null != assignee) {
            complaint.setDepartment(assignee.getDeptDesig().getDepartment());
        }
        if (complaint.getPriority() == null) {
            complaint.setPriority(this.priorityService.getPriorityByCode(this.pgrApplicationProperties.defaultComplaintPriority()));
        }
        this.complaintRepository.saveAndFlush((Object)complaint);
        if (this.securityUtils.currentUserIsCitizen()) {
            this.pushPortalInboxMessage(complaint);
        }
        this.complaintCommunicationService.sendRegistrationMessage(complaint);
        this.complaintIndexService.createComplaintIndex(complaint);
        return complaint;
    }

    @Transactional
    public Complaint update(Complaint complaint, Long nextOwnerId, String approvalComment, boolean sendToPrevAssignee) {
        Role goRole = this.roleService.getRoleByName("Grievance Officer");
        String userName = this.securityUtils.getCurrentUser().getType().equals((Object)UserType.CITIZEN) ? this.securityUtils.getCurrentUser().getName() : this.securityUtils.getCurrentUser().getUsername() + "::" + this.securityUtils.getCurrentUser().getName();
        if (!complaint.getState().isEnded() && (complaint.getStatus().getName().equalsIgnoreCase(ComplaintStatus.COMPLETED.toString()) || complaint.getStatus().getName().equalsIgnoreCase(ComplaintStatus.WITHDRAWN.toString()) || complaint.getStatus().getName().equalsIgnoreCase(ComplaintStatus.REJECTED.toString()))) {
            complaint.setDepartment(complaint.getAssignee().getDeptDesig().getDepartment());
            LOG.debug("Terminating Grievance Workflow");
            if (!this.securityUtils.getCurrentUser().getRoles().contains(goRole)) {
                complaint.transition().end().withComments(approvalComment).withStateValue(complaint.getStatus().getName()).withSenderName(userName).withDateInfo(new Date());
            } else {
                complaint.transition().end().withComments(approvalComment).withStateValue(complaint.getStatus().getName()).withSenderName(userName).withDateInfo(new Date()).withOwner(complaint.getState().getOwnerPosition());
            }
        } else if (nextOwnerId != null && !nextOwnerId.equals(0L)) {
            Position owner = this.positionMasterService.getPositionById(nextOwnerId);
            complaint.setAssignee(owner);
            complaint.setDepartment(complaint.getAssignee().getDeptDesig().getDepartment());
            complaint.transition().progressWithStateCopy().withOwner(owner).withComments(approvalComment).withSenderName(userName).withStateValue(complaint.getStatus().getName()).withDateInfo(new Date());
        } else if (sendToPrevAssignee && this.canSendToPreviousAssignee(complaint)) {
            Position nextAssignee = complaint.previousAssignee();
            complaint.setDepartment(nextAssignee.getDeptDesig().getDepartment());
            complaint.setAssignee(nextAssignee);
            complaint.transition().progressWithStateCopy().withComments(approvalComment).withSenderName(userName).withStateValue(complaint.getStatus().getName()).withOwner(nextAssignee).withDateInfo(new Date());
        } else {
            complaint.setDepartment(complaint.getAssignee().getDeptDesig().getDepartment());
            complaint.transition().progressWithStateCopy().withComments(approvalComment).withSenderName(userName).withStateValue(complaint.getStatus().getName()).withDateInfo(new Date());
        }
        this.complaintRepository.saveAndFlush((Object)complaint);
        this.complaintIndexService.updateComplaintIndex(complaint, nextOwnerId, approvalComment);
        this.pushUpdatePortalInboxMessage(complaint);
        this.complaintCommunicationService.sendUpdateMessage(complaint);
        return complaint;
    }

    public Complaint getComplaintById(Long complaintID) {
        return (Complaint)((Object)this.complaintRepository.findOne(complaintID));
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public Complaint getComplaintByCRN(String crn) {
        return this.complaintRepository.findByCrn(crn);
    }

    public List<Complaint> getComplaintsEligibleForEscalation() {
        Criteria criteria = this.getCurrentSession().createCriteria(Complaint.class, "complaint").createAlias("complaint.status", "complaintStatus");
        criteria.add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.eq((String)COMPLAINT_STATUS_NAME, (Object)ComplaintStatus.REOPENED.name())).add((Criterion)Restrictions.eq((String)COMPLAINT_STATUS_NAME, (Object)ComplaintStatus.FORWARDED.name())).add((Criterion)Restrictions.eq((String)COMPLAINT_STATUS_NAME, (Object)ComplaintStatus.PROCESSING.name())).add((Criterion)Restrictions.eq((String)COMPLAINT_STATUS_NAME, (Object)ComplaintStatus.REGISTERED.name()))).add((Criterion)Restrictions.lt((String)"complaint.escalationDate", (Object)new DateTime().toDate())).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    private String getHeaderMessage(Complaint savedComplaint) {
        StringBuilder headerMessage = new StringBuilder();
        if ("REGISTERED".equals(savedComplaint.getStatus().getName())) {
            headerMessage.append("Grievance Recorded");
        } else {
            headerMessage.append("Grievance Redressal");
        }
        return headerMessage.toString();
    }

    public List<HashMap<String, Object>> getHistory(Complaint complaint) {
        ArrayList<HashMap<String, Object>> historyTable = new ArrayList<HashMap<String, Object>>();
        State state = complaint.getState();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("date", state.getDateInfo());
        map.put("comments", StringUtils.defaultString((String)state.getComments()));
        map.put("status", state.getValue());
        if ("Complaint is escalated".equals(state.getComments())) {
            map.put("updatedBy", "SYSTEM");
            map.put("status", "ESCALATED");
        } else if (!state.getLastModifiedBy().getType().equals((Object)UserType.EMPLOYEE)) {
            map.put("updatedBy", complaint.getComplainant().getName());
        } else {
            map.put("updatedBy", StringUtils.defaultIfBlank((CharSequence)state.getSenderName(), (CharSequence)(state.getLastModifiedBy().getUsername() + "::" + state.getLastModifiedBy().getName())));
        }
        map.put("updatedUserType", state.getLastModifiedBy().getType());
        Position ownerPosition = state.getOwnerPosition();
        User user = state.getOwnerUser();
        if (user != null) {
            map.put("user", user.getUsername() + "::" + user.getName());
            map.put("usertype", user.getType());
            Department department = this.eisCommonService.getDepartmentForUser(user.getId());
            map.put("department", StringUtils.defaultString((String)department.getName()));
        } else if (ownerPosition != null && ownerPosition.getDeptDesig() != null) {
            List assignmentList = this.assignmentService.getAssignmentsForPosition(ownerPosition.getId(), new Date());
            Optional employee = !assignmentList.isEmpty() ? Optional.ofNullable(((Assignment)assignmentList.get(0)).getEmployee()) : Optional.empty();
            map.put("user", employee.isPresent() ? ((Employee)employee.get()).getUsername() + "::" + ((Employee)employee.get()).getName() + "::" + ownerPosition.getDeptDesig().getDesignation().getName() : "NO ASSIGNMENT" + "::" + ownerPosition.getName());
            map.put("usertype", employee.isPresent() ? ((Employee)employee.get()).getType() : "");
            map.put("department", ownerPosition.getDeptDesig().getDepartment().getName());
        }
        historyTable.add(map);
        complaint.getStateHistory().stream().sorted(Comparator.comparing(StateHistory::getLastModifiedDate).reversed()).forEach(stateHistory -> historyTable.add(this.constructComplaintHistory(complaint, (StateHistory)stateHistory)));
        return historyTable;
    }

    private HashMap<String, Object> constructComplaintHistory(Complaint complaint, StateHistory stateHistory) {
        HashMap<String, Object> complaintHistory = new HashMap<String, Object>();
        complaintHistory.put("date", stateHistory.getDateInfo());
        complaintHistory.put("comments", StringUtils.defaultString((String)stateHistory.getComments()));
        complaintHistory.put("status", stateHistory.getValue());
        if ("Complaint is escalated".equals(stateHistory.getComments())) {
            complaintHistory.put("updatedBy", "SYSTEM");
            complaintHistory.put("status", "ESCALATED");
        } else {
            complaintHistory.put("updatedBy", stateHistory.getLastModifiedBy().getType().equals((Object)UserType.EMPLOYEE) ? stateHistory.getSenderName() : complaint.getComplainant().getName());
        }
        complaintHistory.put("updatedUserType", stateHistory.getLastModifiedBy().getType());
        Position owner = stateHistory.getOwnerPosition();
        User userobj = stateHistory.getOwnerUser();
        if (userobj != null) {
            complaintHistory.put("user", userobj.getUsername() + "::" + userobj.getName());
            complaintHistory.put("usertype", userobj.getType());
            Department department = this.eisCommonService.getDepartmentForUser(userobj.getId());
            complaintHistory.put("department", department != null ? department.getName() : "");
        } else if (owner != null && owner.getDeptDesig() != null) {
            List assignments = this.assignmentService.getAssignmentsForPosition(owner.getId(), new Date());
            complaintHistory.put("user", !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee().getUsername() + "::" + ((Assignment)assignments.get(0)).getEmployee().getName() + "::" + owner.getDeptDesig().getDesignation().getName() : "NO ASSIGNMENT::" + owner.getName());
            complaintHistory.put("usertype", !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee().getType() : "");
            complaintHistory.put("department", owner.getDeptDesig().getDepartment() != null ? owner.getDeptDesig().getDepartment().getName() : "");
        }
        return complaintHistory;
    }

    @ReadOnly
    public Page<Complaint> getLatest(int page, int pageSize) {
        int offset = page - 1;
        return this.complaintRepository.findByLatestComplaint(this.securityUtils.getCurrentUser(), (Pageable)new PageRequest(offset, pageSize));
    }

    @ReadOnly
    public Page<Complaint> getMyComplaint(int page, int pageSize) {
        int offset = page - 1;
        return this.complaintRepository.findByMyComplaint(this.securityUtils.getCurrentUser(), (Pageable)new PageRequest(offset, pageSize));
    }

    @ReadOnly
    public List<Complaint> getNearByComplaint(int page, float lat, float lng, int distance, int pageSize) {
        Long offset = ((long)page - 1L) * (long)pageSize;
        Long limit = (long)pageSize + 1L;
        return this.complaintRepository.findByNearestComplaint(this.securityUtils.getCurrentUser().getId(), Float.valueOf(lat), Float.valueOf(lng), Long.valueOf(distance), limit, offset);
    }

    public String getEmailBody(Complaint complaint) {
        String formattedCreatedDate = new SimpleDateFormat("dd/MM/yyyy HH:mm").format(complaint.getCreatedDate());
        StringBuilder emailBody = new StringBuilder().append(" %0D%0A Grievance Details -  %0D%0A %0D%0A CRN - ").append(complaint.getCrn()).append(" %0D%0A Grievance Type -").append(complaint.getComplaintType().getName());
        if (complaint.getDepartment() != null) {
            emailBody.append("  %0D%0A Grievance department  - ").append(complaint.getDepartment().getName());
        }
        if (complaint.getComplainant().getName() != null) {
            emailBody.append("  %0D%0A Complainant name - ").append(complaint.getComplainant().getName());
        }
        if (complaint.getComplainant().getMobile() != null) {
            emailBody.append("  %0D%0A Complainant mobile number - ").append(complaint.getComplainant().getMobile());
        }
        if (complaint.getLocation() != null) {
            emailBody.append("  %0D%0A Location details - ").append(complaint.getLocation().getName());
        }
        emailBody.append(" %0D%0A Grievance details - ").append(complaint.getDetails()).append(" %0D%0A Grievance status -").append(complaint.getStatus().getName()).append(" %0D%0A Grievance Registration Date - ").append(formattedCreatedDate);
        return emailBody.toString();
    }

    @ReadOnly
    public List<Complaint> getPendingGrievances() {
        User user = this.securityUtils.getCurrentUser();
        Object[] pendingStatus = new String[]{"REGISTERED", "FORWARDED", "PROCESSING", "NOTCOMPLETED", RE_OPENED};
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(Complaint.class, "complaint").createAlias("complaint.state", "state").createAlias("complaint.status", "status");
        criteria.add(Restrictions.in((String)"status.name", (Object[])pendingStatus));
        criteria.add(Restrictions.in((String)"complaint.assignee", (Collection)this.positionMasterService.getPositionsForEmployee(user.getId(), new Date())));
        return criteria.list();
    }

    @ReadOnly
    public Page<Complaint> getMyPendingGrievances(int page, int pageSize) {
        int offset = page - 1;
        return this.complaintRepository.findMyComplaintyByStatus(this.securityUtils.getCurrentUser(), PGRConstants.PENDING_STATUS, (Pageable)new PageRequest(offset, pageSize));
    }

    @ReadOnly
    public Page<Complaint> getMyCompletedGrievances(int page, int pageSize) {
        int offset = page - 1;
        return this.complaintRepository.findMyComplaintyByStatus(this.securityUtils.getCurrentUser(), PGRConstants.COMPLETED_STATUS, (Pageable)new PageRequest(offset, pageSize));
    }

    @ReadOnly
    public Page<Complaint> getMyRejectedGrievances(int page, int pageSize) {
        int offset = page - 1;
        return this.complaintRepository.findMyComplaintyByStatus(this.securityUtils.getCurrentUser(), PGRConstants.REJECTED_STATUS, (Pageable)new PageRequest(offset, pageSize));
    }

    @ReadOnly
    public Map<String, Integer> getMyComplaintsCount() {
        HashMap<String, Integer> complaintsCount = new HashMap<String, Integer>();
        complaintsCount.put("ALL", this.complaintRepository.getMyComplaintsTotalCount(this.securityUtils.getCurrentUser()).intValue());
        complaintsCount.put("PENDING", this.complaintRepository.getMyComplaintCountByStatus(this.securityUtils.getCurrentUser(), PGRConstants.PENDING_STATUS).intValue());
        complaintsCount.put("COMPLETED", this.complaintRepository.getMyComplaintCountByStatus(this.securityUtils.getCurrentUser(), PGRConstants.COMPLETED_STATUS).intValue());
        complaintsCount.put("REJECTED", this.complaintRepository.getMyComplaintCountByStatus(this.securityUtils.getCurrentUser(), PGRConstants.REJECTED_STATUS).intValue());
        return complaintsCount;
    }

    @ReadOnly
    public Map<String, Integer> getComplaintsTotalCount() {
        HashMap<String, Integer> complaintsCount = new HashMap<String, Integer>();
        complaintsCount.put("FILED", this.complaintRepository.getTotalComplaintsCount().intValue());
        complaintsCount.put("RESOLVED", this.complaintRepository.getComplaintsTotalCountByStatus(PGRConstants.RESOLVED_STATUS).intValue());
        complaintsCount.put("UNRESOLVED", this.complaintRepository.getComplaintsTotalCountByStatus(PGRConstants.PENDING_STATUS).intValue());
        return complaintsCount;
    }

    @ReadOnly
    public List<Complaint> getOpenComplaints() {
        List<String> statusList = Arrays.asList("REGISTERED", "FORWARDED", RE_OPENED, "PROCESSING");
        return this.complaintRepository.findByStatusNameIn(statusList);
    }

    public boolean canSendToPreviousAssignee(Complaint complaint) {
        return complaint.hasState() && complaint.previousAssignee() != null && this.forwardSkippablePositionService.isSkippablePosition(complaint.currentAssignee());
    }

    private void pushPortalInboxMessage(Complaint savedComplaint) {
        String link = "/pgr/complaint/update/" + savedComplaint.getCrn();
        Integer slaHours = savedComplaint.getComplaintType().getSlaHours();
        StringBuilder detailedMessage = new StringBuilder();
        detailedMessage.append("Complaint Type : ").append(savedComplaint.getComplaintType().getName());
        if (savedComplaint.getLocation() != null && org.egov.infra.utils.StringUtils.isNotBlank((String)savedComplaint.getLocation().getName())) {
            detailedMessage.append(" in ").append(savedComplaint.getLocation().getName());
        }
        PortalInboxBuilder portalInboxBuilder = new PortalInboxBuilder(this.moduleService.getModuleByName("PGR"), savedComplaint.getStateType(), savedComplaint.getCrn(), savedComplaint.getCrn(), savedComplaint.getId(), this.getHeaderMessage(savedComplaint), detailedMessage.toString(), link, false, savedComplaint.getStatus().getName(), slaHours != null ? DateUtils.addHours((Date)new Date(), (int)slaHours) : null, savedComplaint.getState(), Arrays.asList(this.securityUtils.getCurrentUser()));
        PortalInbox portalInbox = portalInboxBuilder.build();
        this.portalInboxService.pushInboxMessage(portalInbox);
    }

    private void pushUpdatePortalInboxMessage(Complaint savedComplaint) {
        String link = "/pgr/complaint/update/" + savedComplaint.getCrn();
        boolean resolved = false;
        if (savedComplaint.getStatus().getName().equalsIgnoreCase("COMPLETED") || savedComplaint.getStatus().getName().equalsIgnoreCase("REJECTED") || savedComplaint.getStatus().getName().equalsIgnoreCase("WITHDRAWN")) {
            resolved = true;
        }
        this.portalInboxService.updateInboxMessage(savedComplaint.getCrn(), this.moduleService.getModuleByName("PGR").getId(), savedComplaint.getStatus().getName(), Boolean.valueOf(resolved), null, savedComplaint.getState(), savedComplaint.getCreatedBy(), savedComplaint.getCrn(), link);
    }
}

