/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.messaging.MessagingService;
import org.egov.pgr.entity.Complaint;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service
public class ComplaintCommunicationService {
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource complaintMessageSource;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private AssignmentService assignmentService;

    public void sendRegistrationMessage(Complaint complaint) {
        Locale locale = Locale.getDefault();
        if ("REGISTERED".equals(complaint.getStatus().getName())) {
            String smsMsg = this.complaintMessageSource.getMessage("msg.complaint.registered.sms", (Object[])new String[]{complaint.getComplainant().getName(), complaint.getComplaintType().getName(), complaint.getComplaintType().getSlaHours().toString(), ApplicationThreadLocals.getDomainURL(), complaint.getCrn(), ApplicationThreadLocals.getMunicipalityName()}, locale);
            String emailBody = this.complaintMessageSource.getMessage("msg.complaint.registered.email.body", (Object[])new String[]{complaint.getComplainant().getName(), complaint.getComplaintType().getName(), complaint.getComplaintType().getSlaHours().toString(), ApplicationThreadLocals.getDomainURL(), complaint.getCrn(), ApplicationThreadLocals.getMunicipalityName()}, locale);
            String emailSubject = this.complaintMessageSource.getMessage("msg.complaint.registered.email.subject", (Object[])new String[0], locale);
            this.messagingService.sendEmail(complaint.getComplainant().getEmail(), emailSubject, emailBody);
            this.messagingService.sendSMS(complaint.getComplainant().getMobile(), smsMsg);
        }
        this.officialSmsOnRegistration(complaint);
    }

    public void officialSmsOnRegistration(Complaint complaint) {
        Employee user;
        List assignments;
        Locale locale = Locale.getDefault();
        Position owner = complaint.getState().getOwnerPosition();
        if (owner != null && owner.getDeptDesig() != null && !(assignments = this.assignmentService.getAssignmentsForPosition(owner.getId(), new Date())).isEmpty() && (user = ((Assignment)assignments.get(0)).getEmployee()) != null) {
            String smsMsg = this.complaintMessageSource.getMessage("msg.complaint.official.registered.sms", (Object[])new String[]{complaint.getComplaintType().getName(), complaint.getLocation().getName(), complaint.getComplainant().getName(), complaint.getComplainant().getMobile()}, locale);
            this.messagingService.sendSMS(user.getMobileNumber(), smsMsg);
        }
    }

    public void sendUpdateMessage(Complaint complaint) {
        Locale locale = Locale.getDefault();
        if ("COMPLETED".equals(complaint.getStatus().getName())) {
            String smsMsg = this.complaintMessageSource.getMessage("msg.complaint.completed.sms", (Object[])new String[]{complaint.getComplainant().getName(), complaint.getComplaintType().getName(), ApplicationThreadLocals.getDomainURL(), complaint.getCrn(), ApplicationThreadLocals.getMunicipalityName()}, locale);
            String emailBody = this.complaintMessageSource.getMessage("msg.complaint.completed.email.body", (Object[])new String[]{complaint.getComplainant().getName(), complaint.getComplaintType().getName(), ApplicationThreadLocals.getDomainURL(), complaint.getCrn(), ApplicationThreadLocals.getMunicipalityName()}, locale);
            String emailSubject = this.complaintMessageSource.getMessage("msg.complaint.completed.email.subject", (Object[])new String[0], locale);
            this.messagingService.sendEmail(complaint.getComplainant().getEmail(), emailSubject, emailBody);
            this.messagingService.sendSMS(complaint.getComplainant().getMobile(), smsMsg);
        } else if ("REJECTED".equals(complaint.getStatus().getName())) {
            String smsMsg = this.complaintMessageSource.getMessage("msg.complaint.rejected.sms", (Object[])new String[]{complaint.getComplainant().getName(), complaint.getComplaintType().getName(), ApplicationThreadLocals.getDomainURL(), complaint.getCrn(), ApplicationThreadLocals.getMunicipalityName()}, locale);
            String emailBody = this.complaintMessageSource.getMessage("msg.complaint.rejected.email.body", (Object[])new String[]{complaint.getComplainant().getName(), complaint.getComplaintType().getName(), ApplicationThreadLocals.getDomainURL(), complaint.getCrn(), ApplicationThreadLocals.getMunicipalityName()}, locale);
            String emailSubject = this.complaintMessageSource.getMessage("msg.complaint.rejected.email.subject", (Object[])new String[0], locale);
            this.messagingService.sendEmail(complaint.getComplainant().getEmail(), emailSubject, emailBody);
            this.messagingService.sendSMS(complaint.getComplainant().getMobile(), smsMsg);
        } else if ("REOPENED".equals(complaint.getStatus().getName())) {
            String smsMsg = this.complaintMessageSource.getMessage("msg.complaint.reopened.sms", (Object[])new String[]{complaint.getComplainant().getName(), complaint.getComplaintType().getName(), complaint.getComplaintType().getSlaHours().toString(), ApplicationThreadLocals.getDomainURL(), complaint.getCrn(), ApplicationThreadLocals.getMunicipalityName()}, locale);
            String emailBody = this.complaintMessageSource.getMessage("msg.complaint.reopened.email.body", (Object[])new String[]{complaint.getComplainant().getName(), complaint.getComplaintType().getName(), complaint.getComplaintType().getSlaHours().toString(), ApplicationThreadLocals.getDomainURL(), complaint.getCrn(), ApplicationThreadLocals.getMunicipalityName()}, locale);
            String emailSubject = this.complaintMessageSource.getMessage("msg.complaint.reopened.email.subject", (Object[])new String[0], locale);
            this.messagingService.sendEmail(complaint.getComplainant().getEmail(), emailSubject, emailBody);
            this.messagingService.sendSMS(complaint.getComplainant().getMobile(), smsMsg);
        } else if ("WITHDRAWN".equals(complaint.getStatus().getName())) {
            String smsMsg = this.complaintMessageSource.getMessage("msg.complaint.withdrawn.sms", (Object[])new String[]{complaint.getComplainant().getName(), complaint.getComplaintType().getName(), ApplicationThreadLocals.getMunicipalityName()}, locale);
            String emailBody = this.complaintMessageSource.getMessage("msg.complaint.withdrawn.email.body", (Object[])new String[]{complaint.getComplainant().getName(), complaint.getComplaintType().getName(), ApplicationThreadLocals.getMunicipalityName()}, locale);
            String emailSubject = this.complaintMessageSource.getMessage("msg.complaint.withdrawn.email.subject", (Object[])new String[0], locale);
            this.messagingService.sendEmail(complaint.getComplainant().getEmail(), emailSubject, emailBody);
            this.messagingService.sendSMS(complaint.getComplainant().getMobile(), smsMsg);
        }
    }

    public void sendEscalationMessage(Complaint complaint, User nextOwner, Position previousAssignee) {
        Locale locale = Locale.getDefault();
        List prevUserAssignments = this.assignmentService.getAssignmentsForPosition(previousAssignee.getId(), new Date());
        Employee previousOwner = !prevUserAssignments.isEmpty() ? ((Assignment)prevUserAssignments.get(0)).getEmployee() : null;
        String emailSubject = this.complaintMessageSource.getMessage("msg.complaint.escalation.email.subject", (Object[])new String[]{complaint.getComplaintType().getSlaHours().toString()}, locale);
        String previousowner = previousOwner != null ? previousOwner.getName() : previousAssignee.getName();
        String smsMsgnextOwner = this.complaintMessageSource.getMessage("msg.complaint.escalation.sms.nextowner", (Object[])new String[]{complaint.getCrn(), complaint.getComplaintType().getName(), nextOwner.getName(), complaint.getAssignee().getName()}, locale);
        String smsMsgPreviousOwner = this.complaintMessageSource.getMessage("msg.complaint.escalation.sms.previousowner", (Object[])new String[]{complaint.getCrn(), previousowner, previousAssignee.getDeptDesig().getDesignation().getName(), complaint.getComplaintType().getName()}, locale);
        if (previousOwner != null) {
            this.messagingService.sendEmail(previousOwner.getEmailId(), emailSubject, smsMsgPreviousOwner);
            this.messagingService.sendSMS(previousOwner.getMobileNumber(), smsMsgPreviousOwner);
        }
        this.messagingService.sendEmail(nextOwner.getEmailId(), emailSubject, smsMsgnextOwner);
        this.messagingService.sendSMS(nextOwner.getMobileNumber(), smsMsgnextOwner);
    }
}

