/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.entity;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.Pattern;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.persistence.entity.AbstractPersistable;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="egpgr_complainant")
@SequenceGenerator(name="SEQ_EGPGR_COMPLAINANT", sequenceName="SEQ_EGPGR_COMPLAINANT", allocationSize=1)
public class Complainant
extends AbstractPersistable<Long> {
    public static final String SEQ_COMPLAINANT = "SEQ_EGPGR_COMPLAINANT";
    private static final long serialVersionUID = 5691022600220045218L;
    @Id
    @GeneratedValue(generator="SEQ_EGPGR_COMPLAINANT", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Length(max=150)
    @SafeHtml
    private String name;
    @Length(max=20)
    @SafeHtml
    @Pattern(regexp="^((\\+)?(\\d{2}[-]))?(\\d{10}){1}?$")
    private String mobile;
    @Length(max=100)
    @SafeHtml
    @Email(regexp="^[\\w!#$%&'*+/=?`{|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$")
    private String email;
    @ManyToOne
    @JoinColumn(name="userDetail", nullable=true)
    private User userDetail;
    @Length(max=256)
    @SafeHtml
    private String address;

    public Long getId() {
        return this.id;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMobile() {
        return this.mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public User getUserDetail() {
        return this.userDetail;
    }

    public void setUserDetail(User userDetail) {
        this.userDetail = userDetail;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
}

