/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service.dashboard;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.utils.DateUtils;
import org.egov.pgr.repository.dashboard.DashboardRepository;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class DashboardService {
    public static final Map<String, String[]> COLOR_GRADIENTS = new HashMap<String, String[]>();
    private static final DateTimeFormatter DFLT_DATE_FRMTR = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
    @Autowired
    private DashboardRepository dashboardRepository;

    private static Map<String, Integer> constructDatePlaceHolder(DateTime startDate, DateTime endDate, String pattern) {
        LinkedHashMap<String, Integer> currentYearTillDays = new LinkedHashMap<String, Integer>();
        DateTime date = startDate;
        while (date.isBefore((ReadableInstant)endDate)) {
            currentYearTillDays.put(date.toString(pattern), 0);
            date = date.plusDays(1);
        }
        currentYearTillDays.put(endDate.toString(pattern), 0);
        return currentYearTillDays;
    }

    private static List<Map<String, Object>> constructMonthPlaceHolder(DateTime startDate, DateTime endDate, String pattern) {
        LinkedList<Map<String, Object>> dataHolder = new LinkedList<Map<String, Object>>();
        DateTime date = startDate;
        while (date.isBefore((ReadableInstant)endDate) || date.isEqual((ReadableInstant)endDate)) {
            LinkedHashMap<String, Object> currentYearTillDays = new LinkedHashMap<String, Object>();
            currentYearTillDays.put("name", date.toString(pattern));
            currentYearTillDays.put("y", 0.0);
            dataHolder.add(currentYearTillDays);
            date = date.plusMonths(1);
        }
        return dataHolder;
    }

    public static List<Object> constructListOfMonthPlaceHolder(DateTime startDate, DateTime endDate, String pattern) {
        LinkedList<Object> dataHolder = new LinkedList<Object>();
        DateTime date = startDate;
        while (date.isBefore((ReadableInstant)endDate)) {
            dataHolder.add(date.toString(pattern));
            date = date.plusMonths(1);
        }
        return dataHolder;
    }

    private static void sortData(List<Map<String, Object>> dataList, String key) {
        Collections.sort(dataList, (map1, map2) -> Double.valueOf(map1.get(key).toString()).compareTo(Double.valueOf(map2.get(key).toString())));
    }

    private static void assignRank(List<Map<String, Object>> dataList, String key) {
        int counter = 1;
        for (Map<String, Object> map : dataList) {
            map.put(key, counter++);
        }
    }

    public Collection<Integer> getComplaintRegistrationTrend() {
        DateTime currentDate = new DateTime();
        Map<String, Integer> currentYearTillDays = DashboardService.constructDatePlaceHolder(currentDate.minusDays(6), currentDate, "MM-dd");
        for (Object[] compDtl : this.dashboardRepository.fetchComplaintRegistrationTrendBetween(DateUtils.startOfGivenDate((DateTime)currentDate.minusDays(6)).toDate(), DateUtils.endOfGivenDate((DateTime)currentDate).toDate())) {
            currentYearTillDays.put(String.valueOf(compDtl[0]), Integer.valueOf(String.valueOf(compDtl[1])));
        }
        return currentYearTillDays.values();
    }

    public Collection<Integer> getComplaintResolutionTrend() {
        DateTime currentDate = new DateTime();
        Map<String, Integer> currentYearTillDays = DashboardService.constructDatePlaceHolder(currentDate.minusDays(6), currentDate, "MM-dd");
        for (Object[] compDtl : this.dashboardRepository.fetchComplaintResolutionTrendBetween(DateUtils.startOfGivenDate((DateTime)currentDate.minusDays(6)).toDate(), DateUtils.endOfGivenDate((DateTime)currentDate).toDate())) {
            currentYearTillDays.put(String.valueOf(compDtl[1]), Integer.valueOf(String.valueOf(compDtl[0])));
        }
        return currentYearTillDays.values();
    }

    public List<Map<String, Object>> getMonthlyAggregate() {
        DateTime currentDate = new DateTime();
        List<Map<String, Object>> dataHolder = DashboardService.constructMonthPlaceHolder(currentDate.minusMonths(6), currentDate, "MMM-yyyy");
        for (Object[] compCnt : this.dashboardRepository.fetchMonthlyAggregateBetween(DateUtils.startOfGivenDate((DateTime)currentDate.minusMonths(6).withDayOfMonth(1)).toDate(), DateUtils.endOfGivenDate((DateTime)currentDate).toDate())) {
            for (Map<String, Object> mapdata : dataHolder) {
                if (!mapdata.containsValue(StringUtils.capitalize((String)String.valueOf(compCnt[0]).toLowerCase()))) continue;
                mapdata.put("y", Integer.valueOf(String.valueOf(compCnt[1])));
            }
        }
        return dataHolder;
    }

    public List<Map<String, Object>> getCompTypewiseAggregate() {
        DateTime currentDate = new DateTime();
        LinkedList<Map<String, Object>> compTypeWiseData = new LinkedList<Map<String, Object>>();
        long totalOthersCount = 0L;
        int topCount = 1;
        for (Object[] complaint : this.dashboardRepository.fetchComplaintTypeWiseBetween(DateUtils.startOfGivenDate((DateTime)currentDate.minusMonths(6).withDayOfMonth(1)).toDate(), DateUtils.endOfGivenDate((DateTime)currentDate).toDate())) {
            HashMap<String, Object> compTypewiseCnt = new HashMap<String, Object>();
            Integer complaintCount = Integer.valueOf(String.valueOf(complaint[2]));
            if (topCount < 9) {
                compTypewiseCnt.put("name", String.valueOf(complaint[0]));
                compTypewiseCnt.put("ctId", complaint[1]);
                compTypewiseCnt.put("y", complaintCount);
                compTypeWiseData.add(compTypewiseCnt);
                ++topCount;
                continue;
            }
            totalOthersCount += (long)complaintCount.intValue();
        }
        if (totalOthersCount > 0L) {
            HashMap<String, Object> othersData = new HashMap<String, Object>();
            othersData.put("name", "Others");
            othersData.put("ctId", "");
            othersData.put("y", totalOthersCount);
            compTypeWiseData.add(othersData);
        }
        return compTypeWiseData;
    }

    public List<List<Map<String, Object>>> getWardwisePerformance() {
        DateTime currentDate = new DateTime();
        List<Object[]> wardwisePerformanceData = this.dashboardRepository.fetchWardwisePerformanceTill(currentDate);
        LinkedList<List<Map<String, Object>>> datas = new LinkedList<List<Map<String, Object>>>();
        datas.add(this.performanceAnalysis(wardwisePerformanceData, currentDate));
        datas.add(this.performanceProjection(wardwisePerformanceData));
        return datas;
    }

    public List<List<Object>> getAgeingByWard(String wardName) {
        return this.getAgeingData("pgr.wardwise.ageing", wardName);
    }

    private List<Map<String, Object>> performanceProjection(List<Object[]> wardwisePerformanceData) {
        DecimalFormat df = new DecimalFormat("####0.00");
        ArrayList<Map<String, Object>> compAggrData = new ArrayList<Map<String, Object>>();
        for (Object[] compData : wardwisePerformanceData) {
            HashMap<String, Object> complaintData = new HashMap<String, Object>();
            complaintData.put("name", compData[0]);
            BigInteger compData1 = (BigInteger)compData[1];
            BigInteger compData3 = (BigInteger)compData[3];
            BigInteger compData4 = (BigInteger)compData[4];
            double noOfCompAsOnDate = compData1.doubleValue();
            double noOfCompReceivedBtw = compData3.doubleValue();
            double noOfCompPenAsonDate = compData4.doubleValue();
            Double yValue = 100.0 * (noOfCompAsOnDate + noOfCompReceivedBtw - noOfCompPenAsonDate) / (noOfCompAsOnDate + noOfCompReceivedBtw);
            if (yValue.isNaN() || yValue.isInfinite()) {
                complaintData.put("y", BigDecimal.ZERO);
            } else {
                complaintData.put("y", new BigDecimal(df.format(yValue)));
            }
            compAggrData.add(complaintData);
        }
        DashboardService.sortData(compAggrData, "y");
        Collections.reverse(compAggrData);
        return compAggrData;
    }

    public Map<String, Object> topComplaints() {
        DateTime currentDate = new DateTime();
        List<Object> dataHolderNumber = DashboardService.constructListOfMonthPlaceHolder(currentDate.minusMonths(5), currentDate.plusMonths(1), "MM");
        List<Object> dataHolderString = DashboardService.constructListOfMonthPlaceHolder(currentDate.minusMonths(5), currentDate.plusMonths(1), "MMM");
        List<Object[]> topFiveCompTypeData = this.dashboardRepository.fetchTopComplaintsBetween(DateUtils.startOfGivenDate((DateTime)currentDate.minusMonths(5).withDayOfMonth(1)).toDate(), DateUtils.endOfGivenDate((DateTime)currentDate).toDate());
        List<Object[]> topFiveCompTypeCurrentMonth = this.dashboardRepository.fetchTopComplaintsForCurrentMonthBetween(DateUtils.startOfGivenDate((DateTime)currentDate.minusMonths(5).withDayOfMonth(1)).toDate(), DateUtils.endOfGivenDate((DateTime)currentDate).toDate());
        LinkedHashMap<String, BigInteger> constructResultPlaceholder = new LinkedHashMap<String, BigInteger>();
        LinkedHashMap<String, Object> actualdata = new LinkedHashMap<String, Object>();
        for (Object[] objectArray : topFiveCompTypeCurrentMonth) {
            for (Object month : dataHolderNumber) {
                constructResultPlaceholder.put(month + "-" + objectArray, BigInteger.ZERO);
            }
        }
        for (Object[] objectArray : topFiveCompTypeData) {
            actualdata.put(objectArray[0] + "-" + objectArray[2], objectArray[1]);
        }
        LinkedHashMap newdata = new LinkedHashMap();
        for (Object placeholderMapKey : constructResultPlaceholder.keySet()) {
            if (actualdata.get(placeholderMapKey) == null) {
                newdata.put(placeholderMapKey, BigInteger.ZERO);
                continue;
            }
            newdata.put(placeholderMapKey, (BigInteger)actualdata.get(placeholderMapKey));
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        LinkedList dataHolder = new LinkedList();
        ArrayList compCount = new ArrayList();
        Iterator entries = newdata.entrySet().iterator();
        int index = 0;
        while (entries.hasNext()) {
            LinkedHashMap<String, Object> tmpdata = new LinkedHashMap<String, Object>();
            Map.Entry entry = entries.next();
            if (index < 5) {
                compCount.add(entry.getValue());
                ++index;
                continue;
            }
            if (index != 5) continue;
            compCount.add(entry.getValue());
            String[] parts = entry.getKey().toString().split("-");
            tmpdata.put("name", parts[1]);
            tmpdata.put("data", new LinkedList(compCount));
            LinkedHashMap<String, Object> ctypeCountMap = new LinkedHashMap<String, Object>();
            ctypeCountMap.putAll(tmpdata);
            dataHolder.add(ctypeCountMap);
            index = 0;
            compCount.clear();
            tmpdata.clear();
        }
        linkedHashMap.put("year", dataHolderString);
        linkedHashMap.put("series", dataHolder);
        return linkedHashMap;
    }

    private List<List<Object>> getAgeingData(String querykey, String wardName) {
        Object[] compData = this.dashboardRepository.fetchComplaintAgeing(querykey, wardName);
        LinkedList<Object> cntabv90 = new LinkedList<Object>();
        cntabv90.add("&gt; 90 Days");
        cntabv90.add(((BigInteger)compData[0]).intValue());
        LinkedList<Object> cntbtw45to90 = new LinkedList<Object>();
        cntbtw45to90.add("90-45 Days");
        cntbtw45to90.add(((BigInteger)compData[1]).intValue());
        LinkedList<Object> cntbtw15to45 = new LinkedList<Object>();
        cntbtw15to45.add("44-15 Days");
        cntbtw15to45.add(((BigInteger)compData[2]).intValue());
        LinkedList<Object> cntlsthn15 = new LinkedList<Object>();
        cntlsthn15.add("&lt; 15 Days");
        cntlsthn15.add(((BigInteger)compData[3]).intValue());
        LinkedList<List<Object>> dataHolder = new LinkedList<List<Object>>();
        dataHolder.add(cntabv90);
        dataHolder.add(cntbtw45to90);
        dataHolder.add(cntbtw15to45);
        dataHolder.add(cntlsthn15);
        return dataHolder;
    }

    private List<Map<String, Object>> performanceAnalysis(List<Object[]> wardwisePerformanceData, DateTime currentDate) {
        ArrayList<Map<String, Object>> compAggrData = new ArrayList<Map<String, Object>>();
        String formattedFrm = DateUtils.endOfGivenDate((DateTime)currentDate.minusDays(14)).toString(DFLT_DATE_FRMTR);
        String formattedDayAfterFrm = DateUtils.startOfGivenDate((DateTime)currentDate.minusDays(13)).toString(DFLT_DATE_FRMTR);
        String formattedTo = currentDate.toString(DFLT_DATE_FRMTR);
        DecimalFormat df = new DecimalFormat("####0.00");
        for (Object[] compData : wardwisePerformanceData) {
            HashMap<String, Object> complaintData = new HashMap<String, Object>();
            complaintData.put("zone", compData[0]);
            BigInteger compData1 = (BigInteger)compData[1];
            BigInteger compData3 = (BigInteger)compData[3];
            BigInteger compData4 = (BigInteger)compData[4];
            double noOfCompAsOnDate = compData1.doubleValue();
            double noOfCompReceivedBtw = compData3.doubleValue();
            double noOfCompPenAsonDate = compData4.doubleValue();
            complaintData.put("dateAsOn2WeekBack", formattedFrm);
            complaintData.put("noOfCompAsOnDate", noOfCompAsOnDate);
            complaintData.put("dateAsOnDayAfter", formattedDayAfterFrm);
            complaintData.put("noOfCompReceivedBtw", noOfCompReceivedBtw);
            complaintData.put("dateAsOn", formattedTo);
            complaintData.put("noOfCompPenAsonDate", noOfCompPenAsonDate);
            Double disposalPerc = 100.0 * (noOfCompAsOnDate + noOfCompReceivedBtw - noOfCompPenAsonDate) / (noOfCompAsOnDate + noOfCompReceivedBtw);
            if (disposalPerc.isNaN() || disposalPerc.isInfinite()) {
                complaintData.put("disposalPerc", "0.00");
            } else {
                complaintData.put("disposalPerc", df.format(disposalPerc));
            }
            complaintData.put("lat", compData[6]);
            complaintData.put("lng", compData[7]);
            complaintData.put("zoneId", compData[8]);
            compAggrData.add(complaintData);
        }
        DashboardService.sortData(compAggrData, "disposalPerc");
        Collections.reverse(compAggrData);
        DashboardService.assignRank(compAggrData, "rank");
        return compAggrData;
    }

    public List<List<Object>> getComplaintSLA() {
        return this.getAgeingData("pgr.comp.count.sla.breakup", null);
    }

    public List<Map<String, Object>> getOpenComplaintSLA() {
        DateTime startOfTheYear = new LocalDate().minusYears(1).toDateTimeAtStartOfDay();
        DateTime tillDate = new LocalDate().toDateTimeAtCurrentTime();
        List<Object[]> openComplaints = this.dashboardRepository.fetchOpenComplaintAggregateBetween(startOfTheYear, tillDate);
        ArrayList<Map<String, Object>> compAggrData = new ArrayList<Map<String, Object>>();
        HashMap<String, Object> complaintData = new HashMap<String, Object>();
        String lastZone = null;
        double regComplaint = 0.0;
        double openFrm90Days = 0.0;
        double totalOpen = 0.0;
        double pecentage = 0.0;
        Date dateBefore90Days = new LocalDate().minusDays(90).toDateTimeAtStartOfDay().toDate();
        DateTimeFormatter dtf = DateTimeFormat.forPattern((String)"dd/MM/yyyy");
        String formattedFrm = startOfTheYear.toString(dtf);
        String formattedTo = tillDate.toString(dtf);
        for (Object[] compData : openComplaints) {
            String statusName = String.valueOf(compData[4]);
            long count = Long.parseLong(String.valueOf(compData[5]));
            if ("REGISTERED FORWARDED PROCESSING REOPENED".contains(statusName)) {
                if (((Date)compData[6]).before(dateBefore90Days)) {
                    openFrm90Days += (double)count;
                }
                totalOpen += (double)count;
            }
            regComplaint += (double)count;
            complaintData.put("lat", compData[3]);
            complaintData.put("lng", compData[2]);
            complaintData.put("startDt", formattedFrm);
            complaintData.put("endDt", formattedTo);
            complaintData.put("zoneID", compData[1]);
            String currentZone = String.valueOf(compData[0]);
            if (openComplaints.size() == 1 || lastZone != null && !currentZone.equals(lastZone)) {
                pecentage = Math.round(100.0 * (totalOpen / regComplaint));
                complaintData.put("pecentage", pecentage);
                complaintData.put("regComp", regComplaint);
                complaintData.put("open90Comp", openFrm90Days);
                complaintData.put("openComp", totalOpen);
                complaintData.put("zone", lastZone);
                compAggrData.add(new HashMap(complaintData));
                pecentage = 0.0;
                regComplaint = 0.0;
                totalOpen = 0.0;
                openFrm90Days = 0.0;
            }
            lastZone = currentZone;
        }
        DashboardService.sortData(compAggrData, "open90Comp");
        return compAggrData;
    }

    public List<Map<String, Object>> getWardwiseComplaintByComplaintType(Long complaintTypeId, String currentChartColor) {
        DateTime currentDate = new DateTime();
        LinkedList<Map<String, Object>> wardWiseData = new LinkedList<Map<String, Object>>();
        double topCount = -1.0;
        for (Object[] complaint : this.dashboardRepository.fetchComplaintsByComplaintTypeGroupByWard(complaintTypeId, DateUtils.startOfGivenDate((DateTime)currentDate.minusMonths(6).withDayOfMonth(1).withTimeAtStartOfDay()), DateUtils.endOfGivenDate((DateTime)currentDate))) {
            HashMap<String, Object> wardwiseCnt = new HashMap<String, Object>();
            wardwiseCnt.put("wardName", String.valueOf(complaint[0]));
            wardwiseCnt.put("wardId", ((BigInteger)complaint[1]).intValue());
            double count = ((BigInteger)complaint[2]).doubleValue();
            wardwiseCnt.put("count", count);
            if (topCount == -1.0) {
                topCount = count;
            }
            double perc = count * 100.0 / topCount;
            String[] colors = COLOR_GRADIENTS.get(currentChartColor);
            if (perc <= 20.0) {
                wardwiseCnt.put("color", colors[4]);
            } else if (perc > 20.0 && perc <= 40.0) {
                wardwiseCnt.put("color", colors[3]);
            } else if (perc > 40.0 && perc <= 60.0) {
                wardwiseCnt.put("color", colors[2]);
            } else if (perc > 60.0 && perc <= 80.0) {
                wardwiseCnt.put("color", colors[1]);
            } else {
                wardwiseCnt.put("color", colors[0]);
            }
            wardWiseData.add(wardwiseCnt);
        }
        return wardWiseData;
    }

    public Map<String, List<Map<String, Object>>> getGISWardWiseAnalysis() {
        HashMap<String, List<Map<String, Object>>> gisAnalysisData = new HashMap<String, List<Map<String, Object>>>();
        gisAnalysisData.put("registered", this.getGISRegCompWardWise());
        return gisAnalysisData;
    }

    public List<Map<String, Object>> getGISCompPerPropertyWardWise() {
        List<Object[]> compCount = this.dashboardRepository.fetchGISCompPerPropertyWardWise();
        LinkedList<Map<String, Object>> wardWiseData = new LinkedList<Map<String, Object>>();
        double topCount = -1.0;
        for (Object[] wardData : compCount) {
            HashMap<String, Object> wardwiseCompPerProp = new HashMap<String, Object>();
            wardwiseCompPerProp.put("wardName", String.valueOf(wardData[0]));
            wardwiseCompPerProp.put("wardId", ((BigDecimal)wardData[1]).intValue());
            double count = ((BigDecimal)wardData[2]).doubleValue();
            wardwiseCompPerProp.put("count", count);
            if (topCount == -1.0) {
                topCount = count;
            }
            double perc = count * 100.0 / topCount;
            String[] colors = COLOR_GRADIENTS.get("#B15D16");
            if (perc <= 20.0) {
                wardwiseCompPerProp.put("color", colors[4]);
            } else if (perc > 20.0 && perc <= 40.0) {
                wardwiseCompPerProp.put("color", colors[3]);
            } else if (perc > 40.0 && perc <= 60.0) {
                wardwiseCompPerProp.put("color", colors[2]);
            } else if (perc > 60.0 && perc <= 80.0) {
                wardwiseCompPerProp.put("color", colors[1]);
            } else {
                wardwiseCompPerProp.put("color", colors[0]);
            }
            wardWiseData.add(wardwiseCompPerProp);
        }
        return wardWiseData;
    }

    public List<Map<String, Object>> getGISCompRedressedWardWise() {
        List<Object[]> compRedrsdCount = this.dashboardRepository.fetchGISCompRedressedWardWise();
        LinkedList<Map<String, Object>> wardWiseData = new LinkedList<Map<String, Object>>();
        double topCount = -1.0;
        for (Object[] wardData : compRedrsdCount) {
            HashMap<String, Object> wardwiseCompRedressed = new HashMap<String, Object>();
            wardwiseCompRedressed.put("wardName", String.valueOf(wardData[0]));
            wardwiseCompRedressed.put("wardId", ((BigDecimal)wardData[1]).intValue());
            double count = ((BigDecimal)wardData[2]).doubleValue();
            wardwiseCompRedressed.put("count", count);
            if (topCount == -1.0) {
                topCount = count;
            }
            double perc = count * 100.0 / topCount;
            String[] colors = COLOR_GRADIENTS.get("#4F54B8");
            if (perc <= 20.0) {
                wardwiseCompRedressed.put("color", colors[4]);
            } else if (perc > 20.0 && perc <= 40.0) {
                wardwiseCompRedressed.put("color", colors[3]);
            } else if (perc > 40.0 && perc <= 60.0) {
                wardwiseCompRedressed.put("color", colors[2]);
            } else if (perc > 60.0 && perc <= 80.0) {
                wardwiseCompRedressed.put("color", colors[1]);
            } else {
                wardwiseCompRedressed.put("color", colors[0]);
            }
            wardWiseData.add(wardwiseCompRedressed);
        }
        return wardWiseData;
    }

    public List<Map<String, Object>> getGISRegCompWardWise() {
        List<Object[]> compCount = this.dashboardRepository.fetchGISRegCompWardWise();
        LinkedList<Map<String, Object>> wardWiseData = new LinkedList<Map<String, Object>>();
        double topCount = -1.0;
        for (Object[] wardData : compCount) {
            HashMap<String, Object> wardwiseCnt = new HashMap<String, Object>();
            wardwiseCnt.put("wardName", String.valueOf(wardData[0]));
            wardwiseCnt.put("wardId", ((BigInteger)wardData[1]).intValue());
            double count = ((BigInteger)wardData[2]).doubleValue();
            wardwiseCnt.put("count", count);
            if (topCount == -1.0) {
                topCount = count;
            }
            double perc = count * 100.0 / topCount;
            String[] colors = COLOR_GRADIENTS.get("#C00000");
            if (perc <= 20.0) {
                wardwiseCnt.put("color", colors[4]);
            } else if (perc > 20.0 && perc <= 40.0) {
                wardwiseCnt.put("color", colors[3]);
            } else if (perc > 40.0 && perc <= 60.0) {
                wardwiseCnt.put("color", colors[2]);
            } else if (perc > 60.0 && perc <= 80.0) {
                wardwiseCnt.put("color", colors[1]);
            } else {
                wardwiseCnt.put("color", colors[0]);
            }
            wardWiseData.add(wardwiseCnt);
        }
        return wardWiseData;
    }

    static {
        COLOR_GRADIENTS.put("#5B94CB", new String[]{"#00285F", "#1D568D", "#4B84BB", "#79B2E9", "#A7E0FF"});
        COLOR_GRADIENTS.put("#938250", new String[]{"#584e30", "#665b38", "#756840", "#847548", "#9d8e61"});
        COLOR_GRADIENTS.put("#f9f107", new String[]{"#BBB300", "#E9E100", "#FFFF25", "#FFFF53", "#FFFF79"});
        COLOR_GRADIENTS.put("#6AC657", new String[]{"#005A00", "#0E6A00", "#2C8819", "#5AB647", "#88E475"});
        COLOR_GRADIENTS.put("#4F54B8", new String[]{"#00004C", "#11167A", "#3F44A8", "#6D72D6", "#9BA0FF"});
        COLOR_GRADIENTS.put("#B15D16", new String[]{"#450000", "#731F00", "#A14D06", "#CF7B34", "#FDA962"});
        COLOR_GRADIENTS.put("#C00000", new String[]{"#540000", "#B00000", "#DE1E1E", "#FF4C4C", "#FF5454"});
    }
}

