/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.ComplaintRouter;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.repository.ComplaintRouterRepository;
import org.egov.pims.commons.Position;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ComplaintRouterService {
    private final ComplaintRouterRepository complaintRouterRepository;
    private final BoundaryService boundaryService;

    @Autowired
    public ComplaintRouterService(ComplaintRouterRepository complaintRouterRepository, BoundaryService boundaryService) {
        this.complaintRouterRepository = complaintRouterRepository;
        this.boundaryService = boundaryService;
    }

    public Position getAssignee(Complaint complaint) {
        Position position = null;
        ComplaintRouter complaintRouter = null;
        ArrayList<Boundary> boundaries = new ArrayList<Boundary>();
        if (null != complaint.getLocation()) {
            this.getParentBoundaries(complaint.getLocation().getId(), boundaries);
            if (null != complaint.getComplaintType()) {
                for (Boundary bndry : boundaries) {
                    complaintRouter = this.complaintRouterRepository.findByComplaintTypeAndBoundary(complaint.getComplaintType(), bndry);
                    if (null == complaintRouter) continue;
                    break;
                }
                if (null == complaintRouter) {
                    complaintRouter = this.complaintRouterRepository.findByOnlyComplaintType(complaint.getComplaintType());
                }
                if (null == complaintRouter) {
                    Boundary bndry;
                    Iterator iterator = boundaries.iterator();
                    while (iterator.hasNext() && null == (complaintRouter = this.complaintRouterRepository.findByOnlyBoundary(bndry = (Boundary)iterator.next()))) {
                    }
                }
            }
        } else {
            complaintRouter = this.complaintRouterRepository.findByOnlyComplaintType(complaint.getComplaintType());
            if (null == complaintRouter) {
                complaintRouter = this.complaintRouterRepository.findCityAdminGrievanceOfficer("ADMINISTRATION");
            }
        }
        if (complaintRouter == null) {
            throw new ApplicationRuntimeException("PGR.001");
        }
        position = complaintRouter.getPosition();
        return position;
    }

    @Transactional
    public ComplaintRouter createComplaintRouter(ComplaintRouter complaintRouter) {
        return (ComplaintRouter)((Object)this.complaintRouterRepository.save((Object)complaintRouter));
    }

    @Transactional
    public ComplaintRouter updateComplaintRouter(ComplaintRouter complaintRouter) {
        return (ComplaintRouter)((Object)this.complaintRouterRepository.save((Object)complaintRouter));
    }

    @Transactional
    public void deleteComplaintRouter(ComplaintRouter complaintRouter) {
        this.complaintRouterRepository.delete((Object)complaintRouter);
    }

    public Boolean validateRouter(ComplaintRouter complaintRouter) {
        Boolean exist = false;
        ComplaintRouter queryResult = null;
        if (null != complaintRouter.getComplaintType() && null != complaintRouter.getBoundary()) {
            queryResult = this.complaintRouterRepository.findByComplaintTypeAndBoundary(complaintRouter.getComplaintType(), complaintRouter.getBoundary());
        }
        if (null != complaintRouter.getBoundary() && null == complaintRouter.getComplaintType()) {
            queryResult = this.complaintRouterRepository.findByOnlyBoundary(complaintRouter.getBoundary());
        }
        if (null != complaintRouter.getComplaintType() && null == complaintRouter.getBoundary()) {
            queryResult = this.complaintRouterRepository.findByOnlyComplaintType(complaintRouter.getComplaintType());
        }
        if (queryResult != null) {
            exist = true;
        }
        return exist;
    }

    public ComplaintRouter getExistingRouter(ComplaintRouter complaintRouter) {
        ComplaintRouter router = null;
        if (null != complaintRouter.getComplaintType() && null != complaintRouter.getBoundary()) {
            router = this.complaintRouterRepository.findByComplaintTypeAndBoundary(complaintRouter.getComplaintType(), complaintRouter.getBoundary());
        }
        if (null != complaintRouter.getBoundary() && null == complaintRouter.getComplaintType()) {
            router = this.complaintRouterRepository.findByOnlyBoundary(complaintRouter.getBoundary());
        }
        if (null != complaintRouter.getComplaintType() && null == complaintRouter.getBoundary()) {
            router = this.complaintRouterRepository.findByOnlyComplaintType(complaintRouter.getComplaintType());
        }
        return router != null ? router : null;
    }

    public ComplaintRouter getRouterById(Long id) {
        return (ComplaintRouter)((Object)this.complaintRouterRepository.findOne(id));
    }

    public List<ComplaintRouter> getPageOfRouters(Long boundaryTypeId, Long complaintTypeId, Long boundaryId) {
        if (boundaryId != 0L && complaintTypeId != 0L && boundaryTypeId != 0L) {
            return this.complaintRouterRepository.findRoutersByComplaintTypeAndBoundaryTypeAndBoundary(complaintTypeId, boundaryTypeId, boundaryId);
        }
        if (boundaryTypeId != 0L && boundaryId == 0L && complaintTypeId != 0L) {
            return this.complaintRouterRepository.findRoutersByComplaintTypeAndBoundaryType(complaintTypeId, boundaryTypeId);
        }
        if (boundaryTypeId != 0L && boundaryId != 0L && complaintTypeId == 0L) {
            return this.complaintRouterRepository.findRoutersByBoundaryAndBoundaryType(boundaryTypeId, boundaryId);
        }
        if (boundaryTypeId != 0L && boundaryId == 0L && complaintTypeId == 0L) {
            return this.complaintRouterRepository.findRoutersByBoundaryType(boundaryTypeId);
        }
        if (boundaryTypeId == 0L && boundaryId == 0L && complaintTypeId != 0L) {
            return this.complaintRouterRepository.findRoutersByComplaintType(complaintTypeId);
        }
        return this.complaintRouterRepository.findRoutersByAll();
    }

    public List<ComplaintRouter> getPageOfRouters(Long complaintTypeId, Long boundaryTypeId, Long boundaryId, Long positionId) {
        if (complaintTypeId != 0L) {
            if (boundaryId != 0L && boundaryTypeId != 0L && positionId != 0L) {
                return this.complaintRouterRepository.findRoutersByComplaintTypeAndBoundaryTypeAndBoundaryAndPosition(complaintTypeId, boundaryTypeId, boundaryId, positionId);
            }
            if (boundaryId == 0L && boundaryTypeId != 0L && positionId != 0L) {
                return this.complaintRouterRepository.findRoutersByComplaintTypeAndBoundaryTypeAndPosition(complaintTypeId, boundaryTypeId, positionId);
            }
            if (boundaryId == 0L && boundaryTypeId == 0L && positionId != 0L) {
                return this.complaintRouterRepository.findRoutersByComplaintTypeAndPosition(complaintTypeId, positionId);
            }
            if (boundaryId == 0L && boundaryTypeId == 0L && positionId == 0L) {
                return this.complaintRouterRepository.findRoutersByComplaintType(complaintTypeId);
            }
            if (boundaryId != 0L && boundaryTypeId == 0L && positionId != 0L) {
                return this.complaintRouterRepository.findRoutersByComplaintTypeAndBoundaryAndPosition(complaintTypeId, boundaryId, positionId);
            }
            if (boundaryId != 0L && boundaryTypeId == 0L && positionId == 0L) {
                return this.complaintRouterRepository.findRoutersByComplaintTypeAndBoundary(complaintTypeId, boundaryId);
            }
            if (boundaryId != 0L && boundaryTypeId != 0L && positionId == 0L) {
                return this.complaintRouterRepository.findRoutersByComplaintTypeAndBoundaryTypeAndBoundary(complaintTypeId, boundaryTypeId, boundaryId);
            }
            if (boundaryId == 0L && boundaryTypeId != 0L && positionId == 0L) {
                return this.complaintRouterRepository.findRoutersByComplaintTypeAndBoundaryType(complaintTypeId, boundaryTypeId);
            }
        } else {
            if (boundaryId != 0L && boundaryTypeId != 0L && positionId != 0L) {
                return this.complaintRouterRepository.findRoutersByBoundaryTypeAndBoundaryAndPosition(boundaryTypeId, boundaryId, positionId);
            }
            if (boundaryId == 0L && boundaryTypeId != 0L && positionId != 0L) {
                return this.complaintRouterRepository.findRoutersByBoundaryTypeAndPosition(boundaryTypeId, positionId);
            }
            if (boundaryId == 0L && boundaryTypeId == 0L && positionId != 0L) {
                return this.complaintRouterRepository.findRoutersByPosition(positionId);
            }
            if (boundaryId != 0L && boundaryTypeId == 0L && positionId != 0L) {
                return this.complaintRouterRepository.findRoutersByBoundaryAndPosition(boundaryId, positionId);
            }
            if (boundaryId != 0L && boundaryTypeId == 0L && positionId == 0L) {
                return this.complaintRouterRepository.findRoutersByBoundary(boundaryId);
            }
            if (boundaryId != 0L && boundaryTypeId != 0L && positionId == 0L) {
                return this.complaintRouterRepository.findRoutersByBoundaryTypeAndBoundary(boundaryTypeId, boundaryId);
            }
            if (boundaryId == 0L && boundaryTypeId != 0L && positionId == 0L) {
                return this.complaintRouterRepository.findRoutersByBoundaryType(boundaryTypeId);
            }
            if (boundaryId == 0L && boundaryTypeId == 0L && positionId == 0L) {
                return this.complaintRouterRepository.findRoutersByAll();
            }
        }
        return null;
    }

    public void getParentBoundaries(Long bndryId, List<Boundary> boundaryList) {
        Boundary bndry = this.boundaryService.getBoundaryById(bndryId);
        if (bndry != null) {
            boundaryList.add(bndry);
            if (bndry.getParent() != null) {
                this.getParentBoundaries(bndry.getParent().getId(), boundaryList);
            }
        }
    }

    public List<ComplaintRouter> getRoutersByComplaintTypeBoundary(List<ComplaintType> complaintTypes, List<Boundary> boundaries) {
        return this.complaintRouterRepository.findRoutersByComplaintTypesBoundaries(complaintTypes, boundaries);
    }
}

