/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.entity;

import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.contract.StateInfoBuilder;
import org.egov.pgr.entity.Complainant;
import org.egov.pgr.entity.ComplaintStatus;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.Priority;
import org.egov.pgr.entity.ReceivingCenter;
import org.egov.pgr.entity.ReceivingMode;
import org.egov.pgr.entity.enums.CitizenFeedback;
import org.egov.pims.commons.Position;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="egpgr_complaint")
@SequenceGenerator(name="SEQ_EGPGR_COMPLAINT", sequenceName="SEQ_EGPGR_COMPLAINT", allocationSize=1)
@Unique(fields={"crn"}, enableDfltMsg=true)
public class Complaint
extends StateAware {
    public static final String SEQ_COMPLAINT = "SEQ_EGPGR_COMPLAINT";
    private static final long serialVersionUID = 4020616083055647372L;
    @Id
    @GeneratedValue(generator="SEQ_EGPGR_COMPLAINT", strategy=GenerationType.SEQUENCE)
    private Long id;
    @Column(name="crn", unique=true)
    @Length(max=32)
    @SafeHtml
    private String crn = "";
    @ManyToOne
    @NotNull
    @JoinColumn(name="complaintType", nullable=false)
    private ComplaintType complaintType;
    @ManyToOne(cascade={CascadeType.ALL})
    @Valid
    @NotNull
    @JoinColumn(name="complainant", nullable=false)
    private Complainant complainant = new Complainant();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="assignee")
    private Position assignee;
    @ManyToOne
    @JoinColumn(name="location")
    private Boundary location;
    @ManyToOne
    @NotNull
    @JoinColumn(name="status")
    private ComplaintStatus status = new ComplaintStatus();
    @Length(min=10, max=500)
    @SafeHtml
    private String details;
    @Length(max=200)
    @SafeHtml
    private String landmarkDetails;
    @ManyToOne
    @JoinColumn(name="receivingMode")
    @NotNull
    private ReceivingMode receivingMode;
    @ManyToOne
    @JoinColumn(name="priority")
    private Priority priority;
    @ManyToOne
    @JoinColumn(name="receivingCenter")
    private ReceivingCenter receivingCenter;
    @OneToMany(fetch=FetchType.LAZY, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinTable(name="egpgr_supportdocs", joinColumns={@JoinColumn(name="complaintid")}, inverseJoinColumns={@JoinColumn(name="filestoreid")})
    private Set<FileStoreMapper> supportDocs = Collections.emptySet();
    private double lng;
    private double lat;
    @Column(name="escalation_date", nullable=false)
    private Date escalationDate;
    @ManyToOne
    @JoinColumn(name="department", nullable=false)
    private Department department;
    @Enumerated(value=EnumType.ORDINAL)
    private CitizenFeedback citizenFeedback;
    @ManyToOne
    @JoinColumn(name="childLocation", nullable=true)
    private Boundary childLocation;
    @Transient
    private String latlngAddress;
    @Transient
    private Long crossHierarchyId;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCrn() {
        return this.crn;
    }

    public void setCrn(String crn) {
        this.crn = crn;
    }

    public ComplaintType getComplaintType() {
        return this.complaintType;
    }

    public void setComplaintType(ComplaintType complaintType) {
        this.complaintType = complaintType;
    }

    public Complainant getComplainant() {
        return this.complainant;
    }

    public void setComplainant(Complainant complainant) {
        this.complainant = complainant;
    }

    public Position getAssignee() {
        return this.assignee;
    }

    public void setAssignee(Position assignee) {
        this.assignee = assignee;
    }

    public ComplaintStatus getStatus() {
        return this.status;
    }

    public void setStatus(ComplaintStatus status) {
        this.status = status;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public ReceivingMode getReceivingMode() {
        return this.receivingMode;
    }

    public void setReceivingMode(ReceivingMode receivingMode) {
        this.receivingMode = receivingMode;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.priority = priority;
    }

    public ReceivingCenter getReceivingCenter() {
        return this.receivingCenter;
    }

    public void setReceivingCenter(ReceivingCenter receivingCenter) {
        this.receivingCenter = receivingCenter;
    }

    public Set<FileStoreMapper> getSupportDocs() {
        return this.supportDocs;
    }

    public void setSupportDocs(Set<FileStoreMapper> supportDocs) {
        this.supportDocs = supportDocs;
    }

    public Boundary getLocation() {
        return this.location;
    }

    public void setLocation(Boundary location) {
        this.location = location;
    }

    public String getLandmarkDetails() {
        return this.landmarkDetails;
    }

    public void setLandmarkDetails(String landmarkDetails) {
        this.landmarkDetails = landmarkDetails;
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public double getLng() {
        return this.lng;
    }

    public void setLng(double lng) {
        this.lng = lng;
    }

    public Date getEscalationDate() {
        return null == this.escalationDate ? null : this.escalationDate;
    }

    public void setEscalationDate(Date escalationDate) {
        this.escalationDate = null == escalationDate ? null : escalationDate;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public CitizenFeedback getCitizenFeedback() {
        return this.citizenFeedback;
    }

    public void setCitizenFeedback(CitizenFeedback citizenFeedback) {
        this.citizenFeedback = citizenFeedback;
    }

    public Boundary getChildLocation() {
        return this.childLocation;
    }

    public void setChildLocation(Boundary childLocation) {
        this.childLocation = childLocation;
    }

    public Long getCrossHierarchyId() {
        return this.crossHierarchyId;
    }

    public void setCrossHierarchyId(Long crossHierarchyId) {
        this.crossHierarchyId = crossHierarchyId;
    }

    public String getLatlngAddress() {
        return this.latlngAddress;
    }

    public void setLatlngAddress(String latlngAddress) {
        this.latlngAddress = latlngAddress;
    }

    public String myLinkId() {
        return this.crn;
    }

    public String getStateDetails() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy hh:mm a");
        return String.format("Complaint Number %s for %s filed on %s. Date of resolution %s. Priority is %s", this.getCrn(), this.getComplaintType().getName(), formatter.format(this.getCreatedDate()), formatter.format(this.getEscalationDate()), this.getPriority() != null ? this.getPriority().getName() : "-");
    }

    protected StateInfoBuilder buildStateInfo() {
        return super.buildStateInfo().citizenName(this.getComplainant().getName()).refDate(this.getCreatedDate()).citizenPhoneno(this.getComplainant().getMobile()).citizenAddress(this.getComplainant().getAddress()).refNum(this.getCrn()).location(this.getLocation().getName()).task("Grievance").status(this.getStatus().getName());
    }
}

