/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service.reports;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.config.persistence.datasource.routing.annotation.ReadOnly;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DrillDownReportService {
    @PersistenceContext
    private EntityManager entityManager;
    public static final String NOT_AVAILABLE = "NOT AVAILABLE";
    public static final String LOCALITY_SELECT_QRY = "select coalesce(cbndry.name,'GIS_LOCATION') as name, ";

    @ReadOnly
    public SQLQuery getDrillDownReportQuery(DateTime fromDate, DateTime toDate, String complaintDateType, String groupBy, String department, String boundary, String complainttype, String selecteduser, String locality) {
        StringBuilder query = new StringBuilder();
        if (StringUtils.isNotBlank((String)boundary)) {
            if (StringUtils.isNotBlank((String)locality)) {
                if (StringUtils.isNotBlank((String)department)) {
                    if (StringUtils.isNotBlank((String)complainttype)) {
                        query.append("  SELECT   emp.name||'~'|| pos.name    as name, ");
                    } else {
                        query.append(" SELECT ctype.name as name, ");
                    }
                } else {
                    query.append(" SELECT dept.name as name, ");
                }
            } else {
                query.append(LOCALITY_SELECT_QRY);
            }
        } else if (StringUtils.isNotBlank((String)department)) {
            if (StringUtils.isNotBlank((String)complainttype)) {
                query.append("  SELECT   emp.name||'~'|| pos.name    as name, ");
            } else {
                query.append(" SELECT ctype.name as name, ");
            }
        } else if (StringUtils.isNotBlank((String)complainttype)) {
            query.append(" SELECT ctype.name as name, ");
        } else if (StringUtils.isNotBlank((String)selecteduser)) {
            query.append("  SELECT   emp.name||'~'|| pos.name    as name, ");
        } else if ("ByBoundary".equals(groupBy)) {
            query.append("SELECT bndry.name as name, ");
        } else {
            query.append(" SELECT dept.name as name, ");
        }
        query.append("   COUNT(CASE WHEN cs.name IN ('REGISTERED') THEN 1 END) registered ,  COUNT(CASE WHEN cs.name IN ('FORWARDED','PROCESSING','REOPENED','NOTCOMPLETED') THEN 1 END) inprocess,  COUNT(CASE WHEN cs.name IN ('COMPLETED','WITHDRAWN','CLOSED') THEN 1 END) Completed,  COUNT(CASE WHEN cs.name IN ('REJECTED') THEN 1 END) Rejected ,");
        query.append("SUM(CASE WHEN state.value in ('COMPLETED','REJECTED','WITHDRAWN') AND (cd.createddate - state.lastmodifieddate) < (interval '1h' * ctype.slahours) THEN 1 WHEN (state.value not in ('COMPLETED','REJECTED','WITHDRAWN') AND (cd.createddate - CURRENT_DATE) < (interval '1h' * ctype.slahours)) THEN 1 else 0 END) withinsla, ");
        query.append(" SUM(CASE WHEN state.value in ('COMPLETED','REJECTED','WITHDRAWN') AND (cd.createddate - state.lastmodifieddate) > (interval '1h' * ctype.slahours) THEN 1 WHEN (state.value not in ('COMPLETED','REJECTED','WITHDRAWN') AND (cd.createddate - CURRENT_DATE ) > (interval '1h' * ctype.slahours)) THEN 1 ELSE 0 END) beyondsla ");
        query.append(" FROM egpgr_complaintstatus cs ,egpgr_complainttype ctype , eg_wf_states state, egpgr_complaint cd  left JOIN eg_boundary bndry on cd.location =bndry.id left JOIN eg_boundary cbndry on cd.childlocation=cbndry.id  left JOIN eg_department dept on cd.department =dept.id left join eg_position pos on cd.assignee=pos.id  left join view_egeis_employee emp on pos.id=emp.position ");
        this.buildWhereClause(fromDate, toDate, complaintDateType, query, department, boundary, complainttype, locality);
        this.buildGroupByClause(groupBy, department, boundary, complainttype, query, locality);
        return this.setParameterForDrillDownReportQuery(query.toString(), fromDate, toDate, complaintDateType);
    }

    private void buildGroupByClause(String groupBy, String department, String boundary, String complainttype, StringBuilder query, String locality) {
        if (StringUtils.isNotBlank((String)boundary)) {
            if (StringUtils.isNotBlank((String)locality)) {
                if (StringUtils.isNotBlank((String)department)) {
                    if (StringUtils.isNotBlank((String)complainttype)) {
                        query.append("  group by emp.name||'~'|| pos.name ");
                    } else {
                        query.append("  group by ctype.name ");
                    }
                } else {
                    query.append(" group by dept.name ");
                }
            } else {
                query.append("group by cbndry.name");
            }
        } else if (StringUtils.isNotBlank((String)department)) {
            if (StringUtils.isNotBlank((String)complainttype)) {
                query.append("  group by emp.name||'~'|| pos.name ");
            } else {
                query.append("  group by ctype.name ");
            }
        } else if (StringUtils.isNotBlank((String)complainttype)) {
            query.append(" group by ctype.name  ");
        } else if ("ByBoundary".equals(groupBy)) {
            query.append("  group by bndry.name ");
        } else {
            query.append("  group by dept.name ");
        }
    }

    private void buildWhereClause(DateTime fromDate, DateTime toDate, String complaintDateType, StringBuilder query, String department, String boundary, String complainttype, String locality) {
        query.append(" WHERE cd.status  = cs.id and cd.complainttype= ctype.id  and cd.state_id = state.id and emp.isprimary = true and emp.todate >= :currdate");
        if (fromDate != null && toDate != null) {
            query.append(" and ( cd.createddate BETWEEN :fromDates and :toDates) ");
        } else if (fromDate != null || "lastsevendays".equals(complaintDateType) || "lastthirtydays".equals(complaintDateType) || "lastninetydays".equals(complaintDateType)) {
            query.append(" and cd.createddate >=   :fromDates ");
        } else if (toDate != null) {
            query.append(" and cd.createddate <=  :toDates ");
        }
        if (StringUtils.isNotBlank((String)boundary)) {
            if (NOT_AVAILABLE.equals(boundary)) {
                query.append(" and  bndry.name is null ");
            } else {
                query.append(" and upper(trim(bndry.name))= '");
                query.append(boundary.toUpperCase()).append("' ");
            }
        }
        if (StringUtils.isNotBlank((String)locality)) {
            if ("GIS_LOCATION".equals(locality)) {
                query.append("and cbndry.name is null");
            } else {
                query.append("and upper(trim(cbndry.name))= '");
                query.append(locality.toUpperCase()).append("' ");
            }
        }
        if (StringUtils.isNotBlank((String)department)) {
            if (NOT_AVAILABLE.equals(department)) {
                query.append(" and  dept.name is null ");
            } else {
                query.append(" and upper(trim(dept.name))=  '");
                query.append(department.toUpperCase()).append("' ");
            }
        }
        if (StringUtils.isNotBlank((String)complainttype)) {
            query.append(" and upper(trim(ctype.name))= '");
            query.append(complainttype.toUpperCase()).append("' ");
        }
    }

    private SQLQuery setParameterForDrillDownReportQuery(String querykey, DateTime fromDate, DateTime toDate, String complaintDateType) {
        SQLQuery qry = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(querykey);
        if ("lastsevendays".equals(complaintDateType)) {
            qry.setParameter("fromDates", (Object)this.getCurrentDateWithOutTime().minusDays(7).toDate());
        } else if ("lastthirtydays".equals(complaintDateType)) {
            qry.setParameter("fromDates", (Object)this.getCurrentDateWithOutTime().minusDays(30).toDate());
        } else if ("lastninetydays".equals(complaintDateType)) {
            qry.setParameter("fromDates", (Object)this.getCurrentDateWithOutTime().minusDays(90).toDate());
        } else if (fromDate != null && toDate != null) {
            qry.setParameter("fromDates", (Object)this.resetTimeByPassingDate(fromDate));
            qry.setParameter("toDates", (Object)this.getEndOfDayByDate(toDate));
        } else if (fromDate != null) {
            qry.setParameter("fromDates", (Object)this.resetTimeByPassingDate(fromDate));
        } else if (toDate != null) {
            qry.setParameter("toDates", (Object)this.getEndOfDayByDate(toDate));
        }
        qry.setParameter("currdate", (Object)this.getCurrentDateWithOutTime().toDate());
        return qry;
    }

    private Date getEndOfDayByDate(DateTime fromDate) {
        return fromDate.withTime(23, 59, 59, 999).toDate();
    }

    private Date resetTimeByPassingDate(DateTime fromDate) {
        return fromDate.withTime(0, 0, 0, 0).toDate();
    }

    private DateTime getCurrentDateWithOutTime() {
        return new LocalDateTime().withTime(0, 0, 0, 0).toDateTime();
    }

    @ReadOnly
    public SQLQuery getDrillDownReportQuery(DateTime fromDate, DateTime toDate, String complaintDateType, String department, String boundary, String complainttype, String selecteduser, String locality) {
        StringBuilder query = new StringBuilder();
        query.append("SELECT distinct complainant.id as complaintid, crn,cd.createddate,complainant.name as complaintname,cd.details,cs.name as status , bndry.name || ' - ' || childlocation.name AS boundaryname , cd.citizenfeedback as feedback ,");
        query.append("CASE WHEN state.value IN ('COMPLETED','REJECTED','WITHDRAWN') AND (cd.createddate - state.lastmodifieddate) < (interval '1h' * ctype.slahours) THEN 'Yes' WHEN (state.value NOT IN ('COMPLETED','REJECTED','WITHDRAWN') ");
        query.append("AND (cd.createddate - CURRENT_DATE) < (interval '1h' * ctype.slahours)) THEN 'Yes' ELSE 'No' END as issla ");
        query.append("FROM egpgr_complaintstatus cs ,egpgr_complainttype ctype ,eg_wf_states state ,egpgr_complaint cd left JOIN eg_boundary bndry on cd.location =bndry.id left JOIN eg_boundary childlocation on cd.childlocation = childlocation.id  left JOIN eg_boundary cbndry on cd.childlocation=cbndry.id left JOIN eg_department dept on cd.department =dept.id  left join eg_position pos on cd.assignee=pos.id left join view_egeis_employee emp on pos.id=emp.position , egpgr_complainant complainant ");
        this.buildWhereClause(fromDate, toDate, complaintDateType, query, department, boundary, complainttype, locality);
        query.append(" and complainant.id=cd.complainant   ");
        if (selecteduser != null && !"".equals(selecteduser)) {
            query.append(" and upper(emp.name)= '");
            query.append(selecteduser.toUpperCase()).append("' ");
        }
        return this.setParameterForDrillDownReportQuery(query.toString(), fromDate, toDate, complaintDateType);
    }
}

