/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.repository.dashboard;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.infra.utils.DateUtils;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Repository;

@Repository
public class DashboardRepository {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    @Qualifier(value="dashboardSQLSource")
    private ReloadableResourceBundleMessageSource dashboardSQLSource;

    public List<Object[]> fetchComplaintResolutionTrendBetween(Date fromDate, Date toDate) {
        return this.fetchDateRangeData("pgr.comp.resolution.weekly.trend", fromDate, toDate);
    }

    public List<Object[]> fetchComplaintRegistrationTrendBetween(Date fromDate, Date toDate) {
        return this.fetchDateRangeData("pgr.comp.reg.weekly.trend", fromDate, toDate);
    }

    public List<Object[]> fetchMonthlyAggregateBetween(Date fromDate, Date toDate) {
        return this.fetchDateRangeData("pgr.comp.six.month.aggr", fromDate, toDate);
    }

    public List<Object[]> fetchComplaintTypeWiseBetween(Date fromDate, Date toDate) {
        return this.fetchDateRangeData("pgr.comp.type.wise.perc", fromDate, toDate);
    }

    public List<Object[]> fetchWardwisePerformanceTill(DateTime toDate) {
        SQLQuery qry = this.getQuery("pgr.wardwiseperformance");
        qry.setParameter("thirteenDaysBefore", (Object)DateUtils.endOfGivenDate((DateTime)toDate.minusDays(13)).toDate());
        qry.setParameter("fourteenDaysBefore", (Object)DateUtils.startOfGivenDate((DateTime)toDate.minusDays(14)).toDate());
        qry.setParameter("currentDate", (Object)DateUtils.endOfGivenDate((DateTime)toDate).toDate());
        return qry.list();
    }

    public Object[] fetchComplaintAgeing(String querykey, String wardName) {
        SQLQuery qry = this.getQuery(querykey);
        DateTime currentDate = new DateTime();
        qry.setParameter("grtthn90", (Object)DateUtils.endOfGivenDate((DateTime)currentDate.minusDays(90)).toDate());
        qry.setParameter("lsthn90", (Object)DateUtils.endOfGivenDate((DateTime)currentDate.minusDays(90)).toDate());
        qry.setParameter("grtthn45", (Object)DateUtils.endOfGivenDate((DateTime)currentDate.minusDays(45)).toDate());
        qry.setParameter("grtthn15", (Object)DateUtils.endOfGivenDate((DateTime)currentDate.minusDays(15)).toDate());
        qry.setParameter("lsthn45", (Object)DateUtils.endOfGivenDate((DateTime)currentDate.minusDays(45)).toDate());
        qry.setParameter("lsthn15", (Object)DateUtils.endOfGivenDate((DateTime)currentDate.minusDays(15)).toDate());
        qry.setParameter("currdate", (Object)DateUtils.endOfGivenDate((DateTime)currentDate).toDate());
        if (wardName != null) {
            qry.setParameter("wardName", (Object)wardName);
        }
        return (Object[])qry.uniqueResult();
    }

    public List<Object[]> fetchOpenComplaintAggregateBetween(DateTime fromDate, DateTime toDate) {
        return this.fetchDateRangeData("pgr.open.comp.aggr", fromDate.toDate(), toDate.toDate());
    }

    public List<Object[]> fetchComplaintsByComplaintTypeGroupByWard(Long complaintTypeId, DateTime fromDate, DateTime toDate) {
        SQLQuery qry = this.getQuery("pgr.bndry.wise.perc");
        qry.setParameter("fromDate", (Object)fromDate.toDate());
        qry.setParameter("toDate", (Object)toDate.toDate());
        qry.setParameter("compTypeId", (Object)complaintTypeId);
        return qry.list();
    }

    public List<Object[]> fetchTopComplaintsBetween(Date fromDate, Date toDate) {
        return this.fetchDateRangeData("pgr.top.comp.types", fromDate, toDate);
    }

    private List<Object[]> fetchDateRangeData(String query, Date fromDate, Date toDate) {
        SQLQuery qry = this.getQuery(query);
        qry.setParameter("fromDate", (Object)fromDate);
        qry.setParameter("toDate", (Object)toDate);
        return qry.list();
    }

    public List<Object[]> fetchGISCompPerPropertyWardWise() {
        SQLQuery qry = this.getQuery("pgr.comp.per.property.six.month.wardwise");
        return qry.list();
    }

    public List<Object[]> fetchGISCompRedressedWardWise() {
        SQLQuery qry = this.getQuery("pgr.comp.redressed.six.month.wardwise");
        return qry.list();
    }

    public List<Object[]> fetchGISRegCompWardWise() {
        SQLQuery qry = this.getQuery("pgr.comp.reg.six.month.wardwise");
        return qry.list();
    }

    private SQLQuery getQuery(String sqlKey) {
        return ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(this.dashboardSQLSource.getMessage(sqlKey, null, Locale.getDefault()));
    }
}

