/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service.reports;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.joda.time.LocalDateTime;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class AgeingReportService {
    private static final String COMPLAINTSTATUS_COMPLETED = "Completed";
    private static final String COMPLAINTSTATUS_REJECTED = "Rejected";
    @PersistenceContext
    private EntityManager entityManager;

    public SQLQuery getageingReportQuery(DateTime fromDate, DateTime toDate, String typeofReport, String complaintDateType, String groupBy) {
        StringBuilder query = new StringBuilder();
        if (groupBy != null && !"".equals(groupBy) && groupBy.equalsIgnoreCase("ByBoundary")) {
            query.append("SELECT bndry.name as name, ");
        } else {
            query.append("SELECT dept.name as name, ");
        }
        if (typeofReport != null && !"".equals(typeofReport) && (typeofReport.equalsIgnoreCase(COMPLAINTSTATUS_COMPLETED) || typeofReport.equalsIgnoreCase(COMPLAINTSTATUS_REJECTED))) {
            query.append(" COUNT(CASE WHEN date_part('day',(cd.createddate - state.createddate)) > :grtthn90 THEN 1 END) grtthn90, ");
            query.append(" COUNT(CASE WHEN date_part('day',(cd.createddate - state.createddate)) BETWEEN :grtthn45 AND :lsthn90 THEN 1 END) btw45to90, ");
            query.append(" COUNT(CASE WHEN date_part('day',(cd.createddate - state.createddate)) BETWEEN :grtthn15 AND :lsthn45 THEN 1 END) btw15to45, ");
            query.append(" COUNT(CASE WHEN date_part('day',(cd.createddate - state.createddate)) BETWEEN :zero AND :lsthn15 THEN 1 END) lsthn15 ");
            query.append(" FROM egpgr_complaintstatus cs  ,egpgr_complainttype ctype, eg_wf_states state, egpgr_complaint cd  ");
        } else {
            query.append(" COUNT(CASE WHEN cd.createddate < :grtthn90 THEN 1 END) grtthn90, ");
            query.append(" COUNT(CASE WHEN cd.createddate BETWEEN :lsthn90 AND :grtthn45 THEN 1 END) btw45to90, ");
            query.append(" COUNT(CASE WHEN cd.createddate BETWEEN :lsthn45 AND  :grtthn15 THEN 1 END) btw15to45, ");
            query.append(" COUNT(CASE WHEN cd.createddate BETWEEN :lsthn15 AND :currdate THEN 1 END) lsthn15 ");
            query.append(" FROM egpgr_complaintstatus cs  ,egpgr_complainttype ctype ,egpgr_complaint cd  ");
        }
        if (groupBy != null && !"".equals(groupBy) && groupBy.equalsIgnoreCase("ByBoundary")) {
            query.append("  left JOIN eg_boundary bndry on cd.location =bndry.id ");
        } else {
            query.append("  left JOIN eg_department dept on cd.department =dept.id ");
        }
        this.buildWhereClause(fromDate, toDate, typeofReport, complaintDateType, query);
        if (groupBy != null && !"".equals(groupBy) && groupBy.equalsIgnoreCase("ByBoundary")) {
            query.append("  group by bndry.name ");
        } else {
            query.append("  group by dept.name ");
        }
        return this.setParameterForAgeingReport(query.toString(), typeofReport, fromDate, toDate, complaintDateType);
    }

    private void buildWhereClause(DateTime fromDate, DateTime toDate, String typeofReport, String complaintDateType, StringBuilder query) {
        if (typeofReport != null && !"".equals(typeofReport) && typeofReport.equalsIgnoreCase(COMPLAINTSTATUS_COMPLETED)) {
            query.append(" WHERE  cd.state_id=state.id and  cd.status  = cs.id and cd.complainttype= ctype.id  ");
            query.append(" AND cs.name IN ('COMPLETED', 'WITHDRAWN','CLOSED') ");
        } else if (typeofReport != null && !"".equals(typeofReport) && typeofReport.equalsIgnoreCase(COMPLAINTSTATUS_REJECTED)) {
            query.append(" WHERE  cd.state_id=state.id and  cd.status  = cs.id and cd.complainttype= ctype.id  ");
            query.append(" AND cs.name IN ('REJECTED') ");
        } else {
            query.append(" WHERE cd.status  = cs.id and cd.complainttype= ctype.id  ");
            query.append(" AND cs.name IN ('REGISTERED','FORWARDED', 'PROCESSING','REOPENED') ");
        }
        if (complaintDateType != null && complaintDateType.equals("lastsevendays")) {
            query.append(" and cd.createddate >=   :fromDates ");
        } else if (complaintDateType != null && complaintDateType.equals("lastthirtydays")) {
            query.append(" and cd.createddate >=   :fromDates ");
        } else if (complaintDateType != null && complaintDateType.equals("lastninetydays")) {
            query.append(" and cd.createddate >=   :fromDates ");
        } else if (fromDate != null && toDate != null) {
            query.append(" and ( cd.createddate BETWEEN :fromDates and :toDates) ");
        } else if (fromDate != null) {
            query.append(" and cd.createddate >=   :fromDates ");
        } else if (toDate != null) {
            query.append(" and cd.createddate <=  :toDates ");
        }
    }

    private SQLQuery setParameterForAgeingReport(String querykey, String typeofReport, DateTime fromDate, DateTime toDate, String complaintDateType) {
        SQLQuery qry = ((Session)this.entityManager.unwrap(Session.class)).createSQLQuery(querykey);
        if (typeofReport != null && !"".equals(typeofReport) && (typeofReport.equalsIgnoreCase(COMPLAINTSTATUS_COMPLETED) || typeofReport.equalsIgnoreCase(COMPLAINTSTATUS_REJECTED))) {
            qry.setParameter("grtthn90", (Object)90);
            qry.setParameter("lsthn90", (Object)90);
            qry.setParameter("grtthn45", (Object)45.0001);
            qry.setParameter("grtthn15", (Object)15.0001);
            qry.setParameter("lsthn45", (Object)45);
            qry.setParameter("lsthn15", (Object)15);
            qry.setParameter("zero", (Object)0);
        } else {
            qry.setParameter("grtthn90", (Object)this.getCurrentDateWithOutTime().minusDays(90).toDate());
            qry.setParameter("grtthn45", (Object)this.getCurrentDateWithOutTime().minusDays(46).toDate());
            qry.setParameter("lsthn90", (Object)this.getCurrentDateWithEndOfDayTime().minusDays(90).toDate());
            qry.setParameter("grtthn15", (Object)this.getCurrentDateWithOutTime().minusDays(16).toDate());
            qry.setParameter("lsthn45", (Object)this.getCurrentDateWithEndOfDayTime().minusDays(45).toDate());
            qry.setParameter("lsthn15", (Object)this.getCurrentDateWithOutTime().minusDays(15).toDate());
            qry.setParameter("currdate", (Object)this.getCurrentDateWithEndOfDayTime().toDate());
        }
        if (complaintDateType != null && complaintDateType.equals("lastsevendays")) {
            qry.setParameter("fromDates", (Object)this.getCurrentDateWithOutTime().minusDays(7).toDate());
        } else if (complaintDateType != null && complaintDateType.equals("lastthirtydays")) {
            qry.setParameter("fromDates", (Object)this.getCurrentDateWithOutTime().minusDays(30).toDate());
        } else if (complaintDateType != null && complaintDateType.equals("lastninetydays")) {
            qry.setParameter("fromDates", (Object)this.getCurrentDateWithOutTime().minusDays(90).toDate());
        } else if (fromDate != null && toDate != null) {
            qry.setParameter("fromDates", (Object)this.resetTimeByPassingDate(fromDate));
            qry.setParameter("toDates", (Object)this.getEndOfDayByDate(toDate));
        } else if (fromDate != null) {
            qry.setParameter("fromDates", (Object)this.resetTimeByPassingDate(fromDate));
        } else if (toDate != null) {
            qry.setParameter("toDates", (Object)this.getEndOfDayByDate(toDate));
        }
        return qry;
    }

    private Date getEndOfDayByDate(DateTime fromDate) {
        return fromDate.withTime(23, 59, 59, 999).toDate();
    }

    private Date resetTimeByPassingDate(DateTime fromDate) {
        return fromDate.withTime(0, 0, 0, 0).toDate();
    }

    private DateTime getCurrentDateWithOutTime() {
        return new LocalDateTime().withTime(0, 0, 0, 0).toDateTime();
    }

    private DateTime getCurrentDateWithEndOfDayTime() {
        return new LocalDateTime().withTime(23, 59, 59, 999).toDateTime();
    }
}

