/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.elasticSearch.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.time.DateUtils;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.search.elastic.annotation.Indexing;
import org.egov.pgr.elasticSearch.entity.ComplaintIndex;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.Escalation;
import org.egov.pgr.entity.enums.ComplaintStatus;
import org.egov.pgr.entity.enums.ReceivingMode;
import org.egov.pgr.service.ComplaintService;
import org.egov.pgr.service.EscalationService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.search.domain.Document;
import org.egov.search.domain.Page;
import org.egov.search.domain.SearchResult;
import org.egov.search.domain.Sort;
import org.egov.search.service.SearchService;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ComplaintIndexService {
    @Autowired
    private CityService cityService;
    @Autowired
    private EscalationService escalationService;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private SearchService searchService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private ComplaintService complaintService;

    @Indexing(name=Index.PGR, type=IndexType.COMPLAINT)
    public ComplaintIndex createComplaintIndex(ComplaintIndex complaintIndex) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        complaintIndex.setCitydetails(cityWebsite);
        if (complaintIndex.getReceivingMode().equals((Object)ReceivingMode.MOBILE)) {
            complaintIndex.setSource("PuraSeva");
        } else if (complaintIndex.getReceivingMode().equals((Object)ReceivingMode.WEBSITE) && (complaintIndex.getCreatedBy().getType().equals((Object)UserType.CITIZEN) || complaintIndex.getCreatedBy().getType().equals((Object)UserType.SYSTEM))) {
            complaintIndex.setSource("By citizens:ULB Portal");
        } else if (complaintIndex.getCreatedBy().getType().equals((Object)UserType.EMPLOYEE) || complaintIndex.getCreatedBy().getType().equals((Object)UserType.SYSTEM)) {
            complaintIndex.setSource("ULB counter");
        }
        complaintIndex.setIsClosed(false);
        complaintIndex.setComplaintIsClosed('N');
        complaintIndex.setIfClosed(0);
        complaintIndex.setComplaintDuration(0.0);
        complaintIndex.setDurationRange("");
        Position position = complaintIndex.getAssignee();
        User assignedUser = this.eisCommonService.getUserForPosition(position.getId(), new Date());
        complaintIndex.setComplaintPeriod(0.0);
        complaintIndex.setComplaintSLADays(complaintIndex.getComplaintType().getSlaHours().intValue());
        complaintIndex.setComplaintAgeingFromDue(0.0);
        complaintIndex.setIsSLA('Y');
        complaintIndex.setIfSLA(1);
        complaintIndex.setInitialFunctionaryName(assignedUser.getName());
        complaintIndex.setInitialFunctionaryAssigneddate(new Date());
        complaintIndex.setInitialFunctionarySLADays(this.getFunctionarySlaDays(complaintIndex));
        complaintIndex.setInitialFunctionaryAgeingFromDue(0.0);
        complaintIndex.setInitialFunctionaryIsSLA('Y');
        complaintIndex.setInitialFunctionaryIfSLA(1);
        complaintIndex.setCurrentFunctionaryName(assignedUser.getName());
        complaintIndex.setCurrentFunctionaryAssigneddate(new Date());
        complaintIndex.setCurrentFunctionarySLADays(this.getFunctionarySlaDays(complaintIndex));
        complaintIndex.setCurrentFunctionaryAgeingFromDue(0.0);
        complaintIndex.setCurrentFunctionaryIsSLA('Y');
        complaintIndex.setCurrentFunctionaryIfSLA(1);
        complaintIndex.setEscalationLevel(0);
        complaintIndex.setReasonForRejection("");
        complaintIndex.setRegistered(1);
        complaintIndex.setInProcess(1);
        complaintIndex.setAddressed(0);
        complaintIndex.setRejected(0);
        complaintIndex.setReOpened(0);
        return complaintIndex;
    }

    @Indexing(name=Index.PGR, type=IndexType.COMPLAINT)
    public ComplaintIndex updateComplaintIndex(ComplaintIndex complaintIndex, Long approvalPosition, String approvalComment) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        complaintIndex.setCitydetails(cityWebsite);
        if (complaintIndex.getReceivingMode().equals((Object)ReceivingMode.MOBILE)) {
            complaintIndex.setSource("PuraSeva");
        } else if (complaintIndex.getReceivingMode().equals((Object)ReceivingMode.WEBSITE) && (complaintIndex.getCreatedBy().getType().equals((Object)UserType.CITIZEN) || complaintIndex.getCreatedBy().getType().equals((Object)UserType.SYSTEM))) {
            complaintIndex.setSource("By citizens:ULB Portal");
        } else if (complaintIndex.getCreatedBy().getType().equals((Object)UserType.EMPLOYEE) || complaintIndex.getCreatedBy().getType().equals((Object)UserType.SYSTEM)) {
            complaintIndex.setSource("ULB counter");
        }
        complaintIndex = this.populateFromIndex(complaintIndex);
        Position position = complaintIndex.getAssignee();
        User assignedUser = this.eisCommonService.getUserForPosition(position.getId(), new Date());
        if (approvalPosition != null && !approvalPosition.equals(0L)) {
            complaintIndex.setCurrentFunctionaryName(assignedUser.getName());
            complaintIndex.setCurrentFunctionaryAssigneddate(new Date());
            complaintIndex.setCurrentFunctionarySLADays(this.getFunctionarySlaDays(complaintIndex));
        }
        if ((complaintIndex = this.updateComplaintLevelIndexFields(complaintIndex)).getStatus().getName().equalsIgnoreCase(ComplaintStatus.COMPLETED.toString()) || complaintIndex.getStatus().getName().equalsIgnoreCase(ComplaintStatus.WITHDRAWN.toString()) || complaintIndex.getStatus().getName().equalsIgnoreCase(ComplaintStatus.REJECTED.toString())) {
            complaintIndex.setIsClosed(true);
            complaintIndex.setComplaintIsClosed('Y');
            complaintIndex.setIfClosed(1);
            complaintIndex.setClosedByFunctionaryName(assignedUser.getName());
            long duration = Math.abs(complaintIndex.getCreatedDate().getTime() - new Date().getTime()) / 86400000L;
            complaintIndex.setComplaintDuration(duration);
            if (duration < 3L) {
                complaintIndex.setDurationRange("(<3 days)");
            } else if (duration < 7L) {
                complaintIndex.setDurationRange("(3-7 days)");
            } else if (duration < 15L) {
                complaintIndex.setDurationRange("(8-15 days)");
            } else if (duration < 30L) {
                complaintIndex.setDurationRange("(16-30 days)");
            } else {
                complaintIndex.setDurationRange("(>30 days)");
            }
        } else {
            complaintIndex.setIsClosed(false);
            complaintIndex.setComplaintIsClosed('N');
            complaintIndex.setIfClosed(0);
            complaintIndex.setComplaintDuration(0.0);
            complaintIndex.setDurationRange("");
        }
        complaintIndex = this.updateComplaintIndexStatusRelatedFields(complaintIndex);
        if (complaintIndex.getStatus().getName().equalsIgnoreCase(ComplaintStatus.REOPENED.toString()) && !this.checkComplaintStatusFromIndex(complaintIndex)) {
            complaintIndex.setComplaintReOpenedDate(new Date());
            complaintIndex.setIsClosed(false);
            complaintIndex.setComplaintIsClosed('N');
            complaintIndex.setIfClosed(0);
        }
        if (complaintIndex.getStatus().getName().equalsIgnoreCase(ComplaintStatus.REJECTED.toString())) {
            complaintIndex.setReasonForRejection(approvalComment);
        }
        return complaintIndex;
    }

    @Indexing(name=Index.PGR, type=IndexType.COMPLAINT)
    public ComplaintIndex updateComplaintEscalationIndexValues(ComplaintIndex complaintIndex) {
        Position position = complaintIndex.getAssignee();
        User assignedUser = this.eisCommonService.getUserForPosition(position.getId(), new Date());
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        complaintIndex.setCitydetails(cityWebsite);
        if (complaintIndex.getReceivingMode().equals((Object)ReceivingMode.MOBILE)) {
            complaintIndex.setSource("PuraSeva");
        } else if (complaintIndex.getReceivingMode().equals((Object)ReceivingMode.WEBSITE) && (complaintIndex.getCreatedBy().getType().equals((Object)UserType.CITIZEN) || complaintIndex.getCreatedBy().getType().equals((Object)UserType.SYSTEM))) {
            complaintIndex.setSource("By citizens:ULB Portal");
        } else if (complaintIndex.getCreatedBy().getType().equals((Object)UserType.EMPLOYEE) || complaintIndex.getCreatedBy().getType().equals((Object)UserType.SYSTEM)) {
            complaintIndex.setSource("ULB counter");
        }
        complaintIndex = this.populateFromIndex(complaintIndex);
        complaintIndex.setCurrentFunctionaryName(assignedUser.getName());
        complaintIndex.setCurrentFunctionaryAssigneddate(new Date());
        complaintIndex.setCurrentFunctionarySLADays(this.getFunctionarySlaDays(complaintIndex));
        complaintIndex = this.updateComplaintLevelIndexFields(complaintIndex);
        int escalationLevel = complaintIndex.getEscalationLevel();
        if (escalationLevel == 0) {
            complaintIndex.setEscalation1FunctionaryName(assignedUser.getName());
            complaintIndex.setEscalation1FunctionaryAssigneddate(new Date());
            complaintIndex.setEscalation1FunctionarySLADays(this.getFunctionarySlaDays(complaintIndex));
            complaintIndex.setEscalation1FunctionaryAgeingFromDue(0.0);
            complaintIndex.setEscalation1FunctionaryIsSLA('Y');
            complaintIndex.setEscalation1FunctionaryIfSLA(1);
            complaintIndex.setEscalationLevel(++escalationLevel);
        } else if (escalationLevel == 1) {
            complaintIndex.setEscalation2FunctionaryName(assignedUser.getName());
            complaintIndex.setEscalation2FunctionaryAssigneddate(new Date());
            complaintIndex.setEscalation2FunctionarySLADays(this.getFunctionarySlaDays(complaintIndex));
            complaintIndex.setEscalation2FunctionaryAgeingFromDue(0.0);
            complaintIndex.setEscalation2FunctionaryIsSLA('Y');
            complaintIndex.setEscalation2FunctionaryIfSLA(1);
            complaintIndex.setEscalationLevel(++escalationLevel);
        } else if (escalationLevel == 2) {
            complaintIndex.setEscalation3FunctionaryName(assignedUser.getName());
            complaintIndex.setEscalation3FunctionaryAssigneddate(new Date());
            complaintIndex.setEscalation3FunctionarySLADays(this.getFunctionarySlaDays(complaintIndex));
            complaintIndex.setEscalation3FunctionaryAgeingFromDue(0.0);
            complaintIndex.setEscalation3FunctionaryIsSLA('Y');
            complaintIndex.setEscalation3FunctionaryIfSLA(1);
            complaintIndex.setEscalationLevel(++escalationLevel);
        }
        complaintIndex = this.updateEscalationLevelIndexFields(complaintIndex);
        complaintIndex = this.updateComplaintIndexStatusRelatedFields(complaintIndex);
        return complaintIndex;
    }

    public void updateAllOpenComplaintIndex() {
        List<Complaint> openComplaints = this.complaintService.getOpenComplaints();
        for (Complaint complaint : openComplaints) {
            this.updateOpenComplaintIndex(complaint);
        }
    }

    @Indexing(name=Index.PGR, type=IndexType.COMPLAINT)
    public ComplaintIndex updateOpenComplaintIndex(Complaint complaint) {
        ComplaintIndex savedComplaintIndex = new ComplaintIndex();
        BeanUtils.copyProperties((Object)((Object)complaint), (Object)((Object)savedComplaintIndex));
        ComplaintIndex complaintIndex = ComplaintIndex.method(savedComplaintIndex);
        complaintIndex = this.populateFromIndex(complaintIndex);
        complaintIndex = this.updateComplaintLevelIndexFields(complaintIndex);
        complaintIndex = this.updateEscalationLevelIndexFields(complaintIndex);
        complaintIndex = this.updateComplaintIndexStatusRelatedFields(complaintIndex);
        return complaintIndex;
    }

    public ComplaintIndex updateComplaintLevelIndexFields(ComplaintIndex complaintIndex) {
        long days = Math.abs(new Date().getTime() - complaintIndex.getCreatedDate().getTime()) / 86400000L;
        complaintIndex.setComplaintPeriod(days);
        Date lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getCreatedDate(), (int)((int)complaintIndex.getComplaintSLADays()));
        Date currentDate = new Date();
        if (lastDateToResolve.getTime() - currentDate.getTime() >= 0L) {
            complaintIndex.setComplaintAgeingFromDue(0.0);
            complaintIndex.setIsSLA('Y');
            complaintIndex.setIfSLA(1);
        } else {
            long ageingDuehours = Math.abs(currentDate.getTime() - lastDateToResolve.getTime()) / 3600000L;
            complaintIndex.setComplaintAgeingFromDue(ageingDuehours);
            complaintIndex.setIsSLA('N');
            complaintIndex.setIfSLA(0);
        }
        if (complaintIndex.getInitialFunctionaryAssigneddate() != null) {
            lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getInitialFunctionaryAssigneddate(), (int)((int)complaintIndex.getInitialFunctionarySLADays()));
            if (lastDateToResolve.getTime() - new Date().getTime() >= 0L) {
                complaintIndex.setInitialFunctionaryAgeingFromDue(0.0);
                complaintIndex.setInitialFunctionaryIsSLA('Y');
                complaintIndex.setInitialFunctionaryIfSLA(1);
            } else {
                long initialFunctionaryAgeingDueHours = Math.abs(new Date().getTime() - lastDateToResolve.getTime()) / 3600000L;
                complaintIndex.setInitialFunctionaryAgeingFromDue(initialFunctionaryAgeingDueHours);
                complaintIndex.setInitialFunctionaryIsSLA('N');
                complaintIndex.setInitialFunctionaryIfSLA(0);
            }
        }
        if (complaintIndex.getCurrentFunctionaryAssigneddate() != null) {
            lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getCurrentFunctionaryAssigneddate(), (int)((int)complaintIndex.getCurrentFunctionarySLADays()));
            if (lastDateToResolve.getTime() - new Date().getTime() >= 0L) {
                complaintIndex.setCurrentFunctionaryAgeingFromDue(0.0);
                complaintIndex.setCurrentFunctionaryIsSLA('Y');
                complaintIndex.setCurrentFunctionaryIfSLA(1);
            } else {
                long currentFunctionaryAgeingDueHours = Math.abs(new Date().getTime() - lastDateToResolve.getTime()) / 3600000L;
                complaintIndex.setCurrentFunctionaryAgeingFromDue(currentFunctionaryAgeingDueHours);
                complaintIndex.setCurrentFunctionaryIsSLA('N');
                complaintIndex.setCurrentFunctionaryIfSLA(0);
            }
        }
        return complaintIndex;
    }

    public ComplaintIndex updateEscalationLevelIndexFields(ComplaintIndex complaintIndex) {
        Date lastDateToResolve;
        if (complaintIndex.getEscalation1FunctionaryAssigneddate() != null) {
            lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getEscalation1FunctionaryAssigneddate(), (int)((int)complaintIndex.getEscalation1FunctionarySLADays()));
            if (lastDateToResolve.getTime() - new Date().getTime() >= 0L) {
                complaintIndex.setEscalation1FunctionaryAgeingFromDue(0.0);
                complaintIndex.setEscalation1FunctionaryIsSLA('Y');
                complaintIndex.setEscalation1FunctionaryIfSLA(1);
            } else {
                long escalation1FunctionaryAgeingDueHours = Math.abs(new Date().getTime() - lastDateToResolve.getTime()) / 3600000L;
                complaintIndex.setEscalation1FunctionaryAgeingFromDue(escalation1FunctionaryAgeingDueHours);
                complaintIndex.setEscalation1FunctionaryIsSLA('N');
                complaintIndex.setEscalation1FunctionaryIfSLA(0);
            }
        }
        if (complaintIndex.getEscalation2FunctionaryAssigneddate() != null) {
            lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getEscalation2FunctionaryAssigneddate(), (int)((int)complaintIndex.getEscalation2FunctionarySLADays()));
            if (lastDateToResolve.getTime() - new Date().getTime() >= 0L) {
                complaintIndex.setEscalation2FunctionaryAgeingFromDue(0.0);
                complaintIndex.setEscalation2FunctionaryIsSLA('Y');
                complaintIndex.setEscalation2FunctionaryIfSLA(1);
            } else {
                long escalation2FunctionaryAgeingDueHours = Math.abs(new Date().getTime() - lastDateToResolve.getTime()) / 3600000L;
                complaintIndex.setEscalation2FunctionaryAgeingFromDue(escalation2FunctionaryAgeingDueHours);
                complaintIndex.setEscalation2FunctionaryIsSLA('N');
                complaintIndex.setEscalation2FunctionaryIfSLA(0);
            }
        }
        if (complaintIndex.getEscalation3FunctionaryAssigneddate() != null) {
            lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getEscalation3FunctionaryAssigneddate(), (int)((int)complaintIndex.getEscalation3FunctionarySLADays()));
            if (lastDateToResolve.getTime() - new Date().getTime() >= 0L) {
                complaintIndex.setEscalation3FunctionaryAgeingFromDue(0.0);
                complaintIndex.setEscalation3FunctionaryIsSLA('Y');
                complaintIndex.setEscalation3FunctionaryIfSLA(1);
            } else {
                long escalation3FunctionaryAgeingDueHours = Math.abs(new Date().getTime() - lastDateToResolve.getTime()) / 3600000L;
                complaintIndex.setEscalation3FunctionaryAgeingFromDue(escalation3FunctionaryAgeingDueHours);
                complaintIndex.setEscalation3FunctionaryIsSLA('N');
                complaintIndex.setEscalation3FunctionaryIfSLA(0);
            }
        }
        return complaintIndex;
    }

    private long getFunctionarySlaDays(ComplaintIndex complaintIndex) {
        Position position = complaintIndex.getAssignee();
        Designation designation = this.assignmentService.getPrimaryAssignmentForPositon(position.getId()).getDesignation();
        Escalation complaintEscalation = this.escalationService.getEscalationBycomplaintTypeAndDesignation(complaintIndex.getComplaintType().getId(), designation.getId());
        if (complaintEscalation != null) {
            long slaHours = complaintEscalation.getNoOfHrs().intValue();
            return slaHours;
        }
        return 0L;
    }

    public ComplaintIndex populateFromIndex(ComplaintIndex complaintIndex) {
        SearchResult searchResult = this.searchService.search(Arrays.asList(Index.PGR.toString()), Arrays.asList(IndexType.COMPLAINT.toString()), null, complaintIndex.searchFilters(), Sort.NULL, Page.NULL);
        if (!searchResult.getDocuments().isEmpty()) {
            List documents = searchResult.getDocuments();
            LinkedHashMap clausesObject = (LinkedHashMap)((Document)documents.get(0)).getResource().get((Object)"clauses");
            LinkedHashMap searchableObject = (LinkedHashMap)((Document)documents.get(0)).getResource().get((Object)"searchable");
            double complaintPeriod = clausesObject.get("complaintPeriod") == null ? 0.0 : (Double)clausesObject.get("complaintPeriod");
            double complaintDuration = searchableObject.get("complaintDuration") == null ? 0.0 : Double.valueOf(searchableObject.get("complaintDuration").toString());
            int complaintSlaDays = clausesObject.get("complaintSLADays") == null ? 0 : (Integer)clausesObject.get("complaintSLADays");
            double complaintAgeingFromDue = clausesObject.get("complaintAgeingFromDue") == null ? 0.0 : (Double)clausesObject.get("complaintAgeingFromDue");
            char isSla = clausesObject.get("isSLA") == null ? (char)'-' : (char)clausesObject.get("isSLA").toString().charAt(0);
            int ifSla = clausesObject.get("ifSLA") == null ? 1 : (Integer)clausesObject.get("ifSLA");
            boolean isClosed = searchableObject.get("isClosed") == null ? false : Boolean.valueOf(searchableObject.get("isClosed").toString());
            char complaintIsClosed = searchableObject.get("complaintIsClosed") == null ? (char)'N' : (char)searchableObject.get("complaintIsClosed").toString().charAt(0);
            int ifClosed = searchableObject.get("ifClosed") == null ? 0 : (Integer)searchableObject.get("ifClosed");
            String initialFunctionaryName = clausesObject.get("initialFunctionaryName") == null ? "" : clausesObject.get("initialFunctionaryName").toString();
            int initialFunctionarySlaDays = clausesObject.get("initialFunctionarySLADays") == null ? 0 : (Integer)clausesObject.get("initialFunctionarySLADays");
            double initialAgeingFromDue = clausesObject.get("initialFunctionaryAgeingFromDue") == null ? 0.0 : (Double)clausesObject.get("initialFunctionaryAgeingFromDue");
            char initialFunctionaryIsSla = clausesObject.get("initialFunctionaryIsSLA") == null ? (char)'-' : (char)clausesObject.get("initialFunctionaryIsSLA").toString().charAt(0);
            int initialFunctionaryIfSla = clausesObject.get("initialFunctionaryIfSLA") == null ? 1 : (Integer)clausesObject.get("initialFunctionaryIfSLA");
            String currentFunctionaryName = clausesObject.get("currentFunctionaryName") == null ? "" : clausesObject.get("currentFunctionaryName").toString();
            int currentFunctionarySlaDays = clausesObject.get("currentFunctionarySLADays") == null ? 0 : (Integer)clausesObject.get("currentFunctionarySLADays");
            double currentAgeingFromDue = clausesObject.get("currentFunctionaryAgeingFromDue") == null ? 0.0 : (Double)clausesObject.get("currentFunctionaryAgeingFromDue");
            char currentFunctionaryIsSla = clausesObject.get("currentFunctionaryIsSLA") == null ? (char)'-' : (char)clausesObject.get("currentFunctionaryIsSLA").toString().charAt(0);
            int currentFunctionaryIfSla = clausesObject.get("currentFunctionaryIfSLA") == null ? 1 : (Integer)clausesObject.get("currentFunctionaryIfSLA");
            String escalation1FunctionaryName = clausesObject.get("escalation1FunctionaryName") == null ? "" : clausesObject.get("escalation1FunctionaryName").toString();
            int escalation1FunctionarySlaDays = clausesObject.get("escalation1FunctionarySLADays") == null ? 0 : (Integer)clausesObject.get("escalation1FunctionarySLADays");
            double escalation1AgeingFromDue = clausesObject.get("escalation1FunctionaryAgeingFromDue") == null ? 0.0 : (Double)clausesObject.get("escalation1FunctionaryAgeingFromDue");
            char escalation1FunctionaryIsSla = clausesObject.get("escalation1FunctionaryIsSLA") == null ? (char)'-' : (char)clausesObject.get("escalation1FunctionaryIsSLA").toString().charAt(0);
            int escalation1FunctionaryIfSla = clausesObject.get("escalation1FunctionaryIfSLA") == null ? 1 : (Integer)clausesObject.get("escalation1FunctionaryIfSLA");
            String escalation2FunctionaryName = clausesObject.get("escalation2FunctionaryName") == null ? "" : clausesObject.get("escalation2FunctionaryName").toString();
            int escalation2FunctionarySlaDays = clausesObject.get("escalation2FunctionarySLADays") == null ? 0 : (Integer)clausesObject.get("escalation2FunctionarySLADays");
            double escalation2AgeingFromDue = clausesObject.get("escalation2FunctionaryAgeingFromDue") == null ? 0.0 : (Double)clausesObject.get("escalation2FunctionaryAgeingFromDue");
            char escalation2FunctionaryIsSla = clausesObject.get("escalation2FunctionaryIsSLA") == null ? (char)'-' : (char)clausesObject.get("escalation2FunctionaryIsSLA").toString().charAt(0);
            int escalation2FunctionaryIfSla = clausesObject.get("escalation2FunctionaryIfSLA") == null ? 1 : (Integer)clausesObject.get("escalation2FunctionaryIfSLA");
            String escalation3FunctionaryName = clausesObject.get("escalation3FunctionaryName") == null ? "" : clausesObject.get("escalation3FunctionaryName").toString();
            int escalation3FunctionarySlaDays = clausesObject.get("escalation3FunctionarySLADays") == null ? 0 : (Integer)clausesObject.get("escalation3FunctionarySLADays");
            double escalation3AgeingFromDue = clausesObject.get("escalation3FunctionaryAgeingFromDue") == null ? 0.0 : (Double)clausesObject.get("escalation3FunctionaryAgeingFromDue");
            char escalation3FunctionaryIsSla = clausesObject.get("escalation3FunctionaryIsSLA") == null ? (char)'-' : (char)clausesObject.get("escalation3FunctionaryIsSLA").toString().charAt(0);
            int escalation3FunctionaryIfSla = clausesObject.get("escalation3FunctionaryIfSLA") == null ? 1 : (Integer)clausesObject.get("escalation3FunctionaryIfSLA");
            int escalationLevel = clausesObject.get("escalationLevel") == null ? 0 : (Integer)clausesObject.get("escalationLevel");
            String durationRange = searchableObject.get("durationRange") == null ? "" : searchableObject.get("durationRange").toString();
            String reasonForRejection = clausesObject.get("reasonForRejection") == null ? "" : clausesObject.get("reasonForRejection").toString();
            int registered = clausesObject.get("registered") == null ? 1 : (Integer)clausesObject.get("registered");
            int reOpened = clausesObject.get("reOpened") == null ? 0 : (Integer)clausesObject.get("reOpened");
            complaintIndex.setComplaintPeriod(complaintPeriod);
            complaintIndex.setComplaintDuration(complaintDuration);
            complaintIndex.setComplaintSLADays(complaintSlaDays);
            complaintIndex.setComplaintAgeingFromDue(complaintAgeingFromDue);
            complaintIndex.setIsSLA(isSla);
            complaintIndex.setIfSLA(ifSla);
            complaintIndex.setIsClosed(isClosed);
            complaintIndex.setComplaintIsClosed(complaintIsClosed);
            complaintIndex.setIfClosed(ifClosed);
            complaintIndex.setInitialFunctionaryName(initialFunctionaryName);
            if (searchableObject.get("initialFunctionaryAssigneddate") != null) {
                complaintIndex.setInitialFunctionaryAssigneddate(this.formatDate(searchableObject.get("initialFunctionaryAssigneddate").toString()));
            }
            complaintIndex.setInitialFunctionarySLADays(initialFunctionarySlaDays);
            complaintIndex.setInitialFunctionaryAgeingFromDue(initialAgeingFromDue);
            complaintIndex.setInitialFunctionaryIsSLA(initialFunctionaryIsSla);
            complaintIndex.setInitialFunctionaryIfSLA(initialFunctionaryIfSla);
            complaintIndex.setCurrentFunctionaryName(currentFunctionaryName);
            if (searchableObject.get("currentFunctionaryAssigneddate") != null) {
                complaintIndex.setCurrentFunctionaryAssigneddate(this.formatDate(searchableObject.get("currentFunctionaryAssigneddate").toString()));
            }
            complaintIndex.setCurrentFunctionarySLADays(currentFunctionarySlaDays);
            complaintIndex.setCurrentFunctionaryAgeingFromDue(currentAgeingFromDue);
            complaintIndex.setCurrentFunctionaryIsSLA(currentFunctionaryIsSla);
            complaintIndex.setCurrentFunctionaryIfSLA(currentFunctionaryIfSla);
            complaintIndex.setEscalation1FunctionaryName(escalation1FunctionaryName);
            if (searchableObject.get("escalation1FunctionaryAssigneddate") != null) {
                complaintIndex.setEscalation1FunctionaryAssigneddate(this.formatDate(searchableObject.get("escalation1FunctionaryAssigneddate").toString()));
            }
            complaintIndex.setEscalation1FunctionarySLADays(escalation1FunctionarySlaDays);
            complaintIndex.setEscalation1FunctionaryAgeingFromDue(escalation1AgeingFromDue);
            complaintIndex.setEscalation1FunctionaryIsSLA(escalation1FunctionaryIsSla);
            complaintIndex.setEscalation1FunctionaryIfSLA(escalation1FunctionaryIfSla);
            complaintIndex.setEscalation2FunctionaryName(escalation2FunctionaryName);
            if (searchableObject.get("escalation2FunctionaryAssigneddate") != null) {
                complaintIndex.setEscalation2FunctionaryAssigneddate(this.formatDate(searchableObject.get("escalation2FunctionaryAssigneddate").toString()));
            }
            complaintIndex.setEscalation2FunctionarySLADays(escalation2FunctionarySlaDays);
            complaintIndex.setEscalation2FunctionaryAgeingFromDue(escalation2AgeingFromDue);
            complaintIndex.setEscalation2FunctionaryIsSLA(escalation2FunctionaryIsSla);
            complaintIndex.setEscalation2FunctionaryIfSLA(escalation2FunctionaryIfSla);
            complaintIndex.setEscalation3FunctionaryName(escalation3FunctionaryName);
            if (searchableObject.get("escalation3FunctionaryAssigneddate") != null) {
                complaintIndex.setEscalation3FunctionaryAssigneddate(this.formatDate(searchableObject.get("escalation3FunctionaryAssigneddate").toString()));
            }
            complaintIndex.setEscalation3FunctionarySLADays(escalation3FunctionarySlaDays);
            complaintIndex.setEscalation3FunctionaryAgeingFromDue(escalation3AgeingFromDue);
            complaintIndex.setEscalation3FunctionaryIsSLA(escalation3FunctionaryIsSla);
            complaintIndex.setEscalation3FunctionaryIfSLA(escalation3FunctionaryIfSla);
            complaintIndex.setEscalationLevel(escalationLevel);
            complaintIndex.setDurationRange(durationRange);
            complaintIndex.setReasonForRejection(reasonForRejection);
            complaintIndex.setRegistered(registered);
            complaintIndex.setReOpened(reOpened);
            if (searchableObject.get("complaintReOpenedDate") != null) {
                complaintIndex.setComplaintReOpenedDate(this.formatDate(searchableObject.get("complaintReOpenedDate").toString()));
            }
        }
        return complaintIndex;
    }

    private boolean checkComplaintStatusFromIndex(ComplaintIndex complaintIndex) {
        SearchResult searchResult = this.searchService.search(Arrays.asList(Index.PGR.toString()), Arrays.asList(IndexType.COMPLAINT.toString()), null, complaintIndex.searchFilters(), Sort.NULL, Page.NULL);
        if (!searchResult.getDocuments().isEmpty()) {
            List documents = searchResult.getDocuments();
            LinkedHashMap clausesObject = (LinkedHashMap)((Document)documents.get(0)).getResource().get((Object)"clauses");
            String status = clausesObject.get("status") == null ? "" : clausesObject.get("status").toString();
            return status.contains("REOPENED");
        }
        return true;
    }

    public Date formatDate(String date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        try {
            return formatter.parse(date);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private ComplaintIndex updateComplaintIndexStatusRelatedFields(ComplaintIndex complaintIndex) {
        if (complaintIndex.getStatus().getName().equalsIgnoreCase(ComplaintStatus.PROCESSING.toString()) || complaintIndex.getStatus().getName().equalsIgnoreCase(ComplaintStatus.FORWARDED.toString()) || complaintIndex.getStatus().getName().equalsIgnoreCase(ComplaintStatus.REGISTERED.toString())) {
            complaintIndex.setInProcess(1);
            complaintIndex.setAddressed(0);
            complaintIndex.setRejected(0);
        }
        if (complaintIndex.getStatus().getName().equalsIgnoreCase(ComplaintStatus.COMPLETED.toString()) || complaintIndex.getStatus().getName().equalsIgnoreCase(ComplaintStatus.WITHDRAWN.toString())) {
            complaintIndex.setInProcess(0);
            complaintIndex.setAddressed(1);
            complaintIndex.setRejected(0);
        }
        if (complaintIndex.getStatus().getName().equalsIgnoreCase(ComplaintStatus.REJECTED.toString())) {
            complaintIndex.setInProcess(0);
            complaintIndex.setAddressed(0);
            complaintIndex.setRejected(1);
        }
        if (complaintIndex.getStatus().getName().equalsIgnoreCase(ComplaintStatus.REOPENED.toString())) {
            complaintIndex.setInProcess(1);
            complaintIndex.setAddressed(0);
            complaintIndex.setRejected(0);
            complaintIndex.setReOpened(1);
        }
        return complaintIndex;
    }
}

