/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.validation.ValidationException;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.EisCommonService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.RoleService;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.infra.utils.StringUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.enums.ComplaintStatus;
import org.egov.pgr.entity.enums.ReceivingMode;
import org.egov.pgr.repository.ComplaintRepository;
import org.egov.pgr.service.ComplaintRouterService;
import org.egov.pgr.service.ComplaintStatusService;
import org.egov.pgr.service.EscalationService;
import org.egov.pims.commons.Position;
import org.egov.portal.entity.CitizenInbox;
import org.egov.portal.entity.CitizenInboxBuilder;
import org.egov.portal.entity.enums.MessageType;
import org.egov.portal.entity.enums.Priority;
import org.egov.portal.service.CitizenInboxService;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ComplaintService {
    private static final Logger LOG = LoggerFactory.getLogger(ComplaintService.class);
    @Autowired
    private ComplaintRepository complaintRepository;
    @Autowired
    private ComplaintStatusService complaintStatusService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ComplaintRouterService complaintRouterService;
    @Autowired
    private EisCommonService eisCommonService;
    @Autowired
    private CitizenInboxService citizenInboxService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    private EscalationService escalationService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private RoleService roleService;
    @Autowired
    private AssignmentService assignmentService;
    @PersistenceContext
    private EntityManager entityManager;
    final String[] pendingStatus = new String[]{"REGISTERED", "FORWARDED", "PROCESSING", "NOTCOMPLETED", "REOPENED"};
    final String[] completedStatus = new String[]{"COMPLETED", "WITHDRAWN", "CLOSED"};
    final String[] rejectedStatus = new String[]{"REJECTED"};
    final String[] resolvedStatus = new String[]{"COMPLETED", "WITHDRAWN", "CLOSED", "REJECTED"};
    public final String COMPLAINT_ALL = "ALL";
    public final String COMPLAINT_PENDING = "PENDING";
    public final String COMPLAINT_COMPLETED = "COMPLETED";
    public final String COMPLAINT_REJECTED = "REJECTED";
    public final String COMPLAINTS_FILED = "FILED";
    public final String COMPLAINTS_RESOLVED = "RESOLVED";
    public final String COMPLAINTS_UNRESOLVED = "UNRESOLVED";

    @Transactional
    public Complaint createComplaint(Complaint complaint) throws ValidationException {
        if (StringUtils.isBlank((String)complaint.getCrn())) {
            complaint.setCrn(this.applicationNumberGenerator.generate());
        }
        User user = this.securityUtils.getCurrentUser();
        complaint.getComplainant().setUserDetail(user);
        if (!SecurityUtils.isCurrentUserAnonymous() && this.securityUtils.currentUserType().equals((Object)UserType.CITIZEN)) {
            complaint.getComplainant().setEmail(user.getEmailId());
            complaint.getComplainant().setName(user.getName());
            complaint.getComplainant().setMobile(user.getMobileNumber());
        }
        complaint.setStatus(this.complaintStatusService.getByName("REGISTERED"));
        if (complaint.getLocation() == null && complaint.getLat() != 0.0 && complaint.getLng() != 0.0) {
            try {
                Long bndryId = this.boundaryService.getBoundaryIdFromShapefile(Double.valueOf(complaint.getLat()), Double.valueOf(complaint.getLng()));
                if (bndryId == null || bndryId == 0L) {
                    throw new ValidationException("gis.location.info.not.found");
                }
                Boundary location = this.boundaryService.getBoundaryById(bndryId);
                complaint.setLocation(location);
            }
            catch (Exception e) {
                throw new ValidationException("gis.location.info.not.found");
            }
        }
        Position assignee = this.complaintRouterService.getAssignee(complaint);
        complaint.transition().start().withSenderName(complaint.getComplainant().getName()).withComments("Grievance registered with Complaint Number : " + complaint.getCrn()).withStateValue(complaint.getStatus().getName()).withOwner(assignee).withDateInfo(new Date());
        complaint.setAssignee(assignee);
        complaint.setEscalationDate(new DateTime());
        complaint.setEscalationDate(this.escalationService.getExpiryDate(complaint));
        if (null != complaint.getComplaintType() && null != complaint.getComplaintType().getDepartment()) {
            complaint.setDepartment(complaint.getComplaintType().getDepartment());
        } else if (null != assignee) {
            complaint.setDepartment(assignee.getDeptDesig().getDepartment());
        }
        Complaint savedComplaint = (Complaint)((Object)this.complaintRepository.save((Object)complaint));
        this.pushMessage(savedComplaint);
        this.sendEmailandSms(complaint);
        return savedComplaint;
    }

    @Transactional
    public Complaint update(Complaint complaint, Long approvalPosition, String approvalComent) {
        Role goRole = this.roleService.getRoleByName("Grievance Officer");
        String userName = null;
        userName = this.securityUtils.getCurrentUser().getType().equals((Object)UserType.CITIZEN) ? this.securityUtils.getCurrentUser().getName() : this.securityUtils.getCurrentUser().getUsername() + "::" + this.securityUtils.getCurrentUser().getName();
        if (complaint.getStatus().getName().equalsIgnoreCase(ComplaintStatus.COMPLETED.toString()) || complaint.getStatus().getName().equalsIgnoreCase(ComplaintStatus.WITHDRAWN.toString()) || complaint.getStatus().getName().equalsIgnoreCase(ComplaintStatus.REJECTED.toString())) {
            complaint.setDepartment(complaint.getAssignee().getDeptDesig().getDepartment());
            LOG.debug("Terminating Grievance Workflow");
            if (!this.securityUtils.getCurrentUser().getRoles().contains(goRole)) {
                complaint.transition(true).end().withComments(approvalComent).withStateValue(complaint.getStatus().getName()).withSenderName(userName).withDateInfo(new Date());
            } else {
                complaint.transition(true).end().withComments(approvalComent).withStateValue(complaint.getStatus().getName()).withSenderName(userName).withDateInfo(new Date()).withOwner(complaint.getState().getOwnerPosition());
            }
        } else if (null != approvalPosition && !approvalPosition.equals(0L)) {
            Position owner = this.positionMasterService.getPositionById(approvalPosition);
            complaint.setAssignee(owner);
            complaint.setDepartment(complaint.getAssignee().getDeptDesig().getDepartment());
            if (!this.securityUtils.getCurrentUser().getRoles().contains(goRole)) {
                complaint.transition(true).withOwner(owner).withComments(approvalComent).withSenderName(userName).withStateValue(complaint.getStatus().getName()).withDateInfo(new Date());
            } else {
                complaint.transition(true).withComments(approvalComent).withStateValue(complaint.getStatus().getName()).withSenderName(userName).withDateInfo(new Date()).withOwner(owner);
            }
        } else {
            complaint.setDepartment(complaint.getAssignee().getDeptDesig().getDepartment());
            if (!this.securityUtils.getCurrentUser().getRoles().contains(goRole)) {
                complaint.transition(true).withComments(approvalComent).withSenderName(userName).withStateValue(complaint.getStatus().getName()).withDateInfo(new Date());
            } else {
                complaint.transition(true).withComments(approvalComent).withSenderName(userName).withStateValue(complaint.getStatus().getName()).withDateInfo(new Date()).withOwner(complaint.getState().getOwnerPosition());
            }
        }
        Complaint savedComplaint = (Complaint)((Object)this.complaintRepository.saveAndFlush((Object)complaint));
        this.pushMessage(savedComplaint);
        if (complaint.getStatus().getName().equalsIgnoreCase(ComplaintStatus.COMPLETED.toString()) || complaint.getStatus().getName().equalsIgnoreCase(ComplaintStatus.REJECTED.toString())) {
            this.sendSmsOnCompletion(savedComplaint);
        }
        if (!(complaint.getStatus().getName().equalsIgnoreCase(ComplaintStatus.COMPLETED.toString()) || complaint.getStatus().getName().equalsIgnoreCase(ComplaintStatus.REJECTED.toString()) || complaint.getStatus().getName().equalsIgnoreCase(ComplaintStatus.WITHDRAWN.toString()))) {
            this.sendSmsToOfficials(savedComplaint);
        }
        return savedComplaint;
    }

    public Complaint getComplaintById(Long complaintID) {
        return (Complaint)((Object)this.complaintRepository.findOne(complaintID));
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public Complaint getComplaintByCRN(String crn) {
        return this.complaintRepository.findByCrn(crn);
    }

    public List<Complaint> getComplaintsEligibleForEscalation() {
        Criteria criteria = this.getCurrentSession().createCriteria(Complaint.class, "complaint").createAlias("complaint.status", "complaintStatus");
        criteria.add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.eq((String)"complaintStatus.name", (Object)ComplaintStatus.REOPENED.name())).add((Criterion)Restrictions.eq((String)"complaintStatus.name", (Object)ComplaintStatus.FORWARDED.name())).add((Criterion)Restrictions.eq((String)"complaintStatus.name", (Object)ComplaintStatus.PROCESSING.name())).add((Criterion)Restrictions.eq((String)"complaintStatus.name", (Object)ComplaintStatus.REGISTERED.name()))).add((Criterion)Restrictions.lt((String)"complaint.escalationDate", (Object)new DateTime().toDate())).setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return criteria.list();
    }

    private void pushMessage(Complaint savedComplaint) {
        CitizenInboxBuilder citizenInboxBuilder = new CitizenInboxBuilder(MessageType.USER_MESSAGE, this.getHeaderMessage(savedComplaint), this.getDetailedMessage(savedComplaint), savedComplaint.getLastModifiedDate(), savedComplaint.getCreatedBy(), Priority.High);
        String strQuery = "select md from Module md where md.name=:name";
        Query hql = this.getCurrentSession().createQuery("select md from Module md where md.name=:name");
        hql.setParameter("name", (Object)"PGR");
        citizenInboxBuilder.module((Module)hql.uniqueResult());
        citizenInboxBuilder.identifier(savedComplaint.getCrn());
        citizenInboxBuilder.link("/pgr/complaint/update/" + savedComplaint.getCrn());
        citizenInboxBuilder.state(savedComplaint.getState());
        citizenInboxBuilder.status(savedComplaint.getStatus().getName());
        CitizenInbox citizenInbox = citizenInboxBuilder.build();
        this.citizenInboxService.pushMessage(citizenInbox);
    }

    private String getHeaderMessage(Complaint savedComplaint) {
        StringBuilder headerMessage = new StringBuilder();
        if (savedComplaint.getStatus().getName().equals("REGISTERED")) {
            headerMessage.append("Grievance Recorded");
        } else {
            headerMessage.append("Grievance Redressal");
        }
        return headerMessage.toString();
    }

    private String getDetailedMessage(Complaint savedComplaint) {
        StringBuilder detailedMessage = new StringBuilder();
        detailedMessage.append("Grievance No. ").append(savedComplaint.getCrn()).append(" regarding ").append(savedComplaint.getComplaintType().getName()).append(" in ").append(savedComplaint.getStatus().getName()).append(" status.");
        return detailedMessage.toString();
    }

    public List<Hashtable<String, Object>> getHistory(Complaint complaint) {
        User user = null;
        ArrayList<Hashtable<String, Object>> historyTable = new ArrayList<Hashtable<String, Object>>();
        State state = complaint.getState();
        Hashtable<String, Object> map = new Hashtable<String, Object>(0);
        map.put("date", state.getDateInfo());
        map.put("comments", state.getComments() != null ? state.getComments() : "");
        if (state.getLastModifiedBy().getType().equals((Object)UserType.CITIZEN) || state.getLastModifiedBy().getType().equals((Object)UserType.SYSTEM)) {
            map.put("updatedBy", complaint.getComplainant().getName());
        } else {
            map.put("updatedBy", state.getSenderName() != null ? state.getSenderName() : state.getLastModifiedBy().getUsername() + "::" + state.getLastModifiedBy().getName());
        }
        map.put("updatedUserType", state.getLastModifiedBy().getType());
        map.put("status", state.getValue());
        Position ownerPosition = state.getOwnerPosition();
        user = state.getOwnerUser();
        if (null != user) {
            map.put("user", user.getUsername() + "::" + user.getName());
            map.put("usertype", null != user ? user.getType() : "");
            map.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
        } else if (null != ownerPosition && null != ownerPosition.getDeptDesig()) {
            List assignmentList = this.assignmentService.getAssignmentsForPosition(ownerPosition.getId(), new Date());
            user = !assignmentList.isEmpty() ? ((Assignment)assignmentList.get(0)).getEmployee() : null;
            map.put("user", null != user ? user.getUsername() + "::" + user.getName() + "::" + ownerPosition.getDeptDesig().getDesignation().getName() : "NO ASSIGNMENT::" + ownerPosition.getName());
            map.put("usertype", null != user ? user.getType() : "");
            map.put("department", null != ownerPosition.getDeptDesig().getDepartment() ? ownerPosition.getDeptDesig().getDepartment().getName() : "");
        }
        historyTable.add(map);
        if (!complaint.getStateHistory().isEmpty() && complaint.getStateHistory() != null) {
            List complaintStateHistory = complaint.getStateHistory();
            Collections.reverse(complaintStateHistory);
            for (StateHistory stateHistory : complaintStateHistory) {
                Hashtable<String, Object> HistoryMap = new Hashtable<String, Object>(0);
                HistoryMap.put("date", stateHistory.getDateInfo());
                HistoryMap.put("comments", stateHistory.getComments() != null ? stateHistory.getComments() : "");
                if (stateHistory.getLastModifiedBy().getType().equals((Object)UserType.CITIZEN) || stateHistory.getLastModifiedBy().getType().equals((Object)UserType.SYSTEM)) {
                    HistoryMap.put("updatedBy", complaint.getComplainant().getName());
                } else {
                    HistoryMap.put("updatedBy", stateHistory.getSenderName());
                }
                HistoryMap.put("updatedUserType", stateHistory.getLastModifiedBy().getType());
                HistoryMap.put("status", stateHistory.getValue());
                Position owner = stateHistory.getOwnerPosition();
                user = stateHistory.getOwnerUser();
                if (null != user) {
                    HistoryMap.put("user", user.getUsername() + "::" + user.getName());
                    HistoryMap.put("usertype", null != user ? user.getType() : "");
                    HistoryMap.put("department", null != this.eisCommonService.getDepartmentForUser(user.getId()) ? this.eisCommonService.getDepartmentForUser(user.getId()).getName() : "");
                } else if (null != owner && null != owner.getDeptDesig()) {
                    List assignments = this.assignmentService.getAssignmentsForPosition(owner.getId(), new Date());
                    user = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee() : null;
                    HistoryMap.put("user", null != user ? user.getUsername() + "::" + user.getName() + "::" + owner.getDeptDesig().getDesignation().getName() : "NO ASSIGNMENT::" + owner.getName());
                    HistoryMap.put("usertype", null != user ? user.getType() : "");
                    HistoryMap.put("department", null != owner.getDeptDesig().getDepartment() ? owner.getDeptDesig().getDepartment().getName() : "");
                }
                historyTable.add(HistoryMap);
            }
        }
        return historyTable;
    }

    public void sendEmailandSms(Complaint complaint) {
        Employee user;
        List assignments;
        String formattedCreatedDate = new SimpleDateFormat("dd/MM/yyyy HH:mm").format(complaint.getCreatedDate());
        StringBuffer emailBody = new StringBuffer().append("Dear ").append(complaint.getComplainant().getName()).append(",\n \n \tThank you for registering a grievance (").append(complaint.getCrn()).append("). Your grievance is registered successfully.\n \tPlease use this number for all future references.").append("\n \n Grievance Details - \n \n Complaint type - ").append(complaint.getComplaintType().getName());
        if (complaint.getLocation() != null) {
            emailBody.append(" \n Location details - ").append(complaint.getLocation().getName());
        }
        emailBody.append("\n Grievance description - ").append(complaint.getDetails()).append("\n Grievance status -").append(complaint.getStatus().getName()).append("\n Grievance Registration Date - ").append(formattedCreatedDate);
        StringBuffer emailSubject = new StringBuffer().append("Registered Grievance -").append(complaint.getCrn()).append(" successfuly");
        StringBuffer smsBody = new StringBuffer().append("Your grievance for ").append(complaint.getComplaintType().getName()).append(" has been registered successfully with tracking number (").append(complaint.getCrn()).append("). Please use this number for all future references.");
        this.messagingService.sendEmail(complaint.getComplainant().getEmail(), emailSubject.toString(), emailBody.toString());
        this.messagingService.sendSMS(complaint.getComplainant().getMobile(), smsBody.toString());
        Position owner = complaint.getState().getOwnerPosition();
        if (null != owner && null != owner.getDeptDesig() && !(assignments = this.assignmentService.getAssignmentsForPosition(owner.getId(), new Date())).isEmpty() && null != (user = ((Assignment)assignments.get(0)).getEmployee())) {
            StringBuffer smsBodyOfficial = new StringBuffer().append("New Grievance for ").append(complaint.getComplaintType().getName()).append(" is registered by ").append(complaint.getComplainant().getName() == null ? "Anonymous User" : complaint.getComplainant().getName()).append(", ").append(complaint.getComplainant().getMobile() == null ? "" : complaint.getComplainant().getMobile()).append(" at ").append(complaint.getLocation().getName());
            if (complaint.getLatlngAddress() != null) {
                smsBodyOfficial.append(", " + complaint.getLatlngAddress());
            } else {
                smsBodyOfficial.append(complaint.getChildLocation() != null ? ", " + complaint.getChildLocation().getName() : "");
            }
            smsBodyOfficial.append(complaint.getLandmarkDetails() != null ? ", " + complaint.getLandmarkDetails() : "");
            this.messagingService.sendSMS(user.getMobileNumber(), smsBodyOfficial.toString());
        }
    }

    public void sendSmsOnCompletion(Complaint complaint) {
        StringBuffer smsBody = new StringBuffer().append("Your Grievance regarding ").append(complaint.getComplaintType().getName()).append(" with tracking number '").append(complaint.getCrn()).append("' is updated to ").append(complaint.getStatus().getName());
        this.messagingService.sendSMS(complaint.getComplainant().getMobile(), smsBody.toString());
    }

    public void sendSmsToOfficials(Complaint complaint) {
        User user;
        Position owner = complaint.getState().getOwnerPosition();
        String senderName = "";
        String string = senderName = complaint.getState().getSenderName().contains("::") ? complaint.getState().getSenderName().split("::")[1] : complaint.getState().getSenderName();
        if (null != owner && null != owner.getDeptDesig() && null != (user = this.eisCommonService.getUserForPosition(owner.getId(), new Date()))) {
            StringBuffer smsBodyOfficial = new StringBuffer().append(user.getName() + ", ").append(complaint.getCrn() + " by ").append(complaint.getComplainant().getName() == null ? "Anonymous User" : complaint.getComplainant().getName()).append(", ").append(complaint.getComplainant().getMobile() == null ? "" : complaint.getComplainant().getMobile()).append(" for " + complaint.getComplaintType().getName() + " from ").append(complaint.getLocation().getName());
            if (complaint.getLatlngAddress() != null) {
                smsBodyOfficial.append(", " + complaint.getLatlngAddress());
            } else {
                smsBodyOfficial.append(complaint.getChildLocation() != null ? ", " + complaint.getChildLocation().getName() : "");
            }
            smsBodyOfficial.append(complaint.getLandmarkDetails() != null ? ", " + complaint.getLandmarkDetails() : "");
            smsBodyOfficial.append(" handled by " + senderName + " has been Forwarded to you.");
            this.messagingService.sendSMS(user.getMobileNumber(), smsBodyOfficial.toString());
        }
    }

    public List<ReceivingMode> getAllReceivingModes() {
        return Arrays.asList(ReceivingMode.values());
    }

    public Page<Complaint> getLatest(int page, int pageSize) {
        int offset = page - 1;
        return this.complaintRepository.findByLatestComplaint(this.securityUtils.getCurrentUser(), (Pageable)new PageRequest(offset, pageSize));
    }

    public Page<Complaint> getMyComplaint(int page, int pageSize) {
        int offset = page - 1;
        return this.complaintRepository.findByMyComplaint(this.securityUtils.getCurrentUser(), (Pageable)new PageRequest(offset, pageSize));
    }

    public List<Complaint> getNearByComplaint(int page, float lat, float lng, int distance, int pageSize) {
        Long offset = new Long((page - 1) * pageSize);
        Long limit = new Long(pageSize + 1);
        return this.complaintRepository.findByNearestComplaint(this.securityUtils.getCurrentUser().getId(), new Float(lat), new Float(lng), new Long(distance), limit, offset);
    }

    public String getEmailBody(Complaint complaint) {
        String formattedCreatedDate = new SimpleDateFormat("dd/MM/yyyy HH:mm").format(complaint.getCreatedDate());
        StringBuffer emailBody = new StringBuffer().append(" %0D%0A Grievance Details -  %0D%0A %0D%0A CRN - ").append(complaint.getCrn()).append(" %0D%0A Grievance Type -").append(complaint.getComplaintType().getName());
        if (complaint.getDepartment() != null) {
            emailBody.append("  %0D%0A Grievance department  - ").append(complaint.getDepartment().getName());
        }
        if (complaint.getComplainant().getName() != null) {
            emailBody.append("  %0D%0A Complainant name - ").append(complaint.getComplainant().getName());
        }
        if (complaint.getComplainant().getMobile() != null) {
            emailBody.append("  %0D%0A Complainant mobile number - ").append(complaint.getComplainant().getMobile());
        }
        if (complaint.getLocation() != null) {
            emailBody.append("  %0D%0A Location details - ").append(complaint.getLocation().getName());
        }
        emailBody.append(" %0D%0A Grievance details - ").append(complaint.getDetails()).append(" %0D%0A Grievance status -").append(complaint.getStatus().getName()).append(" %0D%0A Grievance Registration Date - ").append(formattedCreatedDate);
        return emailBody.toString();
    }

    public List<Complaint> getPendingGrievances() {
        User user = this.securityUtils.getCurrentUser();
        Object[] pendingStatus = new String[]{"REGISTERED", "FORWARDED", "PROCESSING", "NOTCOMPLETED", "REOPENED"};
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(Complaint.class, "complaint").createAlias("complaint.state", "state").createAlias("complaint.status", "status");
        criteria.add(Restrictions.in((String)"status.name", (Object[])pendingStatus));
        criteria.add((Criterion)Restrictions.eq((String)"complaint.assignee", (Object)this.positionMasterService.getCurrentPositionForUser(user.getId())));
        return criteria.list();
    }

    public Page<Complaint> getMyPendingGrievances(int page, int pageSize) {
        int offset = page - 1;
        return this.complaintRepository.findMyComplaintyByStatus(this.securityUtils.getCurrentUser(), this.pendingStatus, (Pageable)new PageRequest(offset, pageSize));
    }

    public Page<Complaint> getMyCompletedGrievances(int page, int pageSize) {
        int offset = page - 1;
        return this.complaintRepository.findMyComplaintyByStatus(this.securityUtils.getCurrentUser(), this.completedStatus, (Pageable)new PageRequest(offset, pageSize));
    }

    public Page<Complaint> getMyRejectedGrievances(int page, int pageSize) {
        int offset = page - 1;
        return this.complaintRepository.findMyComplaintyByStatus(this.securityUtils.getCurrentUser(), this.rejectedStatus, (Pageable)new PageRequest(offset, pageSize));
    }

    public HashMap<String, Integer> getMyComplaintsCount() {
        HashMap<String, Integer> complaintsCount = new HashMap<String, Integer>();
        complaintsCount.put("ALL", this.complaintRepository.getMyComplaintsTotalCount(this.securityUtils.getCurrentUser()).intValue());
        complaintsCount.put("PENDING", this.complaintRepository.getMyComplaintCountByStatus(this.securityUtils.getCurrentUser(), this.pendingStatus).intValue());
        complaintsCount.put("COMPLETED", this.complaintRepository.getMyComplaintCountByStatus(this.securityUtils.getCurrentUser(), this.completedStatus).intValue());
        complaintsCount.put("REJECTED", this.complaintRepository.getMyComplaintCountByStatus(this.securityUtils.getCurrentUser(), this.rejectedStatus).intValue());
        return complaintsCount;
    }

    public HashMap<String, Integer> getComplaintsTotalCount() {
        HashMap<String, Integer> complaintsCount = new HashMap<String, Integer>();
        complaintsCount.put("FILED", this.complaintRepository.getTotalComplaintsCount().intValue());
        complaintsCount.put("RESOLVED", this.complaintRepository.getComplaintsTotalCountByStatus(this.resolvedStatus).intValue());
        complaintsCount.put("UNRESOLVED", this.complaintRepository.getComplaintsTotalCountByStatus(this.pendingStatus).intValue());
        return complaintsCount;
    }

    public List<Complaint> getOpenComplaints() {
        List<String> statusList = Arrays.asList("REGISTERED", "FORWARDED", "REOPENED", "PROCESSING");
        return this.complaintRepository.findByStatusNameIn(statusList);
    }
}

