/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.elasticsearch.service.advice;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.egov.infra.config.properties.ApplicationProperties;
import org.egov.pgr.elasticSearch.entity.ComplaintIndex;
import org.egov.pgr.elasticSearch.service.ComplaintIndexService;
import org.egov.pgr.entity.Complaint;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ComplaintIndexingAdvice {
    private static final Logger LOG = LoggerFactory.getLogger(ComplaintIndexingAdvice.class);
    @Autowired
    private ComplaintIndexService complaintIndexService;
    @Autowired
    private ApplicationProperties applicationProperties;

    @AfterReturning(pointcut="execution(*  org.egov.pgr.service.ComplaintService.createComplaint (..))", returning="retVal")
    public void createComplaintIndex(Object retVal) {
        Complaint savedComplaint = (Complaint)((Object)retVal);
        ComplaintIndex savedComplaintIndex = new ComplaintIndex();
        BeanUtils.copyProperties((Object)((Object)savedComplaint), (Object)((Object)savedComplaintIndex));
        try {
            this.complaintIndexService.createComplaintIndex(savedComplaintIndex);
        }
        catch (NoNodeAvailableException exception) {
            if (this.applicationProperties.devMode()) {
                LOG.error("An error occurred, None of the Elastic search nodes are Available ", (Throwable)exception);
            }
            throw exception;
        }
    }

    @AfterReturning(pointcut="execution(* org.egov.pgr.service.ComplaintService.update (..))", returning="retVal")
    public void updateComplaintIndex(JoinPoint joinPoint, Object retVal) {
        Complaint savedComplaint = (Complaint)((Object)retVal);
        Object[] arguments = joinPoint.getArgs();
        ComplaintIndex savedComplaintIndex = new ComplaintIndex();
        BeanUtils.copyProperties((Object)((Object)savedComplaint), (Object)((Object)savedComplaintIndex));
        try {
            this.complaintIndexService.updateComplaintIndex(savedComplaintIndex, Long.valueOf(arguments[1].toString()), arguments[2].toString());
        }
        catch (NoNodeAvailableException exception) {
            if (this.applicationProperties.devMode()) {
                LOG.error("An error occurred, None of the Elastic search nodes are Available ", (Throwable)exception);
            }
            throw exception;
        }
    }
}

