/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service.es;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.time.DateUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.es.CityIndex;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.es.CityIndexService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.config.mapper.BeanMapperConfiguration;
import org.egov.infra.persistence.entity.enums.UserType;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.Escalation;
import org.egov.pgr.entity.enums.ComplaintStatus;
import org.egov.pgr.entity.enums.ReceivingMode;
import org.egov.pgr.entity.es.ComplaintDashBoardRequest;
import org.egov.pgr.entity.es.ComplaintDashBoardResponse;
import org.egov.pgr.entity.es.ComplaintIndex;
import org.egov.pgr.entity.es.ComplaintSourceResponse;
import org.egov.pgr.repository.es.ComplaintIndexRepository;
import org.egov.pgr.repository.es.util.ComplaintElasticsearchUtils;
import org.egov.pgr.service.ComplaintService;
import org.egov.pgr.service.EscalationService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.bucket.filter.Filter;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.avg.Avg;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class ComplaintIndexService {
    @Autowired
    private CityService cityService;
    @Autowired
    private EscalationService escalationService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private Environment environment;
    @Autowired
    private CityIndexService cityIndexService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private ComplaintIndexRepository complaintIndexRepository;
    @Autowired
    private BeanMapperConfiguration beanMapperConfiguration;
    @Autowired
    private ComplaintService complaintService;

    public void createComplaintIndex(Complaint complaint) {
        ComplaintIndex complaintIndex = new ComplaintIndex();
        this.beanMapperConfiguration.map((Object)complaint, (Object)complaintIndex);
        City city = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        complaintIndex.setCityCode(city.getCode());
        complaintIndex.setCityDistrictCode(city.getDistrictCode());
        complaintIndex.setCityDistrictName(city.getDistrictName());
        complaintIndex.setCityGrade(city.getGrade());
        complaintIndex.setCityDomainUrl(city.getDomainURL());
        complaintIndex.setCityName(city.getName());
        complaintIndex.setCityRegionName(city.getRegionName());
        if (complaint.getReceivingMode().equals((Object)ReceivingMode.MOBILE) && complaint.getCreatedBy().getType().equals((Object)UserType.CITIZEN)) {
            complaintIndex.setSource(this.environment.getProperty("complaint.source.citizen.app"));
        }
        if (complaint.getReceivingMode().equals((Object)ReceivingMode.MOBILE) && complaint.getCreatedBy().getType().equals((Object)UserType.EMPLOYEE)) {
            complaintIndex.setSource(this.environment.getProperty("complaint.source.emp.app"));
        } else if (complaint.getReceivingMode().equals((Object)ReceivingMode.WEBSITE) && complaint.getCreatedBy().getType().equals((Object)UserType.CITIZEN)) {
            complaintIndex.setSource(this.environment.getProperty("complaint.source.portal.citizen"));
        } else if (complaint.getReceivingMode().equals((Object)ReceivingMode.WEBSITE) && complaint.getCreatedBy().getType().equals((Object)UserType.SYSTEM)) {
            complaintIndex.setSource(this.environment.getProperty("complaint.source.portal.anonymous"));
        } else if (complaint.getReceivingMode().equals((Object)ReceivingMode.WEBSITE) && complaint.getCreatedBy().getType().equals((Object)UserType.EMPLOYEE)) {
            complaintIndex.setSource(this.environment.getProperty("complaint.source.emp.website"));
        } else if (complaint.getReceivingMode().equals((Object)ReceivingMode.CALL) && complaint.getCreatedBy().getType().equals((Object)UserType.EMPLOYEE)) {
            complaintIndex.setSource(this.environment.getProperty("complaint.source.website.emp.phone"));
        } else if (complaint.getReceivingMode().equals((Object)ReceivingMode.EMAIL) && complaint.getCreatedBy().getType().equals((Object)UserType.EMPLOYEE)) {
            complaintIndex.setSource(this.environment.getProperty("complaint.source.website.emp.email"));
        } else if (complaint.getReceivingMode().equals((Object)ReceivingMode.MANUAL) && complaint.getCreatedBy().getType().equals((Object)UserType.EMPLOYEE)) {
            complaintIndex.setSource(this.environment.getProperty("complaint.source.website.emp.manual"));
        }
        complaintIndex.setIsClosed(false);
        complaintIndex.setComplaintIsClosed("N");
        complaintIndex.setIfClosed(0);
        complaintIndex.setComplaintDuration(0.0);
        complaintIndex.setDurationRange("");
        Position position = complaint.getAssignee();
        List assignments = this.assignmentService.getAssignmentsForPosition(position.getId(), new Date());
        Employee assignedUser = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee() : null;
        complaintIndex.setComplaintPeriod(0.0);
        complaintIndex.setComplaintSLADays(complaint.getComplaintType().getSlaHours().intValue());
        complaintIndex.setComplaintAgeingFromDue(0.0);
        complaintIndex.setIsSLA("Y");
        complaintIndex.setIfSLA(1);
        complaintIndex.setInitialFunctionaryName(assignedUser != null ? assignedUser.getName() : "NO ASSIGNMENT:" + position.getDeptDesig().getDesignation().getName());
        complaintIndex.setInitialFunctionaryAssigneddate(new Date());
        complaintIndex.setInitialFunctionarySLADays(this.getFunctionarySlaDays(complaint));
        complaintIndex.setInitialFunctionaryAgeingFromDue(0.0);
        complaintIndex.setInitialFunctionaryIsSLA("Y");
        complaintIndex.setInitialFunctionaryIfSLA(1);
        complaintIndex.setCurrentFunctionaryName(assignedUser != null ? assignedUser.getName() : "NO ASSIGNMENT:" + position.getDeptDesig().getDesignation().getName());
        complaintIndex.setCurrentFunctionaryMobileNumber(Objects.nonNull(assignedUser) ? assignedUser.getMobileNumber() : "");
        complaintIndex.setCurrentFunctionaryAssigneddate(new Date());
        complaintIndex.setCurrentFunctionarySLADays(this.getFunctionarySlaDays(complaint));
        complaintIndex.setCurrentFunctionaryAgeingFromDue(0.0);
        complaintIndex.setCurrentFunctionaryIsSLA("Y");
        complaintIndex.setCurrentFunctionaryIfSLA(1);
        complaintIndex.setEscalationLevel(0);
        complaintIndex.setReasonForRejection("");
        complaintIndex.setRegistered(1);
        complaintIndex.setInProcess(1);
        complaintIndex.setAddressed(0);
        complaintIndex.setRejected(0);
        complaintIndex.setReOpened(0);
        complaintIndex.setComplaintAgeingdaysFromDue(0L);
        this.complaintIndexRepository.save(complaintIndex);
    }

    public void updateComplaintIndex(Complaint complaint, Long approvalPosition, String approvalComment) {
        Employee assignedUser;
        ComplaintIndex complaintIndex = this.complaintIndexRepository.findByCrn(complaint.getCrn());
        String status = complaintIndex.getComplaintStatusName();
        this.beanMapperConfiguration.map((Object)complaint, (Object)complaintIndex);
        City city = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        complaintIndex.setCityCode(city.getCode());
        complaintIndex.setCityDistrictCode(city.getDistrictCode());
        complaintIndex.setCityDistrictName(city.getDistrictName());
        complaintIndex.setCityGrade(city.getGrade());
        complaintIndex.setCityDomainUrl(city.getDomainURL());
        complaintIndex.setCityName(city.getName());
        complaintIndex.setCityRegionName(city.getRegionName());
        Position position = complaint.getAssignee();
        List assignments = this.assignmentService.getAssignmentsForPosition(position.getId(), new Date());
        Employee employee = assignedUser = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee() : null;
        if (approvalPosition != null && !approvalPosition.equals(0L)) {
            complaintIndex.setCurrentFunctionaryName(assignedUser != null ? assignedUser.getName() : "NO ASSIGNMENT:" + position.getDeptDesig().getDesignation().getName());
            complaintIndex.setCurrentFunctionaryMobileNumber(Objects.nonNull(assignedUser) ? assignedUser.getMobileNumber() : "");
            complaintIndex.setCurrentFunctionaryAssigneddate(new Date());
            complaintIndex.setCurrentFunctionarySLADays(this.getFunctionarySlaDays(complaint));
        }
        if ((complaintIndex = this.updateComplaintLevelIndexFields(complaintIndex)).getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.COMPLETED.toString()) || complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.WITHDRAWN.toString()) || complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.REJECTED.toString())) {
            complaintIndex.setIsClosed(true);
            complaintIndex.setComplaintIsClosed("Y");
            complaintIndex.setIfClosed(1);
            complaintIndex.setClosedByFunctionaryName(assignedUser != null ? assignedUser.getName() : "NO ASSIGNMENT:" + position.getDeptDesig().getDesignation().getName());
            long duration = Math.abs(complaintIndex.getCreatedDate().getTime() - new Date().getTime()) / 86400000L;
            complaintIndex.setComplaintDuration(duration);
            if (duration < 3L) {
                complaintIndex.setDurationRange("(<3 days)");
            } else if (duration < 7L) {
                complaintIndex.setDurationRange("(3-7 days)");
            } else if (duration < 15L) {
                complaintIndex.setDurationRange("(8-15 days)");
            } else if (duration < 30L) {
                complaintIndex.setDurationRange("(16-30 days)");
            } else {
                complaintIndex.setDurationRange("(>30 days)");
            }
        } else {
            complaintIndex.setIsClosed(false);
            complaintIndex.setComplaintIsClosed("N");
            complaintIndex.setIfClosed(0);
            complaintIndex.setComplaintDuration(0.0);
            complaintIndex.setDurationRange("");
        }
        complaintIndex = this.updateComplaintIndexStatusRelatedFields(complaintIndex);
        if (complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.REOPENED.toString()) && !status.contains("REOPENED")) {
            complaintIndex.setComplaintReOpenedDate(new Date());
            complaintIndex.setIsClosed(false);
            complaintIndex.setComplaintIsClosed("N");
            complaintIndex.setIfClosed(0);
        }
        if (complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.REJECTED.toString())) {
            complaintIndex.setReasonForRejection(approvalComment);
        }
        this.complaintIndexRepository.save(complaintIndex);
    }

    public void updateComplaintEscalationIndexValues(Complaint complaint) {
        ComplaintIndex complaintIndex = this.complaintIndexRepository.findByCrn(complaint.getCrn());
        this.beanMapperConfiguration.map((Object)complaint, (Object)complaintIndex);
        Position position = complaint.getAssignee();
        List assignments = this.assignmentService.getAssignmentsForPosition(position.getId(), new Date());
        Employee assignedUser = !assignments.isEmpty() ? ((Assignment)assignments.get(0)).getEmployee() : null;
        City city = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        complaintIndex.setCityCode(city.getCode());
        complaintIndex.setCityDistrictCode(city.getDistrictCode());
        complaintIndex.setCityDistrictName(city.getDistrictName());
        complaintIndex.setCityGrade(city.getGrade());
        complaintIndex.setCityDomainUrl(city.getDomainURL());
        complaintIndex.setCityName(city.getName());
        complaintIndex.setCityRegionName(city.getRegionName());
        complaintIndex.setCurrentFunctionaryName(assignedUser != null ? assignedUser.getName() : "NO ASSIGNMENT:" + position.getDeptDesig().getDesignation().getName());
        complaintIndex.setCurrentFunctionaryMobileNumber(Objects.nonNull(assignedUser) ? assignedUser.getMobileNumber() : "");
        complaintIndex.setCurrentFunctionaryAssigneddate(new Date());
        complaintIndex.setCurrentFunctionarySLADays(this.getFunctionarySlaDays(complaint));
        complaintIndex = this.updateComplaintLevelIndexFields(complaintIndex);
        int escalationLevel = complaintIndex.getEscalationLevel();
        if (escalationLevel == 0) {
            complaintIndex.setEscalation1FunctionaryName(assignedUser != null ? assignedUser.getName() : "NO ASSIGNMENT:" + position.getDeptDesig().getDesignation().getName());
            complaintIndex.setEscalation1FunctionaryAssigneddate(new Date());
            complaintIndex.setEscalation1FunctionarySLADays(this.getFunctionarySlaDays(complaint));
            complaintIndex.setEscalation1FunctionaryAgeingFromDue(0.0);
            complaintIndex.setEscalation1FunctionaryIsSLA("Y");
            complaintIndex.setEscalation1FunctionaryIfSLA(1);
            complaintIndex.setEscalationLevel(++escalationLevel);
        } else if (escalationLevel == 1) {
            complaintIndex.setEscalation2FunctionaryName(assignedUser != null ? assignedUser.getName() : "NO ASSIGNMENT:" + position.getDeptDesig().getDesignation().getName());
            complaintIndex.setEscalation2FunctionaryAssigneddate(new Date());
            complaintIndex.setEscalation2FunctionarySLADays(this.getFunctionarySlaDays(complaint));
            complaintIndex.setEscalation2FunctionaryAgeingFromDue(0.0);
            complaintIndex.setEscalation2FunctionaryIsSLA("Y");
            complaintIndex.setEscalation2FunctionaryIfSLA(1);
            complaintIndex.setEscalationLevel(++escalationLevel);
        } else if (escalationLevel == 2) {
            complaintIndex.setEscalation3FunctionaryName(assignedUser != null ? assignedUser.getName() : "NO ASSIGNMENT:" + position.getDeptDesig().getDesignation().getName());
            complaintIndex.setEscalation3FunctionaryAssigneddate(new Date());
            complaintIndex.setEscalation3FunctionarySLADays(this.getFunctionarySlaDays(complaint));
            complaintIndex.setEscalation3FunctionaryAgeingFromDue(0.0);
            complaintIndex.setEscalation3FunctionaryIsSLA("Y");
            complaintIndex.setEscalation3FunctionaryIfSLA(1);
            complaintIndex.setEscalationLevel(++escalationLevel);
        }
        complaintIndex = this.updateEscalationLevelIndexFields(complaintIndex);
        complaintIndex = this.updateComplaintIndexStatusRelatedFields(complaintIndex);
        this.complaintIndexRepository.save(complaintIndex);
    }

    public void updateAllOpenComplaintIndex() {
        List<Complaint> openComplaints = this.complaintService.getOpenComplaints();
        for (Complaint complaint : openComplaints) {
            this.updateOpenComplaintIndex(complaint);
        }
    }

    public ComplaintIndex updateOpenComplaintIndex(Complaint complaint) {
        ComplaintIndex complaintIndex = this.complaintIndexRepository.findByCrn(complaint.getCrn());
        this.beanMapperConfiguration.map((Object)complaint, (Object)complaintIndex);
        complaintIndex = this.updateComplaintLevelIndexFields(complaintIndex);
        complaintIndex = this.updateEscalationLevelIndexFields(complaintIndex);
        complaintIndex = this.updateComplaintIndexStatusRelatedFields(complaintIndex);
        return complaintIndex;
    }

    public ComplaintIndex updateComplaintLevelIndexFields(ComplaintIndex complaintIndex) {
        long days = Math.abs(new Date().getTime() - complaintIndex.getCreatedDate().getTime()) / 86400000L;
        complaintIndex.setComplaintPeriod(days);
        Date lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getCreatedDate(), (int)((int)complaintIndex.getComplaintSLADays()));
        Date currentDate = new Date();
        if (lastDateToResolve.getTime() - currentDate.getTime() >= 0L) {
            complaintIndex.setComplaintAgeingFromDue(0.0);
            complaintIndex.setComplaintAgeingdaysFromDue(0L);
            complaintIndex.setIsSLA("Y");
            complaintIndex.setIfSLA(1);
        } else {
            long ageingDuehours = Math.abs(currentDate.getTime() - lastDateToResolve.getTime()) / 3600000L;
            long ageingDueDays = Math.abs(currentDate.getTime() - lastDateToResolve.getTime()) / 86400000L;
            complaintIndex.setComplaintAgeingFromDue(ageingDuehours);
            complaintIndex.setComplaintAgeingdaysFromDue(ageingDueDays);
            complaintIndex.setIsSLA("N");
            complaintIndex.setIfSLA(0);
        }
        if (complaintIndex.getInitialFunctionaryAssigneddate() != null) {
            lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getInitialFunctionaryAssigneddate(), (int)((int)complaintIndex.getInitialFunctionarySLADays()));
            if (lastDateToResolve.getTime() - new Date().getTime() >= 0L) {
                complaintIndex.setInitialFunctionaryAgeingFromDue(0.0);
                complaintIndex.setInitialFunctionaryIsSLA("Y");
                complaintIndex.setInitialFunctionaryIfSLA(1);
            } else {
                long initialFunctionaryAgeingDueHours = Math.abs(new Date().getTime() - lastDateToResolve.getTime()) / 3600000L;
                complaintIndex.setInitialFunctionaryAgeingFromDue(initialFunctionaryAgeingDueHours);
                complaintIndex.setInitialFunctionaryIsSLA("N");
                complaintIndex.setInitialFunctionaryIfSLA(0);
            }
        }
        if (complaintIndex.getCurrentFunctionaryAssigneddate() != null) {
            lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getCurrentFunctionaryAssigneddate(), (int)((int)complaintIndex.getCurrentFunctionarySLADays()));
            if (lastDateToResolve.getTime() - new Date().getTime() >= 0L) {
                complaintIndex.setCurrentFunctionaryAgeingFromDue(0.0);
                complaintIndex.setCurrentFunctionaryIsSLA("Y");
                complaintIndex.setCurrentFunctionaryIfSLA(1);
            } else {
                long currentFunctionaryAgeingDueHours = Math.abs(new Date().getTime() - lastDateToResolve.getTime()) / 3600000L;
                complaintIndex.setCurrentFunctionaryAgeingFromDue(currentFunctionaryAgeingDueHours);
                complaintIndex.setCurrentFunctionaryIsSLA("N");
                complaintIndex.setCurrentFunctionaryIfSLA(0);
            }
        }
        return complaintIndex;
    }

    public ComplaintIndex updateEscalationLevelIndexFields(ComplaintIndex complaintIndex) {
        Date lastDateToResolve;
        if (complaintIndex.getEscalation1FunctionaryAssigneddate() != null) {
            lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getEscalation1FunctionaryAssigneddate(), (int)((int)complaintIndex.getEscalation1FunctionarySLADays()));
            if (lastDateToResolve.getTime() - new Date().getTime() >= 0L) {
                complaintIndex.setEscalation1FunctionaryAgeingFromDue(0.0);
                complaintIndex.setEscalation1FunctionaryIsSLA("Y");
                complaintIndex.setEscalation1FunctionaryIfSLA(1);
            } else {
                long escalation1FunctionaryAgeingDueHours = Math.abs(new Date().getTime() - lastDateToResolve.getTime()) / 3600000L;
                complaintIndex.setEscalation1FunctionaryAgeingFromDue(escalation1FunctionaryAgeingDueHours);
                complaintIndex.setEscalation1FunctionaryIsSLA("N");
                complaintIndex.setEscalation1FunctionaryIfSLA(0);
            }
        }
        if (complaintIndex.getEscalation2FunctionaryAssigneddate() != null) {
            lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getEscalation2FunctionaryAssigneddate(), (int)((int)complaintIndex.getEscalation2FunctionarySLADays()));
            if (lastDateToResolve.getTime() - new Date().getTime() >= 0L) {
                complaintIndex.setEscalation2FunctionaryAgeingFromDue(0.0);
                complaintIndex.setEscalation2FunctionaryIsSLA("Y");
                complaintIndex.setEscalation2FunctionaryIfSLA(1);
            } else {
                long escalation2FunctionaryAgeingDueHours = Math.abs(new Date().getTime() - lastDateToResolve.getTime()) / 3600000L;
                complaintIndex.setEscalation2FunctionaryAgeingFromDue(escalation2FunctionaryAgeingDueHours);
                complaintIndex.setEscalation2FunctionaryIsSLA("N");
                complaintIndex.setEscalation2FunctionaryIfSLA(0);
            }
        }
        if (complaintIndex.getEscalation3FunctionaryAssigneddate() != null) {
            lastDateToResolve = DateUtils.addHours((Date)complaintIndex.getEscalation3FunctionaryAssigneddate(), (int)((int)complaintIndex.getEscalation3FunctionarySLADays()));
            if (lastDateToResolve.getTime() - new Date().getTime() >= 0L) {
                complaintIndex.setEscalation3FunctionaryAgeingFromDue(0.0);
                complaintIndex.setEscalation3FunctionaryIsSLA("Y");
                complaintIndex.setEscalation3FunctionaryIfSLA(1);
            } else {
                long escalation3FunctionaryAgeingDueHours = Math.abs(new Date().getTime() - lastDateToResolve.getTime()) / 3600000L;
                complaintIndex.setEscalation3FunctionaryAgeingFromDue(escalation3FunctionaryAgeingDueHours);
                complaintIndex.setEscalation3FunctionaryIsSLA("N");
                complaintIndex.setEscalation3FunctionaryIfSLA(0);
            }
        }
        return complaintIndex;
    }

    private ComplaintIndex updateComplaintIndexStatusRelatedFields(ComplaintIndex complaintIndex) {
        if (complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.PROCESSING.toString()) || complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.FORWARDED.toString()) || complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.REGISTERED.toString())) {
            complaintIndex.setInProcess(1);
            complaintIndex.setAddressed(0);
            complaintIndex.setRejected(0);
        }
        if (complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.COMPLETED.toString()) || complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.WITHDRAWN.toString())) {
            complaintIndex.setInProcess(0);
            complaintIndex.setAddressed(1);
            complaintIndex.setRejected(0);
        }
        if (complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.REJECTED.toString())) {
            complaintIndex.setInProcess(0);
            complaintIndex.setAddressed(0);
            complaintIndex.setRejected(1);
        }
        if (complaintIndex.getComplaintStatusName().equalsIgnoreCase(ComplaintStatus.REOPENED.toString())) {
            complaintIndex.setInProcess(1);
            complaintIndex.setAddressed(0);
            complaintIndex.setRejected(0);
            complaintIndex.setReOpened(1);
        }
        return complaintIndex;
    }

    private long getFunctionarySlaDays(Complaint complaint) {
        Position position = complaint.getAssignee();
        Designation designation = position.getDeptDesig().getDesignation();
        Escalation complaintEscalation = this.escalationService.getEscalationBycomplaintTypeAndDesignation(complaint.getComplaintType().getId(), designation.getId());
        if (complaintEscalation != null) {
            return complaintEscalation.getNoOfHrs().intValue();
        }
        return 0L;
    }

    public Map<String, Object> getGrievanceReport(ComplaintDashBoardRequest complaintDashBoardRequest) {
        String groupByField = ComplaintElasticsearchUtils.getAggregationGroupingField(complaintDashBoardRequest);
        Map response = this.complaintIndexRepository.findAllGrievanceByFilter(complaintDashBoardRequest, this.getFilterQuery(complaintDashBoardRequest), groupByField);
        SearchResponse consolidatedResponse = (SearchResponse)response.get("consolidatedResponse");
        SearchResponse tableResponse = (SearchResponse)response.get("tableResponse");
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<ComplaintDashBoardResponse> responseDetailsList = new ArrayList<ComplaintDashBoardResponse>();
        ValueCount totalCount = (ValueCount)((SearchResponse)response.get("consolidatedResponse")).getAggregations().get("countAggregation");
        result.put("TotalComplaint", totalCount.getValue());
        Filter filter = (Filter)consolidatedResponse.getAggregations().get("agg");
        Avg averageAgeing = (Avg)filter.getAggregations().get("AgeingInWeeks");
        result.put("AvgAgeingInWeeks", averageAgeing.getValue() / 7.0);
        Range satisfactionAverage = (Range)consolidatedResponse.getAggregations().get("excludeZero");
        Avg averageSatisfaction = (Avg)((Range.Bucket)satisfactionAverage.getBuckets().get(0)).getAggregations().get("satisfactionAverage");
        result.put("AvgCustomeSatisfactionIndex", averageSatisfaction.getValue());
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getUlbCode())) {
            CityIndex city = this.cityIndexService.findOne(complaintDashBoardRequest.getUlbCode());
            result.put("regionName", city.getRegionname());
            result.put("districtName", city.getDistrictname());
            result.put("ulbCode", city.getCitycode());
            result.put("ulbGrade", city.getCitygrade());
            result.put("ulbName", city.getName());
            result.put("domainURL", city.getDomainurl());
        }
        Terms terms = (Terms)consolidatedResponse.getAggregations().get("closedCount");
        for (Terms.Bucket bucket : terms.getBuckets()) {
            if (bucket.getKeyAsNumber().intValue() == 1) {
                result.put("ClosedComplaints", bucket.getDocCount());
                continue;
            }
            result.put("OpenComplaints", bucket.getDocCount());
        }
        terms = (Terms)consolidatedResponse.getAggregations().get("slaCount");
        for (Terms.Bucket bucket : terms.getBuckets()) {
            if (bucket.getKeyAsNumber().intValue() == 1) {
                result.put("WithinSLACount", bucket.getDocCount());
                continue;
            }
            result.put("OutSideSLACount", bucket.getDocCount());
        }
        Range currentYearCount = (Range)consolidatedResponse.getAggregations().get("currentYear");
        result.put("CYTDComplaint", ((Range.Bucket)currentYearCount.getBuckets().get(0)).getDocCount());
        Range todaysCount = (Range)consolidatedResponse.getAggregations().get("todaysComplaintCount");
        result.put("todaysComplaintsCount", ((Range.Bucket)todaysCount.getBuckets().get(0)).getDocCount());
        terms = (Terms)tableResponse.getAggregations().get("groupByField");
        for (Terms.Bucket bucket : terms.getBuckets()) {
            ComplaintDashBoardResponse responseDetail = this.populateResponse(complaintDashBoardRequest, bucket, groupByField);
            responseDetail.setTotalComplaintCount(bucket.getDocCount());
            satisfactionAverage = (Range)bucket.getAggregations().get("excludeZero");
            Avg groupByFieldAverageSatisfaction = (Avg)((Range.Bucket)satisfactionAverage.getBuckets().get(0)).getAggregations().get("groupByFieldSatisfactionAverage");
            if (Double.isNaN(groupByFieldAverageSatisfaction.getValue())) {
                responseDetail.setAvgSatisfactionIndex(0.0);
            } else {
                responseDetail.setAvgSatisfactionIndex(groupByFieldAverageSatisfaction.getValue());
            }
            Terms openAndClosedTerms = (Terms)bucket.getAggregations().get("groupFieldWiseOpenAndClosedCount");
            for (Terms.Bucket closedCountbucket : openAndClosedTerms.getBuckets()) {
                Terms slaTerms;
                if (closedCountbucket.getKeyAsNumber().intValue() == 1) {
                    responseDetail.setClosedComplaintCount(closedCountbucket.getDocCount());
                    slaTerms = (Terms)closedCountbucket.getAggregations().get("groupByFieldSla");
                    for (Object slaBucket : slaTerms.getBuckets()) {
                        if (slaBucket.getKeyAsNumber().intValue() == 1) {
                            responseDetail.setClosedWithinSLACount(slaBucket.getDocCount());
                            continue;
                        }
                        responseDetail.setClosedOutSideSLACount(slaBucket.getDocCount());
                    }
                    Range ageingRange = (Range)closedCountbucket.getAggregations().get("groupByFieldAgeing");
                    Range.Bucket rangeBucket = (Range.Bucket)ageingRange.getBuckets().get(0);
                    responseDetail.setAgeingGroup1(rangeBucket.getDocCount());
                    rangeBucket = (Range.Bucket)ageingRange.getBuckets().get(1);
                    responseDetail.setAgeingGroup2(rangeBucket.getDocCount());
                    rangeBucket = (Range.Bucket)ageingRange.getBuckets().get(2);
                    responseDetail.setAgeingGroup3(rangeBucket.getDocCount());
                    rangeBucket = (Range.Bucket)ageingRange.getBuckets().get(3);
                    responseDetail.setAgeingGroup4(rangeBucket.getDocCount());
                    continue;
                }
                responseDetail.setOpenComplaintCount(closedCountbucket.getDocCount());
                slaTerms = (Terms)closedCountbucket.getAggregations().get("groupByFieldSla");
                for (Object slaBucket : slaTerms.getBuckets()) {
                    if (slaBucket.getKeyAsNumber().intValue() == 1) {
                        responseDetail.setOpenWithinSLACount(slaBucket.getDocCount());
                        continue;
                    }
                    responseDetail.setOpenOutSideSLACount(slaBucket.getDocCount());
                }
            }
            responseDetailsList.add(responseDetail);
        }
        result.put("responseDetails", responseDetailsList);
        ArrayList<ComplaintDashBoardResponse> complaintTypeList = new ArrayList<ComplaintDashBoardResponse>();
        terms = (Terms)tableResponse.getAggregations().get("complaintTypeWise");
        for (Terms.Bucket bucket : terms.getBuckets()) {
            ComplaintDashBoardResponse complaintType = new ComplaintDashBoardResponse();
            complaintType = this.setDefaultValues(complaintType);
            complaintType.setComplaintTypeName(bucket.getKey().toString());
            complaintType.setTotalComplaintCount(bucket.getDocCount());
            satisfactionAverage = (Range)bucket.getAggregations().get("excludeZero");
            Avg complaintTypeAverageSatisfaction = (Avg)((Range.Bucket)satisfactionAverage.getBuckets().get(0)).getAggregations().get("complaintTypeSatisfactionAverage");
            if (Double.isNaN(complaintTypeAverageSatisfaction.getValue())) {
                complaintType.setAvgSatisfactionIndex(0.0);
            } else {
                complaintType.setAvgSatisfactionIndex(complaintTypeAverageSatisfaction.getValue());
            }
            Terms openAndClosedTerms = (Terms)bucket.getAggregations().get("complaintTypeWiseOpenAndClosedCount");
            for (Terms.Bucket closedCountbucket : openAndClosedTerms.getBuckets()) {
                Terms slaTerms;
                if (closedCountbucket.getKeyAsNumber().intValue() == 1) {
                    complaintType.setClosedComplaintCount(closedCountbucket.getDocCount());
                    slaTerms = (Terms)closedCountbucket.getAggregations().get("complaintTypeSla");
                    for (Terms.Bucket slaBucket : slaTerms.getBuckets()) {
                        if (slaBucket.getKeyAsNumber().intValue() == 1) {
                            complaintType.setClosedWithinSLACount(slaBucket.getDocCount());
                            continue;
                        }
                        complaintType.setClosedOutSideSLACount(slaBucket.getDocCount());
                    }
                    Range ageingRange = (Range)closedCountbucket.getAggregations().get("ComplaintTypeAgeing");
                    Range.Bucket rangeBucket = (Range.Bucket)ageingRange.getBuckets().get(0);
                    complaintType.setAgeingGroup1(rangeBucket.getDocCount());
                    rangeBucket = (Range.Bucket)ageingRange.getBuckets().get(1);
                    complaintType.setAgeingGroup2(rangeBucket.getDocCount());
                    rangeBucket = (Range.Bucket)ageingRange.getBuckets().get(2);
                    complaintType.setAgeingGroup3(rangeBucket.getDocCount());
                    rangeBucket = (Range.Bucket)ageingRange.getBuckets().get(3);
                    complaintType.setAgeingGroup4(rangeBucket.getDocCount());
                    continue;
                }
                complaintType.setOpenComplaintCount(closedCountbucket.getDocCount());
                slaTerms = (Terms)closedCountbucket.getAggregations().get("complaintTypeSla");
                for (Terms.Bucket slaBucket : slaTerms.getBuckets()) {
                    if (slaBucket.getKeyAsNumber().intValue() == 1) {
                        complaintType.setOpenWithinSLACount(slaBucket.getDocCount());
                        continue;
                    }
                    complaintType.setOpenOutSideSLACount(slaBucket.getDocCount());
                }
            }
            complaintTypeList.add(complaintType);
        }
        result.put("complaintTypes", complaintTypeList);
        return result;
    }

    public Map<String, Object> getComplaintTypeReport(ComplaintDashBoardRequest complaintDashBoardRequest) {
        String groupByField = ComplaintElasticsearchUtils.getAggregationGroupingField(complaintDashBoardRequest);
        SearchResponse complaintTypeResponse = this.complaintIndexRepository.findAllGrievanceByComplaintType(complaintDashBoardRequest, this.getFilterQuery(complaintDashBoardRequest), groupByField);
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getUlbCode())) {
            CityIndex city = this.cityIndexService.findOne(complaintDashBoardRequest.getUlbCode());
            result.put("regionName", city.getRegionname());
            result.put("districtName", city.getDistrictname());
            result.put("ulbCode", city.getCitycode());
            result.put("ulbGrade", city.getCitygrade());
            result.put("ulbName", city.getName());
            result.put("domainURL", city.getDomainurl());
        }
        ArrayList<ComplaintDashBoardResponse> responseDetailsList = new ArrayList<ComplaintDashBoardResponse>();
        Terms terms = (Terms)complaintTypeResponse.getAggregations().get("groupByField");
        for (Terms.Bucket bucket : terms.getBuckets()) {
            ComplaintDashBoardResponse responseDetail = this.populateResponse(complaintDashBoardRequest, bucket, groupByField);
            responseDetail.setTotalComplaintCount(bucket.getDocCount());
            Terms openAndClosedTerms = (Terms)bucket.getAggregations().get("closedComplaintCount");
            for (Terms.Bucket closedCountbucket : openAndClosedTerms.getBuckets()) {
                if (closedCountbucket.getKeyAsNumber().intValue() == 1) {
                    responseDetail.setClosedComplaintCount(closedCountbucket.getDocCount());
                    continue;
                }
                responseDetail.setOpenComplaintCount(closedCountbucket.getDocCount());
            }
            responseDetailsList.add(responseDetail);
        }
        result.put("complaints", responseDetailsList);
        return result;
    }

    public Map<String, Object> getSourceWiseResponse(ComplaintDashBoardRequest complaintDashBoardRequest) {
        HashMap<String, Long> sourceMap;
        Terms sourceTerms;
        ArrayList<HashMap<String, Long>> list;
        SearchResponse sourceWiseResponse = this.complaintIndexRepository.findAllGrievanceBySource(complaintDashBoardRequest, this.getFilterQuery(complaintDashBoardRequest), ComplaintElasticsearchUtils.getAggregationGroupingField(complaintDashBoardRequest));
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<ComplaintSourceResponse> responseDetailsList = new ArrayList<ComplaintSourceResponse>();
        Terms terms = (Terms)sourceWiseResponse.getAggregations().get("groupByField");
        for (Terms.Bucket bucket : terms.getBuckets()) {
            CityIndex city;
            ComplaintSourceResponse complaintSouce = new ComplaintSourceResponse();
            if (StringUtils.isBlank((CharSequence)complaintDashBoardRequest.getDistrictName())) {
                city = this.cityIndexService.findByDistrictCode(bucket.getKeyAsString());
                complaintSouce.setDistrictName(city.getDistrictname());
            }
            if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getDistrictName())) {
                city = StringUtils.isBlank((CharSequence)complaintDashBoardRequest.getUlbCode()) ? this.cityIndexService.findByCitycode(bucket.getKeyAsString()) : this.cityIndexService.findByCitycode(complaintDashBoardRequest.getUlbCode());
                complaintSouce.setDistrictName(city.getDistrictname());
                complaintSouce.setUlbName(city.getName());
                complaintSouce.setUlbGrade(city.getCitygrade());
                complaintSouce.setUlbCode(city.getCitycode());
                complaintSouce.setDomainURL(city.getDomainurl());
            }
            if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getUlbCode())) {
                Department department;
                if (StringUtils.isBlank((CharSequence)complaintDashBoardRequest.getWardNo()) && StringUtils.isBlank((CharSequence)complaintDashBoardRequest.getDepartmentCode())) {
                    complaintSouce.setWardName(bucket.getKeyAsString());
                } else {
                    complaintSouce.setWardName(this.complaintIndexRepository.getWardName(complaintDashBoardRequest.getWardNo()));
                }
                if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getDepartmentCode()) && (department = this.departmentService.getDepartmentByCode(complaintDashBoardRequest.getDepartmentCode())) != null) {
                    complaintSouce.setDepartmentName(department.getName());
                }
            }
            if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getDepartmentCode()) || StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getWardNo())) {
                complaintSouce.setFunctionaryName(bucket.getKeyAsString());
            }
            list = new ArrayList<HashMap<String, Long>>();
            sourceTerms = (Terms)bucket.getAggregations().get("groupByFieldSource");
            for (Terms.Bucket sourceBucket : sourceTerms.getBuckets()) {
                sourceMap = new HashMap<String, Long>();
                sourceMap.put(sourceBucket.getKeyAsString(), sourceBucket.getDocCount());
                list.add(sourceMap);
            }
            complaintSouce.setSourceList(list);
            responseDetailsList.add(complaintSouce);
        }
        result.put("responseDetails", responseDetailsList);
        ArrayList<ComplaintSourceResponse> complaintTypeList = new ArrayList<ComplaintSourceResponse>();
        terms = (Terms)sourceWiseResponse.getAggregations().get("complaintTypeWise");
        for (Terms.Bucket bucket : terms.getBuckets()) {
            ComplaintSourceResponse complaintSouce = new ComplaintSourceResponse();
            complaintSouce.setComplaintTypeName(bucket.getKey().toString());
            list = new ArrayList();
            sourceTerms = (Terms)bucket.getAggregations().get("complaintTypeWiseSource");
            for (Terms.Bucket sourceBucket : sourceTerms.getBuckets()) {
                sourceMap = new HashMap();
                sourceMap.put(sourceBucket.getKeyAsString(), sourceBucket.getDocCount());
                list.add(sourceMap);
            }
            complaintSouce.setSourceList(list);
            complaintTypeList.add(complaintSouce);
        }
        result.put("complaintTypeWise", complaintTypeList);
        return result;
    }

    public Iterable<ComplaintIndex> searchComplaintIndex(BoolQueryBuilder searchQuery) {
        return this.complaintIndexRepository.search((QueryBuilder)searchQuery);
    }

    private BoolQueryBuilder getFilterQuery(ComplaintDashBoardRequest complaintDashBoardRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"registered", (int)1));
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getRegionName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityRegionName", (Object)complaintDashBoardRequest.getRegionName()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getUlbGrade())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityGrade", (Object)complaintDashBoardRequest.getUlbGrade()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getDistrictName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityDistrictName", (Object)complaintDashBoardRequest.getDistrictName()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getUlbCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityCode", (Object)complaintDashBoardRequest.getUlbCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getWardNo())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"wardNo", (Object)complaintDashBoardRequest.getWardNo()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getDepartmentCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"departmentCode", (Object)complaintDashBoardRequest.getDepartmentCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getToDate())) {
            boolQuery = boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)"createdDate").from(complaintDashBoardRequest.getFromDate()).to(complaintDashBoardRequest.getToDate()));
        }
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getComplaintTypeCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"complaintTypeCode", (Object)complaintDashBoardRequest.getComplaintTypeCode()));
        }
        return boolQuery;
    }

    private ComplaintDashBoardResponse populateResponse(ComplaintDashBoardRequest complaintDashBoardRequest, Terms.Bucket bucket, String groupByField) {
        CityIndex city;
        ComplaintDashBoardResponse responseDetail = new ComplaintDashBoardResponse();
        responseDetail = this.setDefaultValues(responseDetail);
        if ("cityRegionName".equals(groupByField)) {
            responseDetail.setRegionName(bucket.getKeyAsString());
        }
        if ("cityGrade".equals(groupByField)) {
            responseDetail.setUlbGrade(bucket.getKeyAsString());
        }
        if ("cityCode".equals(groupByField) && "ulb".equalsIgnoreCase(complaintDashBoardRequest.getType())) {
            city = this.cityIndexService.findOne(bucket.getKeyAsString());
            responseDetail.setUlbName(city.getName());
        }
        if ("cityDistrictCode".equals(groupByField)) {
            city = this.cityIndexService.findByDistrictCode(bucket.getKeyAsString());
            responseDetail.setDistrictName(city.getDistrictname());
        }
        if ("cityCode".equals(groupByField) && !complaintDashBoardRequest.getType().equals("ulb")) {
            city = this.cityIndexService.findOne(bucket.getKeyAsString());
            responseDetail.setDistrictName(city.getDistrictname());
            responseDetail.setUlbName(city.getName());
            responseDetail.setUlbGrade(city.getCitygrade());
            responseDetail.setUlbCode(city.getCitycode());
            responseDetail.setDomainURL(city.getDomainurl());
        }
        if ("departmentName".equals(groupByField)) {
            responseDetail.setDepartmentName(bucket.getKeyAsString());
        }
        if ("wardName".equals(groupByField)) {
            responseDetail.setWardName(bucket.getKeyAsString());
        }
        if ("localityName".equals(groupByField)) {
            responseDetail.setLocalityName(bucket.getKeyAsString());
        }
        if ("currentFunctionaryName".equals(groupByField)) {
            responseDetail.setFunctionaryName(bucket.getKeyAsString());
            String mobileNumber = this.complaintIndexRepository.getFunctionryMobileNumber(bucket.getKeyAsString());
            responseDetail.setFunctionaryMobileNumber(mobileNumber);
        }
        return responseDetail;
    }

    private ComplaintDashBoardResponse setDefaultValues(ComplaintDashBoardResponse response) {
        response.setDistrictName("");
        response.setUlbName("");
        response.setWardName("");
        response.setDepartmentName("");
        response.setFunctionaryName("");
        response.setLocalityName("");
        response.setComplaintTypeName("");
        response.setUlbGrade("");
        response.setUlbCode("");
        response.setDomainURL("");
        return response;
    }

    public List<String> getSourceNameList() {
        return Arrays.asList(this.environment.getProperty("all.complaint.sources").split(","));
    }
}

