/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.time.DateUtils;
import org.egov.commons.ObjectType;
import org.egov.commons.service.ObjectTypeService;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.Employee;
import org.egov.eis.entity.PositionHierarchy;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.PositionHierarchyService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.pgr.config.properties.PgrApplicationProperties;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.entity.Escalation;
import org.egov.pgr.repository.ComplaintRepository;
import org.egov.pgr.repository.EscalationRepository;
import org.egov.pgr.service.ComplaintService;
import org.egov.pgr.service.es.ComplaintIndexService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EscalationService {
    private static final Logger LOG = LoggerFactory.getLogger(EscalationService.class);
    private final EscalationRepository escalationRepository;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private ComplaintService complaintService;
    @Autowired
    private ObjectTypeService objectTypeService;
    @Autowired
    private ComplaintRepository complaintRepository;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    private PgrApplicationProperties pgrApplicationProperties;
    @Autowired
    private PositionHierarchyService positionHierarchyService;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private UserService userService;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ComplaintIndexService complaintIndexService;

    @Autowired
    public EscalationService(EscalationRepository escalationRepository) {
        this.escalationRepository = escalationRepository;
    }

    @Transactional
    public void create(Escalation escalation) {
        this.escalationRepository.save((Object)escalation);
    }

    @Transactional
    public void update(Escalation escalation) {
        this.escalationRepository.save((Object)escalation);
    }

    @Transactional
    public void delete(Escalation escalation) {
        this.escalationRepository.delete((Object)escalation);
    }

    public List<Escalation> findAllBycomplaintTypeId(Long complaintTypeId) {
        return this.escalationRepository.findEscalationByComplaintTypeId(complaintTypeId);
    }

    @Transactional
    public void escalateComplaint() {
        try {
            ObjectType objectType = this.objectTypeService.getObjectTypeByName("Complaint");
            if (objectType == null) {
                LOG.error("Escalation can't be done, Object Type {} not found", (Object)"Complaint");
                return;
            }
            List<Complaint> escalationComplaints = this.complaintService.getComplaintsEligibleForEscalation();
            for (Complaint complaint : escalationComplaints) {
                PositionHierarchy positionHierarchy = this.positionHierarchyService.getPosHirByPosAndObjectTypeAndObjectSubType(complaint.getAssignee().getId(), objectType.getId(), complaint.getComplaintType().getCode());
                Position superiorPosition = null;
                User superiorUser = null;
                if (positionHierarchy != null) {
                    superiorPosition = positionHierarchy.getToPosition();
                    List superiorAssignments = this.assignmentService.getAssignmentsForPosition(superiorPosition.getId(), new Date());
                    superiorUser = !superiorAssignments.isEmpty() ? ((Assignment)superiorAssignments.get(0)).getEmployee() : null;
                } else {
                    Set users = this.userService.getUsersByRoleName("Grievance Routing Officer");
                    if (!users.isEmpty()) {
                        superiorUser = (User)users.iterator().next();
                    }
                    if (superiorUser != null) {
                        superiorPosition = this.positionMasterService.getCurrentPositionForUser(superiorUser.getId());
                    } else {
                        LOG.error("Could not do escalation, no user defined for Grievance Officer role");
                        continue;
                    }
                }
                if (superiorPosition == null || superiorUser == null || superiorPosition.equals((Object)complaint.getAssignee())) continue;
                this.updateOnEscalation(complaint, superiorPosition, superiorUser);
            }
        }
        catch (Exception e) {
            LOG.error("An error occurred, escalation can't be completed ", (Throwable)e);
            return;
        }
    }

    public void updateOnEscalation(Complaint complaint, Position superiorPosition, User superiorUser) {
        Position previousOwner = complaint.getAssignee();
        List prevUserAssignments = this.assignmentService.getAssignmentsForPosition(previousOwner.getId(), new Date());
        Employee previoususer = !prevUserAssignments.isEmpty() ? ((Assignment)prevUserAssignments.get(0)).getEmployee() : null;
        complaint.setEscalationDate(this.getExpiryDate(complaint));
        complaint.setAssignee(superiorPosition);
        complaint.transition().withOwner(superiorPosition).withComments("Complaint is escalated").withDateInfo(new Date()).withStateValue(complaint.getStatus().getName()).withSenderName(this.securityUtils.getCurrentUser().getName());
        this.complaintRepository.save((Object)complaint);
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("PGR", "SENDEMAILFORESCALATION").get(0);
        if ("YES".equalsIgnoreCase(appConfigValue.getValue())) {
            String formattedEscalationDate = new SimpleDateFormat("dd/MM/yyyy HH:mm").format(complaint.getEscalationDate());
            StringBuffer emailBody = new StringBuffer().append("Dear ").append(superiorUser.getName()).append(",\n \n     The complaint Number (").append(complaint.getCrn()).append(") is escalated.\n").append("\n Complaint Details - \n \n Complaint type - ").append(complaint.getComplaintType().getName()).append(" \n Location details - ").append(complaint.getLocation().getName()).append("\n Complaint description - ").append(complaint.getDetails()).append("\n Complaint status -").append(complaint.getStatus().getName()).append("\n Complaint escalated to - ").append(superiorUser.getName()).append("\n Escalation Time - ").append(formattedEscalationDate);
            StringBuffer emailSubject = new StringBuffer().append("Escalated Complaint Number -").append(complaint.getCrn()).append(" (").append(complaint.getStatus().getName()).append(")");
            StringBuffer smsBody = new StringBuffer().append("Dear ").append(superiorUser.getName()).append(", ").append(complaint.getCrn() + " by ").append(complaint.getComplainant().getName() != null ? complaint.getComplainant().getName() : "Anonymous User").append(", " + complaint.getComplainant().getMobile()).append(" for " + complaint.getComplaintType().getName() + " from ").append(complaint.getLocation().getName()).append(" handled by ").append(previoususer != null ? previoususer.getName() : previousOwner.getName() + " has been escalated to you. ");
            this.messagingService.sendEmail(superiorUser.getEmailId(), emailSubject.toString(), emailBody.toString());
            this.messagingService.sendSMS(superiorUser.getMobileNumber(), smsBody.toString());
        }
        this.complaintIndexService.updateComplaintEscalationIndexValues(complaint);
    }

    protected Date getExpiryDate(Complaint complaint) {
        Date expiryDate = complaint.getEscalationDate();
        Designation designation = complaint.getAssignee().getDeptDesig().getDesignation();
        Integer noOfhrs = this.getHrsToResolve(designation.getId(), complaint.getComplaintType().getId());
        expiryDate = DateUtils.addHours((Date)expiryDate, (int)noOfhrs);
        return expiryDate;
    }

    public Integer getHrsToResolve(Long designationId, Long complaintTypeId) {
        Escalation escalation = this.escalationRepository.findByDesignationAndComplaintType(designationId, complaintTypeId);
        if (escalation != null) {
            return escalation.getNoOfHrs();
        }
        return this.pgrApplicationProperties.defaultResolutionTime();
    }

    @Transactional
    public void deleteAllInBatch(List<Escalation> entities) {
        this.escalationRepository.deleteInBatch(entities);
    }

    public Page<Escalation> getPageOfEscalations(Integer pageNumber, Integer pageSize, Long complaintTypeId, Long designationId) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"id"});
        if (complaintTypeId != 0L && designationId != 0L) {
            return this.escalationRepository.findEscalationBycomplaintTypeAndDesignation(complaintTypeId, designationId, (Pageable)pageable);
        }
        if (complaintTypeId != 0L) {
            return this.escalationRepository.findEscalationBycomplaintType(complaintTypeId, (Pageable)pageable);
        }
        if (designationId != 0L) {
            return this.escalationRepository.findEscalationByDesignation(designationId, (Pageable)pageable);
        }
        return this.escalationRepository.findEscalationByAll((Pageable)pageable);
    }

    public List<PositionHierarchy> getEscalationObjByComplaintTypeFromPosition(List<ComplaintType> complaintTypes, Position fromPosition) {
        ArrayList<String> compTypeCodes = new ArrayList<String>();
        for (ComplaintType complaintType : complaintTypes) {
            compTypeCodes.add(complaintType.getCode());
        }
        ObjectType objectType = this.objectTypeService.getObjectTypeByName("Complaint");
        return this.positionHierarchyService.getListOfPositionHeirarchyByPositionObjectTypeSubType(objectType.getId(), compTypeCodes, fromPosition);
    }

    public PositionHierarchy getExistingEscalation(PositionHierarchy positionHierarchy) {
        PositionHierarchy existingPosHierarchy = null;
        if (null != positionHierarchy.getObjectSubType() && null != positionHierarchy.getFromPosition() && null != positionHierarchy.getToPosition()) {
            existingPosHierarchy = this.positionHierarchyService.getPosHirByPosAndObjectTypeAndObjectSubType(positionHierarchy.getFromPosition().getId(), positionHierarchy.getObjectType().getId(), positionHierarchy.getObjectSubType());
        }
        return existingPosHierarchy != null ? existingPosHierarchy : null;
    }

    public Escalation getEscalationBycomplaintTypeAndDesignation(Long complaintTypeId, Long designationId) {
        return this.escalationRepository.findByDesignationAndComplaintType(designationId, complaintTypeId);
    }
}

