/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.repository.es;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.pgr.entity.es.ComplaintDashBoardRequest;
import org.egov.pgr.repository.es.ComplaintIndexCustomRepository;
import org.egov.pgr.repository.es.util.ComplaintElasticsearchUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.range.RangeBuilder;
import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;

public class ComplaintIndexRepositoryImpl
implements ComplaintIndexCustomRepository {
    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd");
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    @Override
    public Map<String, SearchResponse> findAllGrievanceByFilter(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query, String grouByField) {
        DateTime toDate;
        DateTime fromDate = new DateTime();
        if (StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)complaintDashBoardRequest.getToDate())) {
            fromDate = new DateTime((Object)complaintDashBoardRequest.getFromDate());
            toDate = fromDate.plusDays(1);
        } else {
            toDate = fromDate.plusDays(1);
        }
        int size = 120;
        if (complaintDashBoardRequest.getSize() >= 0) {
            size = complaintDashBoardRequest.getSize();
        }
        SearchResponse consolidatedResponse = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCount("countAggregation", "crn")).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("closedCount", "ifClosed", 2)).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("slaCount", "ifSLA", 2)).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithFilter("ifClosed", 1, "AgeingInWeeks", "complaintAgeingdaysFromDue")).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithExclusion("satisfactionAverage", "satisfactionIndex")).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountBetweenSpecifiedDates("currentYear", "createdDate", new DateTime().withMonthOfYear(4).dayOfMonth().withMinimumValue().toString(formatter), new DateTime().toString(formatter))).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountBetweenSpecifiedDates("todaysComplaintCount", "createdDate", fromDate.toString(formatter), toDate.toString(formatter))).execute().actionGet();
        SearchResponse tableResponse = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGroupingAndOrder("complaintTypeWise", "complaintTypeName", size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithExclusion("complaintTypeSatisfactionAverage", "satisfactionIndex")).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeWiseOpenAndClosedCount", "ifClosed", 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)"ComplaintTypeAgeing").field("complaintAgeingdaysFromDue")).addRange("1week", 0.0, 8.0).addRange("1month", 8.0, 32.0).addRange("3months", 32.0, 91.0).addUnboundedFrom("remainingMonths", 91.0)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeSla", "ifSLA", 2)))).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGroupingAndOrder("groupByField", grouByField, size, complaintDashBoardRequest.getSortField(), complaintDashBoardRequest.getSortDirection()).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getAverageWithExclusion("groupByFieldSatisfactionAverage", "satisfactionIndex")).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupFieldWiseOpenAndClosedCount", "ifClosed", 2).subAggregation((AbstractAggregationBuilder)((RangeBuilder)AggregationBuilders.range((String)"groupByFieldAgeing").field("complaintAgeingdaysFromDue")).addRange("1week", 0.0, 8.0).addRange("1month", 8.0, 32.0).addRange("3months", 32.0, 91.0).addUnboundedFrom("remainingMonths", 91.0)).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupByFieldSla", "ifSLA", 2)))).execute().actionGet();
        HashMap<String, SearchResponse> result = new HashMap<String, SearchResponse>();
        result.put("consolidatedResponse", consolidatedResponse);
        result.put("tableResponse", tableResponse);
        return result;
    }

    @Override
    public String getWardName(String wardNo) {
        SearchResponse response = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setSize(1).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"wardNo", (Object)wardNo)).execute().actionGet();
        Iterator iterator = response.getHits().iterator();
        if (iterator.hasNext()) {
            SearchHit hit = (SearchHit)iterator.next();
            Map fields = hit.getSource();
            return fields.get("wardName").toString();
        }
        return "";
    }

    @Override
    public SearchResponse findAllGrievanceByComplaintType(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query, String grouByField) {
        return (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupByField", grouByField, 120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("closedComplaintCount", "ifClosed", 2))).execute().actionGet();
    }

    @Override
    public SearchResponse findAllGrievanceBySource(ComplaintDashBoardRequest complaintDashBoardRequest, BoolQueryBuilder query, String grouByField) {
        return (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setQuery((QueryBuilder)query).setSize(0).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupByField", grouByField, 120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("groupByFieldSource", "source", 30))).addAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeWise", "complaintTypeName", 120).subAggregation((AbstractAggregationBuilder)ComplaintElasticsearchUtils.getCountWithGrouping("complaintTypeWiseSource", "source", 30))).execute().actionGet();
    }

    @Override
    public String getFunctionryMobileNumber(String functionaryName) {
        SearchResponse response = (SearchResponse)this.elasticsearchTemplate.getClient().prepareSearch(new String[]{"complaint"}).setSize(1).setQuery((QueryBuilder)QueryBuilders.matchQuery((String)"currentFunctionaryName", (Object)functionaryName)).execute().actionGet();
        Iterator iterator = response.getHits().iterator();
        if (iterator.hasNext()) {
            SearchHit hit = (SearchHit)iterator.next();
            Map fields = hit.getSource();
            return fields.get("currentFunctionaryMobileNumber").toString();
        }
        return "";
    }
}

