/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.entity;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.Unique;
import org.egov.pgr.entity.ComplaintTypeCategory;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Unique(fields={"name", "code"}, enableDfltMsg=true)
@Table(name="egpgr_complainttype")
@SequenceGenerator(name="SEQ_EGPGR_COMPLAINTTYPE", sequenceName="SEQ_EGPGR_COMPLAINTTYPE", allocationSize=1)
public class ComplaintType
extends AbstractAuditable {
    public static final String SEQ_COMPLAINTTYPE = "SEQ_EGPGR_COMPLAINTTYPE";
    private static final long serialVersionUID = 8904645810221559541L;
    @Id
    @GeneratedValue(generator="SEQ_EGPGR_COMPLAINTTYPE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotBlank
    @SafeHtml
    @Length(max=150)
    @Column(name="name")
    private String name;
    @NotBlank
    @Length(max=20)
    @SafeHtml
    @Column(name="code", updatable=false)
    private String code;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="department")
    private Department department;
    @Length(max=100)
    @SafeHtml
    private String description;
    @NotNull
    private Integer slaHours;
    private boolean isActive;
    private boolean hasFinancialImpact;
    @ManyToOne(optional=false)
    @JoinColumn(name="category")
    private ComplaintTypeCategory category;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public boolean getIsActive() {
        return this.isActive;
    }

    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getSlaHours() {
        return this.slaHours;
    }

    public void setSlaHours(Integer slaHours) {
        this.slaHours = slaHours;
    }

    public boolean isHasFinancialImpact() {
        return this.hasFinancialImpact;
    }

    public void setHasFinancialImpact(boolean hasFinancialImpact) {
        this.hasFinancialImpact = hasFinancialImpact;
    }

    public ComplaintTypeCategory getCategory() {
        return this.category;
    }

    public void setCategory(ComplaintTypeCategory category) {
        this.category = category;
    }
}

