/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.search.elastic.annotation.Indexing;
import org.egov.pgr.entity.Complaint;
import org.egov.pgr.entity.ComplaintType;
import org.egov.pgr.repository.ComplaintTypeRepository;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ComplaintTypeService {
    private final ComplaintTypeRepository complaintTypeRepository;
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public ComplaintTypeService(ComplaintTypeRepository complaintTypeRepository) {
        this.complaintTypeRepository = complaintTypeRepository;
    }

    public ComplaintType findBy(Long complaintTypeId) {
        return (ComplaintType)((Object)this.complaintTypeRepository.findOne(complaintTypeId));
    }

    @Indexing(name=Index.PGR, type=IndexType.COMPLAINT_TYPE)
    @Transactional
    public ComplaintType createComplaintType(ComplaintType complaintType) {
        return (ComplaintType)((Object)this.complaintTypeRepository.save((Object)complaintType));
    }

    @Transactional
    public ComplaintType updateComplaintType(ComplaintType complaintType) {
        return (ComplaintType)((Object)this.complaintTypeRepository.save((Object)complaintType));
    }

    public List<ComplaintType> findAll() {
        return this.complaintTypeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public List<ComplaintType> findAllActiveByNameLike(String name) {
        return this.complaintTypeRepository.findByIsActiveTrueAndNameContainingIgnoreCase(name);
    }

    public List<ComplaintType> findActiveComplaintTypesByCategory(Long categoryId) {
        return this.complaintTypeRepository.findByIsActiveTrueAndCategoryIdOrderByNameAsc(categoryId);
    }

    public List<ComplaintType> findAllByNameLike(String name) {
        return this.complaintTypeRepository.findByNameContainingIgnoreCase(name);
    }

    public ComplaintType findByName(String name) {
        return this.complaintTypeRepository.findByName(name);
    }

    public ComplaintType load(Long id) {
        return (ComplaintType)((Object)this.complaintTypeRepository.getOne(id));
    }

    public Page<ComplaintType> getListOfComplaintTypes(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"name"});
        return this.complaintTypeRepository.findAll((Pageable)pageable);
    }

    public List<ComplaintType> getFrequentlyFiledComplaints() {
        DateTime previousDate = new DateTime();
        DateTime currentDate = new DateTime();
        previousDate = previousDate.minusMonths(1);
        Criteria criteria = ((Session)this.entityManager.unwrap(Session.class)).createCriteria(Complaint.class, "complaint");
        criteria.createAlias("complaint.complaintType", "compType");
        criteria.setProjection((Projection)Projections.projectionList().add((Projection)Projections.property((String)"complaint.complaintType")).add(Projections.count((String)"complaint.complaintType").as("count")).add((Projection)Projections.groupProperty((String)"complaint.complaintType")));
        criteria.add(Restrictions.between((String)"complaint.createdDate", (Object)previousDate.toDate(), (Object)currentDate.toDate()));
        criteria.add((Criterion)Restrictions.eq((String)"compType.isActive", (Object)Boolean.TRUE));
        criteria.setMaxResults(5).addOrder(Order.desc((String)"count"));
        List resultList = criteria.list();
        ArrayList<ComplaintType> complaintTypeList = new ArrayList<ComplaintType>();
        for (Object row : resultList) {
            Object[] columns = (Object[])row;
            complaintTypeList.add((ComplaintType)((Object)columns[0]));
        }
        return complaintTypeList;
    }

    public ComplaintType findByCode(String code) {
        return this.complaintTypeRepository.findByCode(code);
    }

    public List<Department> getAllComplaintTypeDepartments() {
        return this.complaintTypeRepository.findAllComplaintTypeDepartments();
    }

    public List<ComplaintType> findActiveComplaintTypes() {
        return this.complaintTypeRepository.findByIsActiveTrueOrderByNameAsc();
    }
}

