/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.repository;

import java.util.List;
import org.egov.infra.admin.master.entity.User;
import org.egov.pgr.entity.Complaint;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface ComplaintRepository
extends JpaRepository<Complaint, Long> {
    public Complaint findByCrn(String var1);

    @Query(value="select complaint from Complaint complaint where createdBy =:createdBy order by createddate DESC")
    public Page<Complaint> findByMyComplaint(@Param(value="createdBy") User var1, Pageable var2);

    @Query(value="select complaint from Complaint complaint where createdBy =:createdBy and status.name in (:statuses) order by createddate DESC")
    public Page<Complaint> findMyComplaintyByStatus(@Param(value="createdBy") User var1, @Param(value="statuses") String[] var2, Pageable var3);

    @Query(value="select count(*) from Complaint complaint where status.name in (:statuses)")
    public Long getComplaintsTotalCountByStatus(@Param(value="statuses") String[] var1);

    @Query(value="select count(*) from Complaint")
    public Long getTotalComplaintsCount();

    @Query(value="select count(*) from Complaint complaint where createdBy =:createdBy and status.name in (:statuses)")
    public Long getMyComplaintCountByStatus(@Param(value="createdBy") User var1, @Param(value="statuses") String[] var2);

    @Query(value="select count(*) from Complaint complaint where createdBy =:createdBy")
    public Long getMyComplaintsTotalCount(@Param(value="createdBy") User var1);

    @Query(value="select complaint from Complaint complaint where createdBy <>:createdBy order by createddate DESC")
    public Page<Complaint> findByLatestComplaint(@Param(value="createdBy") User var1, Pageable var2);

    @Query(value="select * FROM egpgr_complaint WHERE createdBy<> :createdBy AND earth_box( ll_to_earth( :lat, :lng), :distance) @> ll_to_earth(egpgr_complaint.lat, egpgr_complaint.lng) order by createddate DESC limit :limit offset :offset", nativeQuery=true)
    public List<Complaint> findByNearestComplaint(@Param(value="createdBy") Long var1, @Param(value="lat") Float var2, @Param(value="lng") Float var3, @Param(value="distance") Long var4, @Param(value="limit") Long var5, @Param(value="offset") Long var6);
}

