/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.entity;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.pgr.entity.Complainant;
import org.egov.pgr.entity.Complaint;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplaintRestAdaptor
implements JsonSerializer<Complaint>,
JsonDeserializer<Complaint> {
    private static final Logger LOG = LoggerFactory.getLogger(ComplaintRestAdaptor.class);

    public JsonElement serialize(Complaint complaint, Type type, JsonSerializationContext jsc) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"dd-MM-yyyy hh:mm a");
        String resolutionDate = "";
        resolutionDate = formatter.print((ReadableInstant)complaint.getEscalationDate());
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("complaintnumber", complaint.getCrn());
        jsonObject.addProperty("timetoresolve", "" + resolutionDate);
        jsonObject.addProperty("message", "Thank you for your submission. We apologize for the inconvenience caused to you. We will resolve the complaint by :" + resolutionDate);
        return jsonObject;
    }

    public Complaint deserialize(JsonElement json, Type type, JsonDeserializationContext context) {
        Complaint complaint = new Complaint();
        LOG.info("json" + json);
        JsonObject object = json.getAsJsonObject();
        LOG.info("object" + object);
        try {
            new Complainant();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return complaint;
    }
}

