/*
 * Decompiled with CFR 0.152.
 */
package org.egov.pgr.elasticSearch.service;

import java.util.Date;
import org.egov.config.search.Index;
import org.egov.config.search.IndexType;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.search.elastic.annotation.Indexing;
import org.egov.pgr.elasticSearch.entity.ComplaintIndex;
import org.egov.pgr.entity.enums.ComplaintStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ComplaintIndexService {
    @Autowired
    private CityService cityService;

    @Indexing(name=Index.PGR, type=IndexType.COMPLAINT)
    public ComplaintIndex createComplaintIndex(ComplaintIndex complaintIndex) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        complaintIndex.setCitydetails(cityWebsite);
        if (complaintIndex.getStatus().getName().equalsIgnoreCase(ComplaintStatus.COMPLETED.toString()) || complaintIndex.getStatus().getName().equalsIgnoreCase(ComplaintStatus.WITHDRAWN.toString()) || complaintIndex.getStatus().getName().equalsIgnoreCase(ComplaintStatus.REJECTED.toString())) {
            complaintIndex.setIsClosed(true);
            long duration = Math.abs(complaintIndex.getCreatedDate().getTime() - new Date().getTime()) / 86400000L;
            complaintIndex.setComplaintDuration(duration);
            if (duration < 3L) {
                complaintIndex.setDurationRange("(<3 days)");
            } else if (duration < 7L) {
                complaintIndex.setDurationRange("(3-7 days)");
            } else if (duration < 15L) {
                complaintIndex.setDurationRange("(8-15 days)");
            } else if (duration < 30L) {
                complaintIndex.setDurationRange("(16-30 days)");
            } else {
                complaintIndex.setDurationRange("(>30 days)");
            }
        } else {
            complaintIndex.setIsClosed(false);
            complaintIndex.setComplaintDuration(0.0);
            complaintIndex.setDurationRange("");
        }
        return complaintIndex;
    }
}

