/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mrs.web.controller.reports;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.reporting.engine.ReportDisposition;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.util.ReportUtil;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.utils.JsonUtils;
import org.egov.mrs.application.MarriageUtils;
import org.egov.mrs.application.reports.service.MarriageRegistrationReportsService;
import org.egov.mrs.domain.entity.ApplicationStatusResultForReport;
import org.egov.mrs.domain.entity.MaritalStatusReport;
import org.egov.mrs.domain.entity.MarriageCertificate;
import org.egov.mrs.domain.entity.MarriageRegistration;
import org.egov.mrs.domain.entity.ReIssue;
import org.egov.mrs.domain.entity.RegistrationCertificatesResultForReport;
import org.egov.mrs.domain.entity.RegistrationReportsSearchResult;
import org.egov.mrs.domain.entity.SearchModel;
import org.egov.mrs.domain.entity.SearchResult;
import org.egov.mrs.domain.enums.MaritalStatus;
import org.egov.mrs.domain.enums.MarriageCertificateType;
import org.egov.mrs.masters.entity.MarriageAct;
import org.egov.mrs.masters.entity.MarriageRegistrationUnit;
import org.egov.mrs.masters.service.MarriageActService;
import org.egov.mrs.masters.service.MarriageRegistrationUnitService;
import org.egov.mrs.masters.service.ReligionService;
import org.egov.mrs.web.adaptor.ApplicationStatusResultReportJsonAdaptor;
import org.egov.mrs.web.adaptor.MaritalStatusReportJsonAdaptor;
import org.egov.mrs.web.adaptor.MarriageReIssueJsonAdaptor;
import org.egov.mrs.web.adaptor.MarriageRegistrationCertificateReportJsonAdaptor;
import org.egov.mrs.web.adaptor.MarriageRegistrationJsonAdaptor;
import org.egov.mrs.web.adaptor.MarriageRegistrationReportsJsonAdaptor;
import org.egov.mrs.web.adaptor.ReligionWiseReportJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamResource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report"})
public class MarriageRegistrationReportsController {
    private static final String REGUNIT = "regunit";
    private static final String YEAR = "year";
    private static final String TO_DATE = "toDate";
    private static final String FROM_DATE = "fromDate";
    private static final String STATUS = "status";
    private static final String HUSBAND = "husband";
    private static final String DATA = "{ \"data\":";
    private static final String REISSUE = "reissue";
    private static final String MARRIAGE_REGISTRATIONS = "marriageRegistrations";
    private static final String APPLICANT_TYPE = "applicantType";
    private static final String YEARLIST = "yearlist";
    private static final String REGISTRATION = "registration";
    private static final String[] RANGES = new String[]{"0-18", "19-25", "26-30", "31-35", "36-40", "40-45", "46-50", "50-100"};
    private static final String KEY_AGE = "age";
    private static final String KEY_HUSBANDCOUNT = "husbandcount";
    private static final String KEY_WIFECOUNT = "wifecount";
    private static final String KEY_MONTH = "month";
    private static final String KEY_REGCOUNT = "Registrationcount";
    private static final String KEY_ACT = "MarriageAct";
    private static final String[] DAYRANGE = new String[]{"0-3", "4-6", "7-9", "10-12", "13-15", "16-20", "20-25", "26-30", "31-365"};
    private static final String KEY_DAY = "days";
    private static final String KEY_REGISTRATIONCOUNT = "registrationcount";
    private static final String KEY_COLLECTIONAMOUNT = "totalcollection";
    @Autowired
    protected BoundaryService boundaryService;
    @Autowired
    private MarriageRegistrationReportsService marriageRegistrationReportsService;
    @Autowired
    private MarriageRegistrationUnitService marriageRegistrationUnitService;
    @Autowired
    private MarriageActService marriageActService;
    @Autowired
    protected AppConfigValueService appConfigValuesService;
    @Autowired
    private ReligionService religionService;
    @Autowired
    private MarriageUtils marriageUtils;
    private final Map<Integer, String> monthMap = DateUtils.getAllMonthsWithFullNames();

    @ModelAttribute(value="zones")
    public List<Boundary> getZonesList() {
        AppConfigValues heirarchyType = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "MARRIAGE_REGISTRATIONUNIT_HEIRARCHYTYPE").get(0);
        AppConfigValues boundaryType = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Marriage Registration", "MARRIAGE_REGISTRATIONUNIT_BOUNDARYYTYPE").get(0);
        if (heirarchyType != null && heirarchyType.getValue() != null && !"".equals(heirarchyType.getValue()) && boundaryType != null && boundaryType.getValue() != null && !"".equals(boundaryType.getValue())) {
            return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName(boundaryType.getValue(), heirarchyType.getValue());
        }
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("City", "ADMINISTRATION");
    }

    @ModelAttribute(value="marriageRegistrationUnit")
    public List<MarriageRegistrationUnit> getMarriageRegistrationUnitList() {
        return this.marriageRegistrationUnitService.getActiveRegistrationunit();
    }

    @RequestMapping(value={"/registrationstatus"}, method={RequestMethod.GET})
    public String showReportForm(Model model) {
        model.addAttribute(REGISTRATION, (Object)new MarriageRegistration());
        model.addAttribute(STATUS, (Object)MarriageRegistration.RegistrationStatus.values());
        return "report-registrationstatus";
    }

    @RequestMapping(value={"/applicantionsstatus-count"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String getByApplicationsStatusCount(Model model, @ModelAttribute MarriageRegistration registration) {
        ArrayList result = new ArrayList();
        List applnsStatusCount = this.marriageRegistrationReportsService.getCountOfApplnsStatusWise(registration.getStatus().getCode(), registration.getFromDate(), registration.getToDate(), registration.getMarriageRegistrationUnit(), registration);
        HashMap map = new HashMap();
        for (Object[] category : applnsStatusCount) {
            HashMap<String, String> subMap;
            if (map.containsKey(category[0])) {
                if (((Map)map.get(category[0])).containsKey(category[1])) {
                    ((Map)map.get(category[0])).put(String.valueOf(category[1]), String.valueOf(category[2]));
                    continue;
                }
                subMap = new HashMap();
                subMap.put(String.valueOf(category[1]), String.valueOf(category[2]));
                ((Map)map.get(category[0])).put(String.valueOf(category[1]), String.valueOf(category[2]));
                continue;
            }
            subMap = new HashMap<String, String>();
            subMap.put(String.valueOf(category[1]), String.valueOf(category[2]));
            map.put(String.valueOf(category[0]), subMap);
        }
        this.buildApplicationStatusWiseResult(result, map);
        return DATA + JsonUtils.toJSON(result, ApplicationStatusResultForReport.class, ApplicationStatusResultReportJsonAdaptor.class) + "}";
    }

    private void buildApplicationStatusWiseResult(ArrayList<ApplicationStatusResultForReport> result, Map<String, Map<String, String>> map) {
        for (Map.Entry<String, Map<String, String>> resMap : map.entrySet()) {
            ApplicationStatusResultForReport statusResultForReport = new ApplicationStatusResultForReport();
            statusResultForReport.setRegistrationUnit(resMap.getKey());
            this.buildApplicationStatusWiseInnerMapResult(resMap, statusResultForReport);
            result.add(statusResultForReport);
        }
    }

    private void buildApplicationStatusWiseInnerMapResult(Map.Entry<String, Map<String, String>> resMap, ApplicationStatusResultForReport statusResultForReport) {
        Integer count = 0;
        for (Map.Entry<String, String> valuesMap : resMap.getValue().entrySet()) {
            if (MarriageRegistration.RegistrationStatus.CREATED.toString().equalsIgnoreCase(valuesMap.getKey())) {
                count = count + Integer.parseInt(valuesMap.getValue());
                statusResultForReport.setCreatedCount(valuesMap.getValue());
            }
            if (MarriageRegistration.RegistrationStatus.APPROVED.toString().equalsIgnoreCase(valuesMap.getKey())) {
                count = count + Integer.parseInt(valuesMap.getValue());
                statusResultForReport.setApprovedCount(valuesMap.getValue());
            }
            if (MarriageRegistration.RegistrationStatus.REGISTERED.toString().equalsIgnoreCase(valuesMap.getKey())) {
                count = count + Integer.parseInt(valuesMap.getValue());
                statusResultForReport.setRegisteredCount(valuesMap.getValue());
            }
            if (MarriageRegistration.RegistrationStatus.REJECTED.toString().equalsIgnoreCase(valuesMap.getKey())) {
                count = count + Integer.parseInt(valuesMap.getValue());
                statusResultForReport.setRejectedCount(valuesMap.getValue());
            }
            if (MarriageRegistration.RegistrationStatus.CANCELLED.toString().equalsIgnoreCase(valuesMap.getKey())) {
                count = count + Integer.parseInt(valuesMap.getValue());
                statusResultForReport.setCancelledCount(valuesMap.getValue());
            }
            statusResultForReport.setTotal(count);
        }
    }

    @RequestMapping(value={"/applicantionsstatus-count"}, method={RequestMethod.GET})
    public String showApplicationsStatusDetails(Model model, @RequestParam(value="status") String status, @RequestParam(value="registrationunit") String registrationUnit, @RequestParam(value="fromdate") Date fromDate, @RequestParam(value="todate") Date toDate) {
        model.addAttribute(FROM_DATE, (Object)fromDate);
        model.addAttribute(TO_DATE, (Object)toDate);
        model.addAttribute(STATUS, (Object)status);
        model.addAttribute("registrationUnit", (Object)registrationUnit);
        return "report-viewregistration-statusdetails";
    }

    @RequestMapping(value={"/registrationstatus"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String search(Model model, @RequestParam(value="status") String status, @RequestParam(value="registrationUnit") String registrationUnit, @RequestParam(value="fromDate") Date fromDate, @RequestParam(value="toDate") Date toDate) {
        List searchResultList = this.marriageRegistrationReportsService.searchRegistrationByStatusForReport(registrationUnit, status, fromDate, toDate);
        return DATA + JsonUtils.toJSON((Collection)searchResultList, MarriageRegistration.class, MarriageRegistrationJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/age-wise"}, method={RequestMethod.GET})
    public String newSearchForm(Model model) {
        model.addAttribute(REGISTRATION, (Object)new MarriageRegistration());
        model.addAttribute(YEARLIST, (Object)this.getPreviousyears());
        return "report-registration-agewise";
    }

    @RequestMapping(value={"/age-wise"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchAgeWise(@RequestParam(value="year") int year, Model model, @ModelAttribute MarriageRegistration registration) {
        Map husbandAgeRangesCount = this.getCountByRange(this.marriageRegistrationReportsService.searchRegistrationOfHusbandAgeWise(year, registration));
        Map wifeAgeRangesCount = this.getCountByRange(this.marriageRegistrationReportsService.searchRegistrationOfWifeAgeWise(year, registration));
        ArrayList result = new ArrayList();
        for (String range : RANGES) {
            HashMap<String, Object> rangeMap = new HashMap<String, Object>();
            rangeMap.put(KEY_AGE, range);
            rangeMap.put(KEY_HUSBANDCOUNT, husbandAgeRangesCount.get(range) != null ? husbandAgeRangesCount.get(range) : Integer.valueOf(0));
            rangeMap.put(KEY_WIFECOUNT, wifeAgeRangesCount.get(range) != null ? wifeAgeRangesCount.get(range) : Integer.valueOf(0));
            result.add(rangeMap);
        }
        JsonArray jsonArray = (JsonArray)new Gson().toJsonTree(result, new /* Unavailable Anonymous Inner Class!! */.getType());
        JsonObject response = new JsonObject();
        response.add("data", (JsonElement)jsonArray);
        return response.toString();
    }

    public Map<String, Integer> getCountByRange(List<String[]> inputs) {
        HashMap<String, Integer> response = new HashMap<String, Integer>();
        block0: for (Object[] objectArray : inputs) {
            String[] values = Arrays.toString(objectArray).replaceFirst("^\\[", "").replaceFirst("\\]$", "").split(",");
            Integer age = Integer.parseInt(values[0]);
            for (String range : RANGES) {
                if (!this.isInRange(range, age)) continue;
                int existingCount = response.get(range) != null ? response.get(range) : 0;
                response.put(range, existingCount + Integer.valueOf(values[1].trim()));
                continue block0;
            }
        }
        return response;
    }

    private boolean isInRange(String ranges, Integer input) {
        String[] range = ranges.split("-");
        return input >= Integer.valueOf(range[0]) && input <= Integer.valueOf(range[1]);
    }

    @RequestMapping(value={"/age-wise/view"}, method={RequestMethod.GET})
    public String viewAgeWiseDetails(@ModelAttribute MarriageRegistration registration, @RequestParam(value="regunit", required=false) String regunit, @RequestParam(value="year") int year, @RequestParam(value="applicantType") String applicantType, @RequestParam(value="agerange") String ageRange, Model model) throws ParseException {
        List marriageRegistrations = this.marriageRegistrationReportsService.getAgewiseDetails(registration, regunit, ageRange, year, applicantType);
        model.addAttribute(MARRIAGE_REGISTRATIONS, (Object)marriageRegistrations);
        model.addAttribute(APPLICANT_TYPE, (Object)applicantType);
        return "marriage-agewise-view";
    }

    @RequestMapping(value={"/certificatedetails"}, method={RequestMethod.GET})
    public String searchCertificatesForReport(Model model) {
        model.addAttribute("certificate", (Object)new MarriageCertificate());
        model.addAttribute("certificateType", (Object)MarriageCertificateType.values());
        return "registration-certificates-report";
    }

    @RequestMapping(value={"/certificatedetails"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchApprovedMarriageRecords(Model model, @ModelAttribute MarriageCertificate certificate) {
        ArrayList<RegistrationCertificatesResultForReport> regCertificateResult = new ArrayList<RegistrationCertificatesResultForReport>();
        List searchResultList = this.marriageRegistrationReportsService.searchMarriageRegistrationsForCertificateReport(certificate);
        for (Object[] objects : searchResultList) {
            RegistrationCertificatesResultForReport certificatesResultForReport = new RegistrationCertificatesResultForReport();
            certificatesResultForReport.setRegistrationNo(objects[0] != null ? objects[0].toString() : "");
            certificatesResultForReport.setDateOfMarriage(objects[1].toString());
            certificatesResultForReport.setRegistrationDate(objects[2].toString());
            certificatesResultForReport.setRejectReason(objects[3] != null ? objects[3].toString() : "");
            certificatesResultForReport.setCertificateNo(objects[4] != null ? objects[4].toString() : "");
            certificatesResultForReport.setCertificateType(objects[5].toString());
            certificatesResultForReport.setCertificateDate(objects[6].toString());
            certificatesResultForReport.setZone(objects[7].toString());
            certificatesResultForReport.setHusbandName(objects[8].toString());
            certificatesResultForReport.setWifeName(objects[9].toString());
            certificatesResultForReport.setId(Long.valueOf(objects[10].toString()));
            regCertificateResult.add(certificatesResultForReport);
        }
        return DATA + JsonUtils.toJSON(regCertificateResult, RegistrationCertificatesResultForReport.class, MarriageRegistrationCertificateReportJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/status-at-time-marriage"}, method={RequestMethod.GET})
    public String getStatusAtTimeOfMarriage(Model model) {
        model.addAttribute(REGISTRATION, (Object)new MarriageRegistration());
        model.addAttribute("maritalStatusList", Arrays.asList(MaritalStatus.values()));
        model.addAttribute(YEARLIST, (Object)this.getPreviousyears());
        return "statustime-ofmarriage-report";
    }

    @RequestMapping(value={"/status-at-time-marriage"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchStatusAtTimeOfMarriage(@RequestParam(value="fromDate") Date fromDate, @RequestParam(value="toDate") Date toDate, @RequestParam(value="maritalStatus") String maritalStatus, @RequestParam(value="applicantType") String applicantType, Model model, @ModelAttribute MarriageRegistration registration) {
        ArrayList maritalStatusReports = new ArrayList();
        if ("Husband".equals(applicantType)) {
            maritalStatusReports.addAll(this.putRecordsIntoHashMapByMonth(this.marriageRegistrationReportsService.getHusbandCountByMaritalStatus(fromDate, toDate, maritalStatus, registration), HUSBAND));
        } else if ("Wife".equals(applicantType)) {
            maritalStatusReports.addAll(this.putRecordsIntoHashMapByMonth(this.marriageRegistrationReportsService.getWifeCountByMaritalStatus(fromDate, toDate, maritalStatus, registration), "wife"));
        } else {
            maritalStatusReports.addAll(this.putRecordsIntoHashMapByMonth(this.marriageRegistrationReportsService.getHusbandCountByMaritalStatus(fromDate, toDate, maritalStatus, registration), HUSBAND));
            maritalStatusReports.addAll(this.putRecordsIntoHashMapByMonth(this.marriageRegistrationReportsService.getWifeCountByMaritalStatus(fromDate, toDate, maritalStatus, registration), "wife"));
        }
        return DATA + JsonUtils.toJSON(maritalStatusReports, MaritalStatusReport.class, MaritalStatusReportJsonAdaptor.class) + "}";
    }

    public List<MaritalStatusReport> putRecordsIntoHashMapByMonth(List<String[]> recordList, String applicantType) {
        HashMap map = new HashMap();
        for (Object[] objectArray : recordList) {
            HashMap<String, String> subMap;
            if (map.containsKey(objectArray[1])) {
                if (((Map)map.get(objectArray[1])).containsKey(objectArray[0])) {
                    ((Map)map.get(objectArray[1])).put(String.valueOf(objectArray[0]), String.valueOf(objectArray[2]));
                    continue;
                }
                subMap = new HashMap();
                subMap.put(String.valueOf(objectArray[0]), String.valueOf(objectArray[2]));
                ((Map)map.get(objectArray[1])).put(String.valueOf(objectArray[0]), String.valueOf(objectArray[2]));
                continue;
            }
            subMap = new HashMap<String, String>();
            subMap.put(String.valueOf(objectArray[0]), String.valueOf(objectArray[2]));
            map.put(String.valueOf(objectArray[1]), subMap);
            ((Map)map.get(objectArray[1])).put(APPLICANT_TYPE, applicantType);
        }
        ArrayList<MaritalStatusReport> maritalStatusReports = new ArrayList<MaritalStatusReport>();
        this.buildMaritalStatusResult(applicantType, map, maritalStatusReports);
        return maritalStatusReports;
    }

    private void buildMaritalStatusResult(String applicantType, Map<String, Map<String, String>> map, List<MaritalStatusReport> maritalStatusReports) {
        for (Map.Entry<String, Map<String, String>> resMap : map.entrySet()) {
            MaritalStatusReport report = new MaritalStatusReport();
            report.setMonth(resMap.getKey());
            this.buildMaritalStatusWiseInnerMapResult(applicantType, resMap, report);
            maritalStatusReports.add(report);
        }
    }

    private void buildMaritalStatusWiseInnerMapResult(String applicantType, Map.Entry<String, Map<String, String>> resMap, MaritalStatusReport report) {
        int count = 0;
        for (Map.Entry<String, String> valuesMap : resMap.getValue().entrySet()) {
            if (HUSBAND.equalsIgnoreCase(valuesMap.getValue()) || "wife".equalsIgnoreCase(valuesMap.getValue())) {
                report.setApplicantType(applicantType);
            }
            if (MaritalStatus.Married.name().equalsIgnoreCase(valuesMap.getKey())) {
                count += Integer.parseInt(valuesMap.getValue());
                report.setMarried(valuesMap.getValue() != null ? valuesMap.getValue() : "0");
            } else if (MaritalStatus.Unmarried.name().equalsIgnoreCase(valuesMap.getKey())) {
                count += Integer.parseInt(valuesMap.getValue());
                report.setUnmarried(valuesMap.getValue() != null ? valuesMap.getValue() : "0");
            } else if (MaritalStatus.Widower.name().equalsIgnoreCase(valuesMap.getKey())) {
                count += Integer.parseInt(valuesMap.getValue());
                report.setWidower(valuesMap.getValue() != null ? valuesMap.getValue() : "0");
            } else if (MaritalStatus.Divorced.name().equalsIgnoreCase(valuesMap.getKey())) {
                count += Integer.parseInt(valuesMap.getValue());
                report.setDivorced(valuesMap.getValue() != null ? valuesMap.getValue() : "0");
            }
            report.setTotal(Integer.valueOf(count));
        }
    }

    @RequestMapping(value={"/status-at-time-marriage/view"}, method={RequestMethod.GET})
    public String viewByMaritalStatus(@ModelAttribute MarriageRegistration registration, @RequestParam(value="regunit", required=false) String regunit, @RequestParam(value="applicantType") String applicantType, @RequestParam(value="maritalStatus") String maritalStatus, @RequestParam(value="fromDate") Date fromDate, @RequestParam(value="toDate") Date toDate, Model model) {
        List marriageRegistrations = this.marriageRegistrationReportsService.getByMaritalStatusDetails(registration, regunit, applicantType, maritalStatus, fromDate, toDate);
        model.addAttribute(MARRIAGE_REGISTRATIONS, (Object)marriageRegistrations);
        model.addAttribute(APPLICANT_TYPE, (Object)applicantType);
        return "status-timeofmrg-view";
    }

    @RequestMapping(value={"/datewiseregistration"}, method={RequestMethod.GET})
    public String showDatewiseReportForm(Model model) {
        model.addAttribute(REGISTRATION, (Object)new MarriageRegistration());
        model.addAttribute(STATUS, (Object)MarriageRegistration.RegistrationStatus.values());
        return "report-datewiseregsitration";
    }

    @RequestMapping(value={"/datewiseregistration"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String showDatewiseReportresult(Model model, @ModelAttribute MarriageRegistration registration) {
        List searchResultList = this.marriageRegistrationReportsService.searchRegistrationBydate(registration);
        return DATA + JsonUtils.toJSON((Collection)searchResultList, MarriageRegistration.class, MarriageRegistrationJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/monthwiseregistration"}, method={RequestMethod.GET})
    public String showMonthwiseReportForm(Model model) {
        model.addAttribute(REGISTRATION, (Object)new MarriageRegistration());
        model.addAttribute(STATUS, (Object)MarriageRegistration.RegistrationStatus.values());
        return "report-monthwiseregistration";
    }

    @RequestMapping(value={"/monthly-applications-count"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String getMonthlyApplicationsCount(Model model, @ModelAttribute MarriageRegistration registration) {
        ArrayList result = new ArrayList();
        List applnsCount = this.marriageRegistrationReportsService.getCountOfApplications(registration);
        HashMap map = new HashMap();
        for (Object[] input : applnsCount) {
            String[] values = Arrays.toString(input).replaceFirst("^\\[", "").replaceFirst("\\]$", "").split(",");
            Integer count = Integer.valueOf(values[1].trim());
            if (map.containsKey(values[0])) {
                ((Map)map.get(values[0])).put(String.valueOf(values[3].trim()), String.valueOf(count));
                continue;
            }
            HashMap<String, String> subMap = new HashMap<String, String>();
            subMap.put("registrationunit", values[0].trim());
            subMap.put(values[3].trim(), String.valueOf(count));
            subMap.put(KEY_MONTH, values[2].trim());
            map.put(String.valueOf(values[0].trim()), subMap);
        }
        this.buildMonthlyApplicationsCountResult(result, map);
        JsonArray jsonArray = (JsonArray)new Gson().toJsonTree(result, new /* Unavailable Anonymous Inner Class!! */.getType());
        JsonObject response = new JsonObject();
        response.add("data", (JsonElement)jsonArray);
        return response.toString();
    }

    private void buildMonthlyApplicationsCountResult(ArrayList<HashMap<String, Object>> result, Map<String, Map<String, String>> map) {
        for (Map.Entry<String, Map<String, String>> resMap : map.entrySet()) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            boolean regExist = true;
            boolean reissueExist = true;
            if (!resMap.getValue().containsKey(REGISTRATION)) {
                regExist = false;
            }
            if (!resMap.getValue().containsKey(REISSUE)) {
                reissueExist = false;
            }
            resultMap.put("registrationunit", resMap.getKey());
            this.buildMonthlyApplicationsInnerMapResult(resMap, resultMap, regExist, reissueExist);
            result.add(resultMap);
        }
    }

    private void buildMonthlyApplicationsInnerMapResult(Map.Entry<String, Map<String, String>> resMap, HashMap<String, Object> resultMap, boolean regExist, boolean reissueExist) {
        Integer count = 0;
        for (Map.Entry<String, String> valuesMap : resMap.getValue().entrySet()) {
            if (regExist) {
                if (REGISTRATION.equalsIgnoreCase(valuesMap.getKey().trim())) {
                    count = count + Integer.parseInt(valuesMap.getValue());
                    resultMap.put(REGISTRATION, valuesMap.getValue());
                }
            } else {
                resultMap.put(REGISTRATION, 0);
            }
            if (reissueExist) {
                if (REISSUE.equalsIgnoreCase(valuesMap.getKey().trim())) {
                    count = count + Integer.parseInt(valuesMap.getValue());
                    resultMap.put(REISSUE, valuesMap.getValue());
                }
            } else {
                resultMap.put(REISSUE, 0);
            }
            if (KEY_MONTH.equalsIgnoreCase(valuesMap.getKey().trim())) {
                resultMap.put(KEY_MONTH, valuesMap.getValue());
            }
            resultMap.put("total", count);
        }
    }

    @RequestMapping(value={"/monthwisefundcollection"}, method={RequestMethod.GET})
    public String showFundColllectionReportForm(Model model) {
        model.addAttribute(REGISTRATION, (Object)new MarriageRegistration());
        model.addAttribute(YEARLIST, (Object)this.getPreviousyears());
        model.addAttribute(STATUS, (Object)MarriageRegistration.RegistrationStatus.values());
        return "report-monthwisefundcollection";
    }

    @RequestMapping(value={"/monthly-fund-collection"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String getMonthlyFundCollection(@RequestParam(value="year") String year, Model model, @ModelAttribute MarriageRegistration registration) {
        ArrayList result = new ArrayList();
        List totalCollection = this.marriageRegistrationReportsService.getMonthwiseFundCollected(registration, year);
        if (registration != null && registration.getMonthYear() != null && year != null && registration.getMonthYear().substring(3).equals(year)) {
            HashMap<String, String> map = new HashMap<String, String>();
            for (Object[] input : totalCollection) {
                String[] values = Arrays.toString(input).replaceFirst("^\\[", "").replaceFirst("\\]$", "").split(",");
                map.put(KEY_MONTH, values[2].trim());
                map.put(KEY_COLLECTIONAMOUNT, values[1].trim());
                result.add(map);
            }
        } else if (registration != null && year != null && registration.getMonthYear() == null) {
            HashMap registrationCount = this.getFundBymonth(totalCollection);
            for (Map.Entry monthname : this.monthMap.entrySet()) {
                HashMap monthRegMap = new HashMap();
                monthRegMap.put(KEY_MONTH, monthname.getValue());
                monthRegMap.put(KEY_COLLECTIONAMOUNT, registrationCount.get(monthname.getValue()) != null ? String.valueOf(registrationCount.get(monthname.getValue())) : "0");
                result.add(monthRegMap);
            }
        }
        JsonArray jsonArray = (JsonArray)new Gson().toJsonTree(result, new /* Unavailable Anonymous Inner Class!! */.getType());
        JsonObject response = new JsonObject();
        response.add("data", (JsonElement)jsonArray);
        return response.toString();
    }

    private HashMap<String, Integer> getFundBymonth(List<String[]> inputs) {
        HashMap<String, Integer> response = new HashMap<String, Integer>();
        for (Object[] objectArray : inputs) {
            String[] values = Arrays.toString(objectArray).replaceFirst("^\\[", "").replaceFirst("\\]$", "").split(",");
            Integer month = Double.valueOf(values[0]).intValue();
            for (Map.Entry monthname : this.monthMap.entrySet()) {
                if (!month.equals(monthname.getKey())) continue;
                int existingCount = response.get(monthname) != null ? response.get(monthname) : 0;
                response.put((String)monthname.getValue(), existingCount + Double.valueOf(values[1]).intValue());
            }
        }
        return response;
    }

    @RequestMapping(value={"/show-applications-details"}, method={RequestMethod.GET})
    public String showMonthlyApplicationDetails(Model model, @RequestParam(value="month") String month, @RequestParam(value="regunit") String registrationUnit, @RequestParam(value="applicationType") String applicationType) {
        model.addAttribute(REGISTRATION, (Object)new MarriageRegistration());
        model.addAttribute(KEY_MONTH, (Object)month);
        model.addAttribute("registrationUnit", (Object)registrationUnit.replaceAll("[^a-zA-Z0-9]", " "));
        model.addAttribute("applicationType", (Object)applicationType);
        return "show-monthlyapplns-details";
    }

    @RequestMapping(value={"/monthwiseregistration"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String getMonthlyApplicationDetailsResult(Model model, @ModelAttribute MarriageRegistration registration, @RequestParam(value="month") String month, @RequestParam(value="regunit") String registrationUnit, @RequestParam(value="applicationType") String applicationType) {
        if (REGISTRATION.equalsIgnoreCase(applicationType)) {
            List searchResultList = this.marriageRegistrationReportsService.searchRegistrationBymonth(registration, month, registrationUnit);
            return DATA + JsonUtils.toJSON((Collection)searchResultList, MarriageRegistration.class, MarriageRegistrationJsonAdaptor.class) + "}";
        }
        List searchResultList = this.marriageRegistrationReportsService.searchReissueBymonth(registration, month, registrationUnit);
        return DATA + JsonUtils.toJSON((Collection)searchResultList, ReIssue.class, MarriageReIssueJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/actwiseregistration"}, method={RequestMethod.GET})
    public String showActwiseReportForm(Model model) {
        model.addAttribute(REGISTRATION, (Object)new MarriageRegistration());
        model.addAttribute("acts", (Object)this.marriageActService.getActs());
        model.addAttribute(YEARLIST, (Object)this.getPreviousyears());
        return "report-actwiseregistration";
    }

    @RequestMapping(value={"/actwiseregistration"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String showActwiseReportresult(@RequestParam(value="year") int year, @ModelAttribute MarriageRegistration registration) {
        JsonObject response = new JsonObject();
        if (registration.getMarriageAct() != null && registration.getMarriageAct().getId() != null) {
            List regcount = this.marriageRegistrationReportsService.searchRegistrationActWise(registration, year);
            HashMap registrationCount = this.getCountBymonth(regcount);
            ArrayList result = new ArrayList();
            for (Map.Entry monthname : this.monthMap.entrySet()) {
                HashMap monthRegMap = new HashMap();
                monthRegMap.put(KEY_MONTH, monthname.getValue());
                monthRegMap.put(KEY_REGCOUNT, registrationCount.get(monthname.getValue()) != null ? registrationCount.get(monthname.getValue()) : Integer.valueOf(0));
                result.add(monthRegMap);
            }
            JsonArray jsonArray = (JsonArray)new Gson().toJsonTree(result, new /* Unavailable Anonymous Inner Class!! */.getType());
            response.add("data", (JsonElement)jsonArray);
        } else {
            List regcount = this.marriageRegistrationReportsService.searchRegistrationMrActWise(year, registration);
            HashMap registrationCount = this.getCountByAct(regcount);
            ArrayList result = new ArrayList();
            List actList = this.marriageActService.getActs();
            for (MarriageAct actName : actList) {
                HashMap<String, Object> actRegMap = new HashMap<String, Object>();
                actRegMap.put(KEY_ACT, actName.getName());
                actRegMap.put(KEY_REGCOUNT, registrationCount.get(actName.getName()) != null ? registrationCount.get(actName.getName()) : Integer.valueOf(0));
                result.add(actRegMap);
            }
            JsonArray jsonArray = (JsonArray)new Gson().toJsonTree(result, new /* Unavailable Anonymous Inner Class!! */.getType());
            response.add("data", (JsonElement)jsonArray);
        }
        return response.toString();
    }

    private HashMap<String, Integer> getCountBymonth(List<String[]> inputs) {
        HashMap<String, Integer> response = new HashMap<String, Integer>();
        for (Object[] objectArray : inputs) {
            String[] values = Arrays.toString(objectArray).replaceFirst("^\\[", "").replaceFirst("\\]$", "").split(",");
            Integer month = Double.valueOf(values[0]).intValue();
            for (Map.Entry monthname : this.monthMap.entrySet()) {
                if (!month.equals(monthname.getKey())) continue;
                int existingCount = response.get(monthname) != null ? response.get(monthname) : 0;
                response.put((String)monthname.getValue(), existingCount + Integer.valueOf(values[1].trim()));
            }
        }
        return response;
    }

    private HashMap<String, Integer> getCountByAct(List<String[]> inputs) {
        HashMap<String, Integer> response = new HashMap<String, Integer>();
        block0: for (Object[] objectArray : inputs) {
            String[] values = Arrays.toString(objectArray).replaceFirst("^\\[", "").replaceFirst("\\]$", "").split(",");
            String actName = values[0];
            List actList = this.marriageActService.getActs();
            for (MarriageAct act : actList) {
                if (!actName.equals(act.getName())) continue;
                int existingCount = response.get(actName) != null ? response.get(actName) : 0;
                response.put(actName, existingCount + Integer.valueOf(values[1].trim()));
                continue block0;
            }
        }
        return response;
    }

    @RequestMapping(value={"/religionwiseregistration"}, method={RequestMethod.GET})
    public String showRegionwiseReportForm(Model model) {
        model.addAttribute(REGISTRATION, (Object)new MarriageRegistration());
        model.addAttribute("religions", (Object)this.religionService.getReligions());
        model.addAttribute(YEARLIST, (Object)this.getPreviousyears());
        return "religionwise-report";
    }

    public List<Integer> getPreviousyears() {
        int startyear;
        ArrayList<Integer> previousyears = new ArrayList<Integer>();
        int currentyear = Calendar.getInstance().get(1);
        Calendar cal = Calendar.getInstance();
        cal.set(1, 2009);
        for (int i = startyear = cal.get(1); i < currentyear; ++i) {
            previousyears.add(startyear + 1);
            ++startyear;
        }
        Collections.sort(previousyears, Collections.reverseOrder());
        return previousyears;
    }

    @RequestMapping(value={"/religionwiseregistration"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String showRegionwiseReportresult(@RequestParam(value="year") int year, Model model, @ModelAttribute MarriageRegistration registration) throws ParseException {
        List searchResultList = this.marriageRegistrationReportsService.searchRegistrationByreligion(registration, year);
        return DATA + JsonUtils.toJSON((Collection)searchResultList, MarriageRegistration.class, MarriageRegistrationJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/act-wise/view/{year}/{MarriageAct}"}, method={RequestMethod.GET})
    public String viewActWiseDetails(@PathVariable int year, @PathVariable String marriageAct, Model model) throws ParseException {
        List marriageRegistrations = this.marriageRegistrationReportsService.getActwiseDetails(year, marriageAct);
        model.addAttribute(MARRIAGE_REGISTRATIONS, (Object)marriageRegistrations);
        return "marriage-actwise-view";
    }

    @RequestMapping(value={"/act-wise/view/{year}/{month}/{actid}"}, method={RequestMethod.GET})
    public String viewActWiseDetails(@PathVariable int year, @PathVariable String month, @PathVariable Long actid, @ModelAttribute MarriageRegistration registration, Model model) throws ParseException {
        Date date = new SimpleDateFormat("MMM").parse(month);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int months = cal.get(2) + 1;
        List marriageRegistrations = this.marriageRegistrationReportsService.getmonthWiseActDetails(year, months, actid);
        model.addAttribute(MARRIAGE_REGISTRATIONS, (Object)marriageRegistrations);
        return "marriage-actwise-view";
    }

    @RequestMapping(value={"/ageing-report"}, method={RequestMethod.GET})
    public String ageingReportForm(Model model) {
        model.addAttribute(REGISTRATION, (Object)new MarriageRegistration());
        model.addAttribute(YEARLIST, (Object)this.getPreviousyears());
        return "ageing-report";
    }

    @RequestMapping(value={"/ageing-report"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String agiengReport(@RequestParam(value="year") int year, Model model, @ModelAttribute MarriageRegistration registration) {
        Map registrationcount = this.getCountByDays(this.marriageRegistrationReportsService.searchRegistrationbyDays(year, registration));
        ArrayList result = new ArrayList();
        for (String range : DAYRANGE) {
            HashMap<String, Object> rangeMap = new HashMap<String, Object>();
            rangeMap.put(KEY_DAY, range);
            rangeMap.put(KEY_REGISTRATIONCOUNT, registrationcount.get(range) != null ? registrationcount.get(range) : Integer.valueOf(0));
            result.add(rangeMap);
        }
        JsonArray jsonArray = (JsonArray)new Gson().toJsonTree(result, new /* Unavailable Anonymous Inner Class!! */.getType());
        JsonObject response = new JsonObject();
        response.add("data", (JsonElement)jsonArray);
        return response.toString();
    }

    public Map<String, Integer> getCountByDays(List<String[]> inputs) {
        HashMap<String, Integer> response = new HashMap<String, Integer>();
        block0: for (Object[] objectArray : inputs) {
            String[] values = Arrays.toString(objectArray).replaceFirst("^\\[", "").replaceFirst("\\]$", "").split(",");
            Integer days = Double.valueOf(values[0]).intValue();
            for (String range : DAYRANGE) {
                if (!this.isInRange(range, days)) continue;
                int existingCount = response.get(range) != null ? response.get(range) : 0;
                response.put(range, existingCount + Integer.valueOf(values[1].trim()));
                continue block0;
            }
        }
        return response;
    }

    @RequestMapping(value={"/ageing-report/view/{year}/{dayRange}"}, method={RequestMethod.GET})
    public String viewAgeingRegDetails(@PathVariable int year, @PathVariable String dayRange, Model model) {
        model.addAttribute(YEAR, (Object)year);
        model.addAttribute("dayRange", (Object)dayRange);
        return "ageingreport-view";
    }

    @RequestMapping(value={"/ageing-report/view/"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String getAgeingRegDetails(@RequestParam(value="year") int year, @RequestParam(value="dayRange") String dayRange, Model model) {
        ArrayList<RegistrationReportsSearchResult> reportsSearchResults = new ArrayList<RegistrationReportsSearchResult>();
        List marriageRegistrations = this.marriageRegistrationReportsService.getAgeingRegDetails(dayRange, year);
        RegistrationReportsSearchResult reportsSearchResult = new RegistrationReportsSearchResult();
        for (Object[] mrgReg : marriageRegistrations) {
            reportsSearchResult.setApplicationNo(mrgReg[0].toString());
            reportsSearchResult.setRegistrationNo(mrgReg[1] != null ? mrgReg[1].toString() : "N/A");
            reportsSearchResult.setApplicationType(mrgReg[9].toString());
            reportsSearchResult.setHusbandName(mrgReg[2].toString());
            reportsSearchResult.setWifeName(mrgReg[3].toString());
            reportsSearchResult.setDateOfMarriage(mrgReg[4].toString());
            reportsSearchResult.setRegistrationDate(mrgReg[5].toString());
            reportsSearchResult.setPlaceOfMarriage(mrgReg[6] != null ? mrgReg[6].toString() : "N/A");
            reportsSearchResult.setZone(mrgReg[7].toString());
            reportsSearchResult.setStatus(mrgReg[8].toString());
            reportsSearchResult.setUserName(this.marriageUtils.getApproverName(Long.valueOf(mrgReg[10].toString())));
            reportsSearchResult.setPendingAction(mrgReg[11].toString());
            reportsSearchResults.add(reportsSearchResult);
        }
        return DATA + JsonUtils.toJSON(reportsSearchResults, RegistrationReportsSearchResult.class, MarriageRegistrationReportsJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/religion-wise-registrations-report"}, method={RequestMethod.GET})
    public String showfagStatutoryReport(Model model) {
        model.addAttribute("searchRequest", (Object)new SearchModel());
        model.addAttribute(YEARLIST, (Object)this.getPreviousyears());
        return "religion-wise-statutory-report";
    }

    @RequestMapping(value={"/religion-wise-registrations-report"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String getAgeWiseStatutoryReportDetails(@ModelAttribute SearchModel searchRequest, Model model) {
        List religionsSearchResults = this.marriageRegistrationReportsService.getUlbWiseReligionDetails(searchRequest);
        return DATA + JsonUtils.toJSON((Collection)religionsSearchResults, SearchResult.class, ReligionWiseReportJsonAdaptor.class) + "}";
    }

    @RequestMapping(value={"/print-religion-wise-details"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<InputStreamResource> printReligionWiseReport(@RequestParam(value="year") int year, Model model) {
        SearchModel searchRequest = new SearchModel();
        searchRequest.setYear(year);
        List religionsSearchResults = this.marriageRegistrationReportsService.getUlbWiseReligionDetails(searchRequest);
        ReportOutput reportOutput = this.marriageRegistrationReportsService.generateReportOutputForReligionWiseReport(year, religionsSearchResults);
        reportOutput.setReportName("religion_report");
        reportOutput.setReportDisposition(ReportDisposition.INLINE);
        return ReportUtil.reportAsResponseEntity((ReportOutput)reportOutput);
    }
}

